#include "pixlib.h"

#ifndef VAX_ORDER

extern void hdr_to_vax(), hdr_to_host(),
	    tile_table_to_vax(), tile_table_to_host(),
	    packet_to_vax(), packet_to_host();

#define vtoh_l htov_l		    /* Just inverting, so use same function */
#define vtoh_s htov_s
#define SWAPL_V(L) (L) = htov_l(L)  /* Swap long to vax order */
#define SWAPS_V(S) (S) = htov_s(S)  /* Swap short to vax order */
#define SWAPL_H(L) (L) = vtoh_l(L)  /* Swap long to host order */
#define SWAPS_H(S) (S) = vtoh_s(S)  /* Swap short to host order */

/* Convert long, host -> vax */
static long htov_l(l)
long l;
{
    long vaxl;
    register u_char *ptr = (u_char *)&l,
		   *vptr = (u_char *)&vaxl;

    /* Host is 4 3 2 1,
       Vax is  1 2 3 4
    */
    vptr[0] = ptr[3];
    vptr[1] = ptr[2];
    vptr[2] = ptr[1];
    vptr[3] = ptr[0];

    return vaxl;
}

/* Convert short, host -> vax */
static short htov_s(s)
short s;
{
    short vaxs;
    register u_char *ptr = (u_char *)&s,
		   *vptr = (u_char *)&vaxs;

    vptr[0] = ptr[1];
    vptr[1] = ptr[0];

    return vaxs;
}

void hdr_to_vax(hdr)
LFF_HDR *hdr;
{
    SWAPL_V(hdr->hdr_magic);
    SWAPS_V(hdr->hdr_version);
    SWAPL_V(hdr->hdr_labelptr);
    SWAPS_V(hdr->hdr_tilepad);
    SWAPS_V(hdr->hdr_height);
    SWAPS_V(hdr->hdr_width);
    SWAPS_V(hdr->hdr_tileheight);
    SWAPS_V(hdr->hdr_tilewidth);
    SWAPS_V(hdr->hdr_format);
    SWAPS_V(hdr->hdr_storage);
    SWAPS_V(hdr->hdr_blocking);
    SWAPS_V(hdr->hdr_alphamode);
    SWAPS_V(hdr->hdr_xoffset);
    SWAPS_V(hdr->hdr_yoffset);
    SWAPL_V(hdr->hdr_map_ptr);
}

void hdr_to_host(hdr)
LFF_HDR *hdr;
{
    SWAPL_H(hdr->hdr_magic);
    SWAPS_H(hdr->hdr_version);
    SWAPL_H(hdr->hdr_labelptr);
    SWAPS_H(hdr->hdr_tilepad);
    SWAPS_H(hdr->hdr_height);
    SWAPS_H(hdr->hdr_width);
    SWAPS_H(hdr->hdr_tileheight);
    SWAPS_H(hdr->hdr_tilewidth);
    SWAPS_H(hdr->hdr_format);
    SWAPS_H(hdr->hdr_storage);
    SWAPS_H(hdr->hdr_blocking);
    SWAPS_H(hdr->hdr_alphamode);
    SWAPS_H(hdr->hdr_xoffset);
    SWAPS_H(hdr->hdr_yoffset);
    SWAPL_H(hdr->hdr_map_ptr);
}

void pix_hdr_to_host(hdr)
PIX_HDR *hdr;
{
    SWAPS_H(hdr->height);
    SWAPS_H(hdr->width);
}

void tile_table_to_vax(table,length)
TILEPTR *table;
int length;
{
    while (length--) {
	SWAPL_V(table->tileptr);
	SWAPL_V(table->tilelength);
	table++;
    }
}

void tile_table_to_host(table,length)
TILEPTR *table;
int length;
{
    while (length--) {
	SWAPL_H(table->tileptr);
	SWAPL_H(table->tilelength);
	table++;
    }
}

/* Swapping packets will be tricky. The format looks like this in vax
    order:
	unsigned short count:12;
	unsigned short flag:4;
    and like this in memory:
	--------------------------------------------
	|first byte  |	      count <0:7>	   |
	--------------------------------------------
	|second byte | flag <0:3>  |  count <8:11> |
	--------------------------------------------
    The vax is little endian. On a big endian, let's do it carefully:
*/
void packet_to_vax(packet)
PACKET_HDR *packet;
{
    register int count = packet->count,
		 flag = packet->flag;
    register u_char *ptr = (u_char *)packet;

    *ptr = count & 0xFF;
    ptr[1] = (flag << 4) | ((count >> 8) & 0x0F);
}

void packet_to_host(packet)
PACKET_HDR *packet;
{
    register int count, flag;
    register u_char *ptr = (u_char *)packet;

    count = 0xFF & *ptr++;
    count |= (*ptr & 0x0F) << 8;
    flag = (*ptr >> 4) & 0x0F;

    packet->count = count;
    packet->flag = flag;
}

#endif /* #ifndef VAX_ORDER */
