.fp 1 R
.fp 2 I
.fp 3 B
.so date.trf
.TH READPIX 3L "\*(td" "Caltech CS Graphics Group" "Graphics Group Programmer's Manual"
.SH NAME
open_pix, pix_read_line, close_pix - .pix file input functions
.SH SYNOPSIS
.nf
\fB#include <pixlib.h>
int open_pix(char *name, PIX_HDR *hdr)
.sp
int pix_read_line(RGBPIXEL line[\|], int *y)
.sp
void close_pix()
.fi
.SH DESCRIPTION
\fIOpen_pix\fR opens the .pix format image \fIname\fR, reads the image's
header block into the passed \fIhdr\fR, and prepares for calls to
\fIpix_read_line\fR. If successful, \fBPIX_OK\fR will be returned. Otherwise,
an error code will be returned for which a textual description may be
obtained by calling \fIpixerrmess\fR. Only one .pix file may be opened
at a time.
.PP
\fIPix_read_line\fR reads the next sequential scanline from the pixfile,
converts it to 32-bit \fBRGBPIXELs\fR, and places it in the passed
array. The y coordinate of the scanline read is placed in the integer
pointed to by \fIy\fR as a check. If successful, \fBPIX_OK\fR will be returned,
otherwise an error code like \fIopen_pix\fR.
.PP
\fIPix_read_line\fR may be called once for each scanline in the image
(as specified by hdr->height). Any further calls are errors. There is
no way to randomly access the image.
.PP
\fIClose_pix\fR must be called after \fIopen_pix\fR before another .pix
file may be opened. It closes the currently open .pix file (if any). Calls
to \fIpix_read_line\fR will fail after \fIclose_pix\fR is called.
.PP
Sample code for processing a .pix file using these routines is:
.sp
.nf
.in +3P
if ((stat = open_pix(name,&hdr)) == PIX_OK)
.in +3P
for (row = 0; row < hdr.height; row++) {
.in +3P
pix_read_line(line,&y);
process_line(line);
.in -3P
}
.ti -3P
else
printf(``Error: %s\\n'',pixerrmess(stat));
.in -6P
.SH SEE ALSO
intro_pix(3L), pixerrmess(3L)
