.fp 1 R
.fp 2 I
.fp 3 B
.so date.trf
.TH READLFF 3L "\*(td" "Caltech CS Graphics Group" "Graphics Group Programmer's Manual"
.SH NAME
.in +3P
.ti -3P
open_lff, lff_seek_tile, lff_read_line, lff_read_packed, close_lff - .lff file input functions
.in -3P
.SH SYNOPSIS
.nf
\fB#include <pixlib.h>
int open_lff(char *name, LFF_HDR *hdr)
.sp
int open_lff_fd(int fd, LFF_HDR *hdr, off_t offset)
.sp
int lff_seek_tile(int row, int col)
.sp
int lff_read_line(RGBPIXEL line[\|], int *y)
.sp
int lff_read_packed(RPIXEL line[\|], int *y, int *format)
.sp
void close_lff()
.fi
.SH DESCRIPTION
\fIOpen_lff\fR opens the lucasfilm format image \fIname\fR, reads the image's
header block into the passed \fIhdr\fR, and prepares for calls to
\fIlff_seek_tile, lff_read_line,\fR and \fIlff_read_packed\fR. If successful,
\fBLFF_OK\fR will be returned. Otherwise,
an error code will be returned for which a textual description may be
obtained by calling \fIpixerrmess\fR. Only one lucasfilm file may be open
at a time.
.PP
\fIOpen_lff_fd\fR prepares to read a lff image from an already opened
file. \fIFd\fR must be a file descriptor of a file opened for reading.
In addition, an \fIoffset\fR (normally 0) into the file must be
spcified; the
image is assumed to begin at the given location (for incorporation
into \fBdvi\fR files). Otherwise this is identical to \fIopen_lff\fR.
.PP
\fILff_seek_tile\fR positions the file pointer so that the tile scanline
reading routines, \fIlff_read_line\fR and \fIlff_read_packed\fR, will
begin reading the first line of the specified tile. \fIRow\fR and \fIcol\fR
must be in the range \fI0..VTILES-1, 0..HTILES-1\fR where
.sp
.in +3P
\fIVTILES = hdr->hdr_height / hdr->hdr_tileheight
.br
HTILES = hdr->hdr_width / hdr->hdr_tilewidth\fR
.in -3P
.sp
Otherwise, an error code is returned like \fIopen_lff\fR.
.PP
A single tile may be read only in scanline order; however, there is
no restriction on the order in which tiles may be accessed.
.PP
\fILff_read_line\fR reads the next sequential scanline from the current
tile, converts it to 32-bit \fBRGBPIXELs\fR, and places it in the passed
array. For a binary image, 1 bits are converted to all-white pixels
(0xFFFFFF bit patterm) and 0 bits are converted to black pixels.
The y coordinate of the scanline read is placed in the integer
pointed to by \fIy\fR as a check. If successful, \fBLFF_OK\fR will be returned,
otherwise an error code.
.PP
\fILff_read_packed\fR reads the next sequential scanline like
\fIlff_read_line\fR, but the pixels read are \fBnot\fR unpacked into
32-bit \fBRGBPIXELs\fR. Instead, the buffer as read off disk is placed
in the byte array \fIline\fR. If the image is \fBdumped\fR
(\fIhdr->hdr_storage\fR == \fBSTORAGE_DUMP\fR),
sequential image bytes are
placed in \fIline\fR in color channel order. For example, if the image
format is \fBFORMAT_RGB\fR (most common), the \fIline\fR array will contain
bytes \fBRGBRGBRGBRGB...\fR. If the image is \fBFORMAT_BINARY\fR, bits
are just copied directly from the image file.
.PP
If the image is run-length encoded, there are two ways of
interpreting the array of bytes returned. Run-length encoded
images may be stored either dumped or encoded on any given scan
line, depending on which method is more space-efficient.
Therefore, \fI*format\fR will be set to either \fBSTORAGE_DUMP\fR if the
pixels are dumped, or \fBSTORAGE_RLE\fR if they are encoded. The
interpretation of these bytes is left to the user. Look at the
source for lffdl for some help. It is recommended that
\fIlff_read_line\fR always be used instead of this function unless
speed is essential.
.PP
\fIClose_lff\fR must be called after \fIopen_lff\fR before another
lucasfilm image may be opened.
It closes the currently open .lff file (if any). Calls
to \fIlff_read_line\fR and \fIlff_read_packed\fR will fail after \fIclose_lff\fR
is called. The file is not actually closed if it was opened with \fIopen_lff_fd\fR.
.PP
Sample code for processing a .lff file using these routines is:
.sp
.nf
.in +3P
if ((stat = open_lff(name,&hdr)) == LFF_OK) {
.in +3P
vtiles = hdr.hdr_height / hdr.hdr_tileheight;
htiles = hdr.hdr_width / hdr.hdr_tilewidth;

for (rowtile = 0; rowtile < vtiles; rowtile++)
.in +3P
for (coltile = 0; coltile < htiles; coltile++) {
.in +3P
lff_seek_tile(rowtile, coltile);
for (row = 0; row < hdr.hdr_tileheight; row++) {
.in +3P
lff_read_line(line,&y);
process_tile_line(rowtile,coltile,line);
.in -3P
}
.in -3P
}
.in -6P
} else
.ti +3P
printf(``Error: %s\\n'',pixerrmess(stat));
.in -3P
.fi
.SH SEE ALSO
intro_pix(3L), pixerrmess(3L)
