.fp 1 R
.fp 2 I
.fp 3 B
.so date.trf
.TH MKLFFHDR 1L "\*(td" "Caltech CS Graphics Group" "Graphics Group Programmer's Manual"
.SH NAME
mklffhdr - create lucasfilm image header
.SH SYNOPSIS
.B mklffhdr
height width [options]
.SH DESCRIPTION
.I Mklffhdr
write on standard output the header and tile pointer table of a lucasfilm
image with specified parameters. The output file size will be rounded up
to a multiple of 1024 bytes (the lucasfilm block size). The header will
contain the specified height, width, and various default values which
may be overridden as follows:
.TP
.BI \-addr " offset"
Offset of the first tile pointer in the file is set as specified.
By default it immediately follows the header (at offset 1024).
.TP
.BI \-alpha " alphamode"
Alpha mode flag is set as specified. Default is 0 (unassociated).
.TP
.B \-dump
Storage flag will be dumped (this is the default).
.TP
.BI \-format " format"
Format flag specifying channels/pixel and pixel size set as
specified (default FORMAT_RGB).
.TP
.B \-rle
Storage flag will be encoded.
.TP
.BI \-tilefile " name"
If this is specified, the file \fIname\fR must contain lines
with (pointer, length)
pairs on each line to be put in the tile table. If unspecified, the tile table
will be filled with offsets appropriate for sequentially dumped tiles,
and 0 lengths.
.TP
.BI \-tiles " vtiles htiles"
Tile height and width fields will be filled in as appropriate for
an image with \fIvtiles\fR x \fIhtiles\fR tiling. Normally these are
set for an untiled image (same as image height and width).
.TP
.BI \-title " 'name'"
Title (comment) field is filled in as specified. Normally it is
filled with an empty string.
.TP
.BI \-vers " version"
Version number is set as specified (default 0)
.TP
.BI \-xoff " cols"
X offset is set as specified (default 0).
.TP
.BI \-yoff " rows"
Y offset is set as specified (default 0).
.SH AUTHOR
Jonathan Leech (jon@cit-vax)
.SH DIAGNOSTICS
Various relating to invalid parameters.
.SH SEE ALSO
lffhdr(1L)
.br
Technical Memo #46, ``\fBThe Format of Stored Pictures\fR'', by Thomas Porter,
Computer Division, Lucasfilm, Ltd.
