.so /usr/lib/tmac/tmac.s
.TL
The Format of Stored Pictures
.AU
Thomas Porter
.AI
Technical Memo #46
Computer Division
Lucasfilm, Ltd.

.ds CF "\\n%
.ds RH "\\*(DY
.ds LH "Tech Memo 46
.ds CH "Format of Stored Pictures
.ds LF "Computer Division
.ds RF "Lucasfilm, Ltd.
.AB
This memo presents the Lucasfilm picture storage standard.
Pictures can be of arbitrary resolution, with either dumping or
run length encoding of any subset of RGBA channels.  Pictures are tiled,
allowing for efficient recall of subwindows.
8 and 12 bits per channel are handled.
Caltech extensions (marked with
\fBCIT\fR) are described to encode binary (1 bit/pixel) images.
.AE

.NH 1
The Picture File
.LP
The standard for picture storage at Lucasfilm is intended to accommodate
several different picture formats: multiple channels; different numbers
of bits per channel; encoded and dumped format; arbitrary picture size.
Large pictures can be handled by breaking the picture into smaller
uniform rectangular pieces called
.I tiles.
Thus, a 1024 x 512 picture
could be broken up into 8 256 x 256 tiles.
All pictures are stored with a 512 byte
picture header describing the picture format,
followed by pointers to the start of each encoded tile, followed
by the pixel data of each tile.

We normally save encoded, one-tile, 512 x 488 pictures, stored in 1024 byte
blocks.
The pixel aspect ratio is approximately 5:4.
.NH 2
Picture Headers
.LP
.KS
.TS
box center tab(@);
n | n | c | l
n | n | c | l.
byte number@# bytes@name@description
_
000@4@magic number@0164200
004@2@version number@0
006@246@label@Ascii description
252@4@labelptr@ptr to label continuation
254@2@tile pad length@scanline length in bytes (\fBCIT\fR)
416@2@picture height@pixel height of full picture
418@2@picture width@pixel width of full picture
420@2@tile height@pixel height of each tile
422@2@tile width@pixel width of each tile
424@2@picture format@four bits designating RGBA
426@2@picture storage@encoding and number of bits
428@2@blocking factor
430@2@alpha mode@matted-to-black:0 ; unassociated:1
432@2@x offset@horizontal offset for picture
434@2@y offset@vertical offset for picture
448@4@colormap pointer@pointer into file
452@28@colormap filename@file name of color map
512@8*n@tile pointer table@4-byte pointer, 4-byte length
.TE
.KE
Multiple-byte
data are stored with the least significant 8 bits in the first byte.
The first 4 bytes of each picture are (0200,0350,0000,0000).
.NH 2
Label
.LP
The picture label
is read as an ASCII description by various picture handling programs.
There are no rules about what can be stored in the picture label,
except that
null and control characters may interfere with the printing of the
label.
The first 246 characters are stored in the picture header,
but labels can be arbitrarily long.
A label pointer stored in the header points to any continuation.
Further label information may be allocated in chucks the size of
the blocking factor, with the last four bytes of that chunk
reserved for a link to further blocks.

\fBCIT:\fR The picture label is interpreted as a NULL-terminated
C string; no more than the first 246 characters are significant.
.NH 2
Picture/Tile Height/Width
.LP
Picture height and picture width must be positive numbers.
Tile height and tile width must be positive numbers not greater than
picture height and width, respectively.  Normally, a picture has
one tile, so that the picture and tile dimensions are the same.
It is often useful to choose tile dimensions which are evenly
divisible into picture dimensions.  It becomes much easier, for
example, to retrieve a 512x512 window from a 4096x4096 encoded picture.

Tile dimensions do not have to evenly divide picture dimensions.
Tile 0 is always understood to be in the upper left corner of the
picture; pixel [0,0] of tile 0 is pixel [0,0] of the picture.
Tiles can extend down or to the right beyond the boundaries
of the picture.
Pixels beyond the picture boundaries yet inside border tiles
must be properly encoded in the tiles, yet are undefined with
regard to the picture.

\fBCIT:\fR in this implementation, tile dimensions \fBmust\fR evenly
divide picture dimensions. Sorry about that, folks.
.NH 2
Picture Format
.LP
Pictures can include any subset of RGBA channels.
Full RGBA pictures are the most common; RGB backgrounds are also
popular.  Single channel R pictures are currently recovered as
black-and-white (single channel RGB) pictures.
RGBA channels correspond to bits 3210, so that an RGB picture
has a format of 1110 binary.

\fBCIT:\fR Pictures may also be stored as 1 bit/pixel binary images. In
this case, the format code must be 0x100 (256 decimal). The
\fItile width\fR field contains the number of useful image
bits while the \fItile pad length\fR (only valid with this format)
contains the length in
bytes of 1 scanline in a tile. Scanlines are stored starting on
even byte boundaries, so there may be up to 7 unused bits at
the end of each scanline. Excess bits are ignored. This format is
chosen to speed access to individual scanlines.
.NH 2
Picture Storage
.LP
Four picture storage modes are supported: 8 bit encoded (0);
12 bit encoded (1); 8 bit dumped (2); 12 bit dumped (3).
Two more are being added to accomodate the precision of
Lucasfilm frame buffers: 11 bit encoded (4); 11 bit dumped (5).
11 and 12 bit data is simply stored in two bytes.
11 bit data is understood to cover the interval [-.5, 1.5),
where 3072 is -0.5, 0 is 0.0, 2048 is 1.0, and 3071 is almost 1.5.

(CIT) Binary images may only be stored in the dumped format (2).
.NH 3
Encoded Tiles
.LP
If the tiles are to be encoded (see byte 426 of the header),
the pixel information is broken into packets, each headed by a flag and count.
The flags are listed below with corresponding data for four, three, and one
channel files:

.KS
.TS
box center tab(@);
c | c | c | c | c | c
c | c | c | c | c | c.
_
flag@count@RGBA@RGB@R@comment
_
0@@@end of disk block
1@c@RGBA RGBA ...@RGB RGB ...@R R ...@full channel dump
2@c@\(*lRGBA \(*lRGBA ...@\(*lRGB \(*lRGB ...@\(*lR \(*lR ...@full channel run
3@c@A RGB RGB ...@n/a@n/a@partial channel dump
4@c@A \(*lRGB \(*lRGB ...@n/a@n/a@partial channel run
.TE
.KE

.ne 1.5i
The flag and count are packed into 16 bits as follows:
.KS
.TS
center box tab(@);
c | c
c | c | c.
first byte@count <0:7>
_
second byte@flag <0:4>@count <8:11>
.TE
.KE
allowing 4 bits for flag and 12 bits for count.
.I
This seems to have been an unfortunate choice.
An 8-bit count would have been perfectly sufficient and more efficient.
.R

When flag equals 1 or 3,
the 12-bit count c is one less than the number of dumped
pixels in the data.  A count c of 0 indicates 1 instance
and no repetition.  This allows dumps of length 4096 pixels.

When flag equals 2 or 4, the 12-bit count c is one less than the number of
run lengths.  Each run length is started with an 8-bit \(*l, which
indicates the number of repeated pixels.  Once again, a length \(*l
of 0 indicates 1 instance and no repetition.

Blocking of the data speeds disk access.
No data packet spans multiple
disk blocks, and zeroes should fill out the block.  The number of bytes
per block is set in byte 428 of the picture header.  Furthermore, no
packet spans multiple scanlines.

\fBCIT:\fR only packet types 0, 1, and 2 are supported.
.NH 3
Dumped Tiles
.LP
If byte 426 of
the picture header lists this as a dumped picture, no excess bytes
are used for encoding the data.  The tile data is listed as RGBRGBRGB...
for RGB pictures and RRRRR... for single channel pictures.
.NH 2
Blocking Factor
.LP
The blocking factor indicates the optimum disk transfer chunk.
The only side effect of the blocking factor is that encoded packets
do not span adjacent disk blocks.
.NH 2
Alpha Mode
.LP
The alpha channel is stored with pictures.  Normally, alpha is stored
.I associated
with its picture in the sense that the element is effectively matted
to black.  Soft edges of the matte correspond to soft edges in the picture
as it rolls off to blackness.  Alpha can be stored
.I unassociated
with RGB, so that a circle matte might be stored with a full
background image.  Compositing routines need to know this differentiation.
.NH 2
Picture Offsets
.LP
Pictures are understood to have an xy translation, so that a saved frame
buffer window can be restored to the same spot.
.NH 2
Color Map information
.LP
This is not fully specified.
.NH 2
Tile Pointer Table
.LP
Each tile has a 4-byte pointer and 4-byte length.  Tiles are numbered
across from 0 to (numberxtiles*numberytiles-1), where numberxtiles is
(1 + (picturewidth-1)/tilewidth) and numberytiles is similar.
A pointer of 0 indicates a null tile; a positive pointer and a count
of -1 indicates an incomplete tile; otherwise the tile is complete.
Using the tile pointers, it is possible to overwrite individual tiles
by appending tile pixels to the file and changing the tile pointer
information, leaving the old tile data as garbage in the file.

\fBCIT:\fR The length field is not used (or needed) in our implementation.
.NH 1
Recommendations for simple use
.LP
Set up the picture header with the tile size equal to the picture size.
This eliminates one level of complexity.  Set up the tile pointer table with
one 4-byte pointer (at byte 512) to file location 1024.  The 4-byte length
is not crucial.
Use dumped format
for the pixel data for further simplification.	Set up the header as indicated
in the table above, and start dumping the pixel data at location 1024.

The simple recommended picture header is listed below:
.KS
.TS
box center tab(@);
n | n | c | l
n | n | c | l.
byte number@# bytes@name@description
_
000@4@magic number@0164200
004@2@version number@0
006@246@label@0
252@4@labelptr@0
254@2@tile pad length@0
416@2@picture height@488
418@2@picture width@512
420@2@tile height@488
422@2@tile width@512
424@2@picture format@14 or 8
426@2@picture storage@0 or 2
428@2@blocking factor@1024
430@2@alpha mode@0
432@2@x offset@0
434@2@y offset@0
448@4@colormap pointer@0
452@28@colormap filename@0
512@8*n@tile pointer table@1024,0
1024@?@dumped pixel information
.TE
.KE
