/*
 *  cli.h - declarations for CLI Library
 */
#ifndef CLI_H_READ
#define CLI_H_READ

#include <stdio.h>
#include <ctype.h>
#include <malloc.h>

#define MAXARGS   30		/* Max arguments to a command */
#define MAXARGLEN 40		/* Maximum length of an argument */
#define MAX_FILES 20		/* Max nesting depth of files */
#define MAX_STACK_DEPTH 20	/* Maximum number of nested transforms */

#ifdef BUFLEN
#undef BUFLEN
#endif
#define BUFLEN 256			/* Max length of input line */

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#ifndef PI
#define PI	3.141592653589793238
#define PI2	6.283185307179586477
#endif

/*
    A COM_ENTRY is an entry in the command dispatch table.
*/
typedef struct {
    char   *com_name;
    int   (*com_pfunc)();
    char   *com_help;
} COM_ENTRY;

/*
    A structure containing multiple ARGs (all arguments to a cli command)
*/
typedef struct {
    int  nargs;
    char args[MAXARGS][MAXARGLEN];
} ARGS;

typedef int (*PFUNC)();
typedef FILE *(*FFUNC)();
typedef void (*VFUNC)();

/*
 * Global CLI variables
 */

/* In cli.c */
extern int  CliDebug;
extern ARGS CliArgs;
extern COM_ENTRY *CliComTable;
extern int	  CliComEntrys;

/* In lex.c */
extern char *stripcmd(),
	    *gettok(),
	    *skipspace();

#endif	/* CLI_H_READ */
