 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 


/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */
#include "unmcopyright.h"
#include "spectrum.h"



/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>  		        Zoom Drivers
 >>>>
 >>>>			run_zoom_subform()
 >>>>			run_zoom()
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */




/********************************************************
*
*  Routine Name:  run_zoom_subform
*
*       Purpose:  drives the subform 'zoom_subform'
*
*         Input:  form - pointer to the form tree 
*		  zoom_subform_info  - information structure for 
*				       subform 'zoom_subform'
*        Output:  action of the application program
*
*     Called By:  run_master()
*
*   Automatically Generated By:  conductor -i spectrum.form -l 3 -b
*
********************************************************/


run_zoom_subform(form, zoom_subform_info)

xvf_form *form;
master_zoom_subform *zoom_subform_info;
{

	_xvf_get_zoom_subform(form, zoom_subform_info);

	/*
	 * action came from the 'zoom' pane
	 */
	if (zoom_subform_info->zoom_selected)
	    run_zoom(form, zoom_subform_info->zoom);


}   /* end run_zoom_subform */





/********************************************************
*
*  Routine Name:  run_zoom
*
*       Purpose:  drives the pane 'zoom'
*
*         Input:  form - pointer to the form tree 
*		  zoom_info  - information structure for pane 'zoom'
*        Output:  action of the application program
*
*     Called By:  run_zoom_subform()
*
*   Automatically Generated By:  conductor -i spectrum.form -l 3 -b
*
********************************************************/


run_zoom(form, zoom_info)

xvf_form *form;
zoom_subform_zoom *zoom_info;
{

	_xvf_get_zoom(form, zoom_info);

	/*
	 * user clicked on 'live' float selection 'zoomfactor'
	 */
	if (xvdisplay == NULL) return;

	if (zoom_info->do_zoom)
	{
             XtRemoveEventHandler(xvdisplay->raster, ButtonPressMask, FALSE, 
			          add_cluster_from_img, NULL);
             XtInsertEventHandler(xvdisplay->raster, ButtonPressMask,
                                  FALSE, spc_zoom, NULL, XtListHead);
	}

	/*
	 * user clicked on 'live' float selection 'zoomfactor'
	 */
	if (zoom_info->zoomfactor_selected)
	{
	    zoom->zoomfactor = zoom_info->zoomfactor;
            refresh_zoom(zoom);

	}
}


