 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 *   Copyright, 1991, The Regents of the University of California.
 *   This software was produced under a U.S. Government contract
 *   (W-7405-ENG-36) by the Los Alamos National Laboratory, which is
 *   operated by the University of California for the U.S. Department
 *   of Energy.  The U.S. Government is licensed to use, reproduce,
 *   and distribute this software.  Neither the Government nor the
 *   University makes any warranty, express or implied, or assumes
 *   any liability responsibility for the use of this software.
 */

#include <stdio.h>

#include "lanlmisc.h"

#define COUNT_COL_PRESENT 1
#define CLASS_COL_PRESENT 2
#define COV_UPPER_PRESENT 4
#define COV_DIAG_PRESENT 8

#define FALSE 0
#define TRUE 1

/*
 *  getstats ()     Given the data statistics for a VIFF file (stored as
 *                  a floating-point map) this routine will allocate 
 *                  memory for, and return the statistics.  If a pointer
 *                  comes back NULL, that item of data was not present in 
 *                  the map.
 *
 *  Written by:  Patrick M. Kelly & James M. White
 *  Date:        6-26-91
 */

int getstats (ptr,ispare1,dim,num,means,count,class,cov_upper,cov_diag)

float *ptr;		/* Pointer to map data (INPUT) */
unsigned long ispare1;	/* Determine what is present in the map data */
int dim;		/* Dimension of the data */
int num;		/* Number of table entries */
float ***means;		/* (OUTPUT) Mean vector data */
int **count;		/* (OUTPUT) Number of members data */
int **class;		/* (OUTPUT) Class number data */
float ****cov_upper;	/* (OUTPUT) Upper triangular covariance matrix data */
float ***cov_diag;	/* (OUTPUT) Variances of the data */

{
   int start;           /* Starting offset into map data */
   int r,c,j;           /* Loop control */

   /*
    *  (1)  Check for stupid call.
    */
   if ( ptr == NULL ) {
      fprintf (stderr,"getstats:  NO MAP DATA PROVIDED!\n");
      return (FALSE);
   }

   /*
    *  (2)  GET MEAN VECTOR DATA:  ALWAYS PRESENT
    */
   start = 0;

   *means = contig_matrix ( num, dim );

   for ( r = 0 ; r < num ; r ++ ) {
   for ( c = 0 ; c < dim ; c ++ ) {
      (*means) [r][c] = ptr [start+r+c*num];
   }
   }

   start += dim*num;

   /*
    *  (3)  GET COUNT DATA
    */
   if ( ispare1 & COUNT_COL_PRESENT ) {
      if ( (*count = (int *) malloc (sizeof(int) * num)) == NULL ) {
         fprintf (stderr,"getstats:  MEMORY ALLOCATION FAILURE\n");
         return (FALSE);
      }
      for ( r = 0 ; r < num ; r ++ ) {
         (*count) [r] = (int) ptr [start+r];
      }
      start += num;
   }

   /*
    *  (4)  GET CLASS DATA
    */
   if ( ispare1 & CLASS_COL_PRESENT ) {
      if ( (*class = (int *) malloc (sizeof(int) * num)) == NULL ) {
         fprintf (stderr,"getstats:  MEMORY ALLOCATION FAILURE\n");
         return (FALSE);
      }
      for ( r = 0 ; r < num ; r ++ ) {
         (*class) [r] = (int) ptr [start+r];
      }
      start += num;
   }

   /*
    *  (5)  GET UPPER-TRIANGULAR COVARIANCE MATRIX.
    */
   if ( ispare1 & COV_UPPER_PRESENT ) {
      if ((*cov_upper = (float ***) malloc(sizeof(float **) * num))==NULL) {
         fprintf (stderr,"getstats:  MEMORY ALLOCATION FAILURE\n");
         return (FALSE);
      }
      for ( r = 0 ; r < num ; r ++ ) {
         (*cov_upper) [r] = SM_get_matrix ( dim );
         for ( j = 0 ; j < ((dim * (dim+1))/2) ; j ++ ) {
            (*cov_upper) [r][0][j] = ptr [start+r+j*num];
         }
      }
      start += ((dim * (dim+1))/2)*num;
   }

   /*
    *  (6)  GET DIAGONAL COVARIANCE MATRIX.
    */
   if ( ispare1 & COV_DIAG_PRESENT ) {

      *cov_diag = contig_matrix ( num, dim );
      for ( r = 0 ; r < num ; r ++ ) {
      for ( c = 0 ; c < dim ; c ++ ) {
         (*cov_diag) [r][c] = ptr [start+r+c*num];
      }
      }

   }

   return (TRUE);
}
