.ds CF
.ds CH
.ds CF - % -
.nr HM .70i
.nr FM .75i
.nr PO .50i
.nr PS 11
.nr VS 13
.nr LL 7.0i
.sp 2
.LP
.ps 17
.vs 20
.ll 6.0i
.ce 3
\f(HB
KHOROS: 
AN ENVIRONMENT FOR INFORMATION PROCESSING, 
DATA VISUALIZATION, AND SOFTWARE DEVELOPMENT
\fP
.R
.sp 2
.MC 3.35i .15i
.ps 9
\f(HBTHE KHOROS PROJECT\fP
.LP
The main goal of the Khoros software project is to create and provide an 
integrated software development environment for information processing and data 
visualization. The Khoros software system is now being used 
as a foundation to improve productivity and promote software 
reuse in a wide variety of application domains.  A powerful feature of the 
Khoros system is the high-level, abstract visual language that can be employed 
to significantly boost the productivity of the researcher. 
.LP
Central to the Khoros system is the need for a consistent yet flexible 
user interface development system that provides cohesiveness to the vast 
number of programs that make up the Khoros system.  Automated tools assist 
in maintenance as well as development of programs. The software structure 
that embodies this system provides for extensibility and portability, and 
allows for easy tailoring to target specific application domains and 
processing environments.  
.sp
.ps 9
\f(HBOVERVIEW\fP
.LP
The Khoros system integrates multiple user interface modes, code generators, 
instructional aids, data visualization, distributed computing
and information processing.
The result is a comprehensive tool for computational research and
development.  The Khoros infrastructure consists of six major subsystems:
.IP (1)
A high-level visual language that may be extended to fit the application domain.
.IP (2) 
A user interface development system consisting of a User Interface 
Specification (UIS) and code generators that use the UIS to generate code for
all programs created under the Khoros system.
.IP (3)
An interoperable data exchange format (VIFF) supported by a comprehensive
automatic storage conversion library.
.IP (4)
Application specific data display and processing libraries; image processing,
digital signal processing, numerical analysis, data and file conversion, 
graphics display, and image display.
.IP (5)
A set of interactive X Windows-based programs address such areas as
image display, colormap manipulation, animation, plotting, warping of image 
data, and surface visualization.
.IP (6)
A set of meta-system calls provide a foundation for
distributed computing and efficient data transport. 
Khoros provides user selectable compute locations via the visual language,
computer supported cooperative work via a distributed X mechanism, and
remote access to data via a distributed data transport server.
.LP
The software structure that embodies this system provides for extensibility 
and portability, and allows for easy tailoring to target specific application 
domains and processing environments. Khoros is a successful demonstration of 
how research programming, application programming, information processing, 
data visualization, instruction, documentation, and maintenance can be 
integrated to build a state-of-the-art software environment.
.sp
.ps 9
\f(HBTHE VISUAL LANGUAGE\fP
.LP
The visual language of Khoros, \fBcantata\fP, is a graphically 
expressed, data-flow oriented language.  The user builds a \fBcantata\fP 
application program ("workspace") by connecting processing nodes ("glyphs")
to form a data flow graph.  Glyphs are selected from the many library routines
available with Khoros; the user may also create new library routines using the 
Khoros user interface development system, and make them available to 
\fBcantata\fP.  The visual language is considered to be large-grain because 
each glyph represents an entire program.  "Control" glyphs (providing if/else
conditions, loops, etc) and a expression parser extend the functionality of 
the underlying data flow methodology.
.LP
Visual "procedures", each representing a segment of the network of glyphs in
a workspace, can be used to add structure to the visual language and help to 
manage the complexity often associated with visual programming.
A dynamic execution scheduler allows the user to interactively execute 
the entire flow graph across a heterogeneous computer network.  The execution
can be set to either a demand driven or data driven model depending on
the application and desired level of interactivity.
.sp
.KS
.ps 9
\f(HBUSER INTERFACE DEVELOPMENT SYSTEM\fP
.LP
The framework of every program in the Khoros system is defined by a
User Interface Specification. This high-level specification is used with
automatic code generators that allow Khoros programs to combine a UNIX-like
command line user interface (CLUI) with an X-Windows based graphical user 
interface (GUI).  Khoros programs can be easily incorporated into the 
visual language that is
an integral part of the Khoros system;  the use of the code generators ensures
that program user interfaces and documentation are consistent and correct.
In addition, the user interface development system provides a means of
quickly prototyping new algorithms, encourages standard coding styles and
methods, and can potentially make the user as productive in extending the
system as the original programmers were in creating it.
The software development tools listed below allow
an end-user to act as a developer to extend the system.
.KE
.nr PS 10
.nr VS 12
.KS
.TS
center tab(:);
l l.
Program Name:Description
_
\fBpreview\fP:GUI display tool
\fBcomposer\fP:GUI editor 
\fBconductor\fP:code generation tool for a GUI's
\fBghostwriter\fP:code generation tool for CLUI's
\fBkinstall\fP:source configuration & management tool
.TE
.KE
.nr PS 11
.nr VS 13
.LP
The Khoros user interface development system provides features common to all 
applications, such as: (1) journal recording/playback & distributed user 
interfaces for X-Windows based applications, (2) re-arrangement of the graphical
user interface without recompiling, (3) consistency of use, (4) standardized
documentation format, and (5) consistent structured programming methodology 
and styles.
.sp
.ps 9
\f(HBINTEROPERABLE DATA EXCHANGE FORMAT
.LP
The Khoros Visualization and Image File Format (VIFF) or data structure 
supports
general geometric objects, multidimensional data, and a robust
mapping scheme.  Storage type conversion
between different architecture platforms is automatically performed by
the meta-system read and write utilities; 
for example, DEC VAX floating point data
is automatically converted to IEEE format if read on a SUN computer.
The consistent use of the Khoros data structure promotes an algorithm
library that can be used in many disciplines and supports
data exchange.
.LP
As Khoros expands, there will be a need
to support a set of "standard" file formats.  Currently, Khoros provides
for data interchange with other systems via file format converters.
Khoros supports the following file formats: TIFF, pbm, BIG, DEM, DLG,
ELAS, FITS, Matlab, SUN raster, TGA, and xbm.
.sp
.ps 9
\f(HBDATA PROCESSING LIBRARIES
.LP
Khoros includes libraries of programs that can operate on point data, 
one-dimensional data, two-dimensional data, multiband data or N-dimensional
vector data.  These operators are designed to be polymorphic, or
in other words they function on bit, byte, short, integer, float and
complex data types.  The term also implies that the functions know
to operate differently depending on the dimensionality or organization
of the data.
.LP
There are two interface levels defined in the library functions in Khoros;
the program or process interface and the function call or procedure
interface.  The program interface is determined completely by the high-level
user interface specification described above.  The procedure
interface is currently not as well defined, but allows the 
procedures (functions) to be easily combined into a single program.  
As a note, visual programs
are built by executing a set of programs using the program interface.
.LP
The libraries contain over 260 programs, in the 
following categories: arithmetic, classification, 
color conversion, data conversion, file format conversion, 
feature extraction, frequency filtering, spatial filtering, 
morphology filtering, geometric manipulation, histogram manipulation,
statistics, signal generation, linear operations, segmentation, 
spectral estimation, subregion, and transforms.
.LP
In addition, high-level graphics and display libraries are available 
to those who wish to create new X-Windows based applications under Khoros.  
These libraries act as a "visualization toolkit" that is layered on
top of Xlib, Xtk and the Athena Widgets.
.nr PS 10
.nr VS 12
.KS
.TS
center tab(:);
l l.
Library:Description
_
\fBforms\fP:graphical user interface 
\fButils\fP:pop-up browsers, errors, help, etc.
\fBgaphics\fP:2D/3D graphics; X, Postscript, HPGL
\fBdisplay\fP:image display & editing
.TE
.nr PS 11
.nr VS 13
.KE
.sp
.ps 9
\f(HBX WINDOWS APPLICATIONS\fP
.LP
The interactive graphical user interface programs that are part of Khoros
are based on MIT X11R4 and the Athena widgets. Such applications written under 
the Khoros system are automatically endowed with a journal record and playback
capability that is useful for demonstration and instructional purposes.
Taken a step farther, the journal record/playback capability was extended
to work on multiple displays simultaneously with a "distributed user interface
controller".  This distributed user interface empowers users to execute a 
Khoros application which not only will appear on multiple displays 
simultaneously, but which can also receive input from each of the users.   
.KS
Still under development, the distributed user interface controller will
provide a more sophisticated mechanism for instructional and demonstration 
purposes, as well as a powerful tool for a long-distance, collaborative 
approach to problem solving.
.KE
.nr PS 10
.nr VS 12
.KS
.TS
center tab(:);
l l.
Program Name:Description
_
\fBcantata\fP:visual programming language
\fBeditimage\fP:image display & manipulation
\fBanimate\fP:image sequence display
\fBxprism2\fP and \fBxprism3\fP:2D and 3D plotting packages
\fBviewimage\fP:surface visualization 
\fBwarpimage\fP:image registration and warping
\fBconcert\fP:distributed user interface controller
.TE
.nr PS 11
.nr VS 13
.KE
.sp
.ps 9
\f(HBMETA-SYSTEM FOUNDATION
.LP
Khoros is designed to operate and fully utilize a heterogeneous computing
environment.  The meta-system library provides a set of function
calls that extend the standard UNIX system calls to provide a network
level interface.  As an example, the \fBkopen()\fP function can 
open a standard file on the local host as well as open access to:
a remote file, a socket, shared memory, a pipe, a stream, or SUN's
Virtual Memory.  This simple interface provides access to network wide
data transport.  
.LP
The application programmer benefits from the meta-system because the
task of writing distributed applications is simplified.
The end user benefits from the meta-system by being able to
select compute locations via \fBcantata\fP and by being able to
access remote data transparently.
.LP
The careful integration of the six Khoros subsystems summarized
above allow it to act as
a distributed collaboration environment.
.sp
.ps 9
\f(HB HISTORY
.LP
The Khoros project has been underway at the Department of Electrical and
Computer Engineering at the University of New Mexico since January of 1987.
Previously named "XVision", the project has undergone tremendous changes in
focus and scope since its beginning.  Originally conceived as a tool 
to improve the productivity of research,  initial software was developed
to provide a consistent command line user interface for an existing
library of image processing programs.  The project quickly expanded to 
contain an image display program,  a plotting package, and 
code generators to automate the creation of code that was 
common to all programs.  
.LP
A visual language was developed to provide users with a more convenient 
and intuitive access to the capabilities offered by the burgeoning image 
processing library.  Other libraries were developed to address problems in 
digital signal processing, numerical analysis, data conversion, and remote 
sensing.  A number of new graphical and image display packages were 
developed to meet the demands of the users, while the user interface 
development system matured in order to meet the demands of the rapidly 
growing project.  The distributed user interface was implemented 
experimentally, to support the concept of groupware;  reactions have been 
extremely favorable so far.  
.sp
.ps 9
\f(HBCURRENT STATUS OF KHOROS (Patch Level 5)\fP
.LP
The Khoros system has been applied to a diverse spectrum of areas including 
medical research, ecological studies, remote sensing, virtual reality, 
telecommunications, and optics. The Khoros project continues to evolve as 
new developments occur in the continued research and development of software 
environments for information processing, data visualization and software 
development.  Khoros is being used as a teaching tool at several Universities.
Release 1.0 of Khoros was offered free of charge via public ftp access on 
May 10, 1991; updates have since been provided in patch form.  Release 2.0 
of Khoros is expected to be out in late 1992.  
.PP
The documentation for the system is a combination of on-line help and
printed manuals.  The manual is made up of three separate
volumes: User's Manual, Programmer's Manual, and Reference Guide.
Also, journal playback files are provided to give the new user
"live" demonstrations of the various applications.
.PP
Khoros currently runs on APOLLO, CRAY, DEC, HP, IBM, OMRON, NeXT, SGI 
and SUN platforms, and there are porting efforts for 386/486, CONVEX, 
DG and MacII platforms.  
Khoros is now available via anonymous ftp at no charge 
(from pprg.eece.unm.edu, 129.24.24.10, in the /pub/khoros directory),
or a tape and printed 
documentation can be ordered for $250.00 (US and Canada) and $350.00 
(International).
Support is provided via both a mail user's group and USENET News in which 
hundreds of users are now members.  For more information, send e-mail to
khoros-request@chama.eece.unm.edu.
