 /*
  * Khoros: $Id: xverror.c,v 1.1 1991/05/10 16:00:00 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: xverror.c,v 1.1 1991/05/10 16:00:00 khoros Exp $";
#endif

 /*
  * $Log: xverror.c,v $
 * Revision 1.1  1991/05/10  16:00:00  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: xverror.c
 >>>>
 >>>>      Program Name: xverror
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	This program pops up a widget on the X screen  in  which  an
 >>>>	error message may be displayed.
 >>>>	
 >>>>	
 >>>>            Author: Stephanie Hallett and Danielle Argiro
 >>>>
 >>>> Date Last Updated: Tue Apr  2 16:07:02 1991
 >>>>
 >>>>          Routines: main- the main program for xverror
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "xverror.h"


/****************************************************************
 *
 * Routine Name:  main program for xverror
 *
 *       Input:  
 *         -e  error message to be displayed 
 *
 *
 *         [-t] title of error box
 *         [-b] label of exit button
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        consolidate_args();
        display = xvf_initialize(ac,av, "xverror");
        xvf_error_wait(xverror->e, xverror->t, xverror->b);
/* -main_before_lib_call_end */

/* -main_library_call */
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for xverror 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "xverror :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tThis program pops up a widget on the X screen  in  which  an\n");
	fprintf(stderr, "\terror message may be displayed.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-e  error message to be displayed  (string)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-t]  title of error box (string) [Error:]\n");
	fprintf(stderr,"\t[-b]  label of exit button (string) [Ok ]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for xverror\n");
	fprintf(stderr, "\t[-U] Gives the usage for xverror\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called xverror.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses xverror.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for xverror
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*e_pstr = 
	"\nEnter: (e) error message to be displayed \n        {string}: "; 
char	*e_def = NULL;
char	*t_pstr = 
	"\nEnter: (t) title of error box \n        {string ['Error:'] }: "; 
char	*t_def = "Error:";
char	*b_pstr = 
	"\nEnter: (b) label of exit button \n        {string ['Ok '] }: "; 
char	*b_def = "Ok ";
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "xverror", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "xverror.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "xverror: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "xverror.ans");
		}

	     }

	}

	/*
	 * allocate the xverror structure
	 */
	xverror = (xverror_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (xverror_struct));

	/*
	 * get required arguments for xverror
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(xverror->e_flag = vget_string(fid, prompt_flag,
			"-e", e_pstr, &(xverror->e),
			e_def)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(xverror->e_flag))
		{
		    fprintf(stderr, "\t\te is required, please re-enter: \n");
		    xverror->e_flag = vget_string(fid, prompt_flag,
		    "-e", e_pstr, &(xverror->e),
		    e_def);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-e' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for xverror
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	xverror->t_flag = vget_string(fid, prompt_flag,
	"-t", t_pstr, &(xverror->t),
	t_def);

	if (prompt_flag == FALSE)
	{
	    if ((xverror->t_flag == 1)&&(xverror->t == NULL))
    	{
		fprintf(stderr, "xverror:\n");
		fprintf(stderr, "you must specify a name following '-t'\n");
		gw_usage();
		exit(1);
		}
	}
	xverror->b_flag = vget_string(fid, prompt_flag,
	"-b", b_pstr, &(xverror->b),
	b_def);

	if (prompt_flag == FALSE)
	{
	    if ((xverror->b_flag == 1)&&(xverror->b == NULL))
    	{
		fprintf(stderr, "xverror:\n");
		fprintf(stderr, "you must specify a name following '-b'\n");
		gw_usage();
		exit(1);
		}
	}

}



