 /*
  * Khoros: $Id: activate.c,v 1.3 1992/03/20 22:52:14 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: activate.c,v 1.3 1992/03/20 22:52:14 dkhoros Exp $";
#endif

 /*
  * $Log: activate.c,v $
 * Revision 1.3  1992/03/20  22:52:14  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1991 by UNM */
#include "kraftsman.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: activate.c                             <<<<
   >>>>                                                       <<<<
   >>>>   description:                                        <<<<
   >>>>                                                       <<<<
   >>>>      routines: activate_create()		      <<<<
   >>>>                activate_config()                      <<<<
   >>>>                deactivate_create()                    <<<<
   >>>>                deactivate_config()                    <<<<
   >>>>                generate_create()                      <<<<
   >>>>                generate_config()                      <<<<
   >>>>                                                       <<<<
   >>>> modifications:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/***********************************************************************
*
*  Routine Name: activate_create()
*
*          Date: 12/4/91
*        
*       Purpose: To reactivate the Create Pane when the user
*		 provides a valid toolbox name
*
*         Input: name - new string for toolbox field
*		 toolpath - new string for toolbox path
*		 author - new string for toolbox author
*		 user - new string for toolbox user
*		 title - new string for toolbox title
*		 sdescript - new string for toolbox short description
*		 info - new string for toolbox information file path
*
*        Output: Activation of the form
*
*    Written By: Steven Jorgensen
*
* Modifications:
*
***********************************************************************/
void activate_create(form, toolpath, author, user, title, sdescript, info)
  xvf_form *form;
  char *toolpath;
  char *author;
  char *user;
  char *title;
  char *sdescript;
  char *info;
  {
    if (toolpath != NULL)
      xvf_change_input(form, Master_info.Kraftsman->create->toolpath_index,
		       xvf_stringval_chng, toolpath, 0);
    xvf_change_input(form, Master_info.Kraftsman->create->toolpath_index,
                     xvf_activation_chng, "1", 0);
    if (author != NULL)
      xvf_change_input(form, Master_info.Kraftsman->create->author_index,
		       xvf_stringval_chng, author, 0);
    xvf_change_input(form, Master_info.Kraftsman->create->author_index,
                     xvf_activation_chng, "1", 0);
    if (user != NULL)
      xvf_change_input(form, Master_info.Kraftsman->create->user_index,
		       xvf_stringval_chng, user, 0);
    xvf_change_input(form, Master_info.Kraftsman->create->user_index,
                     xvf_activation_chng, "1", 0);
    if (title != NULL)
      xvf_change_input(form, Master_info.Kraftsman->create->title_index,
		       xvf_stringval_chng, title, 0);
    xvf_change_input(form, Master_info.Kraftsman->create->title_index,
                     xvf_activation_chng, "1", 0);
    if (sdescript != NULL)
      xvf_change_input(form, Master_info.Kraftsman->create->sdescript_index,
		       xvf_stringval_chng, sdescript, 0);
    xvf_change_input(form, Master_info.Kraftsman->create->sdescript_index,
                     xvf_activation_chng, "1", 0);
    if (info != NULL)
      xvf_change_input(form, Master_info.Kraftsman->create->info_index,
		       xvf_stringval_chng, info, 0);
    xvf_change_input(form, Master_info.Kraftsman->create->info_index,
                     xvf_activation_chng, "1", 0);
    xvf_change_input(form, Master_info.Kraftsman->create->create_index,
                     xvf_activation_chng, "1", 0);
    xvf_change_input(form, Master_info.Kraftsman->create->add_index,
		     xvf_activation_chng, "1", 0);
  }

/***********************************************************************
*
*  Routine Name: activate_config()
*
*          Date: February 27, 1992
*        
*       Purpose: To activate the config pane.
*
*         Input: form		- pointer to an xvf_form structure
*
*        Output: none
*
*    Written By: Steven Jorgensen
*
* Modifications:
*
***********************************************************************/
void activate_config(form)
xvf_form *form;
  {
    int indx = Master_info.Kraftsman->configure->libdir_index;
    static char *endkey = "xlib";
    char *comparekey = NULL;
    Line_Info line_info;

    xvf_clear_line_info(&line_info);

    while (comparekey == NULL || VStrcmp(comparekey,endkey) != 0)
      {
	kfree(comparekey);
	xvf_parse_string_line(form->db[indx], &line_info);
        xvf_change_input(form, indx, xvf_activation_chng, "1", 0);
	comparekey = VStrcpy(line_info.variable);
	indx++;
      }
    kfree(comparekey);
    xvf_change_input(form, Master_info.Kraftsman->configure->configure_index,
		     xvf_activation_chng, "1", 0);
  }

/***********************************************************************
*
*  Routine Name: deactivate_create()
*
*          Date: February 27, 1992
*        
*       Purpose: To disable the fields on the create pane.
*
*         Input: form		- pointer to the xvf_form structure for program
*
*        Output: none
*
*    Written By: Steven Jorgensen
*
* Modifications:
*
***********************************************************************/
deactivate_create(form)
xvf_form *form;
  {
    xvf_change_input(form, Master_info.Kraftsman->create->toolpath_index,
		     xvf_activation_chng, "0", 0);
    xvf_change_input(form, Master_info.Kraftsman->create->author_index,
		     xvf_activation_chng, "0", 0);
    xvf_change_input(form, Master_info.Kraftsman->create->user_index,
		     xvf_activation_chng, "0", 0);
    xvf_change_input(form, Master_info.Kraftsman->create->title_index,
		     xvf_activation_chng, "0", 0);
    xvf_change_input(form, Master_info.Kraftsman->create->sdescript_index,
		     xvf_activation_chng, "0", 0);
    xvf_change_input(form, Master_info.Kraftsman->create->info_index,
		     xvf_activation_chng, "0", 0);
    xvf_change_input(form, Master_info.Kraftsman->create->create_index,
		     xvf_activation_chng, "0", 0);
    xvf_change_input(form, Master_info.Kraftsman->create->add_index,
		     xvf_activation_chng, "0", 0);
  }

/***********************************************************************
*
*  Routine Name: deactivate_config()
*
*          Date: February 27, 1992
*        
*       Purpose: To disable the fields on the config pane
*
*         Input: form           - pointer to the xvf_form structure for program
*
*        Output: none
*
*    Written By: Steven Jorgensen
*
* Modifications:
*
***********************************************************************/
deactivate_config(form)
xvf_form *form;
  {
    int indx = Master_info.Kraftsman->configure->libdir_index;
    static char *endkey = "xlib";
    char *comparekey = NULL;
    Line_Info line_info;

    xvf_clear_line_info(&line_info);

    while (comparekey == NULL || VStrcmp(comparekey,endkey) != 0)
      {
	kfree(comparekey);
	xvf_parse_string_line(form->db[indx], &line_info);
        xvf_change_input(form, indx, xvf_activation_chng, "0", 0);
	comparekey = VStrcpy(line_info.variable);
	indx++;
      }
    kfree(comparekey);
    xvf_change_input(form, Master_info.Kraftsman->configure->configure_index,
		     xvf_activation_chng, "0", 0);
  }


/***********************************************************************
*
*  Routine Name: generate_def_create()
*
*          Date: February 27, 1992
*        
*       Purpose: Generate default values for the fields on the create pane
*
*         Input: toolbox	- variable containing the toolbox name
*		 toolpath	- variable containing the toolbox path
*		 author		- variable containing the toolbox author
*		 user		- variable containing the toolbox user
*		 title		- variable containing the toolbox title
*		 sdescript	- variable containing a short descript of it
*		 info		- variable containing path to TB info file
*
*        Output: the defaults for the fields.  Stored in the parameters
*		  passed into the routine.
*
*    Written By: Steven Jorgensen
*
* Modifications:
*
***********************************************************************/
generate_def_create( toolbox, toolpath, author, user, title, sdescript, info)
char *toolbox, **toolpath, **author, **user, **title, **sdescript, **info;
  {
    struct passwd *user_entry;
    char *upper, *lower, *tmp, *tmp1;

    user_entry = getpwuid(getuid());
    tmp = vupper_string(toolbox,NULL);
    upper = VStrcat("$",tmp);
    free(tmp);
    lower = vlower_string(toolbox,NULL);

    *toolpath = vfullpath(lower, user_entry->pw_dir, NULL);
    if (strchr(user_entry->pw_gecos, ',') == NULL)
      *author = VStrcpy(user_entry->pw_gecos);
    else
      {
	tmp = VStrcpy(user_entry->pw_gecos);
	tmp1 = strchr(user_entry->pw_gecos,',');
	*tmp1 = '\0';
	*author = VStrcpy(tmp);
        free(tmp);
      }
    *user = VStrcpy(user_entry->pw_name);
    *title = VStrcat(toolbox, " Toolbox");
    *sdescript = VStrcat("A toolbox for ", toolbox);
    *info = VStrcat(upper,"/.Toolbox_info");
  }

/***********************************************************************
*
*  Routine Name: generate_config()
*
*          Date: February 27, 1992
*        
*       Purpose: To set the default field values on the config pane
*
*         Input: form           - pointer to the xvf_form structure for program
*		 entry_list	- List of structure containing info to put on
*				  pane
*		 entry_cnt	- size of entry_list
*
*        Output: none
*
*    Written By: Steven Jorgensen
*
* Modifications:
*
***********************************************************************/
generate_config(form, entry_list)
xvf_form *form;
CFG_ENTRY *entry_list;
  {
    static char *endkey = "xlib";
    int j = 0, k, indx = Master_info.Kraftsman->configure->libdir_index;
    char *comparekey = NULL, *value = NULL;
    Line_Info line_info;

    xvf_clear_line_info(&line_info);

    while (comparekey == NULL || VStrcmp(comparekey,endkey) != 0)
      {
	kfree(comparekey);
	xvf_parse_string_line(form->db[indx], &line_info);
	j = 0;
	while (VStrcmp(FORMVAR(entry_list[j]),line_info.variable) != 0)
	  j++;
	kfree(value);
	if (VARVAL(entry_list[j])[0] != '#')
	  value = (ENTRYCNT(entry_list[j]) == 0) ? NULL :
	          VStrcpy(IENTRYLST(entry_list[j],0));
	else
	  {
	    value = NULL;

	    for (k = 0; k < ENTRYCNT(entry_list[j]); k++)
	      value = (value == NULL)? VStrcat(IENTRYLST(entry_list[j],k), "\n")
			: VStr3cat(value, IENTRYLST(entry_list[j],k), "\n");

	  }
        xvf_change_input(form, indx, xvf_stringval_chng, value, 0);
	comparekey = VStrcpy(line_info.variable);
	indx++;
      }
    kfree(comparekey);
  }
