 /*
  * Khoros: $Id: subform.c,v 1.1 1991/05/10 15:57:48 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: subform.c,v 1.1 1991/05/10 15:57:48 khoros Exp $";
#endif

 /*
  * $Log: subform.c,v $
 * Revision 1.1  1991/05/10  15:57:48  khoros
 * Initial revision
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "cantata.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name:  subform.c                             <<<<
   >>>>                                                       <<<<
   >>>>   description:                                        <<<<
   >>>>                                                       <<<<
   >>>>      routines:  xvl_copy_subform()                    <<<<
   >>>>                 xvl_master_button()                   <<<<
   >>>>                                                       <<<<
   >>>> modifications:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/************************************************************
*
* Routine Name:  xvl_copy_subform
*
*      Purpose:  This routine is used to create a subform from
*		 the the given "subform".  It calls xvf_copy_and_add_subform
*		 which copies the old subform into the new subform.
*		 If then adds a glyph button to the subform so that
*		 the user can "glyph" the subform back into a glyph.
*
*        Input:  form    - the form that the new subform will be
*			   created into.
*		 subform - the subform to be copied.
*
*
*   Written By:  Mark Young
*
*************************************************************/


xvf_sub_form	*xvl_copy_subform(form, subform)

xvf_form	*form;
xvf_sub_form	*subform;
{
	xvf_sub_form	*new_subform;

        if (!(new_subform = xvf_copy_and_add_subform(form, subform)))
	{
	   return(NULL);
	}
	return(new_subform);
}



/************************************************************
*
* Routine Name:  xvl_master_button
*
*      Purpose:  This routine is used to create a subform from
*		 the the given "subform".  It calls xvl_copy_subform
*		 which copies the old subform into the new subform.
*		 The new subform is then passed to the either the
*		 build glyph or build control routine.
*
*        Input:  workspace  - the workspace in which the subform
*			      belongs
*		 subform    - the subform in which we wish to make
*			      a new glyph from.
*
*
*   Written By:  Mark Young
*
*************************************************************/


xvl_master_button(workspace, subform)

Workspace	*workspace;
xvf_sub_form	*subform;
{
	int	     type;
	xvf_sub_form *new_subform;


        if (!(new_subform = xvl_copy_subform(workspace->glyphform, subform)))
        {
           xvf_error_wait("Unable to create form","xvl_master_button", NULL);
           return;
        }

	if (!(xvf_adjust_form_indices(workspace->glyphform)))
	   return;

	if (strcmp(subform->subform_name, "control") == 0)
	   type = CONTROL;
	else if (strcmp(subform->subform_name, "image_sequence") == 0)
	   type = IMAGES;
	else if (strcmp(subform->subform_name, "comment") == 0)
	   type = COMMENT;
	else if (strcmp(subform->subform_name, "command") == 0)
	   type = COMMAND;
	else
	   type = GLYPH;

	(void) xvl_build_glyph(workspace, type, (caddr_t) new_subform,
			False, -1, -1);
}
