 /*
  * Khoros: $Id: change.c,v 1.4 1992/03/20 22:47:14 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: change.c,v 1.4 1992/03/20 22:47:14 dkhoros Exp $";
#endif

 /*
  * $Log: change.c,v $
 * Revision 1.4  1992/03/20  22:47:14  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "forms.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>		       file name: change.c		      <<<<
   >>>>                                                       <<<<
   >>>>		       Form  Changing Routines                <<<<
   >>>>                                                       <<<<
   >>>>                xvf_change_input()                     <<<<
   >>>>                                                       <<<<
   >>>>		       xvf_change_startform_line()	      <<<<
   >>>>		       xvf_change_startsubform_line()	      <<<<
   >>>>		       xvf_change_startpane_line()	      <<<<
   >>>>		       xvf_change_startguide_line()	      <<<<
   >>>>		       xvf_change_inputfile_line()	      <<<<
   >>>>		       xvf_change_outputfile_line()	      <<<<
   >>>>		       xvf_change_int_line()	       	      <<<<
   >>>>		       xvf_change_float_line()	      	      <<<<
   >>>>		       xvf_change_string_line()	      	      <<<<
   >>>>		       xvf_change_toggle_line()	      	      <<<<
   >>>>		       xvf_change_logic_line()	      	      <<<<
   >>>>		       xvf_change_subformbutton_line()	      <<<<
   >>>>		       xvf_change_guidebutton_line()	      <<<<
   >>>>		       xvf_change_master_action_line()	      <<<<
   >>>>		       xvf_change_subform_action_line()	      <<<<
   >>>>		       xvf_change_pane_action_line()	      <<<<
   >>>>		       xvf_change_help_line()	      	      <<<<
   >>>>		       xvf_change_quit_line()	      	      <<<<
   >>>>		       xvf_change_routine_line()	      <<<<
   >>>>		       xvf_change_blank_line()	      	      <<<<
   >>>>		       xvf_change_workspace_line()     	      <<<<
   >>>>		       xvf_change_ansinfile_line()     	      <<<<
   >>>>		                                              <<<<
   >>>>		       xvf_change_title()	              <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/************************************************************
*
*  Routine Name: xvf_change_input
*
*      Purpose:  Allows the application program to change the
*		 appearance/values of selections in the form
*
*        Input:  form    - pointer to the form tree
*
*		 index	 - index of the database line to be changed,
*			   a field for this index is provided for all form
*			   selections, panes, guide buttons, etc in the Form 
*			   Info structure created in "forminfo.h" by running
*			   "conductor" on the user interface specification file.
*
*		 change_code - code indicating which change is to be made
*
*		 string  - new string to be substituted for old string
*			   or, if value is an integer (as for the 'activated'
*			   or the 'selected' field, an integer in quotes)
*
*		 max_strlen - if the change_code is one of:
*				  xvf_title_chng
*				  xvf_blank_chng
*			      application program may specify the max number 
*			      of characters that the label will ever be.  
*			      xvf_change_selection will make sure that the 
*			      size of the widget containing this label is 
*			      always large enough to accomodate a string of 
*			      that size.  Note: passing in 0 for max_strlen
*			      causes the label to be made just large enough
*			      for the first (original) label.  Future calls
*			      to by the application program to xvf_change_input
*			      may  cause new labels to be truncated.
*       Output:  none
*
*    Called By:  user application
*
*   Written By:  Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

int xvf_change_input(form, index, change_code, string, max_strlen)

xvf_form *form;
int	  index;
int	  change_code;
char	 *string;
int       max_strlen;  
{
	int flag, test, atoi();
	char **database;
	int success;

	/*
	 *  take care of real obvious errors right away
	 */
	if (change_code == xvf_no_chng)
	{
	    return(true);
	}
	else if (change_code == xvf_activation_chng)
	{
	   test = atoi(string);
	   if ((test != 0) && (test != 1)) 
	   {
	      fprintf(stderr, "xvf_change_input:\n");
	      fprintf(stderr, "   WARNING: Cannot change value of 'activate' field\n");
	      fprintf(stderr, "            to anything other than 0 or 1.\n"); 
	      return(false);
	   }
	}
	else if (change_code == xvf_logicalval_chng)
	{
	   test = atoi(string);
	   if ((test != 0) && (test != 1))
           {
	      fprintf(stderr, "xvf_change_input:\n");
              fprintf(stderr, "   WARNING: Cannot change value of logical\n");
              fprintf(stderr, "            to anything other than 0 or 1.\n");
              return(false);
           }
	}
	else if (change_code == xvf_optsel_chng)
	{
	   test = atoi(string);
           if ((test != 0) && (test != 1))
	   {
	      fprintf(stderr, "xvf_change_input:\n");
              fprintf(stderr, "   WARNING: Cannot change value of 'option_selected' \n");
              fprintf(stderr, "            field to anything other than 0 or 1.\n");
              return(false);
	   }
	}
	
	database = form->db;
	flag = xvf_get_line_type(database[index]);

	switch (flag) {
		
		case  StartForm:
		      success = xvf_change_startform_line(form, database, 
				index, change_code, string, max_strlen);
		      break;
			   
		case  StartSubForm:
		      success = xvf_change_startsubform_line(form, database, 
				index, change_code, string, max_strlen);
		      break;
			   
			 
		case StartPane:
		     success = xvf_change_startpane_line(form, database, 
			       index, change_code, string, max_strlen);
		     break;

		case StartGuide:
		     success = xvf_change_startguide_line(form, database, 
			       index, change_code, string, max_strlen);
                     break;

		case InputFile:
		     success = xvf_change_inputfile_line(form, database, 
			       index, change_code, string, max_strlen);
                     break;

		case OutputFile:
		     success = xvf_change_outputfile_line(form, database, 
			       index, change_code, string, max_strlen);
		     break;
	
		case IntegerOpt:
		     success = xvf_change_int_line(form, database, 
			       index, change_code, string, max_strlen);
		     break;

	
		case FloatOpt:
		     success = xvf_change_float_line(form, database, 
			       index, change_code, string, max_strlen);
		     break;

		case StringOpt:
		     success = xvf_change_string_line(form, database, 
			       index, change_code, string, max_strlen);
		     break;

		case Toggle:
		     success = xvf_change_toggle_line(form, database, 
			       index, change_code, string, max_strlen);
	      	     break;


		case LogicOpt:
		     success = xvf_change_logic_line(form, database, 
			       index, change_code, string, max_strlen);
		     break;

		case Cycle:
		     success = xvf_change_cycle_line(form, database, 
			       index, change_code, string, max_strlen);
		     break;

		case AnswerInfile:
		     success = xvf_change_ansinfile_line(form, database, 
			       index, change_code, string, max_strlen);
		     break;

		case AnswerOutfile:
		     success = xvf_change_ansoutfile_line(form, database, 
			       index, change_code, string, max_strlen);
		     break;

		case SubFormButton:
		     success = xvf_change_subformbutton_line(form, database, 
			       index, change_code, string);
		     break;

		case GuideButton:
		     success = xvf_change_guidebutton_line(form, database, 
				index, change_code, string);
		     break;

		case MasterAction:
		     success = xvf_change_master_action_line(form, database, 
				index, change_code, string);
		     break;

		case SubformAction:
		     success = xvf_change_subform_action_line(form, database, 
				index, change_code, string);
		     break;

		case PaneAction:
		     success = xvf_change_pane_action_line(form, database, 
				index, change_code, string);
		     break;

		case HelpSel:
		     success = xvf_change_help_line(form, database, 
				index, change_code, string);
		     break;

		case QuitForm:
		     success = xvf_change_quit_line(form, database, 
				index, change_code, string);
		     break;

		case Routine:
		     success = xvf_change_routine_line(form, database, 
				index, change_code, string);
		     break;

		case Blank:
		     success = xvf_change_blank_line(form, database, index, 
			       change_code, string, max_strlen);
		     break;

		case WorkWidget:
		     success = xvf_change_workspace_line(form, database, index, 
			       change_code, string);
		     break;

		default:

		      fprintf(stderr, "xvf_chng_input:\n");
		      fprintf(stderr, "   Only able to change the following ");
		      fprintf(stderr, "   types of selections at this time:\n");
		      fprintf(stderr, "   StartForm\n");
		      fprintf(stderr, "   StartSubForm\n");
		      fprintf(stderr, "   StartPane\n");
		      fprintf(stderr, "   StartGuide\n");
		      fprintf(stderr, "   GuideButton\n");
		      fprintf(stderr, "   SubformButton\n");
		      fprintf(stderr, "   MasterAction\n");
		      fprintf(stderr, "   SubformAction\n");
		      fprintf(stderr, "   PaneAction\n");
		      fprintf(stderr, "   InputFile\n");
		      fprintf(stderr, "   OutputFile\n");
		      fprintf(stderr, "   IntegerOpt\n");
		      fprintf(stderr, "   FloatOpt\n");
		      fprintf(stderr, "   StringOpt\n");
		      fprintf(stderr, "   LogicOpt\n");
		      fprintf(stderr, "   Toggle\n");
		      fprintf(stderr, "   Routine\n");
		      fprintf(stderr, "   Blank\n");
		      fprintf(stderr, "   Workspace\n\n");
		      fprintf(stderr, "   Quit\n\n");
		      fprintf(stderr, "   Help\n\n");
		      fprintf(stderr, " The index provided accesses string \n");
		      fprintf(stderr, " '%s', not one of the above.\n");
		      return(false);
		      break;

		} /* end switch (flag) */

	return(success);
}


/************************************************************
*
*  Routine Name: xvf_change_startform_line
*
*      Purpose:  Changes a StartForm line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of StartForm line to be changed
*		 change_code - change code for changing element of
*			       StartForm line - must be xvf_title_chng 
*		 string - string to be changed
*		 max_strlen - max length of string
*       Output:  none
*    Called By:  xvf_change_input 
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_startform_line(form, database, index, 
			      change_code, string, max_strlen)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
int  max_strlen;
{
      Line_Info line_info;
      
      int       width;

      xvf_clear_line_info(&line_info);
      xvf_parse_startform_line(database[index], &line_info);

      if (max_strlen != 0)
         width = max_strlen*xvf_font_width;
      else
         width = xvf_strlen(string)*xvf_font_width;
      if (width == 0) width = 10;

      if (change_code == xvf_title_chng)
      {
	   if (string == NULL) line_info.title = NULL;
	   else line_info.title = xvf_strcpy(string);
	   if (form->label != NULL) 
	       xvf_change_title(form->label, width, 0, 0, string);
      }
      else 
      {
           fprintf(stderr, "xvf_change_startform_line:\n");
	   fprintf(stderr, "   WARNING: Illegal change code for a StartForm line.\n");
	   fprintf(stderr, "            The only accepted change code for a [-F] line is:\n");
	   fprintf(stderr, "            xvf_title_chng\n");
	   return(false);
      }
      xvf_deparse_startform_line (&line_info, database, index);
      return(true);
}


/************************************************************
*
*  Routine Name: xvf_change_startsubform_line
*
*      Purpose:  Changes a StartSubForm line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of StartForm line to be changed
*		 change_code - change code for changing element of
*			       StartForm line - must be xvf_title_chng
*		 string - string to be changed
*		 max_strlen - max length of string
*       Output:  none
*    Called By:  xvf_change_input() 
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_startsubform_line(form, database, index, 
			      change_code, string, max_strlen)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
int  max_strlen;
{
      Line_Info line_info;
      int       width;
      xvf_sub_form *subform;

      xvf_clear_line_info(&line_info);
      xvf_parse_startsubform_line(database[index], &line_info);

      if (max_strlen != 0)
         width = max_strlen*xvf_font_width;
      else
         width = xvf_strlen(string)*xvf_font_width;
      if (width == 0) width = 10;

      subform = xvf_subform_search(form, index);
      if (subform == NULL)
      {
          fprintf(stderr, "xvf_change_startsubform_line:\n");
          fprintf(stderr, "   WARNING: Can't find subform defined by \n%s\n", 
			  database[index]);
          return(false);
      }

      if (change_code == xvf_title_chng)
      {
	   if (string == NULL) line_info.title = NULL;
	   else line_info.title = xvf_strcpy(string);
	   if (subform->label != NULL)
	        xvf_change_title(subform->label, width, 0, 0, string);
      }
      else 
      {
           fprintf(stderr, "xvf_change_startsubform_line:\n");
	   fprintf(stderr, "   WARNING: Illegal change code for a StartSubForm line.\n");
	   fprintf(stderr, "            The only accepted change code for a [-M] line is:\n");
	   fprintf(stderr, "            * xvf_title_chng\n");
	   return(false);
      }
      xvf_deparse_startsubform_line (&line_info, database, index);
      return(true);
}

/************************************************************
*
*  Routine Name: xvf_change_startpane_line
*
*      Purpose:  Changes a StartPane line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of StartPane line to be changed
*		 change_code - change code for changing element of
*			       StartPane line - must be xvf_pane_title_chng
*		 max_strlen - max length of string
*       Output:  none
*    Called By:  xvf_change_input()
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_startpane_line(form, database, index, 
			      change_code, string, max_strlen)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
int  max_strlen;

{
      xvf_pane *pane;
      Line_Info line_info;
      int       width;

      xvf_clear_line_info(&line_info);
      xvf_parse_startpane_line(database[index], &line_info);

      if (max_strlen != 0)
         width = max_strlen*xvf_font_width;
      else
         width = xvf_strlen(string)*xvf_font_width;
      if (width == 0) width = 10;

      pane = xvf_pane_search(form, index);
      if (pane == NULL)
      {
          fprintf(stderr, "xvf_change_startpane_line:\n");
          fprintf(stderr, "   WARNING:  Can't find pane defined by \n%s\n", 
			database[index]);
          return(false);
      }

      if (change_code == xvf_title_chng)
      {
	   if (string == NULL) line_info.title = NULL;
	   else line_info.title = xvf_strcpy(string);
	   if (pane->label_widget != NULL)
	       xvf_change_title(pane->label_widget, width, 0, 0, string);
      }
      else 
      {
           fprintf(stderr, "xvf_change_startpane_line:\n");
	   fprintf(stderr, "   WARNING: Illegal change code for a StartPane line.\n");
	   fprintf(stderr, "            The only accepted change code for");
	   fprintf(stderr, " a [-P] line is:\n");
	   fprintf(stderr, "   * xvf_title_chng\n");
	   return(false);
      }
      xvf_deparse_startpane_line (&line_info, database, index);
      return(true);
}




/************************************************************
*
*  Routine Name: xvf_change_startguide_line
*
*      Purpose:  Changes a StartGuide line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of line to be changed
*		 change_code - desired change to line. 
*			       must be xvf_title_chng
*		 string - string to be changed
*		 max_strlen - max length of string
*       Output:  none
*    Called By:  xvf_change_input()
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_startguide_line(form, database, index, 
			       change_code, string, max_strlen)

xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
int  max_strlen;

{
      xvf_sub_form *subform;
      Line_Info     line_info;
      int           width;

      xvf_clear_line_info(&line_info);
      xvf_parse_startguide_line(database[index], &line_info);

      if (max_strlen != 0)
         width = max_strlen*xvf_font_width;
      else
         width = xvf_strlen(string)*xvf_font_width;
      if (width == 0) width = 10;

      subform = xvf_find_sels_subform(form, index);
      if (subform == NULL)
      {
          fprintf(stderr, "xvf_change_startguide_line:\n");
	  fprintf(stderr, "WARNING: Couldn't find subform associated with %s", 
			   database[index]);
	  return(false);
      }

      if (change_code == xvf_title_chng)
      {
	   if (string == NULL) line_info.title = NULL;
	   else line_info.title = xvf_strcpy(string);
	   if (subform->guide_label != NULL)
   	       xvf_change_title(subform->guide_label, width, 0, 0, string);
      }

      else 
      {
           fprintf(stderr, "xvf_change_startpane_line:\n");
	   fprintf(stderr, "WARNING: Illegal change code for a StartPane line.\n");
	   fprintf(stderr, "         The only accepted change code for a [-P] line is:\n");
	   fprintf(stderr, "         * xvf_title_chng\n");
	   return(false);
      }
      xvf_deparse_startguide_line (&line_info, database, index);
      return(true);
}




/************************************************************
*
*  Routine Name: xvf_change_inputfile_line
*
*      Purpose:  Changes an InputFile line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of line to be changed
*		 change_code - desired change to line. May be:
*				1) xvf_activation_chng
*				2) xvf_title_chng 
*				3) xvf_width_chng
*				4) xvf_height_chng
*				5) xvf_x_chng
*				6) xvf_y_chng
*				7) xvf_optsel_chng
*				8) xvf_inputfile_chng
*		 string - string to be changed
*		 max_strlen - max length of string
*       Output:  none
*    Called By:  xvf_change_input()
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_inputfile_line(form, database, index, 
			      change_code, string, max_strlen)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
int  max_strlen;
{
      XawTextBlock   text_block;
      Line_Info      line_info;
      xvf_selection *selection;
      char 	    *string_return, buff[10*MaxLength];
      int            n, old_len, status;
      int	     atoi(), width, height, x, y;
      double	     atof();
      Arg            arg[MaxArgs];

      xvf_clear_line_info(&line_info);
      xvf_parse_input_line(database[index], &line_info);

      x      = line_info.x*xvf_font_width;
      y      = line_info.y*(xvf_font_height + ((int)xvf_font_height/2));
      width  = line_info.width*xvf_font_width;
      height = line_info.height*(xvf_font_height+6);


      selection = xvf_sel_search(form, index);
      if (selection == NULL)
      {
          fprintf(stderr, "xvf_change_inputfile_line:\n");
	  fprintf(stderr, "WARNING: Couldn't find selection for %s", 
			  database[index]);
      }

      switch (change_code) {

	     case  xvf_activation_chng:
		   line_info.activate = atoi(string);
		   if (selection->back != NULL)
	              XtSetSensitive(selection->back, line_info.activate);
		   break;

	     case  xvf_title_chng:
	           if (string == NULL) line_info.title = NULL;
	           else line_info.title = xvf_strcpy(string);

		   if (selection->label_widget != NULL)
		   {
      		       if (max_strlen != 0)
         	       	   width = max_strlen*xvf_font_width;
      		       else
         		    width = xvf_strlen(string)*xvf_font_width;

	   	       xvf_change_title(selection->label_widget, 
				         width, 0, 0, string);
		   }
		   break;

	     case  xvf_width_chng:
	           if (string == NULL) 
			return(true);
	           line_info.width = atof(string);

		   if (selection->back != NULL)
		   {
		       width = line_info.width*xvf_font_width;
	   	       xvf_change_geometry(selection->back, x, y, 
				            width, height, 0);
		   }
		   break;

	     case  xvf_height_chng:
	           if (string == NULL) 
			return(true);
	           line_info.height = atof(string);

		   if (selection->back != NULL)
		   {
		       height = line_info.height*(xvf_font_height+6);
	   	       xvf_change_geometry(selection->back, x, y, 
		    		           width, height, 0);
		   }
		   break;

	     case  xvf_x_chng:
	           if (string == NULL) 
			return(true);
	           line_info.x = atof(string);

		   if (selection->back != NULL)
		   {
      		       x = line_info.x*xvf_font_width;
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_y_chng:
	           if (string == NULL) 
			return(true);
	           line_info.y = atof(string);

		   if (selection->back != NULL)
		   {
      		   	y = line_info.y*(xvf_font_height + 
					 ((int)xvf_font_height/2));
	   	   	xvf_change_geometry(selection->back, x, y, 
					     width, height, 0);
		   }
		   break;

	     case  xvf_optsel_chng:
		   line_info.opt_sel= atoi(string);
		   if (line_info.optional != true)
		   {
		      fprintf(stderr,"xvf_change_inputfile_line:\n");
		      fprintf(stderr,"WARNING:  'option_selected' field may only be changed\n");
		      fprintf(stderr,"          when the [-I] line has the 'optional' field = 1.\n");
		      return(false);
		   }
		   else
		   {
		      if ((selection->opt_widget != NULL) &&
			  (atoi(string) != selection->opt_selected))
		      {
		          xvf_reverse_colors(selection->opt_widget);
                          selection->opt_selected = atoi(string);
		      }
		   }
		   break;

	     case  xvf_inputfile_chng:
		   if (string == NULL) 
		   {
			line_info.filename = line_info.literal = NULL;
		   }
		   else 
		   { 
			line_info.filename = xvf_strcpy(string);
			line_info.literal  = xvf_strcpy(string);
		   }
		   if (selection->value_widget != NULL)
		   {
		       n = 0;
                       XtSetArg(arg[n], XtNstring, &string_return); n++;
                       XtGetValues(selection->value_widget, arg, n);
                       old_len = xvf_strlen(string_return);

		       if (line_info.filename != NULL)
                                sprintf(buff,"%s", line_info.filename);
                       else sprintf(buff, " ");

		       text_block.firstPos = 0;
                       text_block.length = xvf_strlen(buff);
                       text_block.ptr = buff;
                       text_block.format = FMT8BIT;
		       status = XawTextReplace(selection->value_widget,
                                               (XawTextPosition) 0,
                                               (XawTextPosition) old_len,
                                               &text_block);
                       XawTextDisplay(selection->value_widget);
		       if (status == XawPositionError)
        	       {
                    	   fprintf(stderr, "\nxvf_change_inputfile_line:\n");
        		   fprintf(stderr,"      ERROR: XawPositionError\n");
        	       }
        	       else if (status == XawEditError)
        	       {
                 	   fprintf(stderr, "\nxvf_change_inputfile_line:\n");
                           fprintf(stderr,"      ERROR: XawEditError\n");
             	       }
		   }
		   break;
	

	     default:
		 fprintf(stderr, "xvf_change_inputfile_line:\n");
		 fprintf(stderr, "   WARNING:  Illegal change code for an InputFile selection.\n");
		 fprintf(stderr, "             Only accepted change codes for a [-I] line are:\n");
		 fprintf(stderr, "   * xvf_inputfile_chng\n");
		 fprintf(stderr, "   * xvf_title_chng\n");
	         fprintf(stderr, "   * xvf_activation_chng\n");
		 fprintf(stderr, "   * xvf_optsel_chng\n");
		 fprintf(stderr, "   * xvf_x_chng\n");
		 fprintf(stderr, "   * xvf_y_chng\n");
		 fprintf(stderr, "   * xvf_width_chng\n");
		 fprintf(stderr, "   * xvf_height_chng\n");
		 return(false);
		 break;

	    } /* end switch (change_code) */

      xvf_deparse_input_line(&line_info, database, index);
      return(true);
}


/************************************************************
*
*  Routine Name: xvf_change_outputfile_line
*
*      Purpose:  Changes an OutputFile line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of line to be changed
*		 change_code - desired change to line. May be:
*				1) xvf_activation_chng
*				2) xvf_title_chng 
*				3) xvf_width_chng
*				4) xvf_height_chng
*				5) xvf_x_chng
*				6) xvf_y_chng
*				7) xvf_optsel_chng
*				8) xvf_outputfile_chng
*		 string - string to be changed
*		 max_strlen - max length of string
*       Output:  none
*    Called By:  xvf_change_input()
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_outputfile_line(form, database, index, 
			       change_code, string, max_strlen)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
int  max_strlen;

{
      XawTextBlock   text_block;
      Line_Info      line_info;
      xvf_selection  *selection;
      char 	     *string_return, buff[10*MaxLength];
      int            n, old_len, width, height, x, y;
      int	     atoi(), status;
      double	     atof();
      Arg            arg[MaxArgs];

      xvf_clear_line_info(&line_info);
      xvf_parse_output_line(database[index], &line_info);

      x      = line_info.x*xvf_font_width;
      y      = line_info.y*(xvf_font_height + ((int)xvf_font_height/2));
      width  = line_info.width*xvf_font_width;
      height = line_info.height*(xvf_font_height+6);

      selection = xvf_sel_search(form, index);
      if (selection == NULL)
      {
          fprintf(stderr, "xvf_change_outputfile_line:\n");
	  fprintf(stderr, "   WARNING: Couldn't find selection for %s", database[index]);
      }

      switch (change_code) {

	     case  xvf_activation_chng:
                   line_info.activate = atoi(string);
		   if (selection->back != NULL)
                      XtSetSensitive(selection->back, line_info.activate);
                   break;

	     case  xvf_title_chng:
	           if (string == NULL) line_info.title = NULL;
	           else line_info.title = xvf_strcpy(string);

		   if (selection->label_widget != NULL)
		   {
		       if (max_strlen != 0)
                           width = max_strlen*xvf_font_width;
                       else
                           width = xvf_strlen(string)*xvf_font_width;

	   	       xvf_change_title(selection->label_widget, width, 
		    		        0, 0, string);
		   }
		   break;


	     case  xvf_width_chng:
	           if (string == NULL) 
			return(true);
	           line_info.width = atof(string);

		   if (selection->back != NULL)
		   {
		       width = line_info.width*xvf_font_width;
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_height_chng:
	           if (string == NULL) 
			return(true);
	           line_info.height = atof(string);

		   if (selection->back != NULL)
		   {
		       height = line_info.height*(xvf_font_height+6);
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_x_chng:
	           if (string == NULL) 
			return(true);
	           line_info.x = atof(string);

		   if (selection->back != NULL)
		   {
      		       x = line_info.x*xvf_font_width;
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_y_chng:
	           if (string == NULL) 
			return(true);
	           line_info.y = atof(string);

		   if (selection->back != NULL)
		   {
      		       y = line_info.y* (xvf_font_height+
					((int)xvf_font_height/2));
	   	       xvf_change_geometry(selection->back, x, y, 
		    		           width, height, 0);
		   }
		   break;

	     case  xvf_optsel_chng:
		   line_info.opt_sel= atoi(string);
		   if (line_info.optional != true)
		   {
		      fprintf(stderr,"xvf_change_outputfile_line:\n");
		      fprintf(stderr,"WARNING: 'option_selected' field may only be changed");
		      fprintf(stderr,"         when the [-O] line has the 'optional' field = 1.\n");
		      return(false);
		   }
		   if ((selection->opt_widget != NULL) &&
			  (atoi(string) != selection->opt_selected))
		   {
		          xvf_reverse_colors(selection->opt_widget);
                          selection->opt_selected = atoi(string);
		   }
		   break;

	     case  xvf_outputfile_chng:
		   if (string == NULL) 
		   {
			line_info.filename = line_info.literal = NULL;
		   }
		   else 
		   { 
			line_info.filename = xvf_strcpy(string);
			line_info.literal  = xvf_strcpy(string);
		   }

		   if (selection->value_widget != NULL)
		   {
		       n = 0;
                       XtSetArg(arg[n], XtNstring, &string_return); n++;
                       XtGetValues(selection->value_widget, arg, n);
                       old_len = xvf_strlen(string_return);

		       if (line_info.filename != NULL)
                           sprintf(buff,"%s", line_info.filename);
                       else sprintf(buff, " ");

		       text_block.firstPos = 0;
                       text_block.length = xvf_strlen(buff);
                       text_block.ptr = buff;
                       text_block.format = FMT8BIT;

		       status = XawTextReplace(selection->value_widget,
                                              (XawTextPosition) 0,
                                              (XawTextPosition) old_len,
                                              &text_block);
                       XawTextDisplay(selection->value_widget);
		       if (status == XawPositionError)
        	       {
                    	    fprintf(stderr, "\nxvf_change_outputfile_line:\n");
        		    fprintf(stderr,"      ERROR: XawPositionError\n");
        	       }
        	       else if (status == XawEditError)
        	       {
                    	    fprintf(stderr, "\nxvf_change_outputfile_line:\n");
                            fprintf(stderr,"      ERROR: XawEditError\n");
             	       }
		   }
		   break;
	
	    default:
		 fprintf(stderr,"xvf_change_outputfile_line:\n");
		 fprintf(stderr, "WARNING:  Illegal change code for an OutputFile selection.\n");
		 fprintf(stderr, "          Only accepted change codes for a [-O] line are:\n");
		 fprintf(stderr, "   * xvf_outputfile_chng\n");
		 fprintf(stderr, "   * xvf_title_chng\n");
	         fprintf(stderr, "   * xvf_activation_chng\n");
		 fprintf(stderr, "   * xvf_optsel_chng\n");
		 fprintf(stderr, "   * xvf_x_chng\n");
		 fprintf(stderr, "   * xvf_y_chng\n");
		 fprintf(stderr, "   * xvf_width_chng\n");
		 fprintf(stderr, "   * xvf_height_chng\n");
		 return(false);
		 break;

	    } /* end switch (change_code) */

    xvf_deparse_output_line(&line_info, database, index);
    return(true);
}


/************************************************************
*
*  Routine Name: xvf_change_ansinfile_line
*
*      Purpose:  Changes an AnswerInfile line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of line to be changed
*		 change_code - desired change to line. May be:
*				1) xvf_activation_chng
*				2) xvf_title_chng 
*				3) xvf_width_chng
*				4) xvf_height_chng
*				5) xvf_x_chng
*				6) xvf_y_chng
*				7) xvf_optsel_chng
*				8) xvf_ansinfile_chng
*		 string - string to be changed
*		 max_strlen - max length of string
*       Output:  none
*    Called By:  xvf_change_input()
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_ansinfile_line(form, database, index, 
			      change_code, string, max_strlen)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
int  max_strlen;
{
      XawTextBlock   text_block;
      Line_Info      line_info;
      xvf_selection *selection;
      char 	    *string_return, buff[10*MaxLength];
      int            n, old_len, status;
      int	     atoi(), width, height, x, y;
      double	     atof();
      Arg            arg[MaxArgs];

      xvf_clear_line_info(&line_info);
      xvf_parse_ansinfile_line(database[index], &line_info);

      x      = line_info.x*xvf_font_width;
      y      = line_info.y*(xvf_font_height + ((int)xvf_font_height/2));
      width  = line_info.width*xvf_font_width;
      height = line_info.height*(xvf_font_height+6);


      selection = xvf_sel_search(form, index);
      if (selection == NULL)
      {
          fprintf(stderr, "xvf_change_ansinfile_line:\n");
	  fprintf(stderr, "WARNING: Couldn't find selection for %s", 
			  database[index]);
      }

      switch (change_code) {

	     case  xvf_activation_chng:
		   line_info.activate = atoi(string);
		   if (selection->back != NULL)
	              XtSetSensitive(selection->back, line_info.activate);
		   break;

	     case  xvf_title_chng:
	           if (string == NULL) line_info.title = NULL;
	           else line_info.title = xvf_strcpy(string);

		   if (selection->label_widget != NULL)
		   {
      		       if (max_strlen != 0)
         	       	   width = max_strlen*xvf_font_width;
      		       else
         		    width = xvf_strlen(string)*xvf_font_width;

	   	       xvf_change_title(selection->label_widget, 
				         width, 0, 0, string);
		   }
		   break;

	     case  xvf_width_chng:
	           if (string == NULL) 
			return(true);
	           line_info.width = atof(string);

		   if (selection->back != NULL)
		   {
		       width = line_info.width*xvf_font_width;
	   	       xvf_change_geometry(selection->back, x, y, 
				            width, height, 0);
		   }
		   break;

	     case  xvf_height_chng:
	           if (string == NULL) 
			return(true);
	           line_info.height = atof(string);

		   if (selection->back != NULL)
		   {
		       height = line_info.height*(xvf_font_height+6);
	   	       xvf_change_geometry(selection->back, x, y, 
		    		           width, height, 0);
		   }
		   break;

	     case  xvf_x_chng:
	           if (string == NULL) 
			return(true);
	           line_info.x = atof(string);

		   if (selection->back != NULL)
		   {
      		       x = line_info.x*xvf_font_width;
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_y_chng:
	           if (string == NULL) 
			return(true);
	           line_info.y = atof(string);

		   if (selection->back != NULL)
		   {
      		   	y = line_info.y*(xvf_font_height + 
					 ((int)xvf_font_height/2));
	   	   	xvf_change_geometry(selection->back, x, y, 
					     width, height, 0);
		   }
		   break;

	     case  xvf_ansinfile_chng:
		   if (string == NULL) 
		   {
			line_info.filename = line_info.literal = NULL;
		   }
		   else 
		   { 
			line_info.filename = xvf_strcpy(string);
			line_info.literal  = xvf_strcpy(string);
		   }
		   if (selection->value_widget != NULL)
		   {
		       n = 0;
                       XtSetArg(arg[n], XtNstring, &string_return); n++;
                       XtGetValues(selection->value_widget, arg, n);
                       old_len = xvf_strlen(string_return);

		       if (line_info.filename != NULL)
                                sprintf(buff,"%s", line_info.filename);
                       else sprintf(buff, " ");

		       text_block.firstPos = 0;
                       text_block.length = xvf_strlen(buff);
                       text_block.ptr = buff;
                       text_block.format = FMT8BIT;
		       status = XawTextReplace(selection->value_widget,
                                               (XawTextPosition) 0,
                                               (XawTextPosition) old_len,
                                               &text_block);
                       XawTextDisplay(selection->value_widget);
		       if (status == XawPositionError)
        	       {
                    	   fprintf(stderr, "\nxvf_change_inputfile_line:\n");
        		   fprintf(stderr,"      ERROR: XawPositionError\n");
        	       }
        	       else if (status == XawEditError)
        	       {
                 	   fprintf(stderr, "\nxvf_change_inputfile_line:\n");
                           fprintf(stderr,"      ERROR: XawEditError\n");
             	       }
		   }
		   break;
	

	     default:
		 fprintf(stderr, "xvf_change_ansinfile_line:\n");
		 fprintf(stderr, "   WARNING:  Illegal change code for an AnswerInfile selection.\n");
		 fprintf(stderr, "             Only accepted change codes for a [-A] line are:\n");
		 fprintf(stderr, "   * xvf_ansinfile_chng\n");
		 fprintf(stderr, "   * xvf_title_chng\n");
	         fprintf(stderr, "   * xvf_activation_chng\n");
		 fprintf(stderr, "   * xvf_x_chng\n");
		 fprintf(stderr, "   * xvf_y_chng\n");
		 fprintf(stderr, "   * xvf_width_chng\n");
		 fprintf(stderr, "   * xvf_height_chng\n");
		 return(false);
		 break;

	    } /* end switch (change_code) */

      xvf_deparse_ansinfile_line(&line_info, database, index);
      return(true);
}


/************************************************************
*
*  Routine Name: xvf_change_ansoutfile_line
*
*      Purpose:  Changes an AnswerOutfile line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of line to be changed
*		 change_code - desired change to line. May be:
*				1) xvf_activation_chng
*				2) xvf_title_chng 
*				3) xvf_width_chng
*				4) xvf_height_chng
*				5) xvf_x_chng
*				6) xvf_y_chng
*				7) xvf_ansoutfile_chng
*		 string - string to be changed
*		 max_strlen - max length of string
*       Output:  none
*    Called By:  xvf_change_input()
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_ansoutfile_line(form, database, index, 
			       change_code, string, max_strlen)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
int  max_strlen;

{
      XawTextBlock   text_block;
      Line_Info      line_info;
      xvf_selection  *selection;
      char 	     *string_return, buff[10*MaxLength];
      int            n, old_len, width, height, x, y;
      int	     atoi(), status;
      double	     atof();
      Arg            arg[MaxArgs];

      xvf_clear_line_info(&line_info);
      xvf_parse_ansoutfile_line(database[index], &line_info);

      x      = line_info.x*xvf_font_width;
      y      = line_info.y*(xvf_font_height + ((int)xvf_font_height/2));
      width  = line_info.width*xvf_font_width;
      height = line_info.height*(xvf_font_height+6);

      selection = xvf_sel_search(form, index);
      if (selection == NULL)
      {
          fprintf(stderr, "xvf_change_ansoutfile_line:\n");
	  fprintf(stderr, "   WARNING: Couldn't find selection for %s", database[index]);
      }

      switch (change_code) {

	     case  xvf_activation_chng:
                   line_info.activate = atoi(string);
		   if (selection->back != NULL)
                      XtSetSensitive(selection->back, line_info.activate);
                   break;

	     case  xvf_title_chng:
	           if (string == NULL) line_info.title = NULL;
	           else line_info.title = xvf_strcpy(string);

		   if (selection->label_widget != NULL)
		   {
		       if (max_strlen != 0)
                           width = max_strlen*xvf_font_width;
                       else
                           width = xvf_strlen(string)*xvf_font_width;

	   	       xvf_change_title(selection->label_widget, width, 
		    		        0, 0, string);
		   }
		   break;


	     case  xvf_width_chng:
	           if (string == NULL) 
			return(true);
	           line_info.width = atof(string);

		   if (selection->back != NULL)
		   {
		       width = line_info.width*xvf_font_width;
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_height_chng:
	           if (string == NULL) 
			return(true);
	           line_info.height = atof(string);

		   if (selection->back != NULL)
		   {
		       height = line_info.height*(xvf_font_height+6);
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_x_chng:
	           if (string == NULL) 
			return(true);
	           line_info.x = atof(string);

		   if (selection->back != NULL)
		   {
      		       x = line_info.x*xvf_font_width;
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_y_chng:
	           if (string == NULL) 
			return(true);
	           line_info.y = atof(string);

		   if (selection->back != NULL)
		   {
      		       y = line_info.y* (xvf_font_height+
					((int)xvf_font_height/2));
	   	       xvf_change_geometry(selection->back, x, y, 
		    		           width, height, 0);
		   }
		   break;

	     case  xvf_optsel_chng:
		   line_info.opt_sel= atoi(string);
		   if (line_info.optional != true)
		   {
		      fprintf(stderr,"xvf_change_ansoutfile_line:\n");
		      fprintf(stderr,"WARNING: 'option_selected' field may only be changed");
		      fprintf(stderr,"         when the [-O] line has the 'optional' field = 1.\n");
		      return(false);
		   }
		   if ((selection->opt_widget != NULL) &&
			  (atoi(string) != selection->opt_selected))
		   {
		          xvf_reverse_colors(selection->opt_widget);
                          selection->opt_selected = atoi(string);
		   }
		   break;

	     case  xvf_ansoutfile_chng:
		   if (string == NULL) 
		   {
			line_info.filename = line_info.literal = NULL;
		   }
		   else 
		   { 
			line_info.filename = xvf_strcpy(string);
			line_info.literal  = xvf_strcpy(string);
		   }

		   if (selection->value_widget != NULL)
		   {
		       n = 0;
                       XtSetArg(arg[n], XtNstring, &string_return); n++;
                       XtGetValues(selection->value_widget, arg, n);
                       old_len = xvf_strlen(string_return);

		       if (line_info.filename != NULL)
                           sprintf(buff,"%s", line_info.filename);
                       else sprintf(buff, " ");

		       text_block.firstPos = 0;
                       text_block.length = xvf_strlen(buff);
                       text_block.ptr = buff;
                       text_block.format = FMT8BIT;

		       status = XawTextReplace(selection->value_widget,
                                              (XawTextPosition) 0,
                                              (XawTextPosition) old_len,
                                              &text_block);
                       XawTextDisplay(selection->value_widget);
		       if (status == XawPositionError)
        	       {
                    	    fprintf(stderr, "\nxvf_change_ansoutfile_line:\n");
        		    fprintf(stderr,"      ERROR: XawPositionError\n");
        	       }
        	       else if (status == XawEditError)
        	       {
                    	    fprintf(stderr, "\nxvf_change_ansoutfile_line:\n");
                            fprintf(stderr,"      ERROR: XawEditError\n");
             	       }
		   }
		   break;
	
	    default:
		 fprintf(stderr,"xvf_change_ansoutfile_line:\n");
		 fprintf(stderr, "WARNING:  Illegal change code for an AnswerOutfile selection.\n");
		 fprintf(stderr, "          Only accepted change codes for a [-Z] line are:\n");
		 fprintf(stderr, "   * xvf_ansoutfile_chng\n");
		 fprintf(stderr, "   * xvf_title_chng\n");
	         fprintf(stderr, "   * xvf_activation_chng\n");
		 fprintf(stderr, "   * xvf_x_chng\n");
		 fprintf(stderr, "   * xvf_y_chng\n");
		 fprintf(stderr, "   * xvf_width_chng\n");
		 fprintf(stderr, "   * xvf_height_chng\n");
		 return(false);
		 break;

	    } /* end switch (change_code) */

    xvf_deparse_ansoutfile_line(&line_info, database, index);
    return(true);
}


/************************************************************
*
*  Routine Name: xvf_change_int_line
*
*      Purpose:  Changes an IntegerOpt line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of line to be changed
*		 change_code - desired change to line. May be one of:
*				1) xvf_activation_chng
*				2) xvf_title_chng 
*				3) xvf_width_chng
*				4) xvf_height_chng
*				5) xvf_x_chng
*				6) xvf_y_chng
*				7) xvf_optsel_chng
*				8) xvf_intval_chng
*		 string - string to be changed
*		 max_strlen - max length of string
*       Output:  none
*    Called By:  xvf_change_input
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_int_line(form, database, index, 
			change_code, string, max_strlen)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
int  max_strlen;
{
      XawTextBlock   text_block;
      Line_Info      line_info;
      xvf_selection *selection;
      int      	     n, width, height, x, y, old_len, tmp_int; 
      int	     atoi(), status;
      float	     percent;
      char	     buff[10*MaxLength], *string_return;
      Arg	     arg[MaxLength];

      xvf_clear_line_info(&line_info);
      xvf_parse_int_line(database[index], &line_info);

      x      = line_info.x*xvf_font_width;
      y      = line_info.y* (xvf_font_height + ((int)xvf_font_height/2));
      width  = line_info.width*xvf_font_width;
      height = line_info.height*(xvf_font_height+6);

      selection = xvf_sel_search(form, index);
      if (selection == NULL)
      {
          fprintf(stderr, "xvf_change_int_line:\n");
	  fprintf(stderr, "WARNING: Couldn't find selection for %s", 
			  database[index]);
      }

      switch (change_code) {

	     case  xvf_activation_chng:
		   line_info.activate = atoi(string);
		   if (selection->back != NULL)
                       XtSetSensitive(selection->back, line_info.activate);
		   break;

	     case  xvf_title_chng:
	           if (string == NULL) line_info.title = NULL;
	           else line_info.title = xvf_strcpy(string);
		   
		   if (selection->label_widget != NULL)
		   {
		       if (max_strlen != 0)
                           width = max_strlen*xvf_font_width;
                       else
                           width = xvf_strlen(string)*xvf_font_width;

	   	       xvf_change_title(selection->label_widget, width, 
				        0, 0, string);
		   }
		   break;


	     case  xvf_height_chng:
	           if (string == NULL) 
			return(true);
	           line_info.height = atof(string);

		   if (selection->back != NULL)
		   {
      		       height = line_info.height*(xvf_font_height+6);
	   	       xvf_change_geometry(selection->back, x, y, 
		    		           width, height, 0);
		   }
		   break;

	     case  xvf_x_chng:
	           if (string == NULL) 
			return(true);
	           line_info.x = atof(string);

		   if (selection->back != NULL)
		   {
      		       x = line_info.x*xvf_font_width;
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_y_chng:
	           if (string == NULL) 
			return(true);
	           line_info.y = atof(string);

		   if (selection->back != NULL)
		   {
      		       y = line_info.y*(xvf_font_height+
					((int)xvf_font_height/2));
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_optsel_chng:
		   line_info.opt_sel= atoi(string);
		   if (line_info.optional != true)
		   {
		      fprintf(stderr, "xvf_change_int_line:\n");
		      fprintf(stderr, "   WARNING: 'option_selected' field may only be changed");
		      fprintf(stderr,"             when the [-i] line has the 'optional' field = 1.\n");
		      return(false);
		   }
		   if ((selection->opt_widget != NULL) &&
			  (atoi(string) != selection->opt_selected))
		   {
		          xvf_reverse_colors(selection->opt_widget);
                          selection->opt_selected = atoi(string);
		   }
		   break;

	     case  xvf_intval_chng:
		   tmp_int = atoi(string);

		   if (line_info.upper_int != line_info.lower_int)
		   {
		      if ((tmp_int > line_info.upper_int) ||
                          (tmp_int < line_info.lower_int))  
		      {
		   	   fprintf(stderr, "xvf_change_int_line:\n");
			   fprintf(stderr, "   WARNING: value provided for change to \n");
			   fprintf(stderr, "            int selection is out of bounds.\n");
			   return(false);
		      }
		   }
		   line_info.int_val = tmp_int;
		   sprintf(buff, "%d", line_info.int_val);
		   line_info.literal = xvf_strcpy(buff);

		   if (selection->value_widget != NULL)
		   {
		       n = 0;
                       XtSetArg(arg[n], XtNstring, &string_return); n++;
                       XtGetValues(selection->value_widget, arg, n);
                       old_len = xvf_strlen(string_return);

		       sprintf(buff,"%d", line_info.int_val);

                       text_block.firstPos = 0;
		       text_block.length = xvf_strlen(buff);
                       text_block.ptr = buff;
                       text_block.format = FMT8BIT;

		       status = XawTextReplace(selection->value_widget,
                                              (XawTextPosition)0,
                                              (XawTextPosition)(old_len),
                                              &text_block);
                       XawTextDisplay(selection->value_widget);
		       if (status == XawPositionError)
        	       {
                    	    fprintf(stderr, "\nxvf_change_int_line:\n");
        		    fprintf(stderr,"      ERROR: XawPositionError\n");
        	       }
        	       else if (status == XawEditError)
        	       {
                    	    fprintf(stderr, "\nxvf_change_int_line:\n");
                            fprintf(stderr,"      ERROR: XawEditError\n");
             	       }
		   }
		   if (selection->scroll != NULL)
		   {
	              percent = ( (float) line_info.int_val -  
		      	          (float) line_info.lower_int) /
			        ( (float) line_info.upper_int - 
			          (float) line_info.lower_int );
 		      XawScrollbarSetThumb(selection->scroll, percent, 1.0);
		   }

		   break;
	
	    default:
		 fprintf(stderr, "xvf_change_int_line:\n");
		 fprintf(stderr, "WARNING: Illegal change code for an Integer selection.\n");
		 fprintf(stderr, "         Only accepted change codes for a [-i] line are:\n");
		 fprintf(stderr, "   * xvf_intval_chng\n");
		 fprintf(stderr, "   * xvf_title_chng\n");
	         fprintf(stderr, "   * xvf_activation_chng\n");
		 fprintf(stderr, "   * xvf_optsel_chng\n");
		 fprintf(stderr, "   * xvf_x_chng\n");
		 fprintf(stderr, "   * xvf_y_chng\n");
		 fprintf(stderr, "   * xvf_height_chng\n");
		 return(false);
		 break;

	    } /* end switch (change_code) */

    xvf_deparse_int_line(&line_info, database, index);
    return(true);
}

/************************************************************
*
*  Routine Name: xvf_change_float_line
*
*      Purpose:  Changes a FloatOpt line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of line to be changed
*		 change_code - desired change to line. May be:
*				1) xvf_activation_chng
*				2) xvf_title_chng 
*				3) xvf_width_chng
*				4) xvf_height_chng
*				5) xvf_x_chng
*				6) xvf_y_chng
*				7) xvf_optsel_chng
*				8) xvf_floatval_chng
*		 string - string to be changed
*		 max_strlen - max length of string
*       Output:  none
*    Called By:  xvf_change_input()
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_float_line(form, database, index, 
			  change_code, string, max_strlen)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
int  max_strlen;
{
      XawTextBlock   text_block;
      xvf_selection *selection;
      Line_Info      line_info;
      int            width, height, x, y, old_len;
      int	     atoi(), status, n;
      char 	     buff[10*MaxLength], *string_return;
      double         atof();
      float	     percent, tmp_float;
      Arg	     arg[MaxLength];

      xvf_clear_line_info(&line_info);
      xvf_parse_float_line(database[index], &line_info);

      x      = line_info.x*xvf_font_width;
      y      = line_info.y* (xvf_font_height + ((int)xvf_font_height/2));
      width  = line_info.width*xvf_font_width;
      height = line_info.height*(xvf_font_height+6);

      selection = xvf_sel_search(form, index);
      if (selection == NULL)
      {
          fprintf(stderr, "xvf_change_float_line:\n");
	  fprintf(stderr, "Couldn't find selection for %s", database[index]);
      }

      switch (change_code) {

	     case  xvf_activation_chng:
		   line_info.activate = atoi(string);
		   if (selection->back != NULL)
                       XtSetSensitive(selection->back, line_info.activate);
		   break;

	     case  xvf_title_chng:
	           if (string == NULL) line_info.title = NULL;
	           else line_info.title = xvf_strcpy(string);
		   
		   if (selection->label_widget != NULL)
		   {
		       if (max_strlen != 0)
                           width = max_strlen*xvf_font_width;
                       else
                           width = xvf_strlen(string)*xvf_font_width;

	   	       xvf_change_title(selection->label_widget, width, 
			    	        0, 0, string);
		   }
		   break;


	     case  xvf_height_chng:
	           if (string == NULL) 
			return(true);
	           line_info.height = atof(string);

		   if (selection->back != NULL)
		   {
      		       height = line_info.height*(xvf_font_height+6);
	   	       xvf_change_geometry(selection->back, x, y, 
				            width, height, 0);
		   }
		   break;

	     case  xvf_x_chng:
	           if (string == NULL) 
			return(true);
	           line_info.x = atof(string);

		   if (selection->back != NULL)
		   {
      		       x = line_info.x*xvf_font_width;
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_y_chng:
	           if (string == NULL) 
			return(true);
	           line_info.y = atof(string);

		   if (selection->back != NULL)
		   {
      		       y = line_info.y* (xvf_font_height+
					((int)xvf_font_height/2));
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_optsel_chng:
		   line_info.opt_sel= atoi(string);
		   if (line_info.optional != true)
		   {
		      fprintf(stderr, "xvf_change_float_line:\n");
		      fprintf(stderr, "WARNING: 'option_selected' field may only be changed");
		      fprintf(stderr,"          when the [-f] line has the 'optional' field = 1.\n");
		      return(false);
		   }
		   if ((selection->opt_widget != NULL) &&
			  (atoi(string) != selection->opt_selected))
		   {
		          xvf_reverse_colors(selection->opt_widget);
                          selection->opt_selected = atoi(string);
		   }
		   break;

	     case  xvf_floatval_chng:
		   tmp_float = (float) atof(string);
		   if (line_info.upper_float != line_info.lower_float)
		   {
		      if ((tmp_float > line_info.upper_float) ||
                          (tmp_float < line_info.lower_float))
                      {
                           fprintf(stderr, "xvf_change_float_line:\n");
                           fprintf(stderr, "   WARNING: value provided for change to \n");
                           fprintf(stderr, "            float selection is out of bounds.\n");
                           return(false);
                      }
		   }
		   line_info.float_val = tmp_float;
		   sprintf(buff, "%g", line_info.float_val);
		   line_info.literal = xvf_strcpy(buff);

		   if (selection->value_widget != NULL)
		   {
                       n = 0;
                       XtSetArg(arg[n], XtNstring, &string_return); n++;
                       XtGetValues(selection->value_widget, arg, n);
                       old_len = xvf_strlen(string_return);

		       sprintf(buff,"%g", line_info.float_val);

                       text_block.firstPos = 0;
	               text_block.length = xvf_strlen(buff);
                       text_block.ptr = buff;
                       text_block.format = FMT8BIT;

                       status = XawTextReplace(selection->value_widget,
                                               (XawTextPosition) 0,
                                               (XawTextPosition) old_len,
                                               &text_block);
                       XawTextDisplay(selection->value_widget);
		       if (status == XawPositionError)
        	       {
                    	   fprintf(stderr, "\nxvf_change_float_line:\n");
        		   fprintf(stderr,"      ERROR: XawPositionError\n");
        	       }
        	       else if (status == XawEditError)
        	       {
                    	   fprintf(stderr, "\nxvf_change_float_line:\n");
                           fprintf(stderr,"      ERROR: XawEditError\n");
             	       }
		   }
		   if (selection->scroll != NULL)
		   {
		       percent = (line_info.float_val -
		 	          line_info.lower_float) /
			         (line_info.upper_float -
			          line_info.lower_float);
		       XawScrollbarSetThumb(selection->scroll, percent, 1.0);
		   }

			      
		   break;
	
	    default:
		 fprintf(stderr, "xvf_change_float_line:\n");
		 fprintf(stderr, "WARNING: Illegal change code for a Float selection.\n");
		 fprintf(stderr, "         Only accepted change codes for a [-f] line are:\n");
		 fprintf(stderr, "   * xvf_floatval_chng\n");
		 fprintf(stderr, "   * xvf_title_chng\n");
	         fprintf(stderr, "   * xvf_activation_chng\n");
		 fprintf(stderr, "   * xvf_optsel_chng\n");
		 fprintf(stderr, "   * xvf_x_chng\n");
		 fprintf(stderr, "   * xvf_y_chng\n");
		 fprintf(stderr, "   * xvf_height_chng\n");
		 return(false);
		 break;

	    } /* end switch (change_code) */

    xvf_deparse_float_line(&line_info, database, index);
    return(true);
}


/************************************************************
*
*  Routine Name: xvf_change_string_line
*
*      Purpose:  Changes a StringOpt line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of line to be changed
*		 change_code - desired change to line. May be:
*				1) xvf_activation_chng
*				2) xvf_title_chng 
*				3) xvf_width_chng
*				4) xvf_height_chng
*				5) xvf_x_chng
*				6) xvf_y_chng
*				7) xvf_optsel_chng
*				8) xvf_stringval_chng
*		 string - string to be changed
*		 max_strlen - max length of string
*       Output:  none
*    Called By:  xvf_change_input
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_string_line(form, database, index, 
			   change_code, string, max_strlen)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
int  max_strlen;

{
      XawTextBlock   text_block;
      xvf_selection *selection;
      Line_Info      line_info;
      int            n, width, height, x, y, old_len; 
      int	     atoi(), status;
      double	     atof();
      char  	    *string_return, buff[10*MaxLength];
      Arg            arg[MaxArgs];

      xvf_clear_line_info(&line_info);
      xvf_parse_string_line(database[index], &line_info);

      x      = line_info.x*xvf_font_width;
      y      = line_info.y* (xvf_font_height + ((int)xvf_font_height/2));
      width  = line_info.width*xvf_font_width;
      height = line_info.height*(xvf_font_height+6);

      selection = xvf_sel_search(form, index);
      if (selection == NULL)
      {
          fprintf(stderr, "xvf_change_string_line:\n");
	  fprintf(stderr, "   WARNING: Couldn't find selection for %s", 
			  database[index]);
      }

      switch (change_code) {

	     case  xvf_activation_chng:
		   line_info.activate = atoi(string);
		   if (selection->back != NULL)
                       XtSetSensitive(selection->back, line_info.activate);
		   break;

	     case  xvf_title_chng:
	           if (string == NULL) line_info.title = NULL;
	           else line_info.title = xvf_strcpy(string);

		   if (selection->label_widget != NULL)
		   {
		       if (max_strlen != 0)
                           width = max_strlen*xvf_font_width;
                       else
                           width = xvf_strlen(string)*xvf_font_width;

	   	       xvf_change_title(selection->label_widget, width, 
				        0, 0, string);
		   }
		   break;


	     case  xvf_width_chng:
	           if (string == NULL) 
			return(true);
	           line_info.width = atof(string);

		   if (selection->back != NULL)
		   {
		       width = line_info.width*xvf_font_width;
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_height_chng:
	           if (string == NULL) 
			return(true);
	           line_info.height = atof(string);

		   if (selection->back != NULL)
		   {
      		       height = line_info.height*(xvf_font_height+6);
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_x_chng:
	           if (string == NULL) 
			return(true);
	           line_info.x = atof(string);

		   if (selection->back != NULL)
		   {
      		       x = line_info.x*xvf_font_width;
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_y_chng:
	           if (string == NULL) 
			return(true);
	           line_info.y = atof(string);

		   if (selection->back != NULL)
		   {
      	 	       y = line_info.y* (xvf_font_height+
					 ((int)xvf_font_height/2));
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_optsel_chng:
		   line_info.opt_sel= atoi(string);
		   if (line_info.optional != true)
		   {
		      fprintf(stderr, "xvf_change_string_line:\n");
		      fprintf(stderr, "   WARNING: 'option_selected' field may only be changed");
		      fprintf(stderr,"             when the [-s] line has the 'optional' field = 1.\n");
		      return(false);
		   }
		   if ((selection->opt_widget != NULL) &&
			  (atoi(string) != selection->opt_selected))
		   {
		          xvf_reverse_colors(selection->opt_widget);
                          selection->opt_selected = atoi(string);
		   }
		   break;

	     case  xvf_stringval_chng:
		   if (string == NULL) 
		   {
			line_info.string_val = line_info.literal = NULL;
		   }
		   else 
		   { 
			line_info.string_val = xvf_strcpy(string);
			line_info.literal    = xvf_strcpy(string);
		   }
		   if (selection->value_widget != NULL)
		   {
		       n = 0;
                       XtSetArg(arg[n], XtNstring, &string_return); n++;
                       XtGetValues(selection->value_widget, arg, n);
                       old_len = xvf_strlen(string_return);

		       if (line_info.string_val != NULL)
                           sprintf(buff,"%s", line_info.string_val);
                       else sprintf(buff, " ");

		       text_block.firstPos = 0;
                       text_block.length = xvf_strlen(buff);
                       text_block.ptr = buff;
                       text_block.format = FMT8BIT;

		       status = XawTextReplace(selection->value_widget,
                                               (XawTextPosition) 0,
                                               (XawTextPosition) old_len,
                                               &text_block);
                       XawTextDisplay(selection->value_widget);
		       if (status == XawPositionError)
        	       {
                	   fprintf(stderr, "\nxvf_change_string_line:\n");
        		   fprintf(stderr,"      ERROR: XawPositionError\n");
        	       }
        	       else if (status == XawEditError)
        	       {
                	   fprintf(stderr, "\nxvf_change_string_line:\n");
                           fprintf(stderr,"      ERROR: XawEditError\n");
             	       }
		   }
		   break;
	
 	    default:
		 fprintf(stderr, "xvf_change_string_line:\n");
		 fprintf(stderr, "   WARNING: Illegal change code for a String selection.\n");
		 fprintf(stderr, "            Only accepted change codes for a [-s] line are:\n");
		 fprintf(stderr, "   * xvf_stringval_chng\n");
		 fprintf(stderr, "   * xvf_title_chng\n");
	         fprintf(stderr, "   * xvf_activation_chng\n");
		 fprintf(stderr, "   * xvf_optsel_chng\n");
		 fprintf(stderr, "   * xvf_x_chng\n");
		 fprintf(stderr, "   * xvf_y_chng\n");
		 fprintf(stderr, "   * xvf_width_chng\n");
		 fprintf(stderr, "   * xvf_height_chng\n");
		 return(false);
		 break;

	    } /* end switch (change_code) */

    xvf_deparse_string_line(&line_info, database, index);
    return(true);
}


/************************************************************
*
*  Routine Name: xvf_change_toggle_line
*
*      Purpose:  Changes a Toggle line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of FloatOpt line to be changed
*		 change_code - desired change to line. May be:
*				1) xvf_activation_chng
*				2) xvf_title_chng 
*				3) xvf_optsel_chng
*				4) xvf_toggleval_chng
*		 string - string to be changed
*		 max_strlen - max length of string
*       Output:  none
*    Called By:  xvf_change_input
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_toggle_line(form, database, index, 
			   change_code, string, max_strlen)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
int  max_strlen;
{
      xvf_selection *selection, *toggle_sel;
      Line_Info      line_info, tmp_line_info;
      int            atoi(), n, width;
      int	     new_toggle_val;

      xvf_clear_line_info(&line_info);
      xvf_parse_toggle_line(database[index], &line_info);

      if (max_strlen != 0)
         width = max_strlen*xvf_font_width;
      else
         width = xvf_strlen(string)*xvf_font_width;
      if (width == 0) width = 10;

      selection = xvf_sel_search(form, index);
      if (selection == NULL)
      {
          fprintf(stderr, "xvf_change_toggle_line:\n");
	  fprintf(stderr, "   WARNING: Couldn't find selection for %s", 
			  database[index]);
      }

      switch (change_code) {

	     case  xvf_activation_chng:
		   line_info.activate = atoi(string);
		   if (selection->back != NULL)
                       XtSetSensitive(selection->back, line_info.activate);
		   break;

	     case  xvf_title_chng:
	           if (string == NULL) line_info.title = NULL;
	           else line_info.title = xvf_strcpy(string);

		   if (selection->label_widget != NULL)
	   	       xvf_change_title(selection->label_widget, width, 
		 		         0, 0, string);
		   break;

	     case  xvf_optsel_chng:
		   line_info.opt_sel= atoi(string);
		   if (line_info.optional != true)
		   {
		      fprintf(stderr, "xvf_change_line:\n");
		      fprintf(stderr, "   WARNING: 'option_selected' field may only be changed");
		      fprintf(stderr,"             when the [-T] line has the 'optional' field = 1.\n");
		      return(false);
		   }
		   if ((selection->opt_widget != NULL) &&
			  (atoi(string) != selection->opt_selected))
		   {
		          xvf_reverse_colors(selection->opt_widget);
                          selection->opt_selected = atoi(string);
		   }
		   break;

	     case  xvf_toggleval_chng:
		   line_info.toggle_val = atoi(string);
		   line_info.toggle_def = atoi(string);
		   new_toggle_val = line_info.toggle_val;
                   toggle_sel = selection->toggle_next;
                   n = 1;
		   while (toggle_sel != NULL)
                   {
                      /* parse a line from the toggle switch */
                      xvf_gen_parse(database[toggle_sel->index], &tmp_line_info);

                      /* if it is the old one that used to be selected, it 
			 will be still marked as selected - reverse its colors, 
			 turning it off, and set it to be unselected */

                      if (tmp_line_info.opt_sel == true)
                      {
                          tmp_line_info.opt_sel = false;
                          xvf_gen_deparse(&tmp_line_info, database, toggle_sel->index);                     
		 	  toggle_sel->opt_selected = false;
			  if (toggle_sel->opt_widget != NULL)
                              xvf_reverse_colors(toggle_sel->opt_widget);
                      }

                      /* if its number is the same as the one requested, 
			 reverse its colors, turning it on, and set it 
		         to be selected */

                      if (new_toggle_val == n)
                      {
                          tmp_line_info.opt_sel = true;
                          xvf_gen_deparse(&tmp_line_info, database, toggle_sel->index);
                          toggle_sel->opt_selected = true;
			  if (toggle_sel->opt_widget != NULL)
                              xvf_reverse_colors(toggle_sel->opt_widget);
                      }
                      n++;
                      toggle_sel = toggle_sel->next;
                   }
		   break;
	
	    default:
		 fprintf(stderr, "xvf_change_line:\n");
		 fprintf(stderr, "   WARNING: Illegal change code for a Toggle selection.\n");
		 fprintf(stderr, "            Only accepted change codes for a [-T] line are:\n");
		 fprintf(stderr, "   * xvf_toggleval_chng\n");
		 fprintf(stderr, "   * xvf_title_chng\n");
	         fprintf(stderr, "   * xvf_activation_chng\n");
		 fprintf(stderr, "   * xvf_optsel_chng\n");
		 return(false);
		 break;

      } /* end switch (change_code) */

      xvf_deparse_toggle_line(&line_info, database, index);
      return(true);
}


/************************************************************
*
*  Routine Name: xvf_change_logic_line
*
*      Purpose:  Changes a LogicalOpt line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of line to be changed
*		 change_code - desired change to line. May be:
*				1) xvf_activation_chng
*				2) xvf_title_chng 
*				3) xvf_width_chng
*				4) xvf_height_chng
*				5) xvf_x_chng
*				6) xvf_y_chng
*				7) xvf_optsel_chng
*				8) xvf_logicalval_chng
*		 string - string to be changed
*		 max_strlen - max length of string
*       Output:  none
*    Called By:  xvf_change_input()
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_logic_line(form, database, index, 
		          change_code, string, max_strlen)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
int  max_strlen;

{
      xvf_selection *selection;
      Line_Info      line_info;
      int            width, height, x, y, old_val; 
      int	     atoi();
      double	     atof();
      char  	    *boolean_label, temp[MaxLength];


      xvf_clear_line_info(&line_info);
      xvf_parse_logic_line(database[index], &line_info);

      x      = line_info.x*xvf_font_width;
      y      = line_info.y* (xvf_font_height + ((int)xvf_font_height/2));
      height = line_info.height*(xvf_font_height+6);

      if (line_info.logical_val == true)
          boolean_label = xvf_strcpy(line_info.val_labels[1]);
      else
          boolean_label = xvf_strcpy(line_info.val_labels[0]);

      width  = xvf_strlen(line_info.title)*xvf_font_width + 
	       xvf_font_width + xvf_font_width*(xvf_strlen(boolean_label)+2);
      if (line_info.optional == true)
         width += xvf_font_height + xvf_font_width;

      selection = xvf_sel_search(form, index);
      if (selection == NULL)
      {
          fprintf(stderr, "xvf_change_logic_line:\n");
	  fprintf(stderr, "WARNING: Couldn't find selection for %s", 
			  database[index]);
      }

      switch (change_code) {

	     case  xvf_activation_chng:
		   line_info.activate = atoi(string);
		   if (selection->back != NULL)
                       XtSetSensitive(selection->back, line_info.activate);
		   break;

	     case  xvf_title_chng:
	           if (string == NULL) line_info.title = NULL;
	           else line_info.title = xvf_strcpy(string);

		   if (selection->label_widget != NULL)
		   {
	 	       if (max_strlen != 0)
                           width = max_strlen*xvf_font_width;
                       else
                           width = xvf_strlen(string)*(xvf_font_width+1);
	   	       xvf_change_title(selection->label_widget, width, 
				        0, 0, string);
		   }
		   break;


	     case  xvf_width_chng:
	           if (string == NULL) 
			return(true);
	           line_info.width = atof(string);

		   if (selection->back != NULL)
		   {
		       width = line_info.width*xvf_font_width;
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_height_chng:
	           if (string == NULL) 
			return(true);
	           line_info.height = atof(string);

		   if (selection->back != NULL)
		   {
      		       height = line_info.height*(xvf_font_height+6);
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_x_chng:
	           if (string == NULL) 
			return(true);
	           line_info.x = atof(string);

		   if (selection->back != NULL)
		   {
      		       x = line_info.x*xvf_font_width;
	   	       xvf_change_geometry(selection->back, x, y, 
			       	           width, height, 0);
		   }
		   break;

	     case  xvf_y_chng:
	           if (string == NULL) 
			return(true);
	           line_info.y = atof(string);

		   if (selection->back != NULL)
		   {
      		       y = line_info.y*(xvf_font_height+
					((int)xvf_font_height/2));
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_optsel_chng:
		   line_info.opt_sel= atoi(string);
		   if (line_info.optional != true)
		   {
		      fprintf(stderr, "xvf_change_logic_line:\n");
		      fprintf(stderr, "   WARNING: 'option_selected' field may only be changed");
		      fprintf(stderr, "            when the [-l] line has the 'optional' field = 1.\n");
		      return(false);
		   }
		   if ((selection->opt_widget != NULL) &&
			  (atoi(string) != selection->opt_selected))
		   {
		          xvf_reverse_colors(selection->opt_widget);
                          selection->opt_selected = atoi(string);
		   }
		   break;

	     case  xvf_logicalval_chng:
		   old_val = line_info.logical_val;
		   if (old_val == atoi(string)) return(false);
		   line_info.logical_val = atoi(string);
		   sprintf(temp, "%d", line_info.logical_val);
		   line_info.literal = xvf_strcpy(temp);
		   
		   if (selection->value_widget != NULL)
		   {
		       if (line_info.logical_val == true)
                           boolean_label = xvf_strcpy(line_info.val_labels[1]);
		       else
		           boolean_label = xvf_strcpy(line_info.val_labels[0]);

		       width = (xvf_font_width +2)* 
				(xvf_strlen(boolean_label)+1);
		       height = (xvf_font_height +2)*line_info.height;

		       xvf_change_title(selection->value_widget, width, height, 
		    		        1, boolean_label);
		   }
		   break;
	
 	    default:
		 fprintf(stderr, "xvf_change_logic_line:\n");
		 fprintf(stderr, "   WARNING: Illegal change code for a Logical selection.\n");
		 fprintf(stderr, "            Only accepted change codes for a [-l] line are:\n");
		 fprintf(stderr, "   * xvf_logicalval_chng\n");
		 fprintf(stderr, "   * xvf_title_chng\n");
	         fprintf(stderr, "   * xvf_activation_chng\n");
		 fprintf(stderr, "   * xvf_optsel_chng\n");
		 fprintf(stderr, "   * xvf_x_chng\n");
		 fprintf(stderr, "   * xvf_y_chng\n");
		 fprintf(stderr, "   * xvf_width_chng\n");
		 fprintf(stderr, "   * xvf_height_chng\n");
		 return(false);
		 break;

	    } /* end switch (change_code) */

    xvf_deparse_logic_line(&line_info, database, index);
    return(true);
}


/************************************************************
*
*  Routine Name: xvf_change_cycle_line
*
*      Purpose:  Changes a Cycle line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of line to be changed
*		 change_code - desired change to line. May be:
*				1) xvf_activation_chng
*				2) xvf_title_chng 
*				3) xvf_width_chng
*				4) xvf_height_chng
*				5) xvf_x_chng
*				6) xvf_y_chng
*				7) xvf_optsel_chng
*				8) xvf_cycleval_chng
*		 string - string to be changed
*		 max_strlen - max length of string
*       Output:  none
*    Called By:  xvf_change_input()
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_cycle_line(form, database, index, 
		          change_code, string, max_strlen)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
int  max_strlen;

{
      xvf_selection *selection;
      Line_Info      line_info;
      int            width, height, x, y, old_val; 
      int	     atoi();
      double	     atof();
      char  	    *boolean_label, temp[MaxLength];


      xvf_clear_line_info(&line_info);
      xvf_parse_cycle_line(database[index], &line_info);

      x      = line_info.x*xvf_font_width;
      y      = line_info.y* (xvf_font_height + ((int)xvf_font_height/2));
      height = line_info.height*(xvf_font_height+6);

      boolean_label = xvf_strcpy(line_info.val_labels[line_info.cycle_val]);

      width  = xvf_strlen(line_info.title)*xvf_font_width + 
	       xvf_font_width + xvf_font_width*(xvf_strlen(boolean_label)+2);
      if (line_info.optional == true)
         width += xvf_font_height + xvf_font_width;

      selection = xvf_sel_search(form, index);
      if (selection == NULL)
      {
          fprintf(stderr, "xvf_change_cycle_line:\n");
	  fprintf(stderr, "WARNING: Couldn't find selection for %s", 
			  database[index]);
      }

      switch (change_code) {

	     case  xvf_activation_chng:
		   line_info.activate = atoi(string);
		   if (selection->back != NULL)
                       XtSetSensitive(selection->back, line_info.activate);
		   break;

	     case  xvf_title_chng:
	           if (string == NULL) line_info.title = NULL;
	           else line_info.title = xvf_strcpy(string);

		   if (selection->label_widget != NULL)
		   {
	 	       if (max_strlen != 0)
                           width = max_strlen*xvf_font_width;
                       else
                           width = xvf_strlen(string)*(xvf_font_width+1);
	   	       xvf_change_title(selection->label_widget, width, 
				        0, 0, string);
		   }
		   break;


	     case  xvf_width_chng:
	           if (string == NULL) 
			return(true);
	           line_info.width = atof(string);

		   if (selection->back != NULL)
		   {
		       width = line_info.width*xvf_font_width;
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_height_chng:
	           if (string == NULL) 
			return(true);
	           line_info.height = atof(string);

		   if (selection->back != NULL)
		   {
      		       height = line_info.height*(xvf_font_height+6);
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_x_chng:
	           if (string == NULL) 
			return(true);
	           line_info.x = atof(string);

		   if (selection->back != NULL)
		   {
      		       x = line_info.x*xvf_font_width;
	   	       xvf_change_geometry(selection->back, x, y, 
			       	           width, height, 0);
		   }
		   break;

	     case  xvf_y_chng:
	           if (string == NULL) 
			return(true);
	           line_info.y = atof(string);

		   if (selection->back != NULL)
		   {
      		       y = line_info.y*(xvf_font_height+
					((int)xvf_font_height/2));
	   	       xvf_change_geometry(selection->back, x, y, 
				           width, height, 0);
		   }
		   break;

	     case  xvf_optsel_chng:
		   line_info.opt_sel= atoi(string);
		   if (line_info.optional != true)
		   {
		      fprintf(stderr, "xvf_change_cycle_line:\n");
		      fprintf(stderr, "   WARNING: 'option_selected' field may only be changed");
		      fprintf(stderr, "            when the [-c] line has the 'optional' field = 1.\n");
		      return(false);
		   }
		   if ((selection->back != NULL) &&
			  (atoi(string) != selection->opt_selected))
		   {
		          xvf_reverse_colors(selection->opt_widget);
                          selection->opt_selected = atoi(string);
		   }
		   break;

	     case  xvf_cycleval_chng:
		   old_val = line_info.cycle_val;
		   if (old_val == atoi(string)) return(false);
		   if (atoi(string) > line_info.cycle_num-1) 
		   {
                      fprintf(stderr, "xvf_change_cycle_line:\n");
                      fprintf(stderr, "   ERROR: cannot change value of cycle\n");
                      fprintf(stderr, "          to a value greater than %d\n",
			     line_info.cycle_num-1);
                      return(false);
                   }
		   line_info.cycle_val = atoi(string);
		   sprintf(temp, "%d", line_info.cycle_val);
		   line_info.literal = xvf_strcpy(temp);
		   
		   if (selection->value_widget != NULL)
		   {
                       boolean_label = xvf_strcpy(line_info.val_labels[line_info.cycle_val]);
		       width = (xvf_font_width +2)* 
				(xvf_strlen(boolean_label)+1);
		       height = (xvf_font_height +2)*line_info.height;
		       xvf_change_title(selection->value_widget, width, height, 
		    		        1, boolean_label);
		   }
		   break;
	
 	    default:
		 fprintf(stderr, "xvf_change_cycle_line:\n");
		 fprintf(stderr, "   WARNING: Illegal change code for a Logical selection.\n");
		 fprintf(stderr, "            Only accepted change codes for a [-c] line are:\n");
		 fprintf(stderr, "   * xvf_cycleval_chng\n");
		 fprintf(stderr, "   * xvf_title_chng\n");
	         fprintf(stderr, "   * xvf_activation_chng\n");
		 fprintf(stderr, "   * xvf_optsel_chng\n");
		 fprintf(stderr, "   * xvf_x_chng\n");
		 fprintf(stderr, "   * xvf_y_chng\n");
		 fprintf(stderr, "   * xvf_width_chng\n");
		 fprintf(stderr, "   * xvf_height_chng\n");
		 return(false);
		 break;

	    } /* end switch (change_code) */

    xvf_deparse_cycle_line(&line_info, database, index);
    return(true);
}


/************************************************************
*
*  Routine Name: xvf_change_subformbutton_line
*
*      Purpose:  Changes a SubformButton line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of GuideButton line to be changed
*		 change_code - desired change to line. May be:
*				1) xvf_activation_chng
*				2) xvf_title_chng 
*				3) xvf_width_chng
*				4) xvf_height_chng
*				5) xvf_x_chng
*				6) xvf_y_chng
*				8) xvf_subform_chng
*		 string - string to be changed
*		 max_strlen - max length of string
*       Output:  none
*    Called By:  xvf_change_input()
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_subformbutton_line(form, database, index, 
				  change_code, string)

xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
{
      xvf_sub_form *subform, *old_subform;
      Line_Info     line_info, subform_info;
      int           atoi(), width, height, x, y, i;
      double	    atof();

      xvf_clear_line_info(&line_info);
      xvf_parse_subformbutton_line(database[index], &line_info);

      x = line_info.x*xvf_font_width;
      y = line_info.y*(xvf_font_height + ((int)xvf_font_height/4));
      width = line_info.width*xvf_font_width;
      height = line_info.height*xvf_font_height;

      subform = xvf_subform_button_search(form, index);
      if (subform == NULL)
      {
          fprintf(stderr, "xvf_change_subformbutton_line:\n");
	  fprintf(stderr, "   WARNING: Couldn't find subform associated with %s", 
			   database[index]);
	  return(false);
      }

      switch (change_code) {

	    case  xvf_activation_chng:
		  line_info.activate = atoi(string);
		  if (subform->button != NULL)
                     XtSetSensitive(subform->button, line_info.activate);
		  break;

	    case  xvf_title_chng:
	          if (string == NULL) line_info.title = NULL;
	          else line_info.title = xvf_strcpy(string);
		  
		  if (subform->button != NULL)
	   	      xvf_change_title(subform->button, width, height,
				2, string);
		  break;

	     case xvf_width_chng:
	          if (string == NULL) 
		      return(true);
	          line_info.width = atof(string);

 		  if (subform->button != NULL)
		  {
		      width = line_info.width*xvf_font_width;
	   	      xvf_change_geometry(subform->button, x, y, 
				          width, height, 2);
		  }
		  break;

	     case xvf_height_chng:
	          if (string == NULL) 
		      return(true);
	          line_info.height = atof(string);

		  if (subform->button != NULL)
		  {
		      height = line_info.height*xvf_font_height;
	   	      xvf_change_geometry(subform->button, x, y, 
			   	          width, height, 2);
		  }
		  break;

	     case xvf_x_chng:
	          if (string == NULL) 
		      return(true);
	          line_info.x = atof(string);

		  if (subform->button != NULL)
		  {
      		      x = line_info.x*xvf_font_width;
	   	      xvf_change_geometry(subform->button, x, y, 
				           width, height, 2);
		  }
		  break;

	     case xvf_y_chng:
	          if (string == NULL) 
		      return(true);
	          line_info.y = atof(string);

		  if (subform->button != NULL)
		  {
                      y = line_info.y*(xvf_font_height + 
				      ((int)xvf_font_height/4));
	   	      xvf_change_geometry(subform->button, x, y, 
				          width, height, 2);
		  }
		  break;

	    case  xvf_subform_chng:
		  line_info.selected = atoi(string);
		  old_subform = form->subform;
	          while (old_subform != NULL)
		  {
		       xvf_clear_line_info(&subform_info);
		       if (old_subform->selected == true)
		       {
			   if (old_subform->button != NULL)
			   {
			        xvf_reverse_colors(old_subform->button);
				XUnmapWindow(
					XtDisplay(old_subform->back),
					XtWindow(old_subform->back));
			   }
			   i = old_subform->index;
			   old_subform->selected = false;
			   xvf_parse_startsubform_line(database[i], &subform_info);
			   subform_info.selected = false;
			   xvf_deparse_startsubform_line(&subform_info, database, i);
			   i = old_subform->button_index;
			   xvf_parse_subformbutton_line(database[i], &subform_info);
			   subform_info.selected = false;
			   xvf_deparse_subformbutton_line(&subform_info, database, i);
			   break;

		       }
		       old_subform = subform->next_subform;
		}
		subform = form->subform;
		while (subform != NULL)
		{
		    if (subform->button_index == index)
		    {
			subform->selected = true;
			if (subform->button != NULL)
			{
			    xvf_reverse_colors(subform->button);
			    if (subform->back == NULL)
			    {
				if (!(xvf_create_subform(database, form,
				      subform, true)))
				return(false);

			    }
			     XMapRaised(XtDisplay(subform->back),
					XtWindow(subform->back));
			}
			i = subform->index;
			subform->selected = true;
			xvf_parse_startsubform_line(database[i], &subform_info);
			subform_info.selected = true;
			xvf_deparse_startsubform_line(&subform_info, database,i);
			i = subform->button_index;
                        xvf_parse_subformbutton_line(database[i], &subform_info);
			subform_info.selected = false;
                        xvf_deparse_subformbutton_line(&subform_info, database, i);
                        break;
		    }
		    subform = subform->next_subform;
		}
		break;

	    default:
		 fprintf(stderr, "xvf_change_subformutton_line:\n");
		 fprintf(stderr, "   WARNING: Illegal change code for a SubformButton selection.\n");
		 fprintf(stderr, "            Only accepted change codes for a [-d] line are:\n");
		 fprintf(stderr, "   * xvf_subform_chng\n");
		 fprintf(stderr, "   * xvf_title_chng\n");
	         fprintf(stderr, "   * xvf_activation_chng\n");
		 fprintf(stderr, "   * xvf_x_chng\n");
		 fprintf(stderr, "   * xvf_y_chng\n");
		 fprintf(stderr, "   * xvf_width_chng\n");
		 fprintf(stderr, "   * xvf_height_chng\n");
		 return(false);
		 break;
	    }

    xvf_deparse_subformbutton_line(&line_info, database, index);
    return(true);
}


/************************************************************
*
*  Routine Name: xvf_change_guidebutton_line
*
*      Purpose:  Changes a GuideButton line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of GuideButton line to be changed
*		 change_code - desired change to line. May be:
*				1) xvf_activation_chng
*				2) xvf_title_chng 
*				3) xvf_width_chng
*				4) xvf_height_chng
*				5) xvf_x_chng
*				6) xvf_y_chng
*				7) xvf_guide_chng
*		 string - string to be changed
*       Output:  none
*    Called By:  xvf_change_input()
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_guidebutton_line(form, database, index, 
			        change_code, string)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
{
      xvf_guide_button *guide;
      xvf_sub_form     *subform;
      Line_Info	       line_info, guide_info;
      int      	       i, atoi(), width, height, x, y;
      double	       atof();

      xvf_clear_line_info(&line_info);
      xvf_parse_guide_line(database[index], &line_info);

      x = line_info.x*xvf_font_width;
      y = line_info.y*(xvf_font_height + ((int)xvf_font_height/4));
      width = line_info.width*xvf_font_width;
      height = line_info.height*xvf_font_height;

      guide = xvf_guide_search(form, index);
      if (guide == NULL)
      {
          fprintf(stderr, "xvf_change_subformbutton_line:\n");
	  fprintf(stderr, "   WARNING: Couldn't find guide struct associated with %s", 
			   database[index]);
	  return(false);
      }

      switch (change_code) {

	    case  xvf_activation_chng:
		  line_info.activate = atoi(string);
		  if (guide->button != NULL)
                      XtSetSensitive(guide->button, line_info.activate);
		  break;

	    case  xvf_title_chng:
	          if (string == NULL) line_info.title = NULL;
	          else line_info.title = xvf_strcpy(string);

		  if (guide->button != NULL)
	   	      xvf_change_title(guide->button, width, height,
				        2, string);
		  break;

	     case xvf_width_chng:
	          if (string == NULL) 
		      return(true);
	          line_info.width = atof(string);

		  if (guide->button != NULL)
		  {
		      width = line_info.width*xvf_font_width;
	   	      xvf_change_geometry(guide->button, x, y, 
				          width, height, 2);
		  }
		  break;

	     case xvf_height_chng:
	          if (string == NULL) 
		      return(true);
	          line_info.height = atof(string);

		  if (guide->button != NULL)
		  {
		      height = line_info.height*xvf_font_height;
	   	      xvf_change_geometry(guide->button, x, y, 
				          width, height, 2);
		  }
		  break;

	     case xvf_x_chng:
	          if (string == NULL) 
		      return(true);
	          line_info.x = atof(string);

		  if (guide->button != NULL)
		  {
      		      x = line_info.x*xvf_font_width;
	   	      xvf_change_geometry(guide->button, x, y, 
		   		          width, height, 2);
		  }
		  break;

	     case xvf_y_chng:
	          if (string == NULL) 
		      return(true);
	          line_info.y = atof(string);

		  if (guide->button != NULL)
		  {
                      y = line_info.y*(xvf_font_height + 
				      ((int)xvf_font_height/4));
	   	      xvf_change_geometry(guide->button, x, y, 
				          width, height, 2);
		  }
		  break;

	    case  xvf_guide_chng:
		  line_info.selected = atoi(string);

		  subform=xvf_find_sels_subform(form, index);
		  guide = subform->guide_button;
		  while (guide != NULL) 
		  {
		     xvf_clear_line_info(&guide_info);
		     if ((guide->selected == true) && (guide->pane != NULL))
		     {
			if (guide->button != NULL)
		        {
			   xvf_reverse_colors(guide->button);
			   XUnmapWindow(XtDisplay(guide->pane->back),
			                XtWindow(guide->pane->back));
			}
			i = guide->index;
			guide->selected = false;
			xvf_parse_guide_line(database[i], &guide_info);
			guide_info.selected = false;
			xvf_deparse_guide_line(&guide_info, database, i);

			i = guide->pane->index;
			xvf_parse_startpane_line(database[i], &guide_info);
			guide_info.selected = false;
			xvf_deparse_startpane_line(&guide_info, database, i);
			break;
		     }
		     guide = guide->next_button;
		  }

		  guide = xvf_guide_search(form, index);
		  while (guide != NULL)  
		  {
		     if (guide->index == index) 
		     {
			guide->selected = true;
			if (guide->button != NULL)
			{
			   xvf_reverse_colors(guide->button);
			   
			   if (guide->pane->back == NULL)
			   {
                                XawFormDoLayout(subform->back, (Boolean) false);
				if (!(xvf_create_pane(database, form, 
				      subform, guide, guide->pane, false)))
				return(false);
                                XawFormDoLayout(subform->back, (Boolean) true);
			   }
			   XMapRaised(XtDisplay(guide->pane->back), 
			    	      XtWindow(guide->pane->back));
			}

			i = guide->index;
			guide->selected = true;
			xvf_parse_guide_line(database[i], &guide_info);
			guide_info.selected = true;
			xvf_deparse_guide_line(&guide_info, database, i);

			i = guide->pane->index;
			xvf_parse_startpane_line(database[i], &guide_info);
			guide_info.selected = true;
			xvf_deparse_startpane_line(&guide_info, database, i);
			break;
		     }
		     guide = guide->next_button;
		  }
		  break;

	      default:
		 fprintf(stderr, "xvf_change_guidebutton_line:\n");
		 fprintf(stderr, "   WARNING: Illegal change code for a GuideButton.\n");
		 fprintf(stderr, "            Only accepted change codes for a [-g] line are:\n");
		 fprintf(stderr, "   * xvf_guide_chng\n");
		 fprintf(stderr, "   * xvf_title_chng\n");
	         fprintf(stderr, "   * xvf_activation_chng\n");
		 fprintf(stderr, "   * xvf_x_chng\n");
		 fprintf(stderr, "   * xvf_y_chng\n");
		 fprintf(stderr, "   * xvf_width_chng\n");
		 fprintf(stderr, "   * xvf_height_chng\n");
		 return(false);
		 break;
      }
      xvf_deparse_guide_line(&line_info, database, index);
      return(true);
}


/************************************************************
*
*  Routine Name: xvf_change_blank
*
*      Purpose:  Changes a Blank line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of line to be changed
*		 change_code - desired change to line. May be:
*				1) xvf_title_chng 
*				2) xvf_x_chng
*				3) xvf_y_chng
*		 string - string to be changed
*		 max_strlen - max length of string
*       Output:  none
*    Called By:  xvf_change_input()
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_blank_line(form, database, index, 
			  change_code, string, max_strlen)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
int  max_strlen;
{
      xvf_selection *selection;
      xvf_guide_button *guide;
      xvf_sub_form     *subform;
      Line_Info      line_info;
      int            width, height, x, y, type;

      xvf_clear_line_info(&line_info);
      xvf_parse_blank_line(database[index], &line_info);


      x = line_info.xpos*xvf_font_width;
      y = line_info.ypos*(xvf_font_height + ((int)xvf_font_height/4));
      width = xvf_font_width;
      height = xvf_font_height;

      selection = xvf_sel_search(form, index);
      if (selection == NULL)
      {
           guide = xvf_guide_search(form, index);
           if (guide == NULL)
           {
                subform = xvf_subform_button_search(form, index);
                if (subform == NULL)
                {
                     fprintf(stderr, "xvf_change_help_line:\n");
                     fprintf(stderr, "   WARNING: Couldn't find selection associated with %s",
                                   database[index]);
                     return(false);

                }
                else type = 1;
           }
           else type = 2;
      }
      else
         type = 3;

      if (type == 3)
         y = line_info.y*(xvf_font_height + ((int)xvf_font_height/2));


      switch (change_code) 
      {
	     case  xvf_title_chng:
	           if (string == NULL) line_info.title = NULL;
	           else line_info.title = xvf_strcpy(string);

		   if (max_strlen != 0)
                       width = max_strlen*xvf_font_width;
                   else width = xvf_strlen(string)*xvf_font_width;

		   if ((type == 3) && (selection->value_widget != NULL))
                        xvf_change_title(selection->value_widget, width, height,
                                    2, string);
                   else if ((type == 2) && (guide->button != NULL))
                        xvf_change_title(guide->button, width, height,
                                    2, string);
                   else if ((type == 1) && (subform->button != NULL))
                        xvf_change_title(subform->button, width, height,
                                    2, string);

		   break;

	     case  xvf_x_chng:
	           if (string == NULL) 
			return(true);
	           line_info.x = atof(string);
      		   x = line_info.x*xvf_font_width;
		   if ((type == 3) && (selection->value_widget != NULL))
                        xvf_change_geometry(selection->value_widget, x, y,
                                             width, height, 2);
                   else if ((type == 2) && (guide->button != NULL))
                        xvf_change_geometry(guide->button, x, y,
                                             width, height, 2);
                   else if ((type == 1)  && (subform->button != NULL))
                        xvf_change_geometry(subform->button, x, y,
                                              width, height, 2);
		   break;

	     case  xvf_y_chng:
	           if (string == NULL) return(true);
	           line_info.y = atof(string);

		   if (type == 3)
                        y = line_info.y*(xvf_font_height +
                            ((int)xvf_font_height/2));
                   else y = line_info.y*(xvf_font_height +
                            ((int)xvf_font_height/4));

                   if ((type == 3) && (selection->value_widget != NULL))
                        xvf_change_geometry(selection->value_widget, x, y,
                                             width, height, 2);
                   else if ((type == 2) && (guide->button != NULL))
                        xvf_change_geometry(guide->button, x, y,
                                             width, height, 2);
                   else if ((type == 1) && (subform->button != NULL))
                   {
                        y = line_info.y*(xvf_font_height +
                                         ((int)xvf_font_height/2));
                        xvf_change_geometry(subform->button, x, y,
                                              width, height, 2);
                   }

		   break;

	     default:
		   fprintf(stderr, "xvf_change_blank_line:\n");
		   fprintf(stderr, "   WARNING: Illegal change code for a Blank.\n");
		   fprintf(stderr, "            The only accepted change code for a ");
		   fprintf(stderr, "[-b] line is:\n");
		   fprintf(stderr, "   * xvf_title_chng\n");
		   fprintf(stderr, "   * xvf_x_chng\n");
		   fprintf(stderr, "   * xvf_y_chng\n");
		   return(false);
		   break;

      } /* end switch (change_code) */

      xvf_deparse_blank_line(&line_info, database, index);
      return(true);
}


/************************************************************
*
*  Routine Name: xvf_change_subform_action_line
*
*      Purpose:  Changes a SubformAction line according the change_code.
*
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of line to be changed
*		 change_code - desired change to line. May be:
*				1) xvf_activation_chng
*				2) xvf_title_chng 
*				3) xvf_width_chng
*				4) xvf_height_chng
*				5) xvf_x_chng
*				6) xvf_y_chng
*		 string - string to be changed
*       Output:  none
*    Called By:  xvf_change_input()
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_subform_action_line(form, database, index, 
			  	   change_code, string)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
{
      xvf_guide_button  *guide;
      Line_Info          line_info;
      int                atoi(), width, height, x, y;
      double	         atof();

      xvf_clear_line_info(&line_info);
      xvf_parse_subform_action_line(database[index], &line_info);

      x = line_info.x*xvf_font_width;
      y = line_info.y*(xvf_font_height + ((int)xvf_font_height/4));
      width = line_info.width*xvf_font_width;
      height = line_info.height*xvf_font_height;

      guide = xvf_find_sels_guide(form, index);
      if (guide == NULL)
      {
          fprintf(stderr, "xvf_change_subform_action_line:\n");
	  fprintf(stderr, "   WARNING: Couldn't find guide struct associated with %s", 
			   database[index]);
	  return(false);
      }

      switch (change_code) 
      {

	    case  xvf_activation_chng:
		  line_info.activate = atoi(string);
		  if (guide->button != NULL)
                      XtSetSensitive(guide->button, line_info.activate);
		  break;

	    case  xvf_title_chng:
	          if (string == NULL) line_info.title = NULL;
	          else line_info.title = xvf_strcpy(string);

		  if (guide->button != NULL)
	   	      xvf_change_title(guide->button, width, height,
				        2, string);
		  break;

	     case  xvf_width_chng:
	           if (string == NULL) 
			return(true);
	           line_info.width = atof(string);

		   if (guide->button != NULL)
		   {
		       width = line_info.width*xvf_font_width;
	   	       xvf_change_geometry(guide->button, x, y, 
				           width, height, 2);
		   }
		   break;

	     case  xvf_height_chng:
	           if (string == NULL) 
			return(true);
	           line_info.height = atof(string);

		   if (guide->button != NULL)
		   {
		       height = line_info.height*xvf_font_height;
	   	       xvf_change_geometry(guide->button, x, y, 
				           width, height, 2);
		   }
		   break;

	     case  xvf_x_chng:
	           if (string == NULL) 
			return(true);
	           line_info.x = atof(string);

		   if (guide->button != NULL)
		   {
      		       x = line_info.x*xvf_font_width;
	   	       xvf_change_geometry(guide->button, x, y, 
				           width, height, 2);
		   }
		   break;

	     case  xvf_y_chng:
	           if (string == NULL) 
			return(true);
	           line_info.y = atof(string);

		   if (guide->button != NULL)
		   {
                       y = line_info.y*(xvf_font_height + 
					((int)xvf_font_height/4));
	   	       xvf_change_geometry(guide->button, x, y, 
				           width, height, 2);
		   }
		   break;

	     default:
		   fprintf(stderr, "xvf_change_subform_action_line:\n");
		   fprintf(stderr, "   WARNING: Illegal change code for SubformAction.\n");
		   fprintf(stderr, "            The only accepted change code for a ");
		   fprintf(stderr, "[-m] line is:\n");
		   fprintf(stderr, "   * xvf_activation_chng\n");
		   fprintf(stderr, "   * xvf_title_chng\n");
		   fprintf(stderr, "   * xvf_x_chng\n");
		   fprintf(stderr, "   * xvf_y_chng\n");
		   fprintf(stderr, "   * xvf_width_chng\n");
		   fprintf(stderr, "   * xvf_height_chng\n");
		   return(false);
		   break;

      } /* end switch (change_code) */

      xvf_deparse_subform_action_line(&line_info, database, index);
      return(true);
}



/************************************************************
*
*  Routine Name: xvf_change_master_action_line
*
*      Purpose:  Changes a MasterAction line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of line to be changed
*		 change_code - desired change to line. May be:
*				1) xvf_activation_chng
*				2) xvf_title_chng 
*				3) xvf_width_chng
*				4) xvf_height_chng
*				5) xvf_x_chng
*				6) xvf_y_chng
*		 string - string to be changed
*       Output:  none
*    Called By:  xvf_change_input()
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_master_action_line(form, database, index, 
			  	   change_code, string)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
{
      xvf_sub_form  *subform;
      Line_Info      line_info;
      int            atoi(), width, height, x, y;
      double	     atof();

      xvf_clear_line_info(&line_info);
      xvf_parse_master_action_line(database[index], &line_info);

      x = line_info.x*xvf_font_width;
      y = line_info.y*(xvf_font_height + ((int)xvf_font_height/4));
      width = line_info.width*xvf_font_width;
      height = line_info.height*xvf_font_height;


      subform = xvf_subform_button_search(form, index);
      if (subform == NULL)
      {
          fprintf(stderr, "xvf_change_master_action_line:\n");
	  fprintf(stderr, "   WARNING: Couldn't find subform associated with %s", 
			   database[index]);
	  return(false);
      }
      switch (change_code) 
      {

	    case  xvf_activation_chng:
		  line_info.activate = atoi(string);
		  if (subform->button != NULL)
                      XtSetSensitive(subform->button, line_info.activate);
		  break;

	    case  xvf_title_chng:
	          if (string == NULL) line_info.title = NULL;
	          else line_info.title = xvf_strcpy(string);
		  if (subform->button != NULL)
	   	      xvf_change_title(subform->button, width, height,
				        2, string);
		  break;

	     case  xvf_width_chng:
	           if (string == NULL) 
			return(true);
	           line_info.width = atof(string);

		   if (subform->button != NULL)
		   {
		       width = line_info.width*xvf_font_width;
	   	       xvf_change_geometry(subform->button, x, y, 
				           width, height, 2);
		   }
		   break;

	     case  xvf_height_chng:
	           if (string == NULL) 
			return(true);
	           line_info.height = atof(string);

		   if (subform->button != NULL)
		   {
		       height = line_info.height*xvf_font_height;
	   	       xvf_change_geometry(subform->button, x, y, 
				           width, height, 2);
		   }
		   break;

	     case  xvf_x_chng:
	           if (string == NULL) 
			return(true);
	           line_info.x = atof(string);

		   if (subform->button != NULL)
		   {
      		       x = line_info.x*xvf_font_width;
	   	       xvf_change_geometry(subform->button, x, y, 
				           width, height, 2);
		   }
		   break;

	     case  xvf_y_chng:
	           if (string == NULL) 
			return(true);
	           line_info.y = atof(string);

		   if (subform->button != NULL)
	           {
                       y = line_info.y*(xvf_font_height + 
					((int)xvf_font_height/4));
	   	       xvf_change_geometry(subform->button, x, y, 
			    	           width, height, 2);
		   }
		   break;

	     default:
		   fprintf(stderr, "xvf_change_master_action_line:\n");
		   fprintf(stderr, "   WARNING: Illegal change code for MasterAction.\n");
		   fprintf(stderr, "            The only accepted change code for a ");
		   fprintf(stderr, "[-n] line is:\n");
		   fprintf(stderr, "   * xvf_activation_chng\n");
		   fprintf(stderr, "   * xvf_title_chng\n");
		   fprintf(stderr, "   * xvf_x_chng\n");
		   fprintf(stderr, "   * xvf_y_chng\n");
		   fprintf(stderr, "   * xvf_width_chng\n");
		   fprintf(stderr, "   * xvf_height_chng\n");
		   return(false);
		   break;

      } /* end switch (change_code) */

      xvf_deparse_master_action_line(&line_info, database, index);
      return(true);
}



/************************************************************
*
*  Routine Name: xvf_change_pane_action_line
*
*      Purpose:  Changes a PaneAction line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of line to be changed
*		 change_code - desired change to line. May be:
*				1) xvf_activation_chng
*				2) xvf_title_chng 
*				3) xvf_width_chng
*				4) xvf_height_chng
*				5) xvf_x_chng
*				6) xvf_y_chng
*		 string - string to be changed
*       Output:  none
*    Called By:  xvf_change_input()
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_pane_action_line(form, database, index, 
			  	   change_code, string)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
{
      xvf_selection  *selection;
      Line_Info      line_info;
      int            atoi(), width, height, x, y;
      double	     atof();

      xvf_clear_line_info(&line_info);
      xvf_parse_pane_action_line(database[index], &line_info);

      x = line_info.x*xvf_font_width;
      y = line_info.y*(xvf_font_height + ((int)xvf_font_height/2));
      width = line_info.width*xvf_font_width;
      height = line_info.height*xvf_font_height;

      selection = xvf_sel_search(form, index);
      if (selection == NULL)
      {
          fprintf(stderr, "xvf_change_pane_action_line:\n");
	  fprintf(stderr, "   WARNING: Couldn't find selection associated with %s", 
			   database[index]);
	  return(false);
      }
      switch (change_code) 
      {

	    case  xvf_activation_chng:
		  line_info.activate = atoi(string);
		  if (selection->value_widget != NULL)
                      XtSetSensitive(selection->value_widget, line_info.activate);
		  break;

	    case  xvf_title_chng:
	          if (string == NULL) line_info.title = NULL;
	          else line_info.title = xvf_strcpy(string);
		  if (selection->value_widget != NULL)
	   	      xvf_change_title(selection->value_widget, width, height,
				        2, string);
		  break;

	     case  xvf_width_chng:
	           if (string == NULL) 
			return(true);
	           line_info.width = atof(string);

		   if (selection->value_widget != NULL)
		   {
		       width = line_info.width*xvf_font_width;
	   	       xvf_change_geometry(selection->value_widget, x, y, 
				           width, height, 2);
		   }
		   break;

	     case  xvf_height_chng:
	           if (string == NULL) 
			return(true);
	           line_info.height = atof(string);

		   if (selection->value_widget != NULL)
		   {
		       height = line_info.height*xvf_font_height;
	   	       xvf_change_geometry(selection->value_widget, x, y, 
				           width, height, 2);
		   }
		   break;

	     case  xvf_x_chng:
	           if (string == NULL) 
			return(true);
	           line_info.x = atof(string);

		   if (selection->value_widget != NULL)
		   {
      		       x = line_info.x*xvf_font_width;
	   	       xvf_change_geometry(selection->value_widget, x, y, 
				           width, height, 2);
		   } 
		   break;

	     case  xvf_y_chng:
	           if (string == NULL) 
			return(true);
	           line_info.y = atof(string);

		   if (selection->value_widget != NULL)
		   {
                       y = line_info.y*(xvf_font_height + 
					((int)xvf_font_height/2));
	   	       xvf_change_geometry(selection->value_widget, x, y, 
				           width, height, 2);
		   }
		   break;

	     default:
		   fprintf(stderr, "xvf_change_pane_action_line:\n");
		   fprintf(stderr, "   WARNING: Illegal change code for PaneAction line.\n");
		   fprintf(stderr, "            The only accepted change code for a ");
		   fprintf(stderr, "[-a] line is:\n");
		   fprintf(stderr, "   * xvf_activation_chng\n");
		   fprintf(stderr, "   * xvf_title_chng\n");
		   fprintf(stderr, "   * xvf_x_chng\n");
		   fprintf(stderr, "   * xvf_y_chng\n");
		   fprintf(stderr, "   * xvf_width_chng\n");
		   fprintf(stderr, "   * xvf_height_chng\n");
		   return(false);
		   break;

      } /* end switch (change_code) */

      xvf_deparse_pane_action_line(&line_info, database, index);
      return(true);
}


/************************************************************
*
*  Routine Name: xvf_change_help_line
*
*      Purpose:  Changes a Help line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of line to be changed
*		 change_code - desired change to line. May be:
*				1) xvf_activation_chng
*				2) xvf_title_chng 
*				3) xvf_width_chng
*				4) xvf_height_chng
*				5) xvf_x_chng
*				6) xvf_y_chng
*		 string - string to be changed
*       Output:  none
*    Called By:  xvf_change_input()
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_help_line(form, database, index, 
		 	 change_code, string)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
{
      xvf_selection    *selection;
      xvf_guide_button *guide;
      xvf_sub_form     *subform;
      Line_Info      line_info;
      int            atoi(), width, height, x, y, type;
      double	     atof();

      xvf_clear_line_info(&line_info);
      xvf_parse_help_line(database[index], &line_info);

      x = line_info.x*xvf_font_width;
      y = line_info.y*(xvf_font_height + ((int)xvf_font_height/4));
      width = line_info.width*xvf_font_width;
      height = line_info.height*xvf_font_height;

      selection = xvf_sel_search(form, index);
      if (selection == NULL)
      {
	   guide = xvf_guide_search(form, index);
	   if (guide == NULL)
	   {
		subform = xvf_subform_button_search(form, index);
	        if (subform == NULL)
		{
                     fprintf(stderr, "xvf_change_help_line:\n");
	             fprintf(stderr, "   WARNING: Couldn't find selection associated with %s", 
		           	   database[index]);
	             return(false);

		}
		else type = 1;
	   }
	   else type = 2;
      }
      else
         type = 3;

      if (type == 3) 
	 y = line_info.y*(xvf_font_height + ((int)xvf_font_height/2));

      switch (change_code) 
      {

	    case  xvf_activation_chng:
		  line_info.activate = atoi(string);
                  XtSetSensitive(selection->value_widget, line_info.activate);
		  break;

	    case  xvf_title_chng:
	          if (string == NULL) line_info.title = NULL;
	          else line_info.title = xvf_strcpy(string);
		  if ((type == 3) && (selection->value_widget != NULL))
	   	        xvf_change_title(selection->value_widget, width, height,
				    2, string);
		  else if ((type == 2) && (guide->button != NULL))
	   	        xvf_change_title(guide->button, width, height,
				    2, string);
		  else if ((type == 1) && (subform->button != NULL))
	   	        xvf_change_title(subform->button, width, height,
				    2, string);
		  break;

	     case  xvf_width_chng:
	           if (string == NULL) 
			return(true);
	           line_info.width = atof(string);

		   width = line_info.width*xvf_font_width;
		   if ((type == 3) && (selection->value_widget != NULL))
	   	        xvf_change_geometry(selection->value_widget, x, y, 
				             width, height, 2);
		   else if ((type == 2) && (guide->button != NULL))
			xvf_change_geometry(guide->button, x, y, 
					     width, height, 2);
		   else if ((type == 1) && (subform->button != NULL))
			xvf_change_geometry(subform->button, x, y, 

					      width, height, 2);
		   break;

	     case  xvf_height_chng:
	           if (string == NULL) 
			return(true);
	           line_info.height = atof(string);

		   height = line_info.height*xvf_font_height;
		   if ((type == 3) && (selection->value_widget != NULL))
	   	        xvf_change_geometry(selection->value_widget, x, y, 
				             width, height, 2);
		   else if ((type == 2) && (guide->button != NULL))
			xvf_change_geometry(guide->button, x, y, 
					     width, height, 2);
		   else if ((type == 1) && (subform->button != NULL))
			xvf_change_geometry(subform->button, x, y, 
					      width, height, 2);
		   break;

	     case  xvf_x_chng:
	           if (string == NULL) 
			return(true);
	           line_info.x = atof(string);

      		   x = line_info.x*xvf_font_width;
		   if ((type == 3) && (selection->value_widget != NULL))
	   	        xvf_change_geometry(selection->value_widget, x, y, 
				             width, height, 2);
		   else if ((type == 2) && (guide->button != NULL))
			xvf_change_geometry(guide->button, x, y, 
					     width, height, 2);
		   else if ((type == 1)  && (subform->button != NULL))
			xvf_change_geometry(subform->button, x, y, 
					      width, height, 2);
		   break;

	     case  xvf_y_chng:
	           if (string == NULL) 
			return(true);
	           line_info.y = atof(string);

		   if (type == 3)
	                y = line_info.y*(xvf_font_height + 
			    ((int)xvf_font_height/2));
		   else
	                y = line_info.y*(xvf_font_height + 
			    ((int)xvf_font_height/4));

		   if ((type == 3) && (selection->value_widget != NULL))
	   	        xvf_change_geometry(selection->value_widget, x, y, 
				             width, height, 2);
		   else if ((type == 2) && (guide->button != NULL))
			xvf_change_geometry(guide->button, x, y, 
					     width, height, 2);
		   else if ((type == 1) && (subform->button != NULL))
		   {
                        y = line_info.y*(xvf_font_height + 
					 ((int)xvf_font_height/2));
			xvf_change_geometry(subform->button, x, y, 
					      width, height, 2);
		   }
		   break;

	     default:
		   fprintf(stderr, "xvf_change_help_line:\n");
		   fprintf(stderr, "   WARNING: Illegal change code for HelpSel line.\n");
		   fprintf(stderr, "            The only accepted change code for a ");
		   fprintf(stderr, "[-H] line is:\n");
		   fprintf(stderr, "   * xvf_activation_chng\n");
		   fprintf(stderr, "   * xvf_title_chng\n");
		   fprintf(stderr, "   * xvf_x_chng\n");
		   fprintf(stderr, "   * xvf_y_chng\n");
		   fprintf(stderr, "   * xvf_width_chng\n");
		   fprintf(stderr, "   * xvf_height_chng\n");
		   return(false);
		   break;

      } /* end switch (change_code) */

      xvf_deparse_help_line(&line_info, database, index);
      return(true);
}


/************************************************************
*
*  Routine Name: xvf_change_quit_line
*
*      Purpose:  Changes a Quit line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of line to be changed
*		 change_code - desired change to line. May be:
*				1) xvf_activation_chng
*				2) xvf_title_chng 
*				3) xvf_width_chng
*				4) xvf_height_chng
*				5) xvf_x_chng
*				6) xvf_y_chng
*		 string - string to be changed
*       Output:  none
*    Called By:  xvf_change_input()
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_quit_line(form, database, index, 
		 	 change_code, string)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
{
      xvf_selection    *selection;
      xvf_guide_button *guide;
      xvf_sub_form     *subform;
      Line_Info      line_info;
      int            atoi(), width, height, x, y, type;
      double	     atof();

      xvf_clear_line_info(&line_info);
      xvf_parse_quit_line(database[index], &line_info);

      x = line_info.x*xvf_font_width;
      y = line_info.y*(xvf_font_height + ((int)xvf_font_height/4));
      width = line_info.width*xvf_font_width;
      height = line_info.height*xvf_font_height;

      selection = xvf_sel_search(form, index);
      if (selection == NULL)
      {
	   guide = xvf_guide_search(form, index);
	   if (guide == NULL)
	   {
		subform = xvf_subform_button_search(form, index);
	        if (subform == NULL)
		{
                     fprintf(stderr, "xvf_change_quit_line:\n");
	             fprintf(stderr, "   WARNING: Couldn't find selection associated with %s", 
		           	   database[index]);
	             return(false);

		}
		else type = 1;
	   }
	   else type = 2;
      }
      else
         type = 3;

      if (type == 3) 
	 y = line_info.y*(xvf_font_height + ((int)xvf_font_height/2));

      switch (change_code) 
      {

	    case  xvf_activation_chng:
		  line_info.activate = atoi(string);
                  XtSetSensitive(selection->value_widget, line_info.activate);
		  break;

	    case  xvf_title_chng:
	          if (string == NULL) line_info.title = NULL;
	          else line_info.title = xvf_strcpy(string);
		  if ((type == 3) && (selection->value_widget != NULL))
	   	      xvf_change_title(selection->value_widget, width, height,
				    2, string);
		  else if ((type == 2) && (guide->button != NULL))
	   	      xvf_change_title(guide->button, width, height,
				    2, string);
		  else if ((type == 1) && (subform->button != NULL))
	   	      xvf_change_title(subform->button, width, height,
				    2, string);
		  break;

	     case  xvf_width_chng:
	           if (string == NULL) 
			return(true);
	           line_info.width = atof(string);

		   width = line_info.width*xvf_font_width;
		   if ((type == 3) && (selection->value_widget != NULL))
	   	        xvf_change_geometry(selection->value_widget, x, y, 
				             width, height, 2);
		   else if ((type == 2) && (guide->button != NULL))
			xvf_change_geometry(guide->button, x, y, 
					     width, height, 2);
		   else if ((type == 1) && (subform->button != NULL))
			xvf_change_geometry(subform->button, x, y, 
					      width, height, 2);
		   break;

	     case  xvf_height_chng:
	           if (string == NULL) 
			return(true);
	           line_info.height = atof(string);

		   height = line_info.height*xvf_font_height;
		   if ((type == 3) && (selection->value_widget != NULL))
	   	        xvf_change_geometry(selection->value_widget, x, y, 
				             width, height, 2);
		   else if ((type == 2)  && (guide->button != NULL))
			xvf_change_geometry(guide->button, x, y, 
					     width, height, 2);
		   else if ((type == 1) && (subform->button != NULL))
			xvf_change_geometry(subform->button, x, y, 
					      width, height, 2);
		   break;

	     case  xvf_x_chng:
	           if (string == NULL) 
			return(true);
	           line_info.x = atof(string);
      		   x = line_info.x*xvf_font_width;

		   if ((type == 3) && (selection->value_widget != NULL))
	   	        xvf_change_geometry(selection->value_widget, x, y, 
				             width, height, 2);
		   else if ((type == 2) && (guide->button != NULL))
			xvf_change_geometry(guide->button, x, y, 
					     width, height, 2);
		   else if ((type == 1) && (subform->button != NULL))
			xvf_change_geometry(subform->button, x, y, 
					      width, height, 2);
		   break;

	     case  xvf_y_chng:
	           if (string == NULL) 
			return(true);
	           line_info.y = atof(string);
		   if (type == 3)
	                y = line_info.y*(xvf_font_height + 
			    ((int)xvf_font_height/2));
		   else
	                y = line_info.y*(xvf_font_height + 
			    ((int)xvf_font_height/4));

		   if ((type == 3) && (selection->value_widget != NULL))
	   	        xvf_change_geometry(selection->value_widget, x, y, 
				             width, height, 2);
		   else if ((type == 2) && (guide->button != NULL))
			xvf_change_geometry(guide->button, x, y, 
					     width, height, 2);
		   else if ((type == 1) && (subform->button != NULL))
		   {
	                y = line_info.y*(xvf_font_height + 
					((int)xvf_font_height/2));
			xvf_change_geometry(subform->button, x, y, 
					      width, height, 2);
		   }
		   break;

	     default:
		   fprintf(stderr, "xvf_change_quit_line:\n");
		   fprintf(stderr, "   WARNING: Illegal change code for QuitForm line.\n");
		   fprintf(stderr, "            The only accepted change code for a ");
		   fprintf(stderr, "[-Q] line is:\n");
		   fprintf(stderr, "   * xvf_activation_chng\n");
		   fprintf(stderr, "   * xvf_title_chng\n");
		   fprintf(stderr, "   * xvf_x_chng\n");
		   fprintf(stderr, "   * xvf_y_chng\n");
		   fprintf(stderr, "   * xvf_width_chng\n");
		   fprintf(stderr, "   * xvf_height_chng\n");
		   return(false);
		   break;

      } /* end switch (change_code) */

      xvf_deparse_quit_line(&line_info, database, index);
      return(true);
}


/************************************************************
*
*  Routine Name: xvf_change_workspace_line
*
*      Purpose:  Changes a WorkWidget line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 index	  - index of line to be changed
*		 change_code - desired change to line. May be:
*				1) xvf_title_chng 
*				2) xvf_width_chng
*				3) xvf_height_chng
*		 string - string to be changed
*		 max_strlen - max length of string
*       Output:  none
*    Called By:  xvf_change_input()
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_workspace_line(form, database, index, 
		 	 change_code, string)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
{
      xvf_selection    *selection;
      xvf_guide_button *guide;
      xvf_sub_form     *subform;
      Line_Info      line_info;
      int            width, height, x, y, type;
      double	     atof();

      xvf_clear_line_info(&line_info);
      xvf_parse_workspace_line(database[index], &line_info);

      width = line_info.width;
      height = line_info.height;
      x = 0;
      y = 0;

      selection = xvf_sel_search(form, index);
      if (selection == NULL)
      {
	   guide = xvf_guide_search(form, index);
	   if (guide == NULL)
	   {
		subform = xvf_subform_button_search(form, index);
	        if (subform == NULL)
		{
                     fprintf(stderr, "xvf_change_workspace_line:\n");
	             fprintf(stderr, "  WARNING: Couldn't find selection associated with %s", 
		           	   database[index]);
	             return(false);

		}
		else type = 1;  /* workspace on a subform */
	   }
	   else type = 2; /* workspace on a guide */
      }
      else
         type = 3; /* workspace on a pane */

      switch (change_code) 
      {
	     case  xvf_title_chng:

	   	   if (string == NULL) line_info.title = NULL;
	   	   else line_info.title = xvf_strcpy(string);

		   if ((type == 3) && (selection->label_widget != NULL))
		   {
			if (selection->label_widget != NULL)
	   		   xvf_change_title(selection->label_widget, 
					     0, 0, 0, string);
			else
		        {
                           fprintf(stderr, "xvf_change_workspace_line:\n");
			   fprintf(stderr, "  WARNING: Cannot change workspace label ");
			   fprintf(stderr, "when the workspace was\n");
			   fprintf(stderr, "           originally created without one.\n");
		        }
		   }
		   else if ((type == 2) && (guide->label != NULL))
		   {
			if (guide->label != NULL)
	   		    xvf_change_title(guide->label, 
					      0, 0, 0, string);
			else
		        {
                           fprintf(stderr, "xvf_change_workspace_line:\n");
			   fprintf(stderr, "   WARNING: Cannot change workspace label ");
			   fprintf(stderr, "when the workspace was\n");
			   fprintf(stderr, "            originally created without one.\n");
		        }

		   }
		   else if ((type == 1) && (subform->label != NULL))
		   {
			if (subform->label != NULL)
	   		    xvf_change_title(subform->label, 
					      0, 0, 0, string);
			else
		        {
                           fprintf(stderr, "xvf_change_workspace_line:\n");
			   fprintf(stderr, "   WARNING: Cannot change workspace label ");
			   fprintf(stderr, "when the workspace was\n");
			   fprintf(stderr, "            originally created without one.\n");
		        }
		   }
		   break;

	     case  xvf_width_chng:
	           if (string == NULL) 
			return(true);
	           line_info.width = atof(string);

		   width = line_info.width;
		   if ((type == 3) && (selection->value_widget != NULL))
	   	        xvf_change_geometry(selection->value_widget, x, y, 
				             width, height, 2);
		   else if ((type == 2) && (guide->button != NULL))
			xvf_change_geometry(guide->button, x, y, 
					     width, height, 2);
		   else if ((type == 1) && (subform->button != NULL))
			xvf_change_geometry(subform->button, x, y, 
					      width, height, 2);
		   break;

	     case  xvf_height_chng:
	           if (string == NULL) 
			return(true);
	           line_info.height = atof(string);

		   height = line_info.height;
		   if ((type == 3) && (selection->value_widget != NULL))
	   	        xvf_change_geometry(selection->value_widget, x, y, 
				             width, height, 2);
		   else if ((type == 2) && (guide->button != NULL))
			xvf_change_geometry(guide->button, x, y, 
					     width, height, 2);
		   else if ((type == 1) && (subform->button != NULL))
			xvf_change_geometry(subform->button, x, y, 
					      width, height, 2);
		   break;

	     default:
		   fprintf(stderr, "xvf_change_workspace_line:\n");
		   fprintf(stderr, "   WARNING: Illegal change code for Workspace line.\n");
		   fprintf(stderr, "            The only accepted change code for a ");
		   fprintf(stderr, "[-w] line is:\n");
		   fprintf(stderr, "   * xvf_title_chng\n");
		   fprintf(stderr, "   * xvf_width_chng\n");
		   fprintf(stderr, "   * xvf_height_chng\n");
		   return(false);
		   break;

      } /* end switch (change_code) */

      xvf_deparse_workspace_line(&line_info, database, index);
      return(true);
}
/************************************************************
*
*  Routine Name: xvf_change_routine_line
*
*      Purpose:  Changes a Routine line according the change_code.
*        Input:  form - pointer to the form tree
*		 database - pointer to the database
*		 change_code - desired change to line. May be:
*				1) xvf_activation_chng
*				2) xvf_title_chng 
*				3) xvf_width_chng
*				4) xvf_height_chng
*				5) xvf_x_chng
*				6) xvf_y_chng
*		 index	  - index of line to be changed
*		 string - string to be changed
*		 max_strlen - max length of string
*       Output:  none
*    Called By:  xvf_change_input()
*   Written By:  Danielle Argiro
*
**************************************************************/


int xvf_change_routine_line(form, database, index, 
			    change_code, string)
xvf_form *form;
char *database[];
int  index;
int  change_code;
char *string;
{
      xvf_selection  *selection;
      Line_Info      line_info;
      int            atoi(), width, height, x, y;
      double	     atof();

      xvf_clear_line_info(&line_info);
      xvf_parse_routine_line(database[index], &line_info);

      x = line_info.x*xvf_font_width;
      y = line_info.y*(xvf_font_height + ((int)xvf_font_height/2));
      width = line_info.width*xvf_font_width;
      height = line_info.height*xvf_font_height;

      selection = xvf_sel_search(form, index);
      if (selection == NULL)
      {
          fprintf(stderr, "xvf_change_routine_line:\n");
	  fprintf(stderr, "   WARNING: Couldn't find selection associated with %s", 
			   database[index]);
	  return(false);
      }
      switch (change_code) 
      {

	    case  xvf_activation_chng:
		  line_info.activate = atoi(string);
		  if (selection->value_widget != NULL)
                      XtSetSensitive(selection->value_widget, line_info.activate);
		  break;

	    case  xvf_title_chng:
	          if (string == NULL) line_info.title = NULL;
	          else line_info.title = xvf_strcpy(string);
		  if (selection->value_widget != NULL)
	   	      xvf_change_title(selection->value_widget, width, height,
				        2, string);
		  break;

	     case  xvf_width_chng:
	           if (string == NULL) 
			return(true);
	           line_info.width = atoi(string);

		   if (selection->value_widget != NULL)
		   {
		       width = line_info.width*xvf_font_width;
	   	       xvf_change_geometry(selection->value_widget, x, y, 
				           width, height, 2);
		   }
		   break;

	     case  xvf_height_chng:
	           if (string == NULL) 
			return(true);
	           line_info.height = atof(string);

		   if (selection->value_widget != NULL)
		   {
		       height = line_info.height*xvf_font_height;
	   	       xvf_change_geometry(selection->value_widget, x, y, 
				           width, height, 2);
		   }
		   break;

	     case  xvf_x_chng:
	           if (string == NULL) 
			return(true);
	           line_info.x = atof(string);

		   if (selection->value_widget != NULL)
		   {
      		       x = line_info.x*xvf_font_width;
	   	       xvf_change_geometry(selection->value_widget, x, y, 
				           width, height, 2);
		   }
		   break;

	     case  xvf_y_chng:
	           if (string == NULL) 
			return(true);
	           line_info.y = atof(string);

		   if (selection->value_widget != NULL)
		   {
                       y = line_info.y*(xvf_font_height + ((int)xvf_font_height/2));
	   	       xvf_change_geometry(selection->value_widget, x, y, 
				           width, height, 2);
		   }
		   break;

	     default:
		   fprintf(stderr, "xvf_change_routine_line:\n");
		   fprintf(stderr, "   WARNING: Illegal change code for Routine line.\n");
		   fprintf(stderr, "            The only accepted change code for a ");
		   fprintf(stderr, "[-R] line is:\n");
		   fprintf(stderr, "   * xvf_activation_chng\n");
		   fprintf(stderr, "   * xvf_title_chng\n");
		   fprintf(stderr, "   * xvf_x_chng\n");
		   fprintf(stderr, "   * xvf_y_chng\n");
		   fprintf(stderr, "   * xvf_width_chng\n");
		   fprintf(stderr, "   * xvf_height_chng\n");
		   return(false);
		   break;

      } /* end switch (change_code) */

      xvf_deparse_routine_line(&line_info, database, index);
      return(true);
}

/************************************************************
*
*  Routine Name: xvf_change_title
*
*      Purpose:  Called by xvf_change_xxx_line() to change the
*		 title on a widget
*
*        Input:  widget - widget to be changed
*		 width  - width of widget in characters
*		 height - height of widget in characters
*		 border_width - border width of widget in pixels
*		 new_title - new title for widget
*       Output:  none
*    Called By:  xvf_change_xxx_line()
*   Written By:  Danielle Argiro
*
**************************************************************/

xvf_change_title(widget, width, height, border_width, new_title)
Widget widget;
int    width, height, border_width;
char   *new_title;
{
	int n;
	Arg arg[MaxArgs];

	if (width == 0)  width = xvf_strlen(new_title)*xvf_font_width;
	if (height == 0) height = xvf_font_height;

	n = 0;
	if (new_title != NULL)
	{
	   XtSetArg(arg[n], XtNlabel, new_title);	n++;
	}
	else
	{
	   XtSetArg(arg[n],XtNlabel," "); 		n++;
	   width = 1;
	}
	XtSetArg(arg[n],XtNwidth,width); 		n++;
	XtSetArg(arg[n],XtNheight,height); 		n++;
	XtSetValues(widget,arg,n);
}


/************************************************************
*
*  Routine Name: xvf_change_geometry
*
*      Purpose:  Called by xvf_change_xxx_line to change the
*		 geometry of an item
*
*        Input:  widget - widget to be changed
*		 width  - width of widget in characters
*		 height - height of widget in characters
*		 border_width - border width of widget in pixels
*       Output:  none
*    Called By:  xvf_change_input
*   Written By:  Danielle Argiro
*
**************************************************************/

xvf_change_geometry(widget, x, y, width, height, border_width)
Widget widget;
int    x, y, width, height, border_width;
{
	int n;
	Arg arg[MaxArgs];

	if (width == 0)
	{
	    fprintf(stderr, "xvf_change_geometry\n:");
	    fprintf(stderr, "   ERROR: can't change geometry to 0 width\n");
	    return;
	}
	if (height == 0)
	{
	    fprintf(stderr, "xvf_change_geometry\n:");
	    fprintf(stderr, "   ERROR: can't change geometry to 0 height\n");
	    return;
	}

	n = 0;
	XtSetArg(arg[n],XtNwidth,width); 	n++;
	XtSetArg(arg[n],XtNheight,height); 	n++;
	XtSetArg(arg[n],XtNx,(Position) x); 	n++;
	XtSetArg(arg[n],XtNy,(Position) y);	n++;
	XtSetArg(arg[n],XtNhorizDistance,x);	n++;
	XtSetArg(arg[n],XtNvertDistance, y);	n++;
	XtSetValues(widget,arg,n);

	XtConfigureWidget(widget, x, y, width, height, border_width);   
}
