 /*
  * Khoros: $Id: vthresh.h,v 1.1 1991/05/10 15:51:13 khoros Exp $
  */

 /*
  * $Log: vthresh.h,v $
 * Revision 1.1  1991/05/10  15:51:13  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vthresh.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Thu Mar 28 00:11:42 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vthresh_h_
#define _vthresh_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vthresh Argument Structure
*
****************************************************************/

typedef struct _vthresh  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  output image (Required outfile)
 */
char	*o_file;	/* output image FILENAME */
int	 o_flag;	/* output image FLAG */

/*
 *  lower threshold value (Optional float)
 */
float	 l_float;	/* lower threshold value FLOAT */
int	 l_flag;   	/* lower threshold value FLAG */

/*
 *  upper threshold value (Optional float)
 */
float	 u_float;	/* upper threshold value FLOAT */
int	 u_flag;   	/* upper threshold value FLAG */

/*
 *  specifies the non-zero pixel output value (Optional float)
 */
float	 v_float;	/* specifies the non-zero pixel output value FLOAT */
int	 v_flag;   	/* specifies the non-zero pixel output value FLAG */

}  vthresh_struct;

vthresh_struct *vthresh;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define CHECKINPUT(program,image) \
        proper_num_images(program,image,1,TRUE); \
        proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE);
/* -include_macros_end */

#endif
