 /*
  * Khoros: $Id: vmarr.c,v 1.2 1991/12/18 09:38:00 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vmarr.c,v 1.2 1991/12/18 09:38:00 dkhoros Exp $";
#endif

 /*
  * $Log: vmarr.c,v $
 * Revision 1.2  1991/12/18  09:38:00  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vmarr.c
 >>>>
 >>>>      Program Name: vmarr
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Create a Marr type edge detection filter kernel.
 >>>>	
 >>>>	

 >>>>            Author: Richard Krukar, John Rasure, Robert Estes
 >>>>
 >>>> Date Last Updated: Tue Dec 10 15:35:20 1991
 >>>>
 >>>>          Routines: main- the main program for vmarr
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vmarr.h"


/****************************************************************
 *
 * Routine Name:  main program for vmarr
 *
 *       Input:  
 *       -o  Marr kernel output image 
 *
 *
 *       [-trigger] trigger input
 *       [-r] specify the number of rows in the kernel  (value > 0)
 *       [-c] specify the number of columns in the kernel  (value > 0)
 *       [-v] variance of the Gaussian  (value > 0.0)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *image;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);
/* -main_before_lib_call_end */

/* -main_library_call */
/* Call the procedure that does the work */

    if (! lvmarr( &image, vmarr->r_int, vmarr->c_int, vmarr->v_float))
    {
        (void) fprintf(stderr, "lvmarr Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    (void) writeimage(vmarr->o_file,image);
    exit(0);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vmarr 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vmarr :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCreate a Marr type edge detection filter kernel.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-o  Marr kernel output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-trigger]  trigger input (infile) [null]\n");
	fprintf(stderr,"\t[-r]  specify the number of rows in the kernel (integer, > 0) [3]\n");
	fprintf(stderr,"\t[-c]  specify the number of columns in the kernel (integer, > 0) [3]\n");
	fprintf(stderr,"\t[-v]  variance of the Gaussian (float, > 0.0) [1]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vmarr\n");
	fprintf(stderr, "\t[-U] Gives the usage for vmarr\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vmarr.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vmarr.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vmarr
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) Marr kernel output image \n        {outfile}: "; 
char	*trigger_pstr = 
	"\nEnter: (trigger) trigger input \n        {infile}: "; 
char	*r_pstr = 
	"\nEnter: (r) specify the number of rows in the kernel \n        {integer, > 0 [3] }: "; 
char	*c_pstr = 
	"\nEnter: (c) specify the number of columns in the kernel \n        {integer, > 0 [3] }: "; 
char	*v_pstr = 
	"\nEnter: (v) variance of the Gaussian \n        {float, > 0.0 [1.000000] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vmarr", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vmarr.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vmarr: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vmarr.ans");
		}

	     }

	}

	/*
	 * allocate the vmarr structure
	 */
	vmarr = (vmarr_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vmarr_struct));

	/*
	 * get required arguments for vmarr
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vmarr->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vmarr->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmarr->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vmarr->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vmarr->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vmarr
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vmarr->trigger_flag = vget_infile(fid, prompt_flag,
	"-trigger", trigger_pstr, &(vmarr->trigger_file))
;

	vmarr->r_flag = vget_int(fid, prompt_flag,
	"-r", r_pstr, &(vmarr->r_int),
	3, 2, 2);

	vmarr->c_flag = vget_int(fid, prompt_flag,
	"-c", c_pstr, &(vmarr->c_int),
	3, 2, 2);

	vmarr->v_flag = vget_float(fid, prompt_flag,
	"-v", v_pstr, &(vmarr->v_float),
	1.000000, 2.000000, 2.000000);


}



