 /*
  * Khoros: $Id: vggauss.c,v 1.2 1991/12/18 09:37:34 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vggauss.c,v 1.2 1991/12/18 09:37:34 dkhoros Exp $";
#endif

 /*
  * $Log: vggauss.c,v $
 * Revision 1.2  1991/12/18  09:37:34  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vggauss.c
 >>>>
 >>>>      Program Name: vggauss
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Creates a Gaussian (noise) image.
 >>>>	
 >>>>	

 >>>>            Author: Ramiro Jordan, Jeremy Worley
 >>>>
 >>>> Date Last Updated: Tue Dec 10 15:19:55 1991
 >>>>
 >>>>          Routines: main- the main program for vggauss
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vggauss.h"


/****************************************************************
 *
 * Routine Name:  main program for vggauss
 *
 *       Input:  
 *         -o  resulting image 
 *
 *
 *         [-i] input file
 *         [-trigger] trigger input
 *         [-r] rows of image  (value > 0)
 *         [-c] columns of image  (value > 0)
 *         [-b] # bands in image  (value > 0)
 *         [-m] noise mean value  (value >= 0.0)
 *         [-v] noise variance  (value >= 0.0)
 *         [-t] lets user choose data type of image
 *		'float' (select data type),
 *		 or 'complex' (byte data type)
 *		   [default = float] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *readimage();
int type;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if(check_args())exit(1);
if(!vget_type(&type,vggauss->t_toggle)){
   fprintf(stderr,"vggauss:  Invalid data type.\n");
   exit(1);
}

if(vggauss->i_flag){
  READIMAGE(image);
  CHECKTYPE(program,image);
  CHECKINPUT(program,image);
}
/* -main_before_lib_call_end */

/* -main_library_call */
  if(!lvggauss(&image,vggauss->r_int,vggauss->c_int,vggauss->b_int,
             vggauss->m_float,vggauss->v_float,type,vggauss->i_flag)){
    (void)fprintf(stderr, "lvggauss Failed\n");
    exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vggauss->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vggauss 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vggauss :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCreates a Gaussian (noise) image.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
printf("\nThe -t option will accept the type in either of two forms:\n");
printf("  an alphabetic representation, i.e. 'float' or 'complex',\n");
printf("  or a numeric representation, such as 4 for real.\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-o  resulting image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-i]  input file (infile) [null]\n");
	fprintf(stderr,"\t[-trigger]  trigger input (infile) [null]\n");
	fprintf(stderr,"\t[-r]  rows of image (integer, > 0) [512]\n");
	fprintf(stderr,"\t[-c]  columns of image (integer, > 0) [512]\n");
	fprintf(stderr,"\t[-b]  # bands in image (integer, > 0) [1]\n");
	fprintf(stderr,"\t[-m]  noise mean value (float, >= 0.0) [0]\n");
	fprintf(stderr,"\t[-v]  noise variance (float, >= 0.0) [1]\n");
	fprintf(stderr, "\t[-t]  lets user choose data type of image\n");
	fprintf(stderr, "\t\t'float'  (select data type),\n");
	fprintf(stderr, "\t\t or 'complex'  (byte data type)\n");
	fprintf(stderr, "\t\t[default = float]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vggauss\n");
	fprintf(stderr, "\t[-U] Gives the usage for vggauss\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vggauss.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vggauss.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vggauss
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) resulting image \n        {outfile}: "; 
char	*i_pstr = 
	"\nEnter: (i) input file \n        {infile}: "; 
char	*trigger_pstr = 
	"\nEnter: (trigger) trigger input \n        {infile}: "; 
char	*r_pstr = 
	"\nEnter: (r) rows of image \n        {integer, > 0 [512] }: "; 
char	*c_pstr = 
	"\nEnter: (c) columns of image \n        {integer, > 0 [512] }: "; 
char	*b_pstr = 
	"\nEnter: (b) # bands in image \n        {integer, > 0 [1] }: "; 
char	*m_pstr = 
	"\nEnter: (m) noise mean value \n        {float, >= 0.0 [0.000000] }: "; 
char	*v_pstr = 
	"\nEnter: (v) noise variance \n        {float, >= 0.0 [1.000000] }: "; 
char	*t_pstr = "\nEnter: (t) lets user choose data type of image -- \n      \t\t'float' (select data type)\n\t\tor 'complex' (byte data type)\n  [float]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vggauss", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vggauss.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vggauss: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vggauss.ans");
		}

	     }

	}

	/*
	 * allocate the vggauss structure
	 */
	vggauss = (vggauss_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vggauss_struct));

	/*
	 * get required arguments for vggauss
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vggauss->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vggauss->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vggauss->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vggauss->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vggauss->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vggauss
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vggauss->i_flag = vget_infile(fid, prompt_flag,
	"-i", i_pstr, &(vggauss->i_file))
;

	vggauss->trigger_flag = vget_infile(fid, prompt_flag,
	"-trigger", trigger_pstr, &(vggauss->trigger_file))
;

	vggauss->r_flag = vget_int(fid, prompt_flag,
	"-r", r_pstr, &(vggauss->r_int),
	512, 2, 2);

	vggauss->c_flag = vget_int(fid, prompt_flag,
	"-c", c_pstr, &(vggauss->c_int),
	512, 2, 2);

	vggauss->b_flag = vget_int(fid, prompt_flag,
	"-b", b_pstr, &(vggauss->b_int),
	1, 2, 2);

	vggauss->m_flag = vget_float(fid, prompt_flag,
	"-m", m_pstr, &(vggauss->m_float),
	0.000000, 1.000000, 1.000000);

	vggauss->v_flag = vget_float(fid, prompt_flag,
	"-v", v_pstr, &(vggauss->v_float),
	1.000000, 1.000000, 1.000000);


	/*
	 * get optional toggles for vggauss
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		vggauss->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(vggauss->t_toggle),
		"float");

		if (((strcmp(vggauss->t_toggle, "float") == 0)) || 
		     ((strcmp(vggauss->t_toggle, "complex") == 0)))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		vggauss->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(vggauss->t_toggle),
		"float");

		if (((strcmp(vggauss->t_toggle, "float") != 0)) && 
		     ((strcmp(vggauss->t_toggle, "complex") != 0)))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



