 /*
  * Khoros: $Id: vgbox.c,v 1.4 1991/12/18 09:39:12 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vgbox.c,v 1.4 1991/12/18 09:39:12 dkhoros Exp $";
#endif

 /*
  * $Log: vgbox.c,v $
 * Revision 1.4  1991/12/18  09:39:12  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgbox.c
 >>>>
 >>>>      Program Name: vgbox
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	This program create a grey level file image.
 >>>>	 It makes a file filled  with  a  represention  of  a  plain
 >>>>	parallelogram projected on the CCD sensor.
 >>>>	  14 optionnal parameters can be defined.
 >>>>	
 >>>>	

 >>>>            Author: Jean-Pierre GUERIN  (CEA)
 >>>>
 >>>> Date Last Updated: Sat Dec 14 18:02:02 1991
 >>>>
 >>>>          Routines: main- the main program for vgbox
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vgbox.h"


/****************************************************************
 *
 * Routine Name:  main program for vgbox
 *
 *       Input:  
 *       -o  resulting output image 
 *
 *
 *       [-trigger] trigger input
 *       [-r] Number of Rows    (Height in pixels) of the CCD sensor  (value >= 0)
 *       [-c] Number of Columns (Width  in pixels) of the CCD sensor  (value >= 0)
 *       [-px_h] Active Pixel Height (vertical)    (0.000 < value < 1.000)
 *       [-px_w] Active Pixel Width (horizontal)   (0.000 < value < 1.000)
 *       [-px_y_off] Active Pixel offset from the top  of the cell  (0.000 < value < 1.000)
 *       [-px_x_off] Active Pixel offset from the left of the cell  (0.000 < value < 1.000)
 *       [-h] Height of the parallelogram (box) (in pixel unit)  (value >= 0.0)
 *       [-w] Width  of the parallelogram (box) (in pixel unit)  (value > 0.0)
 *       [-im_y_off] Downward offset of the box (0 is CCD center = box center) 
 *       [-im_x_off] Right    offset of the box (0 is CCD center = box center) 
 *       [-angle] Box rotation (clockwise, degrees) (center = box center) 
 *       [-corner_angl] the value of the 1st corner angle (degrees)  (0.000 < value < 179.999)
 *       [-g_o] Grey level of the background pixels outside of the box  (0 < value < 255)
 *       [-g_i] Grey level of the lighted pixels inside the box  (0 < value < 255)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *image,
                   *createimage();

    char           *dummy = '\0';

/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
/*PARSE_ARGS*/
if (check_args())
{
  fprintf(stderr, "%s: Illegal arguments on command line.\n",program);
  exit(1);
}

    image    = createimage(vgbox->r_int,
                           vgbox->c_int,
                           VFF_TYP_1_BYTE,
                           1,
                           1,
                           dummy,
                           0,
                           0,
                           VFF_MS_NONE,
                           VFF_MAPTYP_NONE,
                           VFF_LOC_IMPLICIT,
                           0);
    if (image == NULL)
    {
       (void) fprintf(stderr,"vgbox: Unable to allocate memory!\\n");
       exit(1);
    }
/* -main_before_lib_call_end */

/* -main_library_call */
    switch (lvgbox(
                 image->imagedata,
                 vgbox->c_int,          /* number of cols (x grid) */
                 vgbox->r_int,          /* number of rows (y grid) */
                 vgbox->px_w_float,     /* active area pixel width in the pixel_cell*/
                 vgbox->px_h_float,     /* active area pixel height in the pixel_cell */
                 vgbox->px_x_off_float, /* active pixel offset from left pixel_cel */
                 vgbox->px_y_off_float, /* active pixel offset from top pixel_cel */
                 vgbox->g_o_int,        /* grey level outside of parallelogram */
                 vgbox->g_i_int,        /* grey level inside of parallelogram */
                 vgbox->w_float,        /* parallelogram width (in pixel unit) */
                 vgbox->h_float,        /* parallelogram height (in pixel unit)  */
                 vgbox->im_x_off_float, /* parallelogram: x right offset
                                             origine: box center = sensor center */
                 vgbox->im_y_off_float, /* parallelogram: y downward offset
                                       origine: parallelogram center = sensor center */
                 vgbox->angle_float * XV_PI/180,   /* parallelogram rotation: (degres ==> radians),
                                       parallelogram center = rot. center) */
                 vgbox->corner_angl_float * XV_PI/180)) /* parallelogram corner_angle (degrees " ) */
     {
        case 0: break;                    /* ok       */
        case 1:                           /* warnings */
                (void) fprintf(stderr,
                               "lvgbox: Internal Warning, pixel area found > 1. \n");
                break;
        case 2:                           /* error */
                (void) fprintf(stderr,
                               "lvgbox: Pixel width+pixel offset must be <= 1\n");
                exit(1);
                break;
        default:                          /* unknown error */
                (void) fprintf(stderr,
                               "lvgbox: Not Registrated Error \n");
                exit(1);
                break;
      }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vgbox->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vgbox 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vgbox :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tThis program create a grey level file image.\n");
	fprintf(stderr, "\t It makes a file filled  with  a  represention  of  a  plain\n");
	fprintf(stderr, "\tparallelogram projected on the CCD sensor.\n");
	fprintf(stderr, "\t  14 optionnal parameters can be defined.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-trigger]  trigger input (infile) [null]\n");
	fprintf(stderr,"\t[-r]  Number of Rows    (Height in pixels) of the CCD sensor (integer, >= 0) [512]\n");
	fprintf(stderr,"\t[-c]  Number of Columns (Width  in pixels) of the CCD sensor (integer, >= 0) [512]\n");
	fprintf(stderr,"\t[-px_h]  Active Pixel Height (vertical)   (float,  0.000 to 1.000) [1]\n");
	fprintf(stderr,"\t[-px_w]  Active Pixel Width (horizontal)  (float,  0.000 to 1.000) [1]\n");
	fprintf(stderr,"\t[-px_y_off]  Active Pixel offset from the top  of the cell (float,  0.000 to 1.000) [0]\n");
	fprintf(stderr,"\t[-px_x_off]  Active Pixel offset from the left of the cell (float,  0.000 to 1.000) [0]\n");
	fprintf(stderr,"\t[-h]  Height of the parallelogram (box) (in pixel unit) (float, >= 0.0) [40.3]\n");
	fprintf(stderr,"\t[-w]  Width  of the parallelogram (box) (in pixel unit) (float, > 0.0) [20.6]\n");
	fprintf(stderr,"\t[-im_y_off]  Downward offset of the box (0 is CCD center = box center) (float) [0]\n");
	fprintf(stderr,"\t[-im_x_off]  Right    offset of the box (0 is CCD center = box center) (float) [0]\n");
	fprintf(stderr,"\t[-angle]  Box rotation (clockwise, degrees) (center = box center) (float) [15]\n");
	fprintf(stderr,"\t[-corner_angl]  the value of the 1st corner angle (degrees) (float,  0.000 to 179.999) [90]\n");
	fprintf(stderr,"\t[-g_o]  Grey level of the background pixels outside of the box (integer, 0 to 255) [10]\n");
	fprintf(stderr,"\t[-g_i]  Grey level of the lighted pixels inside the box (integer, 0 to 255) [200]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vgbox\n");
	fprintf(stderr, "\t[-U] Gives the usage for vgbox\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vgbox.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vgbox.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vgbox
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*trigger_pstr = 
	"\nEnter: (trigger) trigger input \n        {infile}: "; 
char	*r_pstr = 
	"\nEnter: (r) Number of Rows    (Height in pixels) of the CCD sensor \n        {integer, >= 0 [512] }: "; 
char	*c_pstr = 
	"\nEnter: (c) Number of Columns (Width  in pixels) of the CCD sensor \n        {integer, >= 0 [512] }: "; 
char	*px_h_pstr = 
	"\nEnter: (px_h) Active Pixel Height (vertical)   \n        {float,  0.000 to 1.000 [1.000000] }: "; 
char	*px_w_pstr = 
	"\nEnter: (px_w) Active Pixel Width (horizontal)  \n        {float,  0.000 to 1.000 [1.000000] }: "; 
char	*px_y_off_pstr = 
	"\nEnter: (px_y_off) Active Pixel offset from the top  of the cell \n        {float,  0.000 to 1.000 [0.000000] }: "; 
char	*px_x_off_pstr = 
	"\nEnter: (px_x_off) Active Pixel offset from the left of the cell \n        {float,  0.000 to 1.000 [0.000000] }: "; 
char	*h_pstr = 
	"\nEnter: (h) Height of the parallelogram (box) (in pixel unit) \n        {float, >= 0.0 [40.299999] }: "; 
char	*w_pstr = 
	"\nEnter: (w) Width  of the parallelogram (box) (in pixel unit) \n        {float, > 0.0 [20.600000] }: "; 
char	*im_y_off_pstr = 
	"\nEnter: (im_y_off) Downward offset of the box (0 is CCD center = box center) \n        {float [0.000000] }: "; 
char	*im_x_off_pstr = 
	"\nEnter: (im_x_off) Right    offset of the box (0 is CCD center = box center) \n        {float [0.000000] }: "; 
char	*angle_pstr = 
	"\nEnter: (angle) Box rotation (clockwise, degrees) (center = box center) \n        {float [15.000000] }: "; 
char	*corner_angl_pstr = 
	"\nEnter: (corner_angl) the value of the 1st corner angle (degrees) \n        {float,  0.000 to 179.999 [90.000000] }: "; 
char	*g_o_pstr = 
	"\nEnter: (g_o) Grey level of the background pixels outside of the box \n        {integer, 0 to 255 [10] }: "; 
char	*g_i_pstr = 
	"\nEnter: (g_i) Grey level of the lighted pixels inside the box \n        {integer, 0 to 255 [200] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vgbox", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vgbox.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vgbox: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vgbox.ans");
		}

	     }

	}

	/*
	 * allocate the vgbox structure
	 */
	vgbox = (vgbox_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vgbox_struct));

	/*
	 * get required arguments for vgbox
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vgbox->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vgbox->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgbox->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vgbox->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vgbox->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vgbox
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vgbox->trigger_flag = vget_infile(fid, prompt_flag,
	"-trigger", trigger_pstr, &(vgbox->trigger_file))
;

	vgbox->r_flag = vget_int(fid, prompt_flag,
	"-r", r_pstr, &(vgbox->r_int),
	512, 1, 1);

	vgbox->c_flag = vget_int(fid, prompt_flag,
	"-c", c_pstr, &(vgbox->c_int),
	512, 1, 1);

	vgbox->px_h_flag = vget_float(fid, prompt_flag,
	"-px_h", px_h_pstr, &(vgbox->px_h_float),
	1.000000, 0.000000, 1.000000);

	vgbox->px_w_flag = vget_float(fid, prompt_flag,
	"-px_w", px_w_pstr, &(vgbox->px_w_float),
	1.000000, 0.000000, 1.000000);

	vgbox->px_y_off_flag = vget_float(fid, prompt_flag,
	"-px_y_off", px_y_off_pstr, &(vgbox->px_y_off_float),
	0.000000, 0.000000, 1.000000);

	vgbox->px_x_off_flag = vget_float(fid, prompt_flag,
	"-px_x_off", px_x_off_pstr, &(vgbox->px_x_off_float),
	0.000000, 0.000000, 1.000000);

	vgbox->h_flag = vget_float(fid, prompt_flag,
	"-h", h_pstr, &(vgbox->h_float),
	40.299999, 1.000000, 1.000000);

	vgbox->w_flag = vget_float(fid, prompt_flag,
	"-w", w_pstr, &(vgbox->w_float),
	20.600000, 2.000000, 2.000000);

	vgbox->im_y_off_flag = vget_float(fid, prompt_flag,
	"-im_y_off", im_y_off_pstr, &(vgbox->im_y_off_float),
	0.000000, 0.000000, 0.000000);

	vgbox->im_x_off_flag = vget_float(fid, prompt_flag,
	"-im_x_off", im_x_off_pstr, &(vgbox->im_x_off_float),
	0.000000, 0.000000, 0.000000);

	vgbox->angle_flag = vget_float(fid, prompt_flag,
	"-angle", angle_pstr, &(vgbox->angle_float),
	15.000000, 0.000000, 0.000000);

	vgbox->corner_angl_flag = vget_float(fid, prompt_flag,
	"-corner_angl", corner_angl_pstr, &(vgbox->corner_angl_float),
	90.000000, 0.000001, 179.998993);

	vgbox->g_o_flag = vget_int(fid, prompt_flag,
	"-g_o", g_o_pstr, &(vgbox->g_o_int),
	10, 0, 255);

	vgbox->g_i_flag = vget_int(fid, prompt_flag,
	"-g_i", g_i_pstr, &(vgbox->g_i_int),
	200, 0, 255);


}



