 /*
  * Khoros: $Id: vhisto.h,v 1.1 1991/05/10 15:49:29 khoros Exp $
  */

 /*
  * $Log: vhisto.h,v $
 * Revision 1.1  1991/05/10  15:49:29  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vhisto.h
 >>>>            Author: Ramiro Jordan, Marcelo Teran
 >>>> Date Last Updated: Tue Mar  5 22:33:02 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vhisto_h_
#define _vhisto_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vhisto Argument Structure
*
****************************************************************/

typedef struct _vhisto  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  output ASCII file (Required outfile)
 */
char	*o_file;	/* output ASCII file FILENAME */
int	 o_flag;	/* output ASCII file FLAG */

/*
 *  mask image (Optional infile)
 */
char	*m_file;	/* mask image FILENAME */
int	 m_flag;	/* mask image FLAG */

/*
 *  lower bound (Optional float)
 */
float	 l_float;	/* lower bound FLOAT */
int	 l_flag;   	/* lower bound FLAG */

/*
 *  upper bound (Optional float)
 */
float	 u_float;	/* upper bound FLOAT */
int	 u_flag;   	/* upper bound FLAG */

/*
 *  number of bins (Optional integer)
 */
int	 n_int; 	/* number of bins INT */
int	 n_flag;	/* number of bins FLAG */

/*
 *  If True Take Log of Data Before Histogramming (Optional logical)
 */
int	 t_logic;	/* If True Take Log of Data Before Histogramming LOGIC */
int	 t_flag;  	/* If True Take Log of Data Before Histogramming FLAG */

/*
 *  If True Output Histogram in Percent (Optional logical)
 */
int	 p_logic;	/* If True Output Histogram in Percent LOGIC */
int	 p_flag;  	/* If True Output Histogram in Percent FLAG */

}  vhisto_struct;

vhisto_struct *vhisto;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/*
The following define checks for proper values of:
num_of_images = 1
num_data_bands = 1
map_enable = VFF_MAP_OPTIONAL
*/

#define CHECKINPUT(program, img1) \
        (void) proper_num_images(program,img1,1,TRUE); \
        \
        (void) proper_num_bands(program,img1,1,TRUE); \
        \
        (void) proper_map_enable(program,img1,VFF_MAP_OPTIONAL,TRUE)

#define MATCHINPUT(program, img1, img2) \
        (void) match_num_images(program,img1,img2,TRUE); \
        \
        (void) match_num_bands(program,img1,img2,TRUE); \
        \
        (void) match_map_enable(program,img1,img2,TRUE); \
        \
        (void) matchsize(program,img1,img2,TRUE); \
        (void) matchtype(program,img1,img2,TRUE)
/* -include_macros_end */

#endif
