 /*
  * Khoros: $Id: vqmed.c,v 1.2 1992/03/20 23:14:19 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vqmed.c,v 1.2 1992/03/20 23:14:19 dkhoros Exp $";
#endif

 /*
  * $Log: vqmed.c,v $
 * Revision 1.2  1992/03/20  23:14:19  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vqmed.c
 >>>>
 >>>>      Program Name: vqmed
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Perform a median filter on an image using quicksort to  find
 >>>>	the median value.
 >>>>	
 >>>>	

 >>>>            Author: Richard Krukar
 >>>>
 >>>> Date Last Updated: Fri Feb 21 12:03:38 1992
 >>>>
 >>>>          Routines: main- the main program for vqmed
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vqmed.h"


/****************************************************************
 *
 * Routine Name:  main program for vqmed
 *
 *       Input:  
 *       -i  input image 
 *       -o  resulting output image 
 *       -w  filter width   (1 < value < 32)
 *       -h  filter height   (1 < value < 32)
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *readimage(),*img;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);
    img = readimage(vqmed->i_file);
    if(img == NULL)exit(1);

    CHECKINPUT(program,img);    /* Verify input image */
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvqmed(img,vqmed->w_int,vqmed->h_int))
    {
        (void) fprintf(stderr, "lvqmed Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vqmed->o_file,img);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vqmed 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vqmed :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tPerform a median filter on an image using quicksort to  find\n");
	fprintf(stderr, "\tthe median value.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr,"\t-w  filter width  (integer, 1 to 32)\n");
	fprintf(stderr,"\t-h  filter height  (integer, 1 to 32)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vqmed\n");
	fprintf(stderr, "\t[-U] Gives the usage for vqmed\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vqmed.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vqmed.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vqmed
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*w_pstr = 
	"\nEnter: (w) filter width \n        {integer, 1 to 32}: "; 
char	*h_pstr = 
	"\nEnter: (h) filter height \n        {integer, 1 to 32}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vqmed", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vqmed.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vqmed: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vqmed.ans");
		}

	     }

	}

	/*
	 * allocate the vqmed structure
	 */
	vqmed = (vqmed_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vqmed_struct));

	/*
	 * get required arguments for vqmed
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vqmed->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vqmed->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vqmed->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vqmed->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vqmed->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vqmed->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vqmed->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vqmed->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vqmed->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vqmed->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vqmed->w_flag = vget_int(fid, prompt_flag,
			"-w", w_pstr, &(vqmed->w_int),
			3, 1, 32)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vqmed->w_flag))
		{
		    fprintf(stderr, "\t\tw is required, please re-enter: \n");
		    vqmed->w_flag = vget_int(fid, prompt_flag,
		    "-w", w_pstr, &(vqmed->w_int),
		    3, 1, 32);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-w' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vqmed->h_flag = vget_int(fid, prompt_flag,
			"-h", h_pstr, &(vqmed->h_int),
			3, 1, 32)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vqmed->h_flag))
		{
		    fprintf(stderr, "\t\th is required, please re-enter: \n");
		    vqmed->h_flag = vget_int(fid, prompt_flag,
		    "-h", h_pstr, &(vqmed->h_int),
		    3, 1, 32);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-h' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



