 /*
  * Khoros: $Id: vgef.c,v 1.1 1991/05/10 15:48:12 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vgef.c,v 1.1 1991/05/10 15:48:12 khoros Exp $";
#endif

 /*
  * $Log: vgef.c,v $
 * Revision 1.1  1991/05/10  15:48:12  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgef.c
 >>>>
 >>>>      Program Name: vgef
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	First Derivative Operator for Symmetric Exponential Filter.
 >>>>	
 >>>>	
 >>>>            Author: Pascal ADAM
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:29:17 1991
 >>>>
 >>>>          Routines: main- the main program for vgef
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vgef.h"


/****************************************************************
 *
 * Routine Name:  main program for vgef
 *
 *       Input:  
 *      -i  input image 
 *      -o  output image 
 *
 *
 *      [-a0] Filter Parameter GEF  (0.000 < value < 1.000)
 *      [-t1] 1st Hysteresis Threshold  (0 < value < 255)
 *      [-t2] 2nd Hysteresis Threshold  (0 < value < 255)
 *      [-l] Minimum Pixel Number in a Segment  (0 < value < 100000)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *image,*readimage();
    int t1,t2,length;
    float a0;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);

    program = "vgef";

    READINPUT (image);
    CHECKINPUT (program,image);

    t1     = vgef->t1_int;
    t2     = vgef->t2_int;
    length = vgef->l_int;
    a0     = vgef->a0_float; 

/* -main_before_lib_call_end */

/* -main_library_call */
   if(! lvgef(image,a0,t1,t2,length))
    {
        (void) fprintf(stderr, "vgef: lvgef Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vgef->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vgef 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vgef :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tFirst Derivative Operator for Symmetric Exponential Filter.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-a0]  Filter Parameter GEF (float,  0.000 to 1.000) [0.45]\n");
	fprintf(stderr,"\t[-t1]  1st Hysteresis Threshold (integer, 0 to 255) [3]\n");
	fprintf(stderr,"\t[-t2]  2nd Hysteresis Threshold (integer, 0 to 255) [4]\n");
	fprintf(stderr,"\t[-l]  Minimum Pixel Number in a Segment (integer, 0 to 100000) [5]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vgef\n");
	fprintf(stderr, "\t[-U] Gives the usage for vgef\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vgef.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vgef.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vgef
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char	*a0_pstr = 
	"\nEnter: (a0) Filter Parameter GEF \n        {float,  0.000 to 1.000 [0.450000] }: "; 
char	*t1_pstr = 
	"\nEnter: (t1) 1st Hysteresis Threshold \n        {integer, 0 to 255 [3] }: "; 
char	*t2_pstr = 
	"\nEnter: (t2) 2nd Hysteresis Threshold \n        {integer, 0 to 255 [4] }: "; 
char	*l_pstr = 
	"\nEnter: (l) Minimum Pixel Number in a Segment \n        {integer, 0 to 100000 [5] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vgef", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vgef.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vgef: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vgef.ans");
		}

	     }

	}

	/*
	 * allocate the vgef structure
	 */
	vgef = (vgef_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vgef_struct));

	/*
	 * get required arguments for vgef
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vgef->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vgef->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgef->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vgef->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vgef->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgef->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vgef->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgef->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vgef->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vgef->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vgef
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vgef->a0_flag = vget_float(fid, prompt_flag,
	"-a0", a0_pstr, &(vgef->a0_float),
	0.450000, 0.000000, 1.000000);

	vgef->t1_flag = vget_int(fid, prompt_flag,
	"-t1", t1_pstr, &(vgef->t1_int),
	3, 0, 255);

	vgef->t2_flag = vget_int(fid, prompt_flag,
	"-t2", t2_pstr, &(vgef->t2_int),
	4, 0, 255);

	vgef->l_flag = vget_int(fid, prompt_flag,
	"-l", l_pstr, &(vgef->l_int),
	5, 0, 100000);


}



