 /*
  * Khoros: $Id: vpml.c,v 1.1 1991/05/10 15:47:27 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vpml.c,v 1.1 1991/05/10 15:47:27 khoros Exp $";
#endif

 /*
  * $Log: vpml.c,v $
 * Revision 1.1  1991/05/10  15:47:27  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vpml.c
 >>>>
 >>>>      Program Name: vpml
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Estimates the Fractal Dimension of an  image  based  on  the
 >>>>	P(m,L)
 >>>>	
 >>>>	
 >>>>            Author: Charlie Gage
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:26:52 1991
 >>>>
 >>>>          Routines: main- the main program for vpml
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vpml.h"


/****************************************************************
 *
 * Routine Name:  main program for vpml
 *
 *       Input:  
 *      -i  input image 
 *      -o1  resulting multiband fractal dimension output image 
 *      -o2  output image specifying the fractal dimension of each class 
 *
 *
 *      [-f1] output file for P(m,L) statistics
 *      [-l] select the initial size of the sliding window  (3 < value < 10000)
 *      [-u] select the final size of the sliding window  (5 < value < 10000)
 *      [-s] select the window step size or interval  (2 < value < 10000)
 *      [-q] select the range of moments (-r/2 <= 0 >= r/2)  (3 < value < 1000)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *image1, *fd_image, *readimage(), *createimage();
FILE *printdev;
char *dummy = '\0';
int i, j, x, num_classes;
int  *ptr;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

READINPUT(image) ;
CHECKINPUT(program, image) ;

/* Check for proper input image type and convert if necessary */
/* vpml will only work with a BYTE or INTEGER type image. */
switch (image->data_storage_type)
 {
  case VFF_TYP_1_BYTE:            /* convert char and short to integer */
  case VFF_TYP_2_BYTE:
     if (lvconvert(image, 4, 0, 1, 0.0, 1.0) == 0)
      {
       (void)fprintf(stderr,"vpml: ERROR, lvconvert failed\n");
       exit(1);
      }
     break;
  case VFF_TYP_4_BYTE:           /* data type integer */
     break;
  default:
  (void)fprintf(stderr,"vpml: ERROR, input image must be of data type BYTE or INTEGER\n");
  exit(1);
 }

/* Determine row size of fractal dimension image,
                     depends on number of classes. */
ptr = (int *)image->imagedata;
num_classes = 0;
for (i = 0; i < image->col_size; i++)
 {
   for (j = 0; j < image->row_size; j++)
    {
      x = ptr[image->col_size * i + j];
      if (x > num_classes)
         num_classes = x;
    }
 }
 num_classes++;      /* this is the number of classes in input image */

/* Open file for P(m,L) statistics */

if (vpml->f1_flag) {
   if (! vwrite_ascii(vpml->f1_file, &printdev))
   {
      (void) fprintf(stderr, "vpml: Can't open ascii output file: \\n");
      exit(1);
   }
}
else
  printdev = stdout;

/* Allocate space for multiband output image (1 band for each moment) */
image1 = createimage(image->col_size, image->row_size, VFF_TYP_FLOAT, 1, vpml->q_int, dummy, 0, 0, VFF_MS_NONE, VFF_MAPTYP_NONE, VFF_LOC_IMPLICIT, 0);

        if (image1 == NULL)
        {
           (void)fprintf(stderr,"vpml: Unable to allocate new image!\\n");
           exit(1);
        }

/* Allocate space for image containing the fractal dimension values */
fd_image = createimage(1, num_classes, VFF_TYP_FLOAT, 1, vpml->q_int, dummy, 0, 0, VFF_MS_NONE, VFF_MAPTYP_NONE, VFF_LOC_IMPLICIT, 0);

if (fd_image == NULL)
 {
    (void)fprintf(stderr,"vpml: Unable to allocate new image!\\n");
    exit(1);
 }
/* -main_before_lib_call_end */

/* -main_library_call */
/*---  Call the lib routine for P(m,L) algorithm ---*/

if(! lvpml(image, image1, fd_image, printdev, vpml->l_int, vpml->u_int, vpml->s_int, vpml->q_int))
 {
    (void) fprintf(stderr, "lvpml Failed\\n");
    exit(1);
 }
/* -main_library_call_end */

/* -main_after_lib_call */
/* write out the resulting output image and fractal dimension image */
writeimage(vpml->o1_file, image1);
writeimage(vpml->o2_file, fd_image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vpml 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vpml :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tEstimates the Fractal Dimension of an  image  based  on  the\n");
	fprintf(stderr, "\tP(m,L)\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o1  resulting multiband fractal dimension output image  (outfile)\n");
	fprintf(stderr,"\t-o2  output image specifying the fractal dimension of each class  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-f1]  output file for P(m,L) statistics (outfile) [null]\n");
	fprintf(stderr,"\t[-l]  select the initial size of the sliding window (integer, 3 to 10000) [3]\n");
	fprintf(stderr,"\t[-u]  select the final size of the sliding window (integer, 5 to 10000) [5]\n");
	fprintf(stderr,"\t[-s]  select the window step size or interval (integer, 2 to 10000) [2]\n");
	fprintf(stderr,"\t[-q]  select the range of moments (-r/2 <= 0 >= r/2) (integer, 3 to 1000) [3]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vpml\n");
	fprintf(stderr, "\t[-U] Gives the usage for vpml\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vpml.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vpml.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vpml
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o1_pstr = 
	"\nEnter: (o1) resulting multiband fractal dimension output image \n        {outfile}: "; 
char	*o2_pstr = 
	"\nEnter: (o2) output image specifying the fractal dimension of each class \n        {outfile}: "; 
char	*f1_pstr = 
	"\nEnter: (f1) output file for P(m,L) statistics \n        {outfile}: "; 
char	*l_pstr = 
	"\nEnter: (l) select the initial size of the sliding window \n        {integer, 3 to 10000 [3] }: "; 
char	*u_pstr = 
	"\nEnter: (u) select the final size of the sliding window \n        {integer, 5 to 10000 [5] }: "; 
char	*s_pstr = 
	"\nEnter: (s) select the window step size or interval \n        {integer, 2 to 10000 [2] }: "; 
char	*q_pstr = 
	"\nEnter: (q) select the range of moments (-r/2 <= 0 >= r/2) \n        {integer, 3 to 1000 [3] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vpml", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vpml.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vpml: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vpml.ans");
		}

	     }

	}

	/*
	 * allocate the vpml structure
	 */
	vpml = (vpml_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vpml_struct));

	/*
	 * get required arguments for vpml
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vpml->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vpml->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vpml->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vpml->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vpml->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vpml->o1_flag = vget_outfile(fid, prompt_flag,
			"-o1", o1_pstr, &(vpml->o1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vpml->o1_flag))
		{
		    fprintf(stderr, "\t\to1 is required, please re-enter: \n");
		    vpml->o1_flag = vget_outfile(fid, prompt_flag,
		    "-o1", o1_pstr, &(vpml->o1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vpml->o2_flag = vget_outfile(fid, prompt_flag,
			"-o2", o2_pstr, &(vpml->o2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vpml->o2_flag))
		{
		    fprintf(stderr, "\t\to2 is required, please re-enter: \n");
		    vpml->o2_flag = vget_outfile(fid, prompt_flag,
		    "-o2", o2_pstr, &(vpml->o2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vpml
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vpml->f1_flag = vget_outfile(fid, prompt_flag,
	"-f1", f1_pstr, &(vpml->f1_file))
;

	vpml->l_flag = vget_int(fid, prompt_flag,
	"-l", l_pstr, &(vpml->l_int),
	3, 3, 10000);

	vpml->u_flag = vget_int(fid, prompt_flag,
	"-u", u_pstr, &(vpml->u_int),
	5, 5, 10000);

	vpml->s_flag = vget_int(fid, prompt_flag,
	"-s", s_pstr, &(vpml->s_int),
	2, 2, 10000);

	vpml->q_flag = vget_int(fid, prompt_flag,
	"-q", q_pstr, &(vpml->q_int),
	3, 3, 1000);


}



