 /*
  * Khoros: $Id: vqerr.h,v 1.1 1991/05/10 15:46:15 khoros Exp $
  */

 /*
  * $Log: vqerr.h,v $
 * Revision 1.1  1991/05/10  15:46:15  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vqerr.h
 >>>>            Author: 
 >>>> Date Last Updated: Thu Mar  7 16:15:24 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vqerr_h_
#define _vqerr_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vqerr Argument Structure
*
****************************************************************/

typedef struct _vqerr  {

/*
 *  Quantized image (Required infile)
 */
char	*i1_file;	/* Quantized image FILENAME */
int	 i1_flag;	/* Quantized image FLAG */

/*
 *  Original image (Required infile)
 */
char	*i2_file;	/* Original image FILENAME */
int	 i2_flag;	/* Original image FLAG */

/*
 *  Output ASCII File (Required outfile)
 */
char	*o_file;	/* Output ASCII File FILENAME */
int	 o_flag;	/* Output ASCII File FLAG */

/*
 *  add operation masking image (Optional infile)
 */
char	*m_file;	/* add operation masking image FILENAME */
int	 m_flag;	/* add operation masking image FLAG */

}  vqerr_struct;

vqerr_struct *vqerr;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define CHECKINPUT(program, img1, img2) \
        (void) proper_num_images(program,img1,1,TRUE); \
        (void) match_num_images(program,img1,img2,TRUE); \
        \
        (void) matchsize(program,img1,img2,TRUE); \

#define MATCHINPUT(program, img1, img2) \
        (void) match_num_images(program,img1,img2,TRUE); \
        \
        (void) match_num_bands(program,img1,img2,TRUE); \
        \
        (void) matchsize(program,img1,img2,TRUE); \
        (void) matchtype(program,img1,img2,TRUE)
/* -include_macros_end */

#endif
