 /*
  * Khoros: $Id: lvmerode.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvmerode.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvmerode.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvmerode.c
 >>>>
 >>>>      Program Name: vmerode
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:31:17 1991 
 >>>>
 >>>>          Routines: lvmerode - the library call for vmerode
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvmerode - library call for vmerode
*
* Purpose:
*    
*    Erode a binary image X, by a structuring element B.
*    
*    
* Input:
*    
*    img            xvimage structure, must be a byte image.
*    
*    ker            xvimage structure, morphological kernel or  struc-
*                   turing  element.   Should  have  been  created  by
*                   vmcustom.
*    
*    
* Output:
*    
*    img2           xvimage structure, erosion of img1 by kernel ker.
*    
*    
*
* Written By: Pascal ADAM
*    
*    Has been updated to ghostX on 5/24/90 by Pascal ADAM
*    
*    
****************************************************************/


/* -library_def */
int
lvmerode(image,kernel)
struct xvimage *image, *kernel;
/* -library_def_end */

/* -library_code */
{
    int belong,    /* TRAN(IMG2;i,j) belongs to IMG1 ? */ 
        nc,        /* number of columns of image */ 
        nr,        /*   "    "  rows    "  "    */
        starti,    /* x upper left corner position of kernel */
        startj,    /* y   "    "    "        "     "   "     */
        kernc,     /* number of columns of kernel */
        kernr;     /* number of rows of kernel */
    unsigned char *result; /* storage of final result */

    char   *program = "lvmerode";

    int i,j,k,ii,jj,iii,jjj;
    unsigned char *c1, *c2, *c3;

    /* Check type,... of image */
    if (!(propertype(program, image, VFF_TYP_1_BYTE, FALSE))) {
        (void) fprintf (stderr, "\n\n%s:   ", program);
        (void) fprintf (stderr, "lvmerode: image must be of type byte\n");
        return (0);
    }
    if (!(proper_num_images (program, image, 1, FALSE))) {
        (void) fprintf (stderr, "\n\n%s:   ", program);
        (void) fprintf (stderr, "Can only work on files with one image\n\n");
        return (0);
    }
    if (!(proper_num_bands (program, image, 1, FALSE))) {
        (void) fprintf (stderr,"\n\n%s:   ", program);
        (void) fprintf (stderr,"Can only work on images with 1 data band\n\n");
        return (0);
    }

    nc = image->row_size; /* number of columns */
    nr = image->col_size; /* number of rows    */

    c1 = (unsigned char *)(image->imagedata); /* pointer on image's pixels */

    /* Check type,... of image */
    if (!(propertype(program, kernel, VFF_TYP_1_BYTE, FALSE))) {
        (void) fprintf (stderr,"\n\n%s:   ", program);
        (void) fprintf (stderr,"lvmerode: image must be of type byte/n");
        return (0);
    }
    if (!(proper_num_images (program, kernel, 1, FALSE))) {
        (void) fprintf (stderr,"\n\n%s:   ", program);
        (void) fprintf (stderr,"Can only work on files with one image\n\n");
        return (0);
    }
    if (!(proper_num_bands (program, kernel, 1, FALSE))) {
        (void) fprintf (stderr,"\n\n%s:   ", program);
        (void) fprintf (stderr,"Can only work on images with 1 data band\n\n");
        return (0);
    }

    kernc = kernel->row_size;/* number of columns of the kernel */
    kernr = kernel->col_size;/* number of rows of the kernel    */

    starti = (int)kernel->ispare1; /* position of upper left hand */ 
    startj = (int)kernel->ispare2; /* corner of the kernel (x,y)  */

    c2 = (unsigned char *)(kernel->imagedata); /* pointer on kernel values */

    /* Checks if the relative position of the kernel relative to the 
    ** dimension of the image will give a significant result image  */
    if (starti>nr/2 || startj>nc/2) {
        (void) fprintf (stderr, "\n%s:   ", program);
        (void) fprintf (stderr, "Warning : the size of the kernel\n");
        (void) fprintf (stderr, "is too big compared to the image\n");
        (void) fprintf (stderr, "size. The visible result may out\n");
        (void) fprintf (stderr, "of the result image dimension...\n");
        }
   
    /* checks the kernel value to be sure it is a compatible 
    **  morphological kernel ...................................*/
    for (i=0;i<kernc*kernr;i++) {
        if (*(c2+i) !=0 && *(c2+i)!=255) {
                (void) fprintf (stderr, "\n%s:   ", program);
                (void) fprintf (stderr, "Kernel contains values different\n");
                (void) fprintf (stderr, "from 0 or 255. Not acceptable ..\n");
                return(0);
                }
        }
    
    /* dynamic memory allocation for temporary result stockage */
    result = (unsigned char *) malloc( nc * nr *sizeof(unsigned char));
    if (result == NULL) {
        (void) fprintf (stderr, "\n%s:   ", program);
        (void) fprintf (stderr, "Insufficient Space avaliable\n");
        return(0);
    }

    c3 = result; /* pointer on the result image data */

    k = nc * nr; /* total number of pixel in the input image */
                                
    /* initialisation of the resulting image  */
    for (j=0;j<k;j++) *(c3 +j)=0;

    /* Scans  and affects the final value of the result image */
    for (i=0;i<nr;i++) {
      for (j=0;j<nc;j++) {

        belong = TRUE;

        /* scans each pixel of the kernel to be sure that all white ones */
        /* translated by(i,j) will be on a white pix. of the input image */
        for (ii=0;(ii<kernr) && (belong==TRUE);ii++) {
          iii = i+ii+starti;
          if (iii<0 || iii>=nr) belong=FALSE;/* one pixel of the translated
                                             ** kernel is outside the image 
                                             ** (i,j) will stay "black"  */
          for (jj=0; jj<kernc; jj++) {
            jjj = j+jj+startj;
            if ( jjj<0 || jjj>=nc ) belong=FALSE;
            if (*(c2+ii*kernc+jj)==255 && *(c1+iii*nc+jjj)==0) belong=FALSE; 
            }
          }
        if (belong == TRUE) *(c3 + i*nc + j) = 255;
        }
      }
    
    c3=result;
    c1=(unsigned char *)image->imagedata;

    /* transfert result data in image data */
    for (i=0;i<k;i++) *(c1++) = *(c3++); 

    /* free memory location of temporary result storage */ 
    free(result);
    return(1);
}
/* -library_code_end */
