 /*
  * Khoros: $Id: lvcustom.c,v 1.2 1991/12/18 09:22:14 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvcustom.c,v 1.2 1991/12/18 09:22:14 dkhoros Exp $";
#endif

 /*
  * $Log: lvcustom.c,v $
 * Revision 1.2  1991/12/18  09:22:14  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvcustom.c
 >>>>
 >>>>      Program Name: vcustom
 >>>>
 >>>> Date Last Updated: Mon Dec  9 23:17:30 1991 
 >>>>
 >>>>          Routines: lvcustom - the library call for vcustom
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvcustom - library call for vcustom
*
* Purpose:
*    
*    Create a custom  image  via  keyboard  entry,  intended  for
*    building custom kernels for spatial convolution.
*    
*    

* Input:
*    
*    image          pointer to xvimage structure pointer
*    
*    rows           number of rows of image to generate
*    
*    cols           number of columns of image to generate
*    
*    type           data type of image to generate
*    
*    

* Output:
*    
*    image          output xvimage structure.
*    
*    

*
* Written By: Richard Krukar
*    
*    John Rasure - re write.   Ramiro  Jordan  -  change  calling
*    process
*    
*    

****************************************************************/


/* -library_def */
int
lvcustom (image, rows, cols, type)
struct xvimage **image;
int rows, cols, type;
/* -library_def_end */

/* -library_code */
{
        int     i, j, k;

        struct xvimage *kern, *createimage();

        int     *iptr;
        short   *sptr;
        float   *fptr;
        unsigned char *cptr;

        kern = createimage((unsigned long) rows, /* number of rows */
                        (unsigned long) cols,    /* number of columns */
                        (unsigned long) type,    /* data_storage_type */
                        (unsigned long) 1,       /* num_of_images */ 
                        (unsigned long) 1,       /* num_data_bands */ 
                        "created by vcustom",    /* comment */
                        (unsigned long) 0,       /* map_row_size */
                        (unsigned long) 0,       /* map_col_size */
                        (unsigned long)
                        VFF_MS_NONE,             /* map_scheme */
                        (unsigned long)
                        VFF_MAPTYP_NONE,         /* map_storage_type */
                        (unsigned long)
                        VFF_LOC_IMPLICIT,        /* location_type */
                        (unsigned long) 0);      /* location_dim */

        if (kern == NULL)
        {
           (void)fprintf(stderr,"lvcustom: Unable to allocate new image!\n");
           *image = NULL;
           return(0);
        }

        switch (kern->data_storage_type)
        {
           case VFF_TYP_1_BYTE:
                cptr = (unsigned char *) kern->imagedata;
                break;

           case VFF_TYP_2_BYTE:
                sptr = (short *) kern->imagedata;
                break;

           case VFF_TYP_4_BYTE:
                iptr = (int *) kern->imagedata;
                break;

           case VFF_TYP_FLOAT:
                fptr = (float *) kern->imagedata;
                break;
        }


        for (i = 0; i < rows; i++) 
        {
            for (j = 0; j < cols; j++)
            {
                (void) printf("kernel[%d][%d] = ",i,j);
                switch (kern->data_storage_type)
                {
                   case VFF_TYP_1_BYTE:
                        (void) scanf("%d",&k);
                        while (k < 0 || k > 255)
                        {
                          (void) fprintf(stderr,"lvcustom: Invalid input -- Valid input 0 - 255\n");
                          (void) printf("kernel[%d][%d] = ",i,j);
                          (void) scanf("%d",&k);
                        }
                        *cptr++ = k;
                        break;

                   case VFF_TYP_2_BYTE:
                        (void) scanf("%d",&k);
                        *sptr++ = k;
                        break;

                   case VFF_TYP_4_BYTE:
                        (void) scanf("%d",iptr++);
                        break;

                   case VFF_TYP_FLOAT:
                        (void) scanf("%f",fptr++);
                        break;

                   default:
                        (void) fprintf(stderr,"livcustom: Unknown data storage type %d\n",kern->data_storage_type);
                        return(0);
                }
            }
        }

        *image = kern;
        return(1);
}
/* -library_code_end */
