 /*
  * Khoros: $Id: lvabsdiff.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvabsdiff.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvabsdiff.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvabsdiff.c
 >>>>
 >>>>      Program Name: vabsdiff
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:51:31 1991 
 >>>>
 >>>>          Routines: lvabsdiff - the library call for vabsdiff
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvabsdiff - library call for vabsdiff
*
* Purpose:
*    
*    Compute the absolute difference between two images pixel  by
*    pixel.
*    
*    
* Input:
*    
*         1. img1 -- first xvimage strcuture
*         2. img2 -- second xvimage structure
*         3. img3 -- gating mask image
*         4. mflg -- a flag set (equal 1) if gating image mask
*                    available
*    
*         The inputs must be of the same data type and size.
*    
*    
* Output:
*    
*         1. img1 -- holds  the  result  of  the  absolute  difference
*         operation.   The  output  data type is the same as the input
*         data type.
*    
*         img1 is used for both the input xvimage  structure  and  the
*         output  result  xvimage  structure.   This  is  done to save
*         space, but you must be careful not  to  overwrite  important
*         data.
*    
*         lvabsdiff returns a 1 upon success and a 0 on failure.
*    
*    
*
* Written By: Scott Wilson
*    
*    Marcelo Teran, John Rasure, Tom Sauer
*    
*    
****************************************************************/


/* -library_def */
int
lvabsdiff(img1,img2,img3,mflg)
struct xvimage *img1,*img2,*img3;
int  mflg;
/* -library_def_end */

/* -library_code */
{
    int    j, k;
    int    i,*i1,*i2,*i3,*i4;
    short  s,*s1,*s2,*s3,*s4;
    float  f,*f1,*f2,*f3,*f4;
    unsigned char *c1,*c2,*c3,*c4;

    k = img1->row_size*img1->col_size*img1->num_data_bands;
    switch (img1->data_storage_type)
      {
        case VFF_TYP_BIT :
          fprintf(stderr,"lvabsdiff: Don't know how to subtract BIT images\n");
          return(0);
          break;
        case VFF_TYP_1_BYTE : 
          c1 = (unsigned char *)(img1->imagedata);
          c2 = (unsigned char *)(img2->imagedata);
          c3 = (unsigned char *)(img1->imagedata);
          if (mflg) c4 = (unsigned char *)(img3->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  s = *c1 - *c2;
                  if (s < 0) s = -s;
                  *c3 = s;
                  c1++; c2++; c3++;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*c4++)
                    {
                      s = *c1 - *c2;
                      if (s < 0) s = -s;
                      *c3 = s;
                      c1++; c2++; c3++;
                    }
                  else
                    {
                      c1++; c2++; c3++;
                    }
                }
            }
          break;
        case VFF_TYP_2_BYTE :
          s1 = (short *)(img1->imagedata);
          s2 = (short *)(img2->imagedata);
          s3 = (short *)(img1->imagedata);
          if (mflg) s4 = (short *)(img3->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  s = *s1 - *s2;
                  if (s < 0) s = -s;
                  *s3 = s;
                  s1++; s2++; s3++;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*s4++)
                    {
                      s = *s1 - *s2;
                      if (s < 0) s = -s;
                      *s3 = s;
                      s1++; s2++; s3++;
                    }
                  else
                    {
                      s1++; s2++; s3++;
                    }
                }
            }
          break;
        case VFF_TYP_4_BYTE :
          i1 = (int *)(img1->imagedata);
          i2 = (int *)(img2->imagedata);
          i3 = (int *)(img1->imagedata);
          if (mflg) i4 = (int *)(img3->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  i = *i1 - *i2;
                  if (i < 0) i = -i;
                  *i3 = i;
                  i1++; i2++; i3++;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*i4++)
                    {
                      i = *i1 - *i2;
                      if (i < 0) i = -i;
                      *i3 = i;
                      i1++; i2++; i3++;
                    }
                  else
                    {
                      i1++; i2++; i3++;
                    }
                }
            }
          break;
        case VFF_TYP_FLOAT :
          f1 = (float *)(img1->imagedata);
          f2 = (float *)(img2->imagedata);
          f3 = (float *)(img1->imagedata);
          if (mflg) f4 = (float *)(img3->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  f = *f1 - *f2;
                  if (f < 0) f = -f;
                  *f3 = f;
                  f1++; f2++; f3++;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*f4++)
                    {
                      f = *f1 - *f2;
                      if (f < 0) f = -f;
                      *f3 = f;
                      f1++; f2++; f3++;
                    }
                  else
                    {
                      f1++; f2++; f3++;
                    }
                }
            }
          break;
        case VFF_TYP_COMPLEX :
          fprintf(stderr,"lvabsdiff: Cannot operate on COMPLEX images\n");
          return(0);
          break;
        default:
          fprintf(stderr,"lvabsdiff: Unknown data storage type, %d\n",img1->data_storage_type);
          return(0);
          break;
      }
      return(1);

}
/* -library_code_end */
