 /*
  * Khoros: $Id: vsurf.c,v 1.1 1991/05/10 15:51:55 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vsurf.c,v 1.1 1991/05/10 15:51:55 khoros Exp $";
#endif

 /*
  * $Log: vsurf.c,v $
 * Revision 1.1  1991/05/10  15:51:55  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vsurf.c
 >>>>
 >>>>      Program Name: vsurf
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Compute surface parameters (normal and angle)
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Tue Apr 16 14:02:05 1991
 >>>>
 >>>>          Routines: main- the main program for vsurf
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vsurf.h"


/****************************************************************
 *
 * Routine Name:  main program for vsurf
 *
 *       Input:  
 *       -i  input image 
 *       -norm  normals image 
 *       -ang  angles image 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *img1, *img2, *img3, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);

        img1 = readimage(vsurf->i_file);
        if (img1 == NULL) exit(1);                    

        if (img1->data_storage_type != VFF_TYP_FLOAT)
          {
            fprintf(stderr,"vsurf: Surface image must be a FLOAT image\n");
            exit(1);
          }

        if (img1->pixsizx != img1->pixsizy || img1->pixsizx == 0)
          {
            fprintf(stderr,"vsurf: Pixels must be square and non-zero\n");
            exit(1);
          }
/* -main_before_lib_call_end */

/* -main_library_call */
        if(! lvsurf(img1, &img2, &img3) )
        {
            (void) fprintf(stderr, "lvsurf Failed\n");
            exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        (void) writeimage(vsurf->norm_file, img2);
        (void) writeimage(vsurf->ang_file, img3);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vsurf 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vsurf :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCompute surface parameters (normal and angle)\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-norm  normals image  (outfile)\n");
	fprintf(stderr,"\t-ang  angles image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vsurf\n");
	fprintf(stderr, "\t[-U] Gives the usage for vsurf\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vsurf.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vsurf.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vsurf
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*norm_pstr = 
	"\nEnter: (norm) normals image \n        {outfile}: "; 
char	*ang_pstr = 
	"\nEnter: (ang) angles image \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vsurf", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vsurf.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vsurf: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vsurf.ans");
		}

	     }

	}

	/*
	 * allocate the vsurf structure
	 */
	vsurf = (vsurf_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vsurf_struct));

	/*
	 * get required arguments for vsurf
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vsurf->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vsurf->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vsurf->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vsurf->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vsurf->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vsurf->norm_flag = vget_outfile(fid, prompt_flag,
			"-norm", norm_pstr, &(vsurf->norm_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vsurf->norm_flag))
		{
		    fprintf(stderr, "\t\tnorm is required, please re-enter: \n");
		    vsurf->norm_flag = vget_outfile(fid, prompt_flag,
		    "-norm", norm_pstr, &(vsurf->norm_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-norm' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vsurf->ang_flag = vget_outfile(fid, prompt_flag,
			"-ang", ang_pstr, &(vsurf->ang_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vsurf->ang_flag))
		{
		    fprintf(stderr, "\t\tang is required, please re-enter: \n");
		    vsurf->ang_flag = vget_outfile(fid, prompt_flag,
		    "-ang", ang_pstr, &(vsurf->ang_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-ang' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



