 /*
  * Khoros: $Id: lvdetilt.c,v 1.2 1991/10/02 00:03:32 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvdetilt.c,v 1.2 1991/10/02 00:03:32 khoros Exp $";
#endif

 /*
  * $Log: lvdetilt.c,v $
 * Revision 1.2  1991/10/02  00:03:32  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvdetilt.c
 >>>>
 >>>>      Program Name: vdetilt
 >>>>
 >>>> Date Last Updated: Thu Sep 26 13:16:26 1991 
 >>>>
 >>>>          Routines: lvdetilt - the library call for vdetilt
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvdetilt - library call for vdetilt
*
* Purpose:
*    
*    Remove an illumination gradient from an image by subtracting
*    a best-fit plane.
*    
*    

* Input:
*    
*    img1           (struct xvimage) - input/output image structure
*    
*    img2           (struct xvimage) - gating mask image
*    
*    mflg           (int) - a flag set (equal 1) if gating image  mask
*                   available
*    
*                   The input images must be of the same data type and
*                   size.
*    
*    

* Output:
*    
*    img1           (struct xvimage) - holds the result of the  detilt
*                   operation.   The  output  data type is the same as
*                   the input data type.
*    
*    

*
* Written By: Scott Wilson
*    
*    John Rasure, Marcelo Teran, Ron E. Neher
*    
*    Mon Jun 11 15:59:36 MDT 1990 Donna Koechner - updated  to  ghost-
*    writer
*    
*    Wed Mar 20 12:36:43 MET 1991 Jean Pierre Guerin - Fixed incorrect
*    tilt center point calculation
*    
*    26-Sep-91 Scott Wilson - Fixed undocumented  change  in  the  lib
*    source  (not  recorded in vdetilt.prog) that had incorrect checks
*    for the successful completion of the tilt  computation  routines.
*    For  the float case, success was incorrectly detected as failure,
*    resulting in bogus error messages and  premature  termination  of
*    the routine.
*    
*    

****************************************************************/


/* -library_def */
int
lvdetilt(img1,img2,mflg,pflg)
struct xvimage *img1,*img2;
int  mflg, pflg;
/* -library_def_end */

/* -library_code */
{
    int i,j,k,rows,cols,rowsd2,colsd2;
    unsigned char *c1,*c2;
    short *s1,*s2;
    int *i1,*i2;
    float *f1,*f2;
    double xslope,yslope,piston;

    rows = img1->col_size;
    cols = img1->row_size;
    rowsd2 = rows >> 1;
    colsd2 = cols >> 1;

    switch (img1->data_storage_type)
      {
        case VFF_TYP_BIT :
          (void) fprintf(stderr,"lvdetilt: Don't know how to DETILT a BIT image!\n");
          return(0);
          break;
        case VFF_TYP_1_BYTE : 
          c1 = (unsigned char *)(img1->imagedata);
          if (mflg) c2 = (unsigned char *)(img2->imagedata);
          if (!mflg)
            {
              if (!lvfindtilt(img1,&xslope,&yslope,&piston))
                {
                  fprintf(stderr,"lvdetilt: lvfindtilt failed.\n");
                  return(0);
                }
              if (!pflg) piston = 0.0;
              for (j=0; j<rows; j++)
                {
                  for (k=0; k<cols; k++)
                    {
                      i = *c1 - (xslope*(k-colsd2)+yslope*(j-rowsd2)+piston);
                      if (i < 0) i = 0;
                      if (i > 255) i = 255;
                      *c1++ = i;
                    }
                }
            }
          else
            {
              if (!lvmafdtilt(img1,img2,&xslope,&yslope,&piston))
                {
                  (void)fprintf(stderr,"lvdetilt: lvmafdtilt failed.\n");
                  return(0);
                }
              if (!pflg) piston = 0.0;
              for (j=0; j<rows; j++)
                {
                  for (k=0; k<cols; k++)
                    {
                      if (*c2++)
                        {
                          i = *c1 - (xslope*(k-colsd2)+yslope*(j-rowsd2)+piston);
                          if (i < 0) i = 0;
                          if (i > 255) i = 255;
                          *c1++ = i;
                        }
                      else c1++;
                    }
                }
            }
          break;
        case VFF_TYP_2_BYTE :
          s1 = (short *)(img1->imagedata);
          if (mflg) s2 = (short *)(img2->imagedata);
          if (!mflg)
            {
              if (!lvfindtilt(img1,&xslope,&yslope,&piston))
                {
                  fprintf(stderr,"lvdetilt: lvfindtilt failed.\n");
                  return(0);
                }
              if (!pflg) piston = 0.0;
              for (j=0; j<rows; j++)
                {
                  for (k=0; k<cols; k++)
                    {
                      *s1 -= xslope*(k-colsd2)+yslope*(j-rowsd2)+piston;
                      s1++;
                    }
                }
            }
          else
            {
              if (!lvmafdtilt(img1,img2,&xslope,&yslope,&piston))
                {
                  (void)fprintf(stderr,"lvdetilt: lvmafdtilt failed.\n");
                  return(0);
                }
              if (!pflg) piston = 0.0;
              for (j=0; j<rows; j++)
                {
                  for (k=0; k<cols; k++)
                    {
                      if (*s2++)
                        {
                          *s1 -= xslope*(k-colsd2)+yslope*(j-rowsd2)+piston;
                          s1++;
                        }
                      else s1++;
                    }
                }
            }
          break;
        case VFF_TYP_4_BYTE :
          i1 = (int *)(img1->imagedata);
          if (mflg) i2 = (int *)(img2->imagedata);
          if (!mflg)
            {
              if (!lvfindtilt(img1,&xslope,&yslope,&piston))
                {
                  fprintf(stderr,"lvdetilt: lvfindtilt failed.\n");
                  return(0);
                }
              if (!pflg) piston = 0.0;
              for (j=0; j<rows; j++)
                {
                  for (k=0; k<cols; k++)
                    {
                      *i1 -= xslope*(k-colsd2)+yslope*(j-rowsd2)+piston;
                      i1++;
                    }
                }
            }
          else
            {
              if (!lvmafdtilt(img1,img2,&xslope,&yslope,&piston))
                {
                  (void)fprintf(stderr,"lvdetilt: lvmafdtilt failed.\n");
                  return(0);
                }
              if (!pflg) piston = 0.0;
              for (j=0; j<rows; j++)
                {
                  for (k=0; k<cols; k++)
                    {
                      if (*i2++)
                        {
                          *i1 -= xslope*(k-colsd2)+yslope*(j-rowsd2)+piston;
                          i1++;
                        }
                      else i1++;
                    }
                }
            }
          break;
        case VFF_TYP_FLOAT :
          f1 = (float *)(img1->imagedata);
          if (mflg) f2 = (float *)(img2->imagedata);
          if (!mflg)
            {
              if (!lvfindtilt(img1,&xslope,&yslope,&piston))
                {
                  fprintf(stderr,"lvdetilt: lvfindtilt failed.\n");
                  return(0);
                }
              if (!pflg) piston = 0.0;
              for (j=0; j<rows; j++)
                {
                  for (k=0; k<cols; k++)
                    {
                      *f1 -= xslope*(k-colsd2)+yslope*(j-rowsd2)+piston;
                      f1++;
                    }
                }
            }
          else
            {
              if (!lvmafdtilt(img1,img2,&xslope,&yslope,&piston))
                {
                  (void)fprintf(stderr,"lvdetilt: lvmafdtilt failed.\n");
                  return(0);
                }
              if (!pflg) piston = 0.0;
              for (j=0; j<rows; j++)
                {
                  for (k=0; k<cols; k++)
                    {
                      if (*f2++)
                        {
                          *f1 -= xslope*(k-colsd2)+yslope*(j-rowsd2)+piston;
                          f1++;
                        }
                      else f1++;
                    }
                }
            }
          break;
        case VFF_TYP_COMPLEX :
          (void) fprintf(stderr,"lvdetilt: Don't know how to DETILT a COMPLEX image!\n");
          return(0);
          break;
        default:
          (void) fprintf(stderr,"lvdetilt: Unknown data storage type, %d\n",img1->data_storage_type);
          return(0);
          break;
      }
      return(1);  /* success */
}

/* -library_code_end */
