 /*
  * Khoros: $Id: meigen.c,v 1.3 1992/03/20 23:44:36 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: meigen.c,v 1.3 1992/03/20 23:44:36 dkhoros Exp $";
#endif

 /*
  * $Log: meigen.c,v $
 * Revision 1.3  1992/03/20  23:44:36  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: meigen.c
 >>>>
 >>>>      Program Name: meigen
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	computes  the  eigenvalues  and  eigenvectors  of  a  square
 >>>>	matrix.
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley
 >>>>
 >>>> Date Last Updated: Thu Mar  5 08:57:29 1992
 >>>>
 >>>>          Routines: main- the main program for meigen
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "meigen.h"


/****************************************************************
 *
 * Routine Name:  main program for meigen
 *
 *       Input:  
 *        -i  input file (matrix file) 
 *
 *
 *        [-o1] resulting eigenvector output file (matrix file)
 *        [-o2] resulting eigenvalue output file (matrix file)
 *        [-j] define arithmetic on data
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image,*vimage,*createimage();
int     out_option=0,arith_type,rows,cols,type;
char *comment = "no comment...";
int proper_num_images();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if (check_args()) exit(1);

  if((image = readimage(meigen->i_file))==NULL){
     (void)fprintf(stderr,"%s:  failed call to readimage()\n",
             program);
     exit(1);
  }

/*
** check for proper image characteristics
*/

  (void)proper_num_images(program,image,(unsigned long)1,(int)TRUE); 

/*
** get on with it...
*/

  if(image->row_size<=0 || image->col_size<=0){
     (void)fprintf(stderr,"%s:  matrix dimensions cannot be zero.\n",program);
     exit(1);
  }

  arith_type = meigen->j_logic;

/*
** create the images
*/

      vimage = createimage(0,0,image->data_storage_type,1,1,comment,
                           (unsigned long)0, /* map_row_size */
                           (unsigned long)0, /* map_col_size */
                           (unsigned long)VFF_MS_NONE,
                           (unsigned long)VFF_MAPTYP_NONE,
                           (unsigned long)VFF_LOC_IMPLICIT,
                           (unsigned long)0);/* location dimension */

  if(meigen->o2_flag) out_option += 2;

  if(meigen->o1_flag) out_option += 1;
/* -main_before_lib_call_end */

/* -main_library_call */
  if(!lmeigen(image,vimage,out_option,arith_type)) {
     (void)fprintf(stderr, "%s: lmeigen failed\n",program);
     exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
  if(meigen->o1_flag){
     if(!(writeimage(meigen->o1_file,image))){
        (void)fprintf(stderr,"%s:  failed call to writeimage()\n",
              program);
        exit(1);
     }
  }

 if(meigen->o2_flag){
    if(!(writeimage(meigen->o2_file,vimage))){
       (void)fprintf(stderr,"%s:  failed call to writeimage()\n",
             program);
       exit(1);
    }
 }
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for meigen 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "meigen :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tcomputes  the  eigenvalues  and  eigenvectors  of  a  square\n");
	fprintf(stderr, "\tmatrix.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
(void) fprintf(stderr,"where \"j\" type of arithmetic to be used:\n");
(void) fprintf(stderr,"\t\"j=0\" scalar arithmetic \n");
(void) fprintf(stderr,"\t\"j=1\" vector arithmetic \n\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input file (matrix file)  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-o1]  resulting eigenvector output file (matrix file) (outfile) [null]\n");
	fprintf(stderr,"\t[-o2]  resulting eigenvalue output file (matrix file) (outfile) [null]\n");
	fprintf(stderr,"\t[-j]  define arithmetic on data (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for meigen\n");
	fprintf(stderr, "\t[-U] Gives the usage for meigen\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called meigen.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses meigen.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for meigen
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input file (matrix file) \n        {infile}: "; 
char	*o1_pstr = 
	"\nEnter: (o1) resulting eigenvector output file (matrix file) \n        {outfile}: "; 
char	*o2_pstr = 
	"\nEnter: (o2) resulting eigenvalue output file (matrix file) \n        {outfile}: "; 
char	*j_pstr = 
	"\nEnter: (j) define arithmetic on data \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "meigen", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "meigen.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "meigen: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "meigen.ans");
		}

	     }

	}

	/*
	 * allocate the meigen structure
	 */
	meigen = (meigen_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (meigen_struct));

	/*
	 * get required arguments for meigen
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(meigen->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(meigen->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(meigen->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    meigen->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(meigen->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for meigen
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	meigen->o1_flag = vget_outfile(fid, prompt_flag,
	"-o1", o1_pstr, &(meigen->o1_file))
;

	meigen->o2_flag = vget_outfile(fid, prompt_flag,
	"-o2", o2_pstr, &(meigen->o2_file))
;

	meigen->j_flag = vget_logic(fid, prompt_flag,
	"-j", j_pstr, &(meigen->j_logic), 1);


}



