 /*
  * Khoros: $Id: lminfo.c,v 1.5 1992/03/25 17:31:44 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lminfo.c,v 1.5 1992/03/25 17:31:44 dkhoros Exp $";
#endif

 /*
  * $Log: lminfo.c,v $
 * Revision 1.5  1992/03/25  17:31:44  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lminfo.c
 >>>>
 >>>>      Program Name: minfo
 >>>>
 >>>> Date Last Updated: Thu Mar  5 08:49:15 1992 
 >>>>
 >>>>          Routines: lminfo - the library call for minfo
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
#define CLEANUP \
    {  /* cleanup workspace before leaving */ \
       if(amatrix!=NULL)free(amatrix); \
       if(zvector!=NULL)free(zvector); \
       if(smatrix!=NULL)free(smatrix); \
       if(umatrix!=NULL)free(umatrix); \
       if(vmatrix!=NULL)free(vmatrix); \
       if(ipvt!=NULL)free(ipvt); \
    } /* end of cleanup code */

typedef struct complex {
  double re,im;
} complex;

static int llminfo();
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lminfo - library call for minfo
*
* Purpose:
*    
*    obtain information about a matrix
*    
*    

* Input:
*    
*    image          an image containg one or more  matrices  (one  per
*                   band).
*    
*    

* Output:
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    

*
* Written By: Jeremy Worley
*    
*    Jeremy Worley 27 Jan 1992 09:57 MST
*              Changed declaration  of  llminfo()  to  static  int  in
*              lminfo().
*    
*    Jeremy Worley 05 Mar 1992 08:44 MST
*              Moved  the  static  declaration  of  llminfo  into   the
*              includes section.
*    
*    

****************************************************************/


/* -library_def */
int lminfo(image,fptr)
  FILE *fptr;
  struct xvimage *image;
/* -library_def_end */

/* -library_code */
{
  char *program = "lminfo";
  int type,bands,rows,cols,i;
  double *matrix,norm,norm1,enorm,cond,determinant[2];
  int lvcast();

  bands = (int)image->num_data_bands;
  rows = (int)image->col_size;
  cols = (int)image->row_size;

/*
** cast all of the data up to double or double complex
*/

   if(image->data_storage_type==VFF_TYP_COMPLEX || image->data_storage_type==
        VFF_TYP_DCOMPLEX){
      if(!lvcast(&image,(int)1,(int)VFF_TYP_DCOMPLEX)){
         fprintf(stderr,"%s:  Failure to cast up to double complex.\n",program);
         return(0);
      }
      type = 1;
   }else{
      if(!lvcast(&image,(int)1,(int)VFF_TYP_DOUBLE)){
         fprintf(stderr,"%s:  Failure to cast up to double.\n",program);
         return(0);
      }
      type = 0;
   }

   matrix = (double *)image->imagedata;

   fprintf(fptr,"\tDimensions:  %d rows by %d columns\n\n",rows,cols);
   fprintf(fptr,"\tType: %s\n\n",(type?"complex":"real"));

   for(i=0;i<bands;i++){
       if(!llminfo(matrix,rows,cols,type,&norm,&norm1,&enorm,&cond,
          determinant)){
          fprintf(stderr,"%s:  Failed call to static routine.\n",program);
          return(0);
       }
       fprintf(fptr,"\n\nBAND #%d\n\n",i);
       fprintf(fptr,"\tCondition:      %g\n",cond);
       fprintf(fptr,"\tNorm:           %g\n",norm);
       fprintf(fptr,"\t1-Norm:         %g\n",norm1);
       fprintf(fptr,"\tEuclidean Norm: %g\n\n",enorm);
       if(rows==cols){
          if(type==0){
             fprintf(fptr,"\tDeterminant:    %g\n",determinant[0]);
          }else{
             fprintf(fptr,"\tDeterminant:    (%g,%g)\n",determinant[0],
             determinant[1]);
          }
       }
       matrix += (type+1)*rows*cols;
   }

   return(1);
}

/***********************************************************************
*
*  Routine Name: 
*
*          Date:
*        
*       Purpose:  
*
*         Input: 
*
*        Output: 
*
*    Written By:  
*
* Modifications:
*
***********************************************************************/
static int llminfo(matrix,rows,cols,type,norm,norm1,enorm,condition,determinant)
  double *matrix,*condition,*norm,*norm1,*enorm,*determinant;
  int rows,cols,type;
{
  int   index1,index2,k,j;
  void zgedi_(), zgeco_(); 
  void swap();

  complex *amatrix,*zvector=NULL,det[2];
  double  *smatrix=NULL,*vmatrix=NULL,*umatrix=NULL;
  int *ipvt=NULL;
  double temp,temp2;
  char *program = "lminfo";
  int job = 10; /* determinant only */
  void mcmppow_(); 
  int lsvd();
/*
** test some junk
*/

  if(rows<=0 || cols<=0){
     fprintf(stderr,"%s:  matrix dimensions must be nonzero.\n",program);
     return(0);
  }

  if(matrix==NULL){
     fprintf(stderr,"%s:  null matrix not allowed.\n",program);
     return(0);
  }

/*
** allocate memory for junk
*/

  amatrix = (complex *)malloc((unsigned)rows * cols * sizeof(complex));
  if(amatrix==NULL){
     fprintf(stderr,"%s:  [1]memory allocation failure.\n",program);
     CLEANUP;
     return(0);
  }

  zvector = (complex *)malloc((unsigned)cols * sizeof(complex));
  if(zvector==NULL){
     fprintf(stderr,"%s:  [2]memory allocation failure.\n",program);
     CLEANUP;
     return(0);
  }

  ipvt = (int *)malloc((unsigned)cols * sizeof(int));
  if(ipvt==NULL){
     fprintf(stderr,"%s:  [3]memory allocation failure.\n",program);
     CLEANUP;
     return(0);
  }

/*
** transpose data 'cause were working with that brain-dead excuse for
** a language FORTRAN... 
*/

  if(type == 0){
     for(j=0;j<rows;j++){
         for(k=0;k<cols;k++){
            amatrix[j*cols+k].re = (double) matrix[j+k*cols];
            amatrix[j*cols+k].im = (double) 0.0;
         }
     }
  }else{
     for(j=0;j<rows;j++){
         for(k=0;k<cols;k++){
            index1 = j*cols + k;
            index2 = j + k*cols ;
            amatrix[index1].re = (double) matrix[2*index2];
            amatrix[index1].im = (double) matrix[2*index2 + 1];
         }
     }
  }

/*
** zgeco factors a complex*16 matrix by gaussian elimination
** and estimates the condition of the matrix.
*/

  (void)zgeco_(amatrix,&rows,&cols,ipvt,condition,zvector);
  (void)zgedi_(amatrix,&rows,&cols,ipvt,det,zvector,&job);

  if(type==0){
     determinant[0] = det[0].re * pow((double)10.0,det[1].re);
     determinant[1] = 0.0;
  }else{
     mcmppow_(determinant,det);
  }

/*
** calculate the 1-norm
*/

  *norm1 = 0.0;
  *enorm = 0.0;

  for(k=0;k<cols;k++){
      temp = temp2 = 0.0;
      for(j=0;j<rows;j++){
          if(type==0){
             temp += fabs(matrix[j*cols+k]); 
             temp2 += pow(matrix[j*cols+k],2.0); 
          }else{
             index1 = 2*(j*cols+k);
             temp += sqrt(matrix[index1]*matrix[index1]+
                          matrix[index1+1]*matrix[index1+1]);
             temp2 += pow(matrix[index1],2.0)+pow(matrix[index1+1],2.0);
          }
          *norm1 = (*norm1<temp)?temp:(*norm1);
          *enorm = sqrt((*enorm<temp2)?temp2:(*enorm));
      }
  }

/*
** calculate norm (largest singular value of x)
*/

  if((smatrix = (double *)malloc(rows*cols*(type+1)*sizeof(double)))==NULL){
     (void)fprintf(stderr,"%s:  unable to allocate s matrix.\n",program);
     exit(1);
  }

  if((umatrix = (double *)malloc(rows*rows*(type+1)*sizeof(double)))==NULL){
     (void)fprintf(stderr,"%s:  unable to allocate u matrix.\n",program);
     exit(1);
  }

  if((vmatrix = (double *)malloc(cols*cols*(type+1)*sizeof(double)))==NULL){
     (void)fprintf(stderr,"%s:  unable to allocate v matrix.\n",program);
     exit(1);
  }

  if(!lsvd(umatrix,smatrix,vmatrix,matrix,rows,cols,type)) {
     (void)fprintf(stderr, "%s: lmsvd failed\n",program);
     exit(1);
  }

  *norm = smatrix[0];

/*
** calculate the condition of the matrix
*/

  temp = MIN(rows,cols);
  if(type){
     *condition = smatrix[0]/smatrix[(int)(2*(temp*temp)-1)-1];
  }else{
     *condition = smatrix[0]/smatrix[(int)(temp*temp)-1];
  }

  CLEANUP;
  return(1);
}
/* -library_code_end */
