 /*
  * Khoros: $Id: elas2viff.c,v 1.1 1991/05/10 15:52:43 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: elas2viff.c,v 1.1 1991/05/10 15:52:43 khoros Exp $";
#endif

 /*
  * $Log: elas2viff.c,v $
 * Revision 1.1  1991/05/10  15:52:43  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: elas2viff.c
 >>>>
 >>>>      Program Name: elas2viff
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Converts an ELAS file format to the VIFF image file format.
 >>>>	
 >>>>	
 >>>>            Author: Charlie Gage
 >>>>
 >>>> Date Last Updated: Sat Mar  2 14:22:06 1991
 >>>>
 >>>>          Routines: main- the main program for elas2viff
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "elas2viff.h"


/****************************************************************
 *
 * Routine Name:  main program for elas2viff
 *
 *       Input:  
 *           -i  input ELAS data file 
 *           -o  resulting output image (viff file) 
 *
 *
 *           [-b] band number 
 *           [-x] upper left x coordinate  (value >= 0)
 *           [-y] upper left y coordinate  (value >= 0)
 *           [-w] width  (value > 0)
 *           [-h] height  (value > 0)
 *           [-c] select color space model
 *		0 (no model),
 *		1 (ntscRGB model),
 *		2 (ntscCMY model),
 *		3 (ntscYIQ model),
 *		4 (HSV model),
 *		5 (HLS model),
 *		6 (IHS model),
 *		7 (cieRGB model),
 *		8 (cieXYZ model),
 *		9 (cieUVW model),
 *		10 (cieucsUVW model),
 *		11 (cieucsSOW model),
 *		12 (cieucsLab model),
 *		13 (cieucsLuv model),
 *		14 (GENERIC model),
 *		or 15 (genericRGB model)
 *		   [default = 0] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *viff_image;
ELAS *elas_image, *open_elas();
int elas_fid, subimg_flag;
char *program = "elas2viff";
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if (check_args()) exit(1);

  subimg_flag = FALSE;    /* initialize optional subimage flag to false */

    /*--------------------------------------------------------
     * First Open ELAS file to get a file descriptor, 
     *  then read ELAS header info
     *------------------------------------------------------ */
  elas_image = open_elas(elas2viff->i_file, &elas_fid);
  if ( elas_image == NULL)
  {
    (void) fprintf(stderr,"%s: unable to read the ELAS image '%s'\n",
                   program, elas2viff->i_file);
    exit(1);
  }

    /*-------------------------------------------------------------------
     * ERROR checking:
     *  If subimage coordinates are specified, ensure that all four 
     *  subimage parameters are specified, then check that the 
     *  requested location coordinates are within ELAS image bounds.
     *-------------------------------------------------------------------*/
if (elas2viff->x_flag || elas2viff->y_flag || elas2viff->w_flag || elas2viff->h_flag)
{
  if ( !(elas2viff->x_flag && elas2viff->y_flag && elas2viff->w_flag && elas2viff->h_flag) )
  {
     (void) fprintf(stderr,"%s: Must select all four subimage parameters.\n", program);
     close(elas_fid);
     exit(1);
    }

  subimg_flag = TRUE;     /* set optional subimage flag to true */

  if (elas2viff->x_int  > (elas_image->last_elem_scan_line - elas_image->init_elem_scan_line))
   {
     (void) fprintf(stderr,"%s: input x-coordinate out of bounds.\n", program);
     (void) fprintf(stderr,"ELAS image width = %d bytes.\n",elas_image->last_elem_scan_line);
     close(elas_fid);
     exit(1);
   }
  if (elas2viff->y_int  > (elas_image->last_line - elas_image->init_line))
   {
     (void) fprintf(stderr,"%s: input y-coordinate out of bounds.\n", program);
     (void) fprintf(stderr,"ELAS image height = %d bytes.\n",elas_image->last_line);
     close(elas_fid);
     exit(1);
   }
  if ((elas2viff->x_int + elas2viff->w_int) > (elas_image->last_elem_scan_line - elas_image->init_elem_scan_line))
   {
     (void) fprintf(stderr,"%s: requested width exceeds ELAS image bounds.\n", program);
     (void) fprintf(stderr,"Use smaller x-coordinate and/or width values.\n");
     close(elas_fid);
     exit(1);
   }
  if ((elas2viff->y_int + elas2viff->h_int) > (elas_image->last_line - elas_image->init_line))
   {
     (void) fprintf(stderr,"%s: requested height exceeds ELAS image bounds.\n", program);
     (void) fprintf(stderr,"Use smaller y-coordinate and/or height values.\n");
     close(elas_fid);
     exit(1);
   }
  if (elas2viff->b_int > elas_image->num_channels)
   {
     (void) fprintf(stderr,"%s: requested band number exceeds\n", program);
     (void) fprintf(stderr,"the number of channels in the ELAS image.\n");
     (void) fprintf(stderr,"Number of channels in ELAS image = %d\n", elas_image->num_channels);
     close(elas_fid);
     exit(1);
   }
}

  if (elas2viff->b_int > elas_image->num_channels)
   {
     (void) fprintf(stderr,"%s: requested band number exceeds\n", program);
     (void) fprintf(stderr,"the number of channels in the ELAS image.\n");
     (void) fprintf(stderr,"Number of channels in ELAS image = %d\n", elas_image->num_channels);
     close(elas_fid);
     exit(1);
   }

/* -main_before_lib_call_end */

/* -main_library_call */
  if (! lelas2viff(elas_image, elas_fid, &viff_image, elas2viff->b_int, elas2viff->x_int, elas2viff->y_int, elas2viff->w_int, elas2viff->h_int, elas2viff->c_toggle, subimg_flag))
  {
     (void) fprintf (stderr, "lelas2viff Failed\n");
     exit (1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage (elas2viff->o_file, viff_image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for elas2viff 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "elas2viff :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tConverts an ELAS file format to the VIFF image file format.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input ELAS data file  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image (viff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-b]  band number (integer) [0]\n");
	fprintf(stderr,"\t[-x]  upper left x coordinate (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-y]  upper left y coordinate (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-w]  width (integer, > 0) [128]\n");
	fprintf(stderr,"\t[-h]  height (integer, > 0) [128]\n");
	fprintf(stderr, "\t[-c]  select color space model\n");
	fprintf(stderr, "\t\t0  (no model),\n");
	fprintf(stderr, "\t\t1  (ntscRGB model),\n");
	fprintf(stderr, "\t\t2  (ntscCMY model),\n");
	fprintf(stderr, "\t\t3  (ntscYIQ model),\n");
	fprintf(stderr, "\t\t4  (HSV model),\n");
	fprintf(stderr, "\t\t5  (HLS model),\n");
	fprintf(stderr, "\t\t6  (IHS model),\n");
	fprintf(stderr, "\t\t7  (cieRGB model),\n");
	fprintf(stderr, "\t\t8  (cieXYZ model),\n");
	fprintf(stderr, "\t\t9  (cieUVW model),\n");
	fprintf(stderr, "\t\t10  (cieucsUVW model),\n");
	fprintf(stderr, "\t\t11  (cieucsSOW model),\n");
	fprintf(stderr, "\t\t12  (cieucsLab model),\n");
	fprintf(stderr, "\t\t13  (cieucsLuv model),\n");
	fprintf(stderr, "\t\t14  (GENERIC model),\n");
	fprintf(stderr, "\t\tor 15  (genericRGB model)\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for elas2viff\n");
	fprintf(stderr, "\t[-U] Gives the usage for elas2viff\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called elas2viff.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses elas2viff.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for elas2viff
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input ELAS data file \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image (viff file) \n        {outfile}: "; 
char	*b_pstr = 
	"\nEnter: (b) band number \n        {integer [0] }: "; 
char	*x_pstr = 
	"\nEnter: (x) upper left x coordinate \n        {integer, >= 0 [0] }: "; 
char	*y_pstr = 
	"\nEnter: (y) upper left y coordinate \n        {integer, >= 0 [0] }: "; 
char	*w_pstr = 
	"\nEnter: (w) width \n        {integer, > 0 [128] }: "; 
char	*h_pstr = 
	"\nEnter: (h) height \n        {integer, > 0 [128] }: "; 
char	*c_pstr = "\nEnter: (c) select color space model -- \n      \t\t0 (no model)\n\t\t1 (ntscRGB model)\n\t\t2 (ntscCMY model)\n\t\t3 (ntscYIQ model)\n\t\t4 (HSV model)\n\t\t5 (HLS model)\n\t\t6 (IHS model)\n\t\t7 (cieRGB model)\n\t\t8 (cieXYZ model)\n\t\t9 (cieUVW model)\n\t\t10 (cieucsUVW model)\n\t\t11 (cieucsSOW model)\n\t\t12 (cieucsLab model)\n\t\t13 (cieucsLuv model)\n\t\t14 (GENERIC model)\n\t\tor 15 (genericRGB model)\n  [0]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "elas2viff", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "elas2viff.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "elas2viff: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "elas2viff.ans");
		}

	     }

	}

	/*
	 * allocate the elas2viff structure
	 */
	elas2viff = (elas2viff_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (elas2viff_struct));

	/*
	 * get required arguments for elas2viff
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(elas2viff->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(elas2viff->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(elas2viff->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    elas2viff->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(elas2viff->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(elas2viff->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(elas2viff->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(elas2viff->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    elas2viff->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(elas2viff->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for elas2viff
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	elas2viff->b_flag = vget_int(fid, prompt_flag,
	"-b", b_pstr, &(elas2viff->b_int),
	0, 0, 0);

	elas2viff->x_flag = vget_int(fid, prompt_flag,
	"-x", x_pstr, &(elas2viff->x_int),
	0, 1, 1);

	elas2viff->y_flag = vget_int(fid, prompt_flag,
	"-y", y_pstr, &(elas2viff->y_int),
	0, 1, 1);

	elas2viff->w_flag = vget_int(fid, prompt_flag,
	"-w", w_pstr, &(elas2viff->w_int),
	128, 2, 2);

	elas2viff->h_flag = vget_int(fid, prompt_flag,
	"-h", h_pstr, &(elas2viff->h_int),
	128, 2, 2);


	/*
	 * get optional toggles for elas2viff
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		elas2viff->c_flag = vget_int(fid, prompt_flag,
		"-c", c_pstr, &(elas2viff->c_toggle),
		0, 0, 0);

		if ((elas2viff->c_toggle == 0 ) || 
		    (elas2viff->c_toggle == 1 ) || 
		    (elas2viff->c_toggle == 2 ) || 
		    (elas2viff->c_toggle == 3 ) || 
		    (elas2viff->c_toggle == 4 ) || 
		    (elas2viff->c_toggle == 5 ) || 
		    (elas2viff->c_toggle == 6 ) || 
		    (elas2viff->c_toggle == 7 ) || 
		    (elas2viff->c_toggle == 8 ) || 
		    (elas2viff->c_toggle == 9 ) || 
		    (elas2viff->c_toggle == 10 ) || 
		    (elas2viff->c_toggle == 11 ) || 
		    (elas2viff->c_toggle == 12 ) || 
		    (elas2viff->c_toggle == 13 ) || 
		    (elas2viff->c_toggle == 14 ) || 
		    (elas2viff->c_toggle == 15 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		elas2viff->c_flag = vget_int(fid, prompt_flag,
		"-c", c_pstr, &(elas2viff->c_toggle),
		0, 0, 0);

		if ((elas2viff->c_toggle != 0 ) && 
		    (elas2viff->c_toggle != 1 ) && 
		    (elas2viff->c_toggle != 2 ) && 
		    (elas2viff->c_toggle != 3 ) && 
		    (elas2viff->c_toggle != 4 ) && 
		    (elas2viff->c_toggle != 5 ) && 
		    (elas2viff->c_toggle != 6 ) && 
		    (elas2viff->c_toggle != 7 ) && 
		    (elas2viff->c_toggle != 8 ) && 
		    (elas2viff->c_toggle != 9 ) && 
		    (elas2viff->c_toggle != 10 ) && 
		    (elas2viff->c_toggle != 11 ) && 
		    (elas2viff->c_toggle != 12 ) && 
		    (elas2viff->c_toggle != 13 ) && 
		    (elas2viff->c_toggle != 14 ) && 
		    (elas2viff->c_toggle != 15 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



