 /*
  * Khoros: $Id: dgpoiss.c,v 1.3 1992/03/20 23:18:00 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dgpoiss.c,v 1.3 1992/03/20 23:18:00 dkhoros Exp $";
#endif

 /*
  * $Log: dgpoiss.c,v $
 * Revision 1.3  1992/03/20  23:18:00  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dgpoiss.c
 >>>>
 >>>>      Program Name: dgpoiss
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Creates a Poisson distributed noise data set.
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley
 >>>>
 >>>> Date Last Updated: Sat Feb 15 16:29:57 1992
 >>>>
 >>>>          Routines: main- the main program for dgpoiss
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dgpoiss.h"


/****************************************************************
 *
 * Routine Name:  main program for dgpoiss
 *
 *       Input:  
 *         -o  resulting image 
 *
 *
 *         [-i] input value file (xviff file)
 *         [-trigger] trigger input
 *         [-s] number of vectors  (value > 0)
 *         [-n] number of points  (value > 0)
 *         [-v] variance  (value >= 0.0)
 *         [-x] time  (value >= 0.0)
 *         [-d] data processing direction (0 = down vectors, 1 = across bands)
 *         [-t] lets user choose data type of image
 *		'float' (select data type),
 *		 or 'complex' (choose data type)
 *		   [default = float] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */

struct xvimage *image=NULL, *kernel=NULL, *readimage();
int type;

/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if(check_args())exit(1);
  if(!vget_type(&type,dgpoiss->t_toggle)){
     fprintf(stderr,"dgpoiss:  Invalid data type specified\n");
     exit(1);
  }

/*
** load kernel if necessary
*/

  if (dgpoiss->i_flag) {
    image = readimage(dgpoiss->i_file);
    if(image == NULL)
    {
      (void)fprintf(stderr,"dgpoiss:  Value file could not be read!\n");
      exit(1);
    }
  }

/* -main_before_lib_call_end */

/* -main_library_call */

  if(!ldgpoiss(&image,dgpoiss->s_int,dgpoiss->n_int,
             dgpoiss->v_float,dgpoiss->x_float,type, dgpoiss->d_logic)){
    (void)fprintf(stderr, "ldgpoiss Failed\n");
    exit(1);
  }


/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(dgpoiss->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dgpoiss 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dgpoiss :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCreates a Poisson distributed noise data set.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
fprintf(stderr,"\nThe -t option will accept input in either of two forms:\n");
fprintf(stderr,"  an alphabetic representation, i.e. 'float' or 'complex',\n");
fprintf(stderr,"  or a numeric representation, such as 4 for real.\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-o  resulting image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-i]  input value file (xviff file) (infile) [null]\n");
	fprintf(stderr,"\t[-trigger]  trigger input (infile) [null]\n");
	fprintf(stderr,"\t[-s]  number of vectors (integer, > 0) [1]\n");
	fprintf(stderr,"\t[-n]  number of points (integer, > 0) [256]\n");
	fprintf(stderr,"\t[-v]  variance (float, >= 0.0) [1]\n");
	fprintf(stderr,"\t[-x]  time (float, >= 0.0) [1]\n");
	fprintf(stderr,"\t[-d]  data processing direction (0 = down vectors, 1 = across bands) (boolean) [true]\n");
	fprintf(stderr, "\t[-t]  lets user choose data type of image\n");
	fprintf(stderr, "\t\t'float'  (select data type),\n");
	fprintf(stderr, "\t\t or 'complex'  (choose data type)\n");
	fprintf(stderr, "\t\t[default = float]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dgpoiss\n");
	fprintf(stderr, "\t[-U] Gives the usage for dgpoiss\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dgpoiss.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dgpoiss.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dgpoiss
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) resulting image \n        {outfile}: "; 
char	*i_pstr = 
	"\nEnter: (i) input value file (xviff file) \n        {infile}: "; 
char	*trigger_pstr = 
	"\nEnter: (trigger) trigger input \n        {infile}: "; 
char	*s_pstr = 
	"\nEnter: (s) number of vectors \n        {integer, > 0 [1] }: "; 
char	*n_pstr = 
	"\nEnter: (n) number of points \n        {integer, > 0 [256] }: "; 
char	*v_pstr = 
	"\nEnter: (v) variance \n        {float, >= 0.0 [1.000000] }: "; 
char	*x_pstr = 
	"\nEnter: (x) time \n        {float, >= 0.0 [1.000000] }: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (0 = down vectors, 1 = across bands) \n        {boolean, (y/n)  [yes] }: "; 
char	*t_pstr = "\nEnter: (t) lets user choose data type of image -- \n      \t\t'float' (select data type)\n\t\tor 'complex' (choose data type)\n  [float]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dgpoiss", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dgpoiss.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dgpoiss: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dgpoiss.ans");
		}

	     }

	}

	/*
	 * allocate the dgpoiss structure
	 */
	dgpoiss = (dgpoiss_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dgpoiss_struct));

	/*
	 * get required arguments for dgpoiss
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dgpoiss->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dgpoiss->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dgpoiss->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dgpoiss->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dgpoiss->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dgpoiss
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dgpoiss->i_flag = vget_infile(fid, prompt_flag,
	"-i", i_pstr, &(dgpoiss->i_file))
;

	dgpoiss->trigger_flag = vget_infile(fid, prompt_flag,
	"-trigger", trigger_pstr, &(dgpoiss->trigger_file))
;

	dgpoiss->s_flag = vget_int(fid, prompt_flag,
	"-s", s_pstr, &(dgpoiss->s_int),
	1, 2, 2);

	dgpoiss->n_flag = vget_int(fid, prompt_flag,
	"-n", n_pstr, &(dgpoiss->n_int),
	256, 2, 2);

	dgpoiss->v_flag = vget_float(fid, prompt_flag,
	"-v", v_pstr, &(dgpoiss->v_float),
	1.000000, 1.000000, 1.000000);

	dgpoiss->x_flag = vget_float(fid, prompt_flag,
	"-x", x_pstr, &(dgpoiss->x_float),
	1.000000, 1.000000, 1.000000);

	dgpoiss->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dgpoiss->d_logic), 1);


	/*
	 * get optional toggles for dgpoiss
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dgpoiss->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(dgpoiss->t_toggle),
		"float");

		if (((strcmp(dgpoiss->t_toggle, "float") == 0)) || 
		     ((strcmp(dgpoiss->t_toggle, "complex") == 0)))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dgpoiss->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(dgpoiss->t_toggle),
		"float");

		if (((strcmp(dgpoiss->t_toggle, "float") != 0)) && 
		     ((strcmp(dgpoiss->t_toggle, "complex") != 0)))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



