 /*
  * Khoros: $Id: dzresp.c,v 1.2 1992/03/20 23:23:04 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dzresp.c,v 1.2 1992/03/20 23:23:04 dkhoros Exp $";
#endif

 /*
  * $Log: dzresp.c,v $
 * Revision 1.2  1992/03/20  23:23:04  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dzresp.c
 >>>>
 >>>>      Program Name: dzresp
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Calculates the magnitude, power or phase response  of  a  z-
 >>>>	domain system
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley
 >>>>
 >>>> Date Last Updated: Mon Mar  9 20:20:39 1992
 >>>>
 >>>>          Routines: main- the main program for dzresp
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dzresp.h"


/****************************************************************
 *
 * Routine Name:  main program for dzresp
 *
 *       Input:  
 *        -i  input data file (polynomial file) 
 *        -o  resulting output file (xviff file) 
 *
 *
 *        [-n] number of points 
 *        [-r] generate one-sided (0) or two-sided (1) response
 *        [-d] data processing direction (0 = down vectors, 1 = across bands)
 *        [-p] type of response(0 = magnitude; 1 = power; 2 = phase)
 *		0 (magnitude response),
 *		1 (power response),
 *		or 2 (phase response)
 *		   [default = 0] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
  struct xvimage *image=NULL;
  struct poly_struct *poly = NULL;
  int side,npolys,numpts,resp_type,proc_dir;
  int createpoly(), readpoly();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
 if (check_args()) exit(1);

  numpts = dzresp->n_int;
  resp_type = dzresp->p_toggle;
  proc_dir = dzresp->d_logic;
  side = dzresp->r_logic;

  if(!createpoly(&poly,MAXPOLYS,0,MAXSTAGES,STRMAX)){
     fprintf(stderr,"%s:  failure to create polynomial.\n",program);
     exit(1);
  }

  if(!readpoly(dzresp->i_file,poly,MAXPOLYS,&npolys)){
     fprintf(stderr,"%s:  failure to read polynomial file.\n",program);
     exit(1);
  }
/* -main_before_lib_call_end */

/* -main_library_call */
  if(!ldzresp(&image,poly,npolys,numpts,side,resp_type,proc_dir)) {
     fprintf(stderr, "ldzresp failed\n");
     exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
  writeimage(dzresp->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dzresp 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dzresp :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCalculates the magnitude, power or phase response  of  a  z-\n");
	fprintf(stderr, "\tdomain system\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input data file (polynomial file)  (infile)\n");
	fprintf(stderr,"\t-o  resulting output file (xviff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-n]  number of points (integer) [256]\n");
	fprintf(stderr,"\t[-r]  generate one-sided (0) or two-sided (1) response (boolean) [false]\n");
	fprintf(stderr,"\t[-d]  data processing direction (0 = down vectors, 1 = across bands) (boolean) [true]\n");
	fprintf(stderr, "\t[-p]  type of response(0 = magnitude; 1 = power; 2 = phase)\n");
	fprintf(stderr, "\t\t0  (magnitude response),\n");
	fprintf(stderr, "\t\t1  (power response),\n");
	fprintf(stderr, "\t\tor 2  (phase response)\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dzresp\n");
	fprintf(stderr, "\t[-U] Gives the usage for dzresp\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dzresp.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dzresp.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dzresp
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input data file (polynomial file) \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output file (xviff file) \n        {outfile}: "; 
char	*n_pstr = 
	"\nEnter: (n) number of points \n        {integer [256] }: "; 
char	*r_pstr = 
	"\nEnter: (r) generate one-sided (0) or two-sided (1) response \n        {boolean, (y/n)  [no] }: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (0 = down vectors, 1 = across bands) \n        {boolean, (y/n)  [yes] }: "; 
char	*p_pstr = "\nEnter: (p) type of response(0 = magnitude; 1 = power; 2 = phase) -- \n      \t\t0 (magnitude response)\n\t\t1 (power response)\n\t\tor 2 (phase response)\n  [0]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dzresp", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dzresp.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dzresp: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dzresp.ans");
		}

	     }

	}

	/*
	 * allocate the dzresp structure
	 */
	dzresp = (dzresp_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dzresp_struct));

	/*
	 * get required arguments for dzresp
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dzresp->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(dzresp->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dzresp->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    dzresp->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(dzresp->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dzresp->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dzresp->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dzresp->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dzresp->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dzresp->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dzresp
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dzresp->n_flag = vget_int(fid, prompt_flag,
	"-n", n_pstr, &(dzresp->n_int),
	256, 0, 0);

	dzresp->r_flag = vget_logic(fid, prompt_flag,
	"-r", r_pstr, &(dzresp->r_logic), 0);

	dzresp->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dzresp->d_logic), 1);


	/*
	 * get optional toggles for dzresp
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dzresp->p_flag = vget_int(fid, prompt_flag,
		"-p", p_pstr, &(dzresp->p_toggle),
		0, 0, 0);

		if ((dzresp->p_toggle == 0 ) || 
		    (dzresp->p_toggle == 1 ) || 
		    (dzresp->p_toggle == 2 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dzresp->p_flag = vget_int(fid, prompt_flag,
		"-p", p_pstr, &(dzresp->p_toggle),
		0, 0, 0);

		if ((dzresp->p_toggle != 0 ) && 
		    (dzresp->p_toggle != 1 ) && 
		    (dzresp->p_toggle != 2 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



