 /*
  * Khoros: $Id: rowsize.c,v 1.1 1991/05/10 15:41:35 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: rowsize.c,v 1.1 1991/05/10 15:41:35 khoros Exp $";
#endif

 /*
  * $Log: rowsize.c,v $
 * Revision 1.1  1991/05/10  15:41:35  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 *            Copyright 1990 University of New Mexico
 *
 *  Permission to use, copy, modify, distribute, and sell this
 *  software and its documentation for any purpose is hereby
 *  granted without fee, provided that the above copyright
 *  notice appear in all copies and that both that copyright
 *  notice and this permission notice appear in supporting docu-
 *  mentation, and that the name of UNM not be used in advertis-
 *  ing or publicity pertaining to distribution of the software
 *  without specific, written prior permission.  UNM makes no
 *  representations about the suitability of this software for
 *  any purpose.  It is provided "as is" without express or
 *  implied warranty.
 *
 *  UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 *  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 *  NESS, IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 *  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 *  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 *  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 *  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 *  OF THIS SOFTWARE.
 *
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1990 by UNM */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                         <<<<
   >>>>     file name: rowsize.c                                <<<<
   >>>>                                                         <<<<
   >>>>   description: General utilities to help manipulate     <<<<
   >>>>                viff images.                             <<<<
   >>>>                                                         <<<<
   >>>>      routines: viff_rowsize                             <<<<
   >>>>                                                         <<<<
   >>>> modifications:                                          <<<<
   >>>>                                                         <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/**************************************************************
*
* MODULE NAME: viff_rowsize
*
*     PURPOSE: computes the rowsize in bytes of an image according
*	       to the data type and width.
*
*       INPUT:  data_storage_type - the data type of the scan line
*		width -	the width of the scan line
*
*      OUTPUT: 	returns number of bytes for the scanline or -1
*		if an unknown data storage type.
*
* CALLED FROM: ipl routines
*
* ROUTINES CALLED: none
*
**************************************************************/

#include "vinclude.h"


int viff_rowsize(data_storage_type, width)

int data_storage_type, width;
{
	switch (data_storage_type)
	{
	   case VFF_TYP_BIT:
	        return((width+7)/8);
	        break;

	   case VFF_TYP_1_BYTE:
	        return(width);
	        break;

	   case VFF_TYP_2_BYTE:
	        return(sizeof(short)*width);
	        break;

	   case VFF_TYP_4_BYTE:
	        return(sizeof(int)*width);
	        break;

	   case VFF_TYP_FLOAT:
	        return(sizeof(float)*width);
	        break;

	   case VFF_TYP_DOUBLE:
	        return(sizeof(double)*width);
	        break;

	   case VFF_TYP_COMPLEX:
	        return(sizeof(float)*width*2);
	        break;

	   case VFF_TYP_DCOMPLEX:
	        return(sizeof(double)*width*2);
	        break;

	    default:
	        (void) fprintf(stderr,"viff_rowsize: Unknown data storage \
type, %d\n", data_storage_type);
	        return(-1);
		break;
	}
}
