 /*
  * Khoros: $Id: freeimage.c,v 1.3 1992/03/20 23:40:29 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: freeimage.c,v 1.3 1992/03/20 23:40:29 dkhoros Exp $";
#endif

 /*
  * $Log: freeimage.c,v $
 * Revision 1.3  1992/03/20  23:40:29  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "vinclude.h"	


/************************************************************
*
*  MODULE NAME: freeimage
*
*      PURPOSE: This routine frees an khoros xvimage structure.
*
*        INPUT: image --  a pointer to an khoros xvimage structure that 
*			  contains the image structure to be freed.
*
*       OUTPUT: (none)  since all we are doing is freeing as much of
*		a image structure as we can.
*
*    CALLED BY: any routine that wishes to free an xvimage structure
*
*   WRITTEN BY: Mark Young
*   MODIFIED BY: Scott Wilson - Updated to XV III 27-Feb-89
*                Scott Wilson - Added bzero of header 13-Nov-91
*                Scott Wilson - Added defensive ID test. 14-Jan-92
*
*************************************************************/

freeimage(image)

struct xvimage *image;
{
	unsigned char id1,id2;

	/*
	 *  Free as much of the xvimage structure as we can.  But first check to
	 *  make sure the image pointer is not NULL.
	 */
	if (image != NULL)
	{
	   /* Now see of the image itself is legal. This catches accidental
	      attempts to free an image already turned loose by freeimage(). */
           id1 = image->identifier;
	   id2 = XV_FILE_MAGIC_NUM;
	   if (id1 != id2)
	     {
	       (void)fprintf(stderr,
       "freeimage: Attempt to free an object that is not a VIFF image.\n");
	       (void)fprintf(stderr,
       "freeimage: Object may be a VIFF image that has already been free'd.\n");
	       (void)fprintf(stderr,"freeimage: Attempt aborted.\n");
	       return;
	     }

	   /*  free image data */
	   if (image->imagedata != NULL && (image->row_size * 
	       image->col_size) > 0)
	      free ((char *) image->imagedata);

	   /*  free map data */
	   if (image->maps != NULL && image->map_row_size > 0)
	      free ((char *) image->maps);

	   /*  free location data */
	   if (image->location != NULL && image->row_size *
               image->col_size > 0 &&
               image->location_type == VFF_LOC_EXPLICIT)
	      free ((char *) image->location);

	   /*
	    *  Get rid of the image structure itself.  We know it is not
	    *  NULL, since we checked it above. BUT: before we do this,
            *  fill the header with zeros so that should an unspecting
            *  programmer try to use an already free'd image it will not
            *  just appear that all is well!
	    */
           bzero(image,sizeof(struct xvimage));
	   free((char *) image);

	}
}
