 /*
  * Khoros: $Id: wait3.c,v 1.2 1991/12/18 09:55:34 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: wait3.c,v 1.2 1991/12/18 09:55:34 dkhoros Exp $";
#endif

 /*
  * $Log: wait3.c,v $
 * Revision 1.2  1991/12/18  09:55:34  dkhoros
 * HellPatch3
 *
  */ 

#include "vgparm.h"	
#include "vsignal.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: wait3.c				      <<<<
   >>>>                                                       <<<<
   >>>>   description: performs a wait3 emulation             <<<<
   >>>>                                                       <<<<
   >>>>      routines: 					      <<<<
   >>>>                                                       <<<<
   >>>> modifications:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/**************************************************************
*
* MODULE NAME: vwait3
*
*     PURPOSE: 	This return emulates the bsd wait3() command.
*		The wait3 process waits until any child has
*		completed, without hanging (WNOHANG).
*
*		This routine was developed and tested for a
*		cray.
*
*       INPUT: 	options - options used for wait3 (WUNTRACED, WNOHANG)
*
*      OUTPUT:  status - the return status of the process
*		rusage - the resource usage
*
*		(note:  the rusage are ignored when WAIT3 is not defined.
*
*
*  WRITTEN BY:  Bob Weaver (at Idaho National Labs)
*
**************************************************************/


#ifndef WAIT3
/*
 * "vwait3" system call emulation.  Note - the 2nd and 3rd arguments are
 *    ignored.
 */
int
vwait3(status, options, dummy)
vstatus *status;
int	options;
void	*dummy;
{
      return(waitpid(0, status, options));
}
#else
int
vwait3(status, options, rusage)
vstatus *status;
int	options;
struct  rusage *rusage;
{
	return(wait3(status, options, rusage));
}
#endif
