 /*
  * Khoros: $Id: vget.c,v 1.3 1991/12/18 09:55:28 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vget.c,v 1.3 1991/12/18 09:55:28 dkhoros Exp $";
#endif

 /*
  * $Log: vget.c,v $
 * Revision 1.3  1991/12/18  09:55:28  dkhoros
 * HellPatch3
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "vinclude.h"	


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: vget.c 
   >>>>               
   >>>>   description:
   >>>>              
   >>>>      routines: 
   >>>>		vget_infile()  --> get an input file. 
   >>>>		vget_outfile() --> get an output file. 
   >>>>		vget_int()     --> get an integer value.
   >>>>		vget_float()   --> get a float value.
   >>>>		vget_logic()   --> get a logic value.
   >>>>		vget_string()  --> get a string.
   >>>>		
   >>>>		vwrite_ascii() -->  used to get device for fprintf'ing
   >>>>		vread_ascii()  -->  used to read device
   >>>>               
   >>>> modifications:
   >>>>          John Rasure and Mark Young
   >>>>
   >>>>           Added image cache support in vget_input and vopen_output.
   >>>>                                               Scott Wilson 6-Jan-90
   >>>>
   >>>>           Re-wrote vget_infile and vget_outfile to use filenames
   >>>>           instead of file descriptors. Removed vopen_output().
   >>>>           Removed image cache stuff since it no longer matters.
   >>>>           Removed single STDIN/STDOUT/STDERR restriction.
   >>>>           Use access() to see if file is accessible rather than
   >>>>           open(). Removed file creation code for write check in
   >>>>           vget_outfile().                     Scott Wilson 19-Jun-90
   >>>>
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "vgparm.h"
/* The following include is only done for POSIX compliance - thus far
   this is more liability than benefit. It is not available on the
   Apollo DN10000. The defines appear to be done in sys/file.h
   as well. */
/* #include <unistd.h>   */      /*     Defines for access() modes */

#undef  LENGTH
#define LENGTH	512

#define CA_QUIT	1
#define CA_CONT 0

extern	char	*program;	/* the name of the program */
extern char	**av;
extern int	ac;

/**************************************************************
*
* MODULE NAME: vget_infile
*
*     PURPOSE: used to get an input file for a program
*
*       INPUT: see below
*
*      OUTPUT: just changes inputs
*
* CALLED FROM: Users VGetArgs routine
*
**************************************************************/

vget_infile(fd_ansr, prompt_flag, opt, opt_str, opt_file)
int	fd_ansr;	/* the file descriptor for the answer file */
int 	prompt_flag;	/* flag set to prompt user for input */
char	*opt;		/* the option to look for */
char 	*opt_str;	/* the string used to prompt the user with */
char 	**opt_file;	/* the pointer to the file name returned */
  {
    char	buff[LENGTH];
    int		error;
    int		done=0;

    if (prompt_flag) vgparms(fd_ansr,opt,opt_str,buff,0,0,&error);
    else vgparms(fd_ansr,opt,"noprompt",buff,0,0,&error);

    if (error == 0 && VStrlen(buff) != 0)
      {
	*opt_file = vfullpath(buff, NULL, NULL);      /* Got a file name */
	if (!prompt_flag)
	  {
	    if (*opt_file == NULL)
	       return(0);

	    /* If prompting is disabled, just check accessibility.
               STDIN is always accessible. */
            if (strcmp(*opt_file,"-") != 0) check_access(*opt_file,CA_QUIT);
	  }
	else
	  { /* Prompting is enabled, so check accessibility and
               ask for more input if it fails. */
	    do
              {
		if (*opt_file == NULL)
		   *opt_file = buff;

                if (strcmp(*opt_file,"-") != 0)
                  {
                    if (!check_access(*opt_file,CA_CONT))
                      {
                        fprintf(stderr,"%s: Re-enter: ",program);

			if (*opt_file != buff) free(*opt_file);

                        gets(buff);
			*opt_file = vfullpath(buff, NULL, NULL);
			
		        if (VStrlen(*opt_file) == 0 && VStrlen(buff) == 0)
		          { /* User didn't really want this option */
		            if (khoros_verbose)
            	              fprintf(stderr,
                                    "%s: \"%s\" infile flag not used\n",
	        	            program,opt);
                            return(0);
 		          }
                      }
                    else done=1;       /* File was accessible */
                  }
                else done=1;           /* STDIN is always accessible */
	      }
            while(!done);
	  }
      }
    else
      {
        /* Got an error from the vgparms or else a NULL filename
           so we just claim that this option was not specified
           on the command line */
	if (khoros_verbose)
            fprintf(stderr,"%s: \"%s\" infile flag not used\n",
	          program,opt);
	return(0);
      }
    return(1);
  }

/**************************************************************
*
* MODULE NAME: vget_outfile
*
*     PURPOSE: used to get an output file for a program
*
*       INPUT: see below
*
*      OUTPUT: just changes output
*
* CALLED FROM: Users VGetArgs routine
*
**************************************************************/
vget_outfile(fd_ansr, prompt_flag, opt, opt_str, opt_file)
int	fd_ansr;	/* the file descriptor for the answer file */
int 	prompt_flag;	/* flag set to prompt user for input */
char	*opt;		/* the option to look for */
char 	*opt_str;	/* the string used to prompt the user with */
char 	**opt_file;	/* the pointer to the file name returned */
 {
   char	buff[LENGTH];
   int		error;

   if (prompt_flag) vgparms(fd_ansr,opt,opt_str,buff,0,0,&error);
   else vgparms(fd_ansr,opt,"noprompt",buff,0,0,&error);

   if (error == 0 && VStrlen(buff) != 0)
     {
       /* got possible valid output file */
       *opt_file = vfullpath(buff, NULL, NULL);
       if (*opt_file == NULL)
          return(0);
       else
          return(1);
     }
   else
     { 
       /* flag not used */
       if (khoros_verbose) fprintf(stderr, "%s: \"%s\" outfile flag not used\n",
                                program, opt);
       return(0);
     }
 }

/**************************************************************
*
* MODULE NAME: vget_int
*
*     PURPOSE: used to get an integer for a program
*
*       INPUT: see below
*
*      OUTPUT: just changes inputs
*
* CALLED FROM: Users VGetArgs routine
*
**************************************************************/
vget_int(fd_ansr,prompt_flag,opt,opt_str,opt_int,opt_default,opt_min,opt_max)
int	fd_ansr;	/* the file descriptor for the answer file */
int 	prompt_flag;	/* flag set to prompt user for input */
char	*opt;		/* the option to look for */
char 	*opt_str;	/* the string used to prompt the user with */
int 	*opt_int;	/* the pointer to the int to be returned */
int	opt_default;	/* the default int value */
int	opt_min, opt_max; /* the range of valid input for the int */
{
int	error;

    if (prompt_flag)
        vgparmi(fd_ansr,opt,opt_str,opt_int,opt_max,opt_min,&error);
    else vgparmi(fd_ansr,opt,"noprompt",opt_int,opt_max,opt_min,&error);

    if (error != 0)
    {
	*opt_int = opt_default;

	if (khoros_verbose)
            fprintf(stderr,
               "%s: \"%s\" integer flag not used: Default is: \"%d\"\n",
                program,opt,*opt_int);
    	return(0);
    }
    return(1);
}

/**************************************************************
*
* MODULE NAME: vget_float
*
*     PURPOSE: used to get a float for a program
*
*       INPUT: see below
*
*      OUTPUT: just changes inputs
*
* CALLED FROM: Users VGetArgs routine
*
**************************************************************/
vget_float(fd_ansr,prompt_flag,opt,opt_str,opt_float,opt_default,opt_min,
           opt_max)
int	fd_ansr;	/* the file descriptor for the answer file */
int 	prompt_flag;	/* flag set to prompt user for input */
char	*opt;		/* the option to look for */
char 	*opt_str;	/* the string used to prompt the user with */
float 	*opt_float;	/* the pointer to the float to be returned */
float	opt_default;	/* the default float value */
float	opt_min, opt_max; /* the range of valid input for the float */
{
int	error;

    if (prompt_flag)
        vgparmf(fd_ansr,opt,opt_str,opt_float,opt_max,opt_min,&error);
    else vgparmf(fd_ansr,opt,"noprompt",opt_float,opt_max,opt_min,&error);

    if (error != 0)
    {
	*opt_float = opt_default;

	if (khoros_verbose)
            fprintf(stderr,
                "%s: \"%s\" float flag not used: Default is: \"%f\"\n",
	         program,opt,*opt_float);
	return(0);
    }
    return(1);
}

/**************************************************************
*
* MODULE NAME: vget_logic
*
*     PURPOSE: used to get a logic for a program
*
*       INPUT: see below
*
*      OUTPUT: just changes inputs
*
* CALLED FROM: Users VGetArgs routine
*
**************************************************************/
vget_logic(fd_ansr,prompt_flag,opt,opt_str,opt_logic,opt_default)
int	fd_ansr;	/* the file descriptor for the answer file */
int 	prompt_flag;	/* flag set to prompt user for input */
char	*opt;		/* the option to look for */
char 	*opt_str;	/* the string used to prompt the user with */
int 	*opt_logic;	/* the pointer to the logic to be returned */
int	opt_default;	/* the default logic value */
{
int	error;

    if (prompt_flag) vgparml(fd_ansr,opt,opt_str,opt_logic,0,0,&error);
    else vgparml(fd_ansr,opt,"noprompt",opt_logic,0,0,&error);

    if (error != 0)
    {
	*opt_logic = opt_default;

	if (khoros_verbose)
            fprintf(stderr,
                "%s: \"%s\" logic flag not used: Default is: \"%d\"\n",
                program,opt,*opt_logic);
	return(0);
    }
    return(1);
}

/**************************************************************
*
* MODULE NAME: vget_string
*
*     PURPOSE: used to get a string for a program
*
*       INPUT: see below
*
*      OUTPUT: just changes inputs
*
* CALLED FROM: Users VGetArgs routine
*
**************************************************************/
vget_string(fd_ansr,prompt_flag,opt,opt_str,opt_string,opt_default)
int	fd_ansr;	/* the file descriptor for the answer file */
int 	prompt_flag;	/* flag set to prompt user for input */
char	*opt;		/* the option to look for */
char 	*opt_str;	/* the string used to prompt the user with */
char 	**opt_string;	/* the pointer to the logic to be returned */
char 	*opt_default;	/* the default string */
{
char	buff[LENGTH];
int	error;

    if (prompt_flag) vgparms(fd_ansr,opt,opt_str,buff,0,0,&error);
    else vgparms(fd_ansr,opt,"noprompt",buff,0,0,&error);

    if ((error != 0) || (VStrlen(buff) == 0))
    {
        if (opt_default == NULL) 
           *opt_string = NULL;
        else
	   *opt_string = VStrcpy(opt_default);

	if (khoros_verbose)
            fprintf(stderr, "%s: \"%s\" string flag not used\n",
	        program,opt);
        if ((error == 0) && (*opt_string == NULL))  /* everything was ok */
	   return(1);
	else if (error == -1)
	   return(0);
	else return(1);
    }
    *opt_string = VStrcpy(buff);
    return(1);
}

/**************************************************************
*
* MODULE NAME: vwrite_ascii()
*
*     PURPOSE: used to get the print device or filename for ascii
*              printing.  This rountine should be used whenever
*              you are writing out anything but error messages
*              so that ascii output is done in a consistent way.
*              NOTE:  the file name has already been checked
*                     by Vget_Args in the main().
*
*       INPUT: outputfile - pointer to filename
*
*      OUTPUT: device - pointer to FILE pointer, returns the device
*              number for stdout, stderr or file.
*
* CALLED FROM: main() routines
*
**************************************************************/

int 
vwrite_ascii(output_file,device)
char	*output_file;
FILE	**device;
{

FILE	*fopen(),
	*printdev;

if (strcmp(output_file,"-") == 0) printdev = stdout;

   else if (strcmp(output_file,"#") == 0) printdev = stderr;

   else if ((printdev = fopen(output_file,"w")) == NULL) {
      fprintf(stderr,"Can't open output file: %s\n",output_file);
      return(0);   /*  Failure */
   }

*device = printdev;

return(1);   /*  Success */
}

/**************************************************************
*
* MODULE NAME: vread_ascii()
*
*     PURPOSE: used to get the print device or filename for ascii
*              printing.  This rountine should be used whenever
*              you are reading from an ascii file.
*              NOTE:  the file name has already been checked
*                     by Vget_Args in the main().
*
*       INPUT: input file - pointer to filename
*
*      OUTPUT: device - pointer to FILE pointer, returns the device
*              number for stdout or file.
*
* CALLED FROM: main() routines
*
**************************************************************/

int 
vread_ascii(input_file, device)
char	*input_file;
FILE	**device;
{

FILE	*fopen(),
	*printdev;

   if (strcmp(input_file,"-") == 0) printdev = stdin;
   else if (strcmp(input_file,"#") == 0) {
      fprintf(stderr,"Can't open stderr for reading\n");
      return(0);
   }
   else if ((printdev = fopen(input_file,"r")) == NULL) {
      fprintf(stderr,"Can't open input file: %s\n",input_file);
      return(0);   /*  Failure */
   }

*device = printdev;

return(1);   /*  Success */
}

int
check_access(filename,quit)
char *filename;
int quit;
  {
    if (kaccess(filename,R_OK|F_OK) != 0)
      {
        fprintf(stderr,"%s: Cannot access \"%s\" for reading\n",
		              program,filename);
	if (quit) exit(-1);
        else return(0);
      }
    return(1);
  }
