 /*
  * Khoros: $Id: tempnam.c,v 1.1 1991/05/10 15:41:06 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: tempnam.c,v 1.1 1991/05/10 15:41:06 khoros Exp $";
#endif

 /*
  * $Log: tempnam.c,v $
 * Revision 1.1  1991/05/10  15:41:06  khoros
 * Initial revision
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "vgparm.h"	


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: tempnam.c                              <<<<
   >>>>                                                       <<<<
   >>>>   description: File Utility                           <<<<
   >>>>                                                       <<<<
   >>>>      routines: vtempnam()			      <<<<
   >>>>                                                       <<<<
   >>>> modifications:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#define  TEMPLATE  "xvtemp"
#ifndef W_OK
#define W_OK 2
#endif

/**************************************************************
*
* MODULE NAME: vtempnam
*
*     PURPOSE: This module is used to create temporary files.
*	       The application program calls "vtempnam"
*	       with a template filename which is used to help
*	       identify the application routine.  If no template
*	       is given then TEMPLATE is used.
*
*       INPUT: 	template - template of the file to be created.
*
*      OUTPUT:  returns a unique temporary filename
*
* CALLED FROM:
*
* WRITTEN BY:  Mark Young
*
**************************************************************/


char  *vtempnam(template)

char *template;
{
        char    xvname[512], *temp, *filename, *directory, *getenv();

#ifndef TEMPNAM
	  int	 i, num_dirs = 3;
	  static char	*alternate_dirs[] = { ".", "/usr/tmp", "/tmp" };
	  char   path[512];
#endif


	if (template == NULL)
	   strcpy(xvname, TEMPLATE);
	else
           strcpy(xvname, template);

	/*
	 *  Want to seperate the *  directory (if any) from the actual
	 *  template filename.
	 */
        if ((temp = strrchr(xvname,'/')) != NULL)
	{
	   if (xvname != temp)
	      directory = xvname;
	   else
	      directory = VStrcpy("/");

	   *temp = '\0';
           filename = ++temp;
	}
	else
	{
           filename = xvname;
	   directory = ".";
	}

#ifndef TEMPNAM
	{
	  /*
	   *  Check to see if the user has overridden the directory with
	   *  TMPDIR.  If so that is the directory we wish to use.
	   */
	   if (getenv("TMPDIR"))
	      directory = getenv("TMPDIR");

           /* file named vroutine.xvXXXXXX */
           strcat(filename, ".xvXXXXXX");

	   /*
	    *  Check to see if we can create the file.
	    */
	   if (access(directory, W_OK) == -1)
	   {
	      for (i = 0; i < num_dirs; i++)
	      {
	         if (access(alternate_dirs[i], W_OK) == 0)
		 {
	            sprintf(path,"%s/%s", alternate_dirs[i], filename);
		    break;
		 }
	      } 

	      if (i == num_dirs)
	      {
	         (void) fprintf(stderr,"\nvtempnam: Cannot create temporary \
file %s.  Do not have write access to the directory.\n", template);
		 return(NULL);
	      }
	   }
	   else
	   {
	      if (strcmp(directory,"/") != 0)
	         sprintf(path,"%s/%s", directory, filename);
	      else
	         sprintf(path,"/%s", filename);
	   }
           mktemp(path);
	}
        return(VStrcpy(path));
#else
        temp = tempnam(directory, filename);
	if (temp == NULL)
	{
	   (void) fprintf(stderr,"\nvtempnam: Cannot create temporary \
file %s.\n", template);
	    return(NULL);
	}
        return(temp);
#endif
}
