 /*
  * Khoros: $Id: getarg_afile.c,v 1.1 1991/05/10 15:41:06 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: getarg_afile.c,v 1.1 1991/05/10 15:41:06 khoros Exp $";
#endif

 /*
  * $Log: getarg_afile.c,v $
 * Revision 1.1  1991/05/10  15:41:06  khoros
 * Initial revision
 *
  */ 

/******************************************************************

	Get Argument from Answer File 

	source filename:			get_arg_afile.c		

	revision	  date			programmer
	--------	  ----			----------
	   0.0		Jan-05-85		don hush

******************************************************************

	usage
	-----

	stat = get_arg_afile(fd,key,arg,type)

	int stat,fd;
	char *key,type;
	char *arg;

	#include "uio_defs"

	description
	-----------

	  This routine searches the answer file array for a
	match to the key. Once a match is found the string
	parameter is converted to the proper type according
	to 'type' ('i','f','l', or 's'). If no key is found 
	this routine returns a -1, otherwise it returns a 0.

******************************************************************/

#include "vgparm.h"

get_arg_afile(fd,key,arg,type)

int fd;
char *key,type;
char *arg;

{
	static int first=TRUE;
	char *sarg,*bin_search();
	char leftover[512];
	int err, loop;

	if (fd<0) return(-1);

	if (first) {
	    init_afile_args(fd);
	    first = FALSE;
	}

	sarg = bin_search(key);

	switch (type) {

	    case 'i':
		if (sarg!=NULL) {
		    if (!(isdigit(sarg[0]) || sarg[0] == '-' ||
		          sarg[0] == '+'))
		        return(-2);
		    for (loop = 1; loop < VStrlen(sarg); loop++)
			if (! isdigit(sarg[loop]))
			    return(-2);
		    *(int *) arg = atoi(sarg);
		    err = 0;
		}
		else {
		    *(int *) arg = 0;
		    return(-2);
		}
		break;

	    case 'f':
		if (sarg!=NULL) {
		    if (VStrlen(sarg) == 0)
			return(-2);
                    if (sscanf(sarg, "%f%s", (float *) arg, leftover) == 1)
			err = 0;
		    else
			return(-2);
		}
		else {
		    *(float *) arg = 0.0;
		    return(-2);
		}
		break;

	    case 'l':
		if (sarg!=NULL) {
		    *(int *) arg = TRUE;
		    switch (sarg[0]) {
		    	case 'n':
		    	case 'N':
		    	case 'f':
		    	case 'F':
		    	case '0':
		            *(int *) arg = FALSE;
		    }
		    err = 0;
		}
		else {
		    *(int *) arg = FALSE;
		    err = -1;
		}
		break;

	    case 's':
		if (sarg!=NULL) {
		    strcpy(arg, sarg);
		    err = 0;
		}
		else {
		    arg[0] = '\0';
		    err = -1;
		}
		break;
	}

	return(err);
}
