 /*
  * Khoros: $Id: daemon.c,v 1.2 1991/12/18 09:53:57 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: daemon.c,v 1.2 1991/12/18 09:53:57 dkhoros Exp $";
#endif

 /*
  * $Log: daemon.c,v $
 * Revision 1.2  1991/12/18  09:53:57  dkhoros
 * HellPatch3
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "vgparm.h"	
#include "transport.h"	


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>								<<<<
   >>>>	    file name: distrib_util.c				<<<<
   >>>>								<<<<
   >>>>   description: Distributed support utility		<<<<
   >>>>								<<<<
   >>>>      public routines:	   kstart_daemon		<<<<
   >>>>								<<<<
   >>>>      semi-public routines: daemon_command		<<<<
   >>>>								<<<<
   >>>> modifications:						<<<<
   >>>>								<<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/*
 *  The following are public routines that the user is allowed to call.
 *  There are utilities used by 
 *
 *	routines:	kstart_daemon
 */



/**************************************************************
*
* MODULE NAME: kstart_daemon
*
*     PURPOSE: This function is used to start a daemon process.
*
*       INPUT:
*
*      OUTPUT: returns the number of started deamons (-1 if an error
*	       occurs).
*
* CALLED FROM: daemon programs
*
*  WRITTEN BY:  Mark Young
*
**************************************************************/


int kstart_daemon(identifier, max_connections, timeout)

char *identifier;
int  max_connections;
int  timeout;
{
	DaemonInformation *routines;


	/*
	 *  According to the transport routines
	 */
	routines = daemon_routines(identifier);

	if (routines == NULL && identifier != NULL)
	{
	   (void) fprintf(stderr,"kstart_daemon: Unsupported transport...\n\n");
           (void) fprintf(stderr,"  Unable to find support for the following \
transport (%s).\n", identifier);
	   return(-1);
	}
	else if (routines == NULL)
	{
	   (void) fprintf(stderr,"\n\nkstart_daemon: Unable to find any remote \
transports...\n\n");
	   (void) fprintf(stderr,"  Unable to find any remote transports in \
which to start a daemon for.\nEither this machine doesn't have any such \
transports or they have\nnot been enabled for your machine.  Please check with \
the Khoros transport\ndocumentation or online Khoros manpage (transport.3) for \
more information.\n\n");
	   return(-1);
	}
	else if (routines->daemon == NULL)
	{
	   (void) fprintf(stderr,"kstart_daemon: Transport does not \
support remote transport...\n\n");
           (void) fprintf(stderr,"  Unable to start daemon since the following \
transport '%s' does not\nsupport remote daemons.  Please check with the Khoros \
transport documentation or\nor online Khoros manpage (transport.3) for more \
information.\n\n", identifier);
	   return(-1);
	}
	return(routines->daemon(max_connections, timeout));
}



/*
 *  The following are semiprivate routines and should *usually* not be called
 *  by the application programmer.  These routines are available for the
 *  more sophisticated application.  These routines are used as utilities
 *  by the public routines found in "daemon.c".  The reason why they are
 *  semi-public is that there maybe an occasion when the user needs a
 *  "daemon" routine like kstart_daemon(), but slightly different.  In which
 *  case may find these routines helpful.
 *
 *	routines:
 *			daemon_command
 */


/**************************************************************
*
* MODULE NAME: daemon_command(command)
*
*     PURPOSE: This function is used to process the command retrieved
*	       by a daemon process.
*
*       INPUT:
*
*      OUTPUT:
*
* CALLED FROM: various daemons
*
*  WRITTEN BY:  Mark Young
*
**************************************************************/


int daemon_command(command)

char *command;
{
}
