 /*
  * Khoros: $Id: checkargs.c,v 1.1 1991/05/10 15:41:06 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: checkargs.c,v 1.1 1991/05/10 15:41:06 khoros Exp $";
#endif

 /*
  * $Log: checkargs.c,v $
 * Revision 1.1  1991/05/10  15:41:06  khoros
 * Initial revision
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name:  checkargs.c                           <<<<
   >>>>                                                       <<<<
   >>>>   description: Command line utility                   <<<<
   >>>>                                                       <<<<
   >>>>      routines: check_args()			      <<<
   >>>>                                                       <<<<
   >>>> modifications:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/****************************************************************

	Routine Name: check_args()

	description
	-----------

	  This routine searches the command line for any
	arguments that have not been set to NULL. The 
	first argument is not looked at since it contains 
	the program name. If the command line contains any
	arguaments that have not been set to NULL an error
	message results.

	A an error occured then a 1 is returned.

*****************************************************************/

#include "vgparm.h"

extern int ac;
extern char **av;

int check_args()
{
	int	error, num;
	char	buff[LENGTH];

	(void) strcpy(buff, "");
	error = FALSE;
	
	for (num = 1; num < ac; num++)
	{
	    if (av[num] != NULL)
	    {
	       error = TRUE;
	       (void) strcat(buff, av[num]);
	       (void) strcat(buff, " ");
	    }
	}

	if (error)
	{
	   (void) fprintf(stderr, 
                         "\n%s: ERROR Invalid Arguments '%s'\n", av[0], buff);
	}
	return(error);
}
