 /*
  * Khoros: $Id: xvgraphics.h,v 1.1 1991/05/10 04:12:28 khoros Exp $
  */

 /*
  * $Log: xvgraphics.h,v $
 * Revision 1.1  1991/05/10  04:12:28  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 *
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1990 by UNM */

#ifndef	 _xvgraphics_h_
#define  _xvgraphics_h_

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                          <<<<
   >>>>      file: xvgraphics.h				         <<<<
   >>>>                                                          <<<<
   >>>>      contains:  all #defines, structures, and global     <<<<
   >>>>                 definitions used by the xvgraphics       <<<<
   >>>>			library					 <<<<
   >>>>                                                          <<<<
   >>>>      date: 4/6/88                                        <<<<
   >>>>                                                          <<<<
   >>>>      written by: Mark Young, Mike Lang                   <<<<
   >>>>                                                          <<<<
   >>>>      modifications:                                      <<<<
   >>>>                                                          <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */


/*
 * general utility matrix structures used by all routines
 */

#ifndef Real
typedef	 double	Real;
#endif

#ifndef Index
typedef	 unsigned long Index;
#endif

typedef  Real	Matrix[4][4];
typedef  Real	Matrix_2D[3][3];

/*
 * general utility vector structures used by all routines:
 * note: the difference between a "vector" here and the 
 * identical "coord" structure that follows is that a 
 * "vector" has a direction associated with it, while a 
 * "coord" implies a mathematical point.
 */
typedef  struct
	 { 
		   Real x, y, z;
	 }  Vector;


/*
 * general utility point coordinate  structures used by all routines
 * note: the difference between a "coord" here and the 
 * identical "vector" structure above is that a 
 * "coord" implies a mathematical point, while
 * "vector" has a direction associated with it. 
 */
typedef  struct
	 {
		   Real  x, y, z;
		   Index d;
	 }  Coord;


/*
 *  Defines for the type of Coordinate system
 *  (Two or Three dimensions).
 */
#define X2D		2
#define X3D		3

/*
 *  Defines for default monochrome colors 
 */
#define X3D_WHITE  0
#define X3D_BLACK  1

/*
 *  3D Plot types used by graphics library
 */
#define UNDEFINED	0
#define PLOT_3D		1
#define PLOT_MESH	2
#define PLOT_SCATTER	3
#define PLOT_CONTOUR_3D	4
#define PLOT_CONTOUR_2D	5
#define PLOT_IMPULSE	6
#define PLOT_SURFACE	7
#define PLOT_HORIZON	8
#define PLOT_COLORMESH  9
#define PLOT_WIREFRAME  10
#define PLOT_3D_BEZIER  11
#define PLOT_SURFACE_BEZIER  12
#define PLOT_RENDERED_BEZIER 13


/*
 *  2D Plot types used by graphics library
 */
#define PLOT_2D		20
#define PLOT_DISCRETE	21
#define PLOT_HISTOGRAM	22
#define PLOT_POLYMARKER	23
#define PLOT_LINEMARKER	24


/*
 *  Defines for the type of 3D projection system
 */
#define Perspective	1
#define Orthographic	2
#define Cavalier	3
#define Cabinet		4

/*
 *  Defines for the type of 3D Coordinate orientation
 *  (left-handed .vs. right-handed).
 */
#define LeftHanded	1
#define RightHanded	2

/*
 *  Defines for text string justification.
 */
#define LeftJustify	1
#define CenterJustify	2
#define RightJustify	3

/*
 *  Defines for the type of font.
 */
#define DefaultFont	"DoubleRoman"
#define SimplexRoman	"SimplexRoman"
#define ComplexRoman	"ComplexRoman"
#define TimesRoman	"TimesRoman"
#define DoubleRoman	"DoubleRoman"
#define ComplexItalics	"ComplexItalics"
#define TimesItalics	"TimesItalics"
#define Symbols		"Symbols"

/*
 *  Defines for the type of marker.
 */
#define MarkerSquare	 1
#define MarkerTriangle	 2
#define MarkerCross	 3
#define MarkerBowTie	 4
#define MarkerArc	 5
#define MarkerDiamond	 6
#define MarkerCircle	 7
#define MarkerV		 8
#define MarkerHexagon	 9
#define MarkerX		10
#define MarkerDot	11
#define MarkerCaret	12
#define MarkerPoint	13
#define MarkerDagger	14
#define MarkerBox	15

/*
 *  Defines for the line width.
 */

#define ExtraFine	0
#define Fine		1
#define MediumFine	2
#define	Medium		3
#define MediumWide	4
#define	Wide		5
#define ExtraWide	6
/*
 *  Defines for the line type.
 */
#define Solid		1
#define Dotted		2
#define DotDash		3
#define ShortDash	4
#define LongDash	5
#define OddDash		6
#define Grid_Dotted     7

/*
 *  Defines for the scale type
 */
#define LINEAR		1
#define LOG10		2
#define LN		3

#endif /* _xvgraphics_h_ */
/*  Don't add after endif  */
