 /*
  * Khoros: $Id: xvforms.h,v 1.3 1991/12/18 08:53:21 dkhoros Exp $
  */

 /*
  * $Log: xvforms.h,v $
 * Revision 1.3  1991/12/18  08:53:21  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 *
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */
#include "unmcopyright.h"        /* Copyright 1990 by UNM */

#ifndef _xvforms_h_
#define _xvforms_h_

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                          <<<<
   >>>>      file: xvforms.h                                     <<<<
   >>>>                                                          <<<<
   >>>>      contains:  all #defines, structures, and global     <<<<
   >>>>                 definitions and routine declarations     <<<<
   >>>>			used by the xvforms library		 <<<<
   >>>>                                                          <<<<
   >>>>      written by: Danielle Argiro & Stephanie Hallett     <<<<
   >>>>                                                          <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "xvlineinfo.h"

/*
 *    The following structures link together the information needed to 
 *  create and maintain the form.  The following is a diagram of the flow of
 *  a form with 2 "true" guide buttons on the guide pane (i.e., they will
 *  change the pane on the form when clicked on) and 2 other buttons
 *  (e.g. "help" and "quit"). The "true" guide buttons have pointers to
 *  their respective panes, which have linked lists of the selections 
 *  which will appear on them. Each structure has pointers to appropriate
 *  widgets. Selections and guide buttons (whose entries in the database
 *  will change during a run) have access to the database through the index
 *  into the database marking the line from which they originated, and
 *  which must be updated.  
 *      Selections, guide buttons, and forms each have an id number; 
 *  the id for the form is passed into the XVFORMS software by the 
 *  application program.  ID's of guide buttons  and selections
 *  are assigned according to the order in which they appear in the database. 
 *  Panes do not need an id as they can always be accessed through the 
 *  guide_button structure.
 *  
 *	      Form ---> "true" subform ------------------
 *			     |				|
 *			     V				|
 *			 "true" subform             	|
 *			     |		          	|
 *			     V		          	|
 *			 button on Master	  	|
 *			     |			  	|
 *			     V			  	|
 *			 button on Master	  	|
 *						  	|
 *	                                                |
 *	  						|
 *          ---------------------------------------------
 *	    |
 *	    |
 *	    |
 *	    |--> "true" guide button ----------> pane ------> selection 
 *        	     |                                          |
 *        	     V                                          V
 *	         "true" guide button ---> pane -> selection   selection
 *	  	     |                               |          | 
 *	  	     V                               V          V
 *		 button on guide pane             selection    selection
 *		     |                               |
 *		     V                               V
 *		 button on guide pane             selection
 */


/*****  update structures ******/

typedef struct _update_input {  /* SSS added after danielle */
   int          index;          /* index of db line of input */
   time_t       last_time;      /* last time updated */
   struct _update_input *next;         /* next input in list */
}  UpdateInput;

typedef struct _update {        /* SSS added after danielle */
   int          time;           /* time to update */
   UpdateInput  *input_list;    /* list of inputs to check */
   Widget       widget;         /* widget to highlight */
 Pixel        bg,fg;          /* normal colors of widget */
   XtIntervalId interval_id;    /* running timer */
   int          count;          /* counts twice before actual update */
} Update;


/****** structure for bookkeeping mutually exclusive groups ********/

typedef struct _mut_excl_group {  
   int          index;      /* index of db line of mut. excl. selection */
   int		type;       /* only one type so far: MutExcl  */
   struct _mut_excl_group *next;         /* next input in list */
}  mut_excl_link;

/***********	xvf_selection   structure ******/

typedef struct selection {
	int	      sel_num;	     /* id number of selection */
	Widget	      back;          /* the back plane of the selection */
	char 	      *back_name;     /* name of back plane */

	Widget	      value_widget;   /* the value widget of the selection */
	char          *value_name;     /* name of value widget */

	Widget	      opt_widget;     /* the optional widget of selection */
	char          *opt_name;      /* name of opt widget */
        int	      opt_selected;   /* tells if options button in selected */

	Widget        label_widget;  /* the label widget of the selection */
	char          *label_name;    /* name of label widget */

	Widget	      scroll;        /* scroll bar of integer or float */

	int	      index;         /* index that marks the line in the
					database that produced this 
					selection (-I,-O,-i,-f,-T...)*/

	int	      guide_num;     /* id number of guide button corresponding
					to the pane this selection is on */

	char	      *buffer;	     /* (if an ascii text widget)
					buffer containing the string
					representing the string, int,
					float, etc */
        int	      modified;	    /* tells autorun if needs to be run */
        int           toggle_int;   /* this int describes which
					option is currently selected
					(starts 1,2,3,...)         */

        int	      selected;     /* if selection is "live" - a logical,
				       toggle, int scroll bar or float
					scroll bar - will be set to true when
					user activates selection */
	struct selection *toggle_next;
				     /* (if a toggle selection)
					points to a list of all of
					the possible options in the
					toggle 			   */

	int	      mut_excl;	     /* true if this selection is mutually
					exclusive with any other selection */
	int	      mut_excl_id; /*   if this selection is mutually
					exclusive with any other selection,
					identifies which array i of the 
					mut_exclusion[i][j] array of the 
					pane structure is applicable */

	struct selection *next;  /* pointer to the next selection */


	} xvf_selection;


/***********	xvf_pane  structure *****/

typedef struct {
	Widget        label_widget; /* label widget for the pane */
	char          *label_name;   /* name of label widget */

	Widget        back;       /* the backplane of the pane */ 
	char          *back_name;  /* name of label widget */

	Widget        guide;	   /* the guide button assoc. w/ pane */
	char          *guide_button_name; /* name of label widget */
        int           guide_num;   /* id number of pane's guide button */

	int 	      index;       /* index that marks the line in the 
				      database that produced this pane 
				      (-P) */
	int	      count;	   /* number of times pane is activated */

	mut_excl_link *mut_exclusion[20];  /* allows up to 20 mutually 
					      exclusive groups on a pane,
					      each group a list of indexes
					      of the selections in the group.
					    */

	xvf_selection *sel_list;   /* pointer to hdr of selection list */

	} xvf_pane;



/***********	xvf_guide_button  structure *****/

typedef struct guide_button {
	     Widget   button;       /* guide button on guide pane of subform */
	     char    *button_name; /* name of label widget */
	     Widget   label;

	        int  type;	    /* type of guide button this is */
		int  selected;	    /* tells if button currently selected */

	        int  index;         /* index that marks the line in the
					database that produced this 
					selection (-g) */

	        int  guide_num;     /* id number of guide button */

	   xvf_pane  *pane;         /* the associated pane structure  */

struct  guide_button *next_button;  /* the pointer to the next guide button */

	} xvf_guide_button;



/*****	xvf_sub_form  structure ******/

typedef struct sub_form{
	Widget     toplevel;		/* toplevel widget of the subform */
	char      *toplevel_name; 	/* name of label widget */

	Widget    button;		/* button on the master that activates
					   subform or does an action */
	char      *button_name;	
	int	  button_index;		/* index into database of corresponding
					   (-d) line            */

	Widget     back; 		/* backplane of the subform */
	char      *back_name;

	Widget     label;  		/* title of the subform */
	char      *label_name;

	Widget     guide_back; 		/* backplane of the guide pane */
	char      *guide_back_name; 
	Widget     guide_label; 	/* title of the guide pane */
	int	   guide_index; 	/* index of -G line */
	char      *guide_label_name;

	char	  **db;			/* pointer to the internal database */
	int	  glyph_state;		/* 0 = form, 1 = glyph */
	int	  glyph_type;   	/* NONE, SIMPLE,... */
        Widget    glyph_toplevel; 	/* toplevel glyph needed to map */
	char      *glyph_top_name; 
	Widget	  glyph_wid;		/* used to glyphify form (wid on form)*/
	char      *glyph_wid_name;
	caddr_t   glyph_info;		/* glyph's info structure (different
				    	   structure for different glyphs) */

 xvf_guide_button *guide_button;	/* pointer to hdr of guide list */
	int	  selected;		/* is this subform selected ? */
	int	  type;			/* is this a true subform or a first
					   action button, help or quit? */

	char      *subform_name;	/* name of subform (on single line) */
	int       subform_sel;		/* tells if this form set FORM_DONE */
        int       count;		/* number of times form is activated */
	int	  index;		/* index into database of -M line */

	int	  submenu;		/* flag used to indicate if this subform
					   a subform item */

	int	  quit;			/* this flag TRUE when subform exits */
struct sub_form   *next_subform;        /* pointer to the next subform struct */

	} xvf_sub_form;



/*****	xvf_form  structure ******/

typedef struct {
	Widget    toplevel;	/* the toplevel widget of the form */
	char      *toplevel_name;

	Widget    back; 	/* the backplane of the form */
	char      *back_name;

	Widget    label;  /* the title of the form */
	char      *label_name;

	char      *form_name;	/* name of form (on single line) */
	int       form_sel;	/* tells if this form set FORM_DONE */

 xvf_sub_form 	  *subform;	/* pointer to hdr of list subform structures */

	int 	  subform_num;  /* number of subforms on this form */
        int       count;	/* number of times form is activated */
	int	  index;	/* index into database of -F line */

	char	  **db;		/* pointer to the internal database */
	int	  line_num;	/* number of lines in the database */
	int	  db_size;	/* allocated size of the database */

	Update	  *update;	/* update structure for routine exec */
	int	  glyph_state;	/* 0 = form, 1 = glyph */
	int	  glyph_type;   /* NONE, SIMPLE,... */
        Widget    glyph_toplevel; /* toplevel glyph needed to map */
	char      *glyph_top_name;
	Widget	  glyph_wid;	/* used to glyphify form (wid on form)*/
	char      *glyph_button_name;
	caddr_t   glyph_info;	/* glyph's info structure (different
				   structure for different glyphs) */

	int	  mut_excl;     /* are subforms mutually exclusive? */
	int	  quit;		/* flag used for xvf_show to know when to
				   exit */

	} xvf_form;



/**********  glyph defines and structures ****/

#define		ICON		-1
#define		NONE		 0
#define		SIMPLE		 1


typedef struct _simple_glyph_stat {

   Widget   toplevel;
   char     *label_str;
   Widget   do_form;		/* used to bring back form */

} S_Glyph;



/*
 *  General defines for Forms
 */

#undef true
#define true 1

#undef false
#define false 0


/*
 *  Variable to hold Global Environment stuff
 */
int     XVF_ECHO_CMD;
int	XVF_EXPRESSION;
char    *PROG_NAME;
int     JP_PLAY;
int     JP_REC;
int	JP_TMP_HALT;  /* used by outside programs stop reading events */


/*
 * These are defines that we will need after we change the forms
 * to use multiple displays, multiple app_contexts
 *
 *  #define xvf_display(form)  (form->display);
 *  #define xvf_app_context(form)  (form->app_context);
 */

/*
 *  Routines to help Application Program to use Forms
 */
	Display *xvf_initialize();

/*
 *  Routines to create and run Forms
 */
	xvf_form *xvf_create_form();
	xvf_form *xvf_run_form();
	xvf_form *xvf_build_form();
	int   run_form_wait();
	char **xvf_read_database();


/*
 *  Routines to allow Application Program to change Forms
 */

	int xvf_change_selection();
	int xvf_change_input();

/*
 * Utilities
 */
        xvf_selection      *xvf_sel_search();
        xvf_guide_button   *xvf_guide_search();
        xvf_pane           *xvf_pane_search();
        xvf_sub_form       *xvf_subform_search();
        xvf_sub_form       *xvf_subform_button_search();
        xvf_sub_form       *xvf_find_sels_subform();
        xvf_guide_button   *xvf_find_sels_guide();

        xvf_guide_button   *xvf_search_sel_guide();
        xvf_guide_button   *xvf_search_sel_subform_action();
        xvf_sub_form       *xvf_search_sel_master_action();

        Widget 		   xvf_form_create_glyph_sel();
        Widget             xvf_subform_create_glyph_sel();
        caddr_t            xvf_create_form_glyph();
        caddr_t            xvf_create_subform_glyph();

	char 		   *form2command();
	int 		    xvf_fork_routine();



/*
 *  Form manipulation routines
 */

	xvf_form *xvf_begin_form();

        int xvf_add_subform();
        int xvf_delete_subform();

        char **xvf_add_subform_to_db();
        char **xvf_delete_subform_from_db();

        int xvf_add_subform_to_form();
        int xvf_delete_subform_from_form();

        xvf_sub_form *xvf_copy_and_add_subform();
        char **xvf_copy_database();

/*
 * Change Codes:  indicate the type of change that the application
 *  		  program wishes to make to the form
 *		  note: "sel" means a "selection"
 *
 */

#define xvf_no_chng 		   0  /* not making a change */
#define xvf_title_chng  	   1  /* change a title on a -> selection */
#define xvf_intval_chng  	   2  /* change int value on int sel */
#define xvf_floatval_chng  	   3  /* change float value on float sel */
#define xvf_stringval_chng  	   4  /* change string val on string sel */
#define xvf_toggleval_chng  	   5  /* change toggle val on toggle sel */
#define xvf_logicalval_chng  	   6  /* change logical val on logical sel */ 
#define xvf_activation_chng  	   7  /* change activate field on any sel */
#define xvf_guide_chng		   8  /* change guide button now selected */
#define xvf_optsel_chng		   9  /* change optional selection on/off */
#define xvf_inputfile_chng	   10 /* change input file on infile sel */
#define xvf_outputfile_chng	   11 /* change output file on outfile sel */
#define xvf_subform_chng	   12  /* change a subform on/off NOT DONE*/
#define xvf_width_chng	   	   13  /* change the width of a selection */
#define xvf_height_chng	   	   14  /* change the height of a selection */
#define xvf_x_chng	  	   15  /* change x position of selection */
#define xvf_y_chng	   	   16  /* change y position of selection */
#define xvf_xpos_chng	   	   17  /* change x position of title */
#define xvf_ypos_chng	   	   18  /* change y position of title */
#define xvf_cycleval_chng	   19  /* change value of cycle */
#define xvf_ansinfile_chng	   20  /* change input answer file */
#define xvf_ansoutfile_chng	   21  /* change output answer file */

/*
 *  Routines called by xvf_change_input 
 *  individual change_line routines
 */ 

	int xvf_change_startform_line(),
	    xvf_change_startsubform_line(),
	    xvf_change_startpane_line(),
	    xvf_change_startguide_line(),
	    xvf_change_inputfile_line(),
	    xvf_change_outputfile_line(),
	    xvf_change_int_line(),
	    xvf_change_float_line(),
	    xvf_change_string_line(),
	    xvf_change_toggle_line(),
	    xvf_change_logic_line(),
	    xvf_change_cycle_line(),
	    xvf_change_subformbutton_line(),
	    xvf_change_guidebutton_line(),
	    xvf_change_master_action_line(),
	    xvf_change_subform_action_line(),
	    xvf_change_pane_action_line(),
	    xvf_change_help_line(),
	    xvf_change_quit_line(),
	    xvf_change_routine_line(),
	    xvf_change_ansinfile_line(),
	    xvf_change_ansoutfile_line(),
	    xvf_change_blank_line();

/*
 *  utility routines provided by xvforms
 *  for use by application programs
 */ 

	char *xvf_query_sel_title();

#endif /* _xvforms_h_ */
/* Don't add after this line */
