 /*
  * Khoros: $Id: lvtexture.h,v 1.1 1991/05/10 04:15:50 khoros Exp $
  */

 /*
  * $Log: lvtexture.h,v $
 * Revision 1.1  1991/05/10  04:15:50  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                           <<<<
   >>>>	    file name: lvtexture.h                                <<<<
   >>>>                                                           <<<<
   >>>>      contains: This include file specifies all of the LAW <<<<
   >>>>                microtexture masks.  The masks are derived <<<<
   >>>>                from the 5 center-weighted vectors spec-   <<<<
   >>>>		       ified by K. I. Laws (Proc. SPIE vol. 238,  <<<<
   >>>>                1980).  The 5 center-weighted vectors are: <<<<
   >>>>                                                           <<<<
   >>>>			L5 = [ 1  4  6  4  1]                     <<<<
   >>>>			E5 = [-1 -2  0  2  1]                     <<<<
   >>>>			S5 = [-1  0  2  0 -1]                     <<<<
   >>>>			W5 = [-1  2  0 -2  1]                     <<<<
   >>>>			R5 = [ 1 -4  6 -4  1]                     <<<<
   >>>>                                                           <<<<
   >>>>      written by:  Charlie Gage, Tom Sauer	          <<<<
   >>>>                                                           <<<<
   >>>>      date: 5/22/90                                        <<<<
   >>>>                                                           <<<<
   >>>>      modifications:				          <<<<
   >>>>                                                           <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _lvtexture_h_
#define _lvtexture_h_


typedef int texture_mask[25];

texture_mask L5L5_m = { 1,   4,   6,   4,   1,
		        4,  16,  24,  16,   4,
		        6,  24,  36,  24,   6,
		        4,  16,  24,  16,   4,
	     	        1,   4,   6,   4,   1 };
		
texture_mask L5E5_m = {-1,  -2,   0,   2,   1,
	      	       -4,  -8,   0,   8,   4,
		       -6, -12,   0,  12,   6,
  		       -4,  -8,   0,   8,   4,
		       -1,  -2,   0,   2,   1 };
		
texture_mask L5S5_m = {-1,   0,   2,   0,  -1,
		       -4,   0,   8,   0,  -4,
		       -6,   0,  12,   0,  -6,
		       -4,   0,   8,   0,  -4,
		       -1,   0,   2,   0,  -1 };
		
texture_mask L5W5_m = {-1,   2,   0,  -2,   1,
	  	       -4,   8,   0,  -8,   4,
		       -6,  12,   0, -12,   6,
		       -4,   8,   0,  -8,   4,
		       -1,   2,   0,  -2,   1 };
		
texture_mask L5R5_m = { 1,  -4,   6,  -4,   1,
		        4, -16,  24, -16,   4,
		        6, -24,  36, -24,   6,
		        4, -16,  24, -16,   4,
		        1,  -4,   6,  -4,   1 };
		
texture_mask E5L5_m = {-1,  -4,  -6,  -4,  -1,
		       -2,  -8, -12,  -8,  -2,
		        0,   0,   0,   0,   0,
		        2,   8,  12,   8,   2,
		        1,   4,   6,   4,   1 };
		
texture_mask E5E5_m = { 1,   2,   0,  -2,  -1,
		        2,   4,   0,  -4,  -2,
		        0,   0,   0,   0,   0,
		       -2,  -4,   0,   4,   2,
		       -1,  -2,   0,   2,   1 };
		
texture_mask E5S5_m = { 1,   0,  -2,   0,   1,
		        2,   0,  -4,   0,   2,
		        0,   0,   0,   0,   0,
		       -2,   0,   4,   0,  -2,
		       -1,   0,   2,   0,  -1 };
		
texture_mask E5W5_m = { 1,  -2,   0,   2,  -1,
		        2,  -4,   0,   4,  -2,
		        0,   0,   0,   0,   0,
		       -2,   4,   0,  -4,   2,
		       -1,   2,   0,  -2,   1 };
		
texture_mask E5R5_m = {-1,   4,  -6,   4,  -1,
		       -2,   8, -12,   8,  -2,
		        0,   0,   0,   0,   0,
		        2,  -8,  12,  -8,   2,
		        1,  -4,   6,  -4,   1 };
		
texture_mask S5L5_m = {-1,  -4,  -6,  -4,  -1,
		        0,   0,   0,   0,   0,
		        2,   8,  12,   8,   2,
		        0,   0,   0,   0,   0,
		       -1,  -4,  -6,  -4,  -1 };
		
texture_mask S5E5_m = { 1,   2,   0,  -2,  -1,
		        0,   0,   0,   0,   0,
		       -2,  -4,   0,   4,   2,
		        0,   0,   0,   0,   0,
		        1,   2,   0,  -2,  -1 };
		
texture_mask S5S5_m = { 1,   0,  -2,   0,   1,
		        0,   0,   0,   0,   0,
		       -2,   0,   4,   0,  -2,
		        0,   0,   0,   0,   0,
		        1,   0,  -2,   0,   1 };
		
texture_mask S5W5_m = { 1,  -2,   0,   2,  -1,
	  	        0,   0,   0,   0,   0,
		       -2,   4,   0,  -4,   2,
		        0,   0,   0,   0,   0,
		        1,  -2,   0,   2,  -1 };
		
texture_mask S5R5_m = {-1,   4,  -6,   4,  -1,
		        0,   0,   0,   0,   0,
		        2,  -8,  12,  -8,   2,
		        0,   0,   0,   0,   0,
		       -1,   4,  -6,   4,  -1 };
		
texture_mask W5L5_m = {-1,  -4,  -6,  -4,  -1,
		        2,   8,  12,   8,   2,
		        0,   0,   0,   0,   0,
		       -2,  -8, -12,  -8,  -2,
		        1,   4,   6,   4,   1 };
		
texture_mask W5E5_m = { 1,   2,   0,  -2,  -1,
		       -2,  -4,   0,   4,   2,
		        0,   0,   0,   0,   0,
		        2,   4,   0,  -4,  -2,
		       -1,  -2,   0,   2,   1 };
		
texture_mask W5S5_m = { 1,   0,  -2,   0,   1,
		       -2,   0,   4,   0,  -2,
		        0,   0,   0,   0,   0,
		        2,   0,  -4,   0,   2,
		       -1,   0,   2,   0,  -1 };
		
texture_mask W5W5_m = { 1,  -2,   0,   2,  -1,
		       -2,   4,   0,  -4,   2,
		        0,   0,   0,   0,   0,
		        2,  -4,   0,   4,  -2,
		       -1,   2,   0,  -2,   1 };
		
texture_mask W5R5_m = {-1,   4,  -6,   4,  -1,
		        2,  -8,  12,  -8,   2,
		        0,   0,   0,   0,   0,
		       -2,   8, -12,   8,  -2,
		        1,  -4,   6,  -4,   1 };
		
texture_mask R5L5_m = { 1,   4,   6,   4,   1,
		       -4, -16, -24, -16,  -4,
		        6,  24,  36,  24,   6,
		       -4, -16, -24, -16,  -4,
		        1,   4,   6,   4,   1 };
		
texture_mask R5E5_m = {-1,  -2,   0,   2,   1,
		        4,   8,   0,  -8,  -4,
		       -6, -12,   0,  12,   6,
		        4,   8,   0,  -8,  -4,
		       -1,  -2,   0,   2,   1 };
		
texture_mask R5S5_m = {-1,   0,   2,   0,  -1,
	  	        4,   0,  -8,   0,   4,
		       -6,   0,  12,   0,  -6,
		        4,   0,  -8,   0,   4,
		       -1,   0,   2,   0,  -1 };
		
texture_mask R5W5_m = {-1,   2,   0,  -2,   1,
		        4,  -8,   0,   8,  -4,
		       -6,  12,   0, -12,   6,
		        4,  -8,   0,   8,  -4,
		       -1,   2,   0,  -2,   1 };
		
texture_mask R5R5_m = { 1,  -4,   6,  -4,   1,
		       -4,  16, -24,  16,  -4,
		        6, -24,  36, -24,   6,
		       -4,  16, -24,  16,  -4,
		        1,  -4,   6,  -4,   1 };
		

#endif
/* Don't add after the endif */
