/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: Fdat2viff.h
 >>>>            Author: Donna Koechner
 >>>> Date Last Updated: Mon Apr 15 22:31:30 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _Fdat2viff_h_
#define _Fdat2viff_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    Fdat2viff Argument Structure
*
****************************************************************/

typedef struct _Fdat2viff  {

/*
 *  input raw .DAT data file (Required infile)
 */
char	*i_file;	/* input raw .DAT data file FILENAME */
int	 i_flag;	/* input raw .DAT data file FLAG */

/*
 *  complex output image (viff file) (Optional outfile)
 */
char	*o1_file;	/* complex output image (viff file) FILENAME */
int	 o1_flag;	/* complex output image (viff file) FLAG */

/*
 *  real output image filename (Optional outfile)
 */
char	*o2_file;	/* real output image filename FILENAME */
int	 o2_flag;	/* real output image filename FLAG */

/*
 *  imaginary output image filename (Optional outfile)
 */
char	*o3_file;	/* imaginary output image filename FILENAME */
int	 o3_flag;	/* imaginary output image filename FLAG */

/*
 *  number of rows (Optional integer)
 */
int	 r_int; 	/* number of rows INT */
int	 r_flag;	/* number of rows FLAG */

/*
 *  number of columns (Optional integer)
 */
int	 c_int; 	/* number of columns INT */
int	 c_flag;	/* number of columns FLAG */

/*
 *  number of points/voxel (bands) (Optional integer)
 */
int	 b_int; 	/* number of points/voxel (bands) INT */
int	 b_flag;	/* number of points/voxel (bands) FLAG */

/*
 *  byte offset from the start of the input data file (Optional integer)
 */
int	 h_int; 	/* byte offset from the start of the input data file INT */
int	 h_flag;	/* byte offset from the start of the input data file FLAG */

/*
 *  Extract only one voxel vector (1 = yes, 0 = no) (Optional logical)
 */
int	 s_logic;	/* Extract only one voxel vector (1 = yes, 0 = no) LOGIC */
int	 s_flag;  	/* Extract only one voxel vector (1 = yes, 0 = no) FLAG */

/*
 *  vertical offset of voxel (Optional integer)
 */
int	 x_int; 	/* vertical offset of voxel INT */
int	 x_flag;	/* vertical offset of voxel FLAG */

/*
 *  horizontal offset of voxel (Optional integer)
 */
int	 y_int; 	/* horizontal offset of voxel INT */
int	 y_flag;	/* horizontal offset of voxel FLAG */

}  Fdat2viff_struct;

Fdat2viff_struct *Fdat2viff;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
