/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vexpwarp.c
 >>>>
 >>>>      Program Name: vexpwarp
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Perform geometric transformation (warp) using  symbolic  ex-
 >>>>	pression
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Tue Apr 16 14:17:56 1991
 >>>>
 >>>>          Routines: main- the main program for vexpwarp
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vexpwarp.h"


/****************************************************************
 *
 * Routine Name:  main program for vexpwarp
 *
 *       Input:  
 *          -i  input image 
 *          -o  output image 
 *
 *          -xmap  X map function    -OR-
 *          -ix  X map function file
 *          -ymap  Y map function    -OR-
 *          -iy  Y map function file
 *
 *          [-x] x coordinate of center-of-action 
 *          [-y] y coordinate of center-of-action 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *image;
        char xmap[2048],ymap[2048];
        FILE *f;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);
        image = readimage(vexpwarp->i_file);
        if (image == NULL) exit(1);                 /* Quit if bad image */
        if (vexpwarp->ix_flag )
          {
            f = fopen(vexpwarp->ix_file,"r");
            if (f == NULL)
              {
                fprintf(stderr,"vexpwarp: unable to read x map function file\n");
                exit(1);
              }
            fscanf(f,"%s",xmap);
            fclose(f);
          }
        else
          strcpy(xmap,vexpwarp->xmap_string);

        if (vexpwarp->iy_flag )
          {
            f = fopen(vexpwarp->iy_file,"r");
            if (f == NULL)
              {
                fprintf(stderr,"vexpwarp: unable to read y map function file\n");
                exit(1);
              }
            fscanf(f,"%s",ymap);
            fclose(f);
          }
        else
          strcpy(ymap,vexpwarp->ymap_string);

        CHECKINPUT(program,image); /* Verify input */
/* -main_before_lib_call_end */

/* -main_library_call */
            if(!lvexpwarp(image,xmap,ymap,vexpwarp->x_float,vexpwarp->y_float))
              {
                (void) fprintf(stderr, "lvexpwarp Failed\n");
                exit(1);
              }
/* -main_library_call_end */

/* -main_after_lib_call */
        writeimage(vexpwarp->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vexpwarp 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vexpwarp :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tPerform geometric transformation (warp) using  symbolic  ex-\n");
	fprintf(stderr, "\tpression\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t-xmap  X map function  (string) -OR- \n");
	fprintf(stderr,"\t-ix  X map function file  (infile) \n");
	fprintf(stderr,"\t-ymap  Y map function  (string) -OR- \n");
	fprintf(stderr,"\t-iy  Y map function file  (infile) \n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-x]  x coordinate of center-of-action (float) [0]\n");
	fprintf(stderr,"\t[-y]  y coordinate of center-of-action (float) [0]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vexpwarp\n");
	fprintf(stderr, "\t[-U] Gives the usage for vexpwarp\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vexpwarp.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vexpwarp.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vexpwarp
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char	*xmap_pstr = 
	"\nEnter: (xmap) X map function \n        {string ['x'] }: "; 
char	*xmap_def = "x";
char	*ix_pstr = 
	"\nEnter: (ix) X map function file \n        {infile}: "; 
char	*ymap_pstr = 
	"\nEnter: (ymap) Y map function \n        {string ['y'] }: "; 
char	*ymap_def = "y";
char	*iy_pstr = 
	"\nEnter: (iy) Y map function file \n        {infile}: "; 
char	*x_pstr = 
	"\nEnter: (x) x coordinate of center-of-action \n        {float [0.000000] }: "; 
char	*y_pstr = 
	"\nEnter: (y) y coordinate of center-of-action \n        {float [0.000000] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vexpwarp", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vexpwarp.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vexpwarp: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vexpwarp.ans");
		}

	     }

	}

	/*
	 * allocate the vexpwarp structure
	 */
	vexpwarp = (vexpwarp_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vexpwarp_struct));

	/*
	 * get required arguments for vexpwarp
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vexpwarp->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vexpwarp->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vexpwarp->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vexpwarp->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vexpwarp->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vexpwarp->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vexpwarp->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vexpwarp->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vexpwarp->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vexpwarp->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get required mutually exclusive groups for vexpwarp
	 */
	if (prompt_flag == TRUE)
	{
		   fprintf(stderr, "\nThe following prompts are mutually exclusive.\n");
		   fprintf(stderr, "\nHit <cr> until the desired prompt appears.\n");
	   ok = FALSE;
	   while(!ok)
	   {
		vexpwarp->xmap_flag = vget_string(fid, prompt_flag,
		    "-xmap", xmap_pstr, &(vexpwarp->xmap_string),
		    xmap_def);

    		if(!( (vexpwarp->xmap_flag)))
		    vexpwarp->ix_flag = vget_infile(fid, prompt_flag,
		    "-ix", ix_pstr, &(vexpwarp->ix_file))
;

		if((vexpwarp->xmap_flag)|| 
		    (vexpwarp->ix_flag))
		    ok = TRUE;
		else
		{
		   fprintf(stderr, "Error: You MUST specify one of :\n");
		    fprintf(stderr, " -xmap  -ix \n");
		}
	   }
	   ok = FALSE;
	   while(!ok)
	   {
		vexpwarp->ymap_flag = vget_string(fid, prompt_flag,
		    "-ymap", ymap_pstr, &(vexpwarp->ymap_string),
		    ymap_def);

    		if(!( (vexpwarp->ymap_flag)))
		    vexpwarp->iy_flag = vget_infile(fid, prompt_flag,
		    "-iy", iy_pstr, &(vexpwarp->iy_file))
;

		if((vexpwarp->ymap_flag)|| 
		    (vexpwarp->iy_flag))
		    ok = TRUE;
		else
		{
		   fprintf(stderr, "Error: You MUST specify one of :\n");
		    fprintf(stderr, " -ymap  -iy \n");
		}
	   }
		   fprintf(stderr, "\n ------\n");
	}
	else
	{
		count = 0;
		if(vexpwarp->xmap_flag = vget_string(fid, prompt_flag,
		    "-xmap", xmap_pstr, &(vexpwarp->xmap_string),
		    xmap_def))
		    count++;

		if(vexpwarp->ix_flag = vget_infile(fid, prompt_flag,
		    "-ix", ix_pstr, &(vexpwarp->ix_file))
)
		    count++;

		if (count == 0)
		{
		    fprintf(stderr, "Error: You MUST specify one of :\n");
		    fprintf(stderr, " -xmap  -ix \n");
		    gw_usage();
		    exit(1);
		}

		else if (count > 1)
		{
		    fprintf(stderr, "Error: You may specify ONLY ONE of :\n");
		    fprintf(stderr, " -xmap  -ix \n");
		    gw_usage();
		    exit(1);
		}

		count = 0;
		if(vexpwarp->ymap_flag = vget_string(fid, prompt_flag,
		    "-ymap", ymap_pstr, &(vexpwarp->ymap_string),
		    ymap_def))
		    count++;

		if(vexpwarp->iy_flag = vget_infile(fid, prompt_flag,
		    "-iy", iy_pstr, &(vexpwarp->iy_file))
)
		    count++;

		if (count == 0)
		{
		    fprintf(stderr, "Error: You MUST specify one of :\n");
		    fprintf(stderr, " -xmap  -ix  -ymap  -iy \n");
		    gw_usage();
		    exit(1);
		}

		else if (count > 1)
		{
		    fprintf(stderr, "Error: You may specify ONLY ONE of :\n");
		    fprintf(stderr, " -xmap  -ix  -ymap  -iy \n");
		    gw_usage();
		    exit(1);
		}

	}

	/*
	 * get optional arguments for vexpwarp
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vexpwarp->x_flag = vget_float(fid, prompt_flag,
	"-x", x_pstr, &(vexpwarp->x_float),
	0.000000, 0.000000, 0.000000);

	vexpwarp->y_flag = vget_float(fid, prompt_flag,
	"-y", y_pstr, &(vexpwarp->y_float),
	0.000000, 0.000000, 0.000000);


}



