/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vconic.c
 >>>>
 >>>>      Program Name: vconic
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Creates an image of a conic section of revolution
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Tue Apr 23 01:36:48 1991
 >>>>
 >>>>          Routines: main- the main program for vconic
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vconic.h"


/****************************************************************
 *
 * Routine Name:  main program for vconic
 *
 *       Input:  
 *        -o  output image 
 *
 *
 *        [-r] desired number of rows in output image  (value > 0)
 *        [-c] desired number of columns in output image  (value > 0)
 *        [-cx] coordinate system X origin (pixel number)  (value >= 0)
 *        [-cy] coordinate system Y origin (pixel number)  (value >= 0)
 *        [-x] X offset of center of symmetry (meters) 
 *        [-y] Y offset of center of symmetry (meters) 
 *        [-radius] radius parameter (meters) 
 *        [-conic] conic constant 
 *        [-piston] piston (meters) 
 *        [-branch] select positive (1) or negative (0) branch of quadratic
 *        [-s] pixel size (meters) 
 *        [-cutoff] cutoff radius (meters) 
 *        [-t] Selects data type of output image
 *		'byte' (choose Byte data storage type),
 *		'float' (choose Float data storage type),
 *		 or 'double' (choose Double data storage type)
 *		   [default = float] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image;
int type;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if(check_args())exit(1);

if(!vget_type(&type, vconic->t_toggle))
  {
    fprintf(stderr,"vconic:  Invalid data type specified\n");
    exit(1);
  }

if(type!=VFF_TYP_1_BYTE && type!=VFF_TYP_FLOAT && type !=VFF_TYP_DOUBLE)
  {
    fprintf(stderr,"%s:  Illegal image data type specified.\n",program);
    exit(1);
  }

if (vconic->r_int <= 0 || vconic->c_int <= 0)
  {
    fprintf(stderr,"%s: Rows and columns must be positive and non-zero\n",program);
    exit(1);
  }
/* -main_before_lib_call_end */

/* -main_library_call */
if(! lvconic( &image,vconic->r_int,vconic->c_int, type,
              vconic->radius_float, vconic->conic_float,
              vconic->cx_int,vconic->cy_int,
              vconic->x_float,vconic->y_float, vconic->s_float,
              vconic->cutoff_float,vconic->piston_float,
              vconic->branch_logic))
  {
      (void) fprintf(stderr, "lvconic Failed\n");
      exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vconic->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vconic 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vconic :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCreates an image of a conic section of revolution\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-r]  desired number of rows in output image (integer, > 0) [32]\n");
	fprintf(stderr,"\t[-c]  desired number of columns in output image (integer, > 0) [32]\n");
	fprintf(stderr,"\t[-cx]  coordinate system X origin (pixel number) (integer, >= 0) [16]\n");
	fprintf(stderr,"\t[-cy]  coordinate system Y origin (pixel number) (integer, >= 0) [16]\n");
	fprintf(stderr,"\t[-x]  X offset of center of symmetry (meters) (float) [0]\n");
	fprintf(stderr,"\t[-y]  Y offset of center of symmetry (meters) (float) [0]\n");
	fprintf(stderr,"\t[-radius]  radius parameter (meters) (float) [10]\n");
	fprintf(stderr,"\t[-conic]  conic constant (float) [0]\n");
	fprintf(stderr,"\t[-piston]  piston (meters) (float) [0]\n");
	fprintf(stderr,"\t[-branch]  select positive (1) or negative (0) branch of quadratic (boolean) [false]\n");
	fprintf(stderr,"\t[-s]  pixel size (meters) (float) [0.1]\n");
	fprintf(stderr,"\t[-cutoff]  cutoff radius (meters) (float) [0]\n");
	fprintf(stderr, "\t[-t]  Selects data type of output image\n");
	fprintf(stderr, "\t\t'byte'  (choose Byte data storage type),\n");
	fprintf(stderr, "\t\t'float'  (choose Float data storage type),\n");
	fprintf(stderr, "\t\t or 'double'  (choose Double data storage type)\n");
	fprintf(stderr, "\t\t[default = float]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vconic\n");
	fprintf(stderr, "\t[-U] Gives the usage for vconic\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vconic.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vconic.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vconic
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char	*r_pstr = 
	"\nEnter: (r) desired number of rows in output image \n        {integer, > 0 [32] }: "; 
char	*c_pstr = 
	"\nEnter: (c) desired number of columns in output image \n        {integer, > 0 [32] }: "; 
char	*cx_pstr = 
	"\nEnter: (cx) coordinate system X origin (pixel number) \n        {integer, >= 0 [16] }: "; 
char	*cy_pstr = 
	"\nEnter: (cy) coordinate system Y origin (pixel number) \n        {integer, >= 0 [16] }: "; 
char	*x_pstr = 
	"\nEnter: (x) X offset of center of symmetry (meters) \n        {float [0.000000] }: "; 
char	*y_pstr = 
	"\nEnter: (y) Y offset of center of symmetry (meters) \n        {float [0.000000] }: "; 
char	*radius_pstr = 
	"\nEnter: (radius) radius parameter (meters) \n        {float [10.000000] }: "; 
char	*conic_pstr = 
	"\nEnter: (conic) conic constant \n        {float [0.000000] }: "; 
char	*piston_pstr = 
	"\nEnter: (piston) piston (meters) \n        {float [0.000000] }: "; 
char	*branch_pstr = 
	"\nEnter: (branch) select positive (1) or negative (0) branch of quadratic \n        {boolean, (y/n)  [no] }: "; 
char	*s_pstr = 
	"\nEnter: (s) pixel size (meters) \n        {float [0.100000] }: "; 
char	*cutoff_pstr = 
	"\nEnter: (cutoff) cutoff radius (meters) \n        {float [0.000000] }: "; 
char	*t_pstr = "\nEnter: (t) Selects data type of output image -- \n      \t\t'byte' (choose Byte data storage type)\n\t\t'float' (choose Float data storage type)\n\t\tor 'double' (choose Double data storage type)\n  [float]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vconic", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vconic.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vconic: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vconic.ans");
		}

	     }

	}

	/*
	 * allocate the vconic structure
	 */
	vconic = (vconic_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vconic_struct));

	/*
	 * get required arguments for vconic
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vconic->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vconic->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vconic->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vconic->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vconic->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vconic
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vconic->r_flag = vget_int(fid, prompt_flag,
	"-r", r_pstr, &(vconic->r_int),
	32, 2, 2);

	vconic->c_flag = vget_int(fid, prompt_flag,
	"-c", c_pstr, &(vconic->c_int),
	32, 2, 2);

	vconic->cx_flag = vget_int(fid, prompt_flag,
	"-cx", cx_pstr, &(vconic->cx_int),
	16, 1, 1);

	vconic->cy_flag = vget_int(fid, prompt_flag,
	"-cy", cy_pstr, &(vconic->cy_int),
	16, 1, 1);

	vconic->x_flag = vget_float(fid, prompt_flag,
	"-x", x_pstr, &(vconic->x_float),
	0.000000, 0.000000, 0.000000);

	vconic->y_flag = vget_float(fid, prompt_flag,
	"-y", y_pstr, &(vconic->y_float),
	0.000000, 0.000000, 0.000000);

	vconic->radius_flag = vget_float(fid, prompt_flag,
	"-radius", radius_pstr, &(vconic->radius_float),
	10.000000, 0.000000, 0.000000);

	vconic->conic_flag = vget_float(fid, prompt_flag,
	"-conic", conic_pstr, &(vconic->conic_float),
	0.000000, 0.000000, 0.000000);

	vconic->piston_flag = vget_float(fid, prompt_flag,
	"-piston", piston_pstr, &(vconic->piston_float),
	0.000000, 0.000000, 0.000000);

	vconic->branch_flag = vget_logic(fid, prompt_flag,
	"-branch", branch_pstr, &(vconic->branch_logic), 0);

	vconic->s_flag = vget_float(fid, prompt_flag,
	"-s", s_pstr, &(vconic->s_float),
	0.100000, 0.000000, 0.000000);

	vconic->cutoff_flag = vget_float(fid, prompt_flag,
	"-cutoff", cutoff_pstr, &(vconic->cutoff_float),
	0.000000, 0.000000, 0.000000);


	/*
	 * get optional toggles for vconic
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		vconic->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(vconic->t_toggle),
		"float");

		if (((strcmp(vconic->t_toggle, "byte") == 0)) || 
		     ((strcmp(vconic->t_toggle, "float") == 0)) || 
		     ((strcmp(vconic->t_toggle, "double") == 0)))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		vconic->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(vconic->t_toggle),
		"float");

		if (((strcmp(vconic->t_toggle, "byte") != 0)) && 
		     ((strcmp(vconic->t_toggle, "float") != 0)) && 
		     ((strcmp(vconic->t_toggle, "double") != 0)))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



