/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvuclass.c
 >>>>
 >>>>      Program Name: vuclass
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:17:53 1991 
 >>>>
 >>>>          Routines: lvuclass - the library call for vuclass
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvuclass - library call for vuclass
*
* Purpose:
*    
*    Ruled based classifier for  segmented  ultrasonic  ventricle
*    images.
*    
*    
* Input:
*    
*         1. img1 -- first xvimage strcuture
*         2. img2 -- second xvimage structure
*    
*    
* Output:
*    
*         1. img1 -- holds the result of the  operation.   The  output
*         data type is the same as the input data type.
*    
*         img1 is used for both the input xvimage  structure  and  the
*         output  result  xvimage  structure.   This  is  done to save
*         space, but you must be careful not  to  overwrite  important
*         data.
*    
*         lvuclass returns a 1 upon success and a 0 on failure.
*    
*    
*
* Written By: Shirley Lee
*    
*    
****************************************************************/


/* -library_def */
int
lvuclass(img1,img2)
struct xvimage *img1,*img2;
/* -library_def_end */

/* -library_code */
{

     int i,row,col,nr,nc;
     int nr1,nc1, *test, ind;
     float *data;
     unsigned char *ptr, *result;

     nr = img2->col_size;
     nc = img2->row_size;

     test = (int *)malloc(nc*sizeof(int));

     data = (float *) img2->imagedata;
     for (i = 0; i < nc; i++)
          {
             test[i] = 0;

                /* large percentage of the image */
                if (*(data+1*nr*nc+nc+i) > 40){
                    printf("wrong obj (background): %d\n",i);
                    test[i] = 1;
                }

                /* region above and below the likely position */
                else if ((*(data+4*nr*nc+nc+i) < 145) || 
                    (*(data+4*nr*nc+nc+i) > 475)) {
                    printf("wrong obj (top, bottom): %d\n",i);
                    test[i] = 1;
                }

                /* region too close to the border */
                else if ((*(data+3*nr*nc+nc+i) < 100) || 
                    (*(data+3*nr*nc+nc+i) > 400)) {
                    printf("wrong obj (right, left): %d\n",i);
                    test[i] = 1;
                }

                /* flat region */
                else if (*(data+10*nr*nc+nc+i) > 2.3) { 
                    printf("wrong obj (flat): %d\n",i);
                    test[i] = 1;
                }

                /* large region on top*/
                else if ((*(data+1*nr*nc+nc+i) > 4.5) && 
                    (((*(data+3*nr*nc+nc+i) < 150)) ||
                        (*(data+4*nr*nc+nc+i) > 450))  )  {
                    printf("wrong obj (flat, top): %d\n",i);
                    test[i] = 1;
                }

                /* small region not in center */
                else if ((*(data+1*nr*nc+nc+i) < 0.20) && 
                  !((((*(data+3*nr*nc+nc+i)>235))&&(*(data+3*nr*nc+nc+i)<400)) 
                  &&(((*(data+4*nr*nc+nc+i)>200))&&(*(data+4*nr*nc+nc+i)<400))))
                {
                    printf("wrong obj (small): %d\n",i);
                    test[i] = 1;
                }
           }

     nr1 = img1->col_size;
     nc1 = img1->row_size;

    /* Allocate space for resulting image */
    result = (unsigned char *)malloc((unsigned int)nc1*nr1*sizeof(unsigned char));
    if(result == NULL) {
        (void) fprintf(stderr,"lvuclass: insufficient memory available\n");
        return(0);
    }

     ptr = (unsigned char *)img1->imagedata;

      for (row=0; row<nr1; row++){
        for (col=0; col<nc1; col++){
            ind = ptr[nc1*row+col]-1;
            if (test[ind])
                result[nc1*row+col] = 255;
            else 
                result[nc1*row+col] = 0;
        }
      }

      free(img1->imagedata);
      img1->data_storage_type = VFF_TYP_1_BYTE; 
      img1->imagedata = (char *)result;

      return(1);

}
/* -library_code_end */
