/****************************************************************************\
*                                                                            *
*  THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE  *
*     WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR     *
*   PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.   *
*                                                                            *
*     In no event will the supplier be liable for any lost revenue           *
*   or profits or other special, indirect and consequential damages, even    *
*    if the supplier has been advised of the possibility of such damages.    *
*                                                                            *
*             Users may copy or modify this file without charge,             *
*       but are NOT authorized to license or sell it to anyone.              *
*                                                                            *
\****************************************************************************/

/****************************************************************************\
*                                                                            *
*    If you modify this software, you should include a notice giving the     *
* name of the person performing the modification, the date of modification,  *
* and the reason for such modification.  Bug reports or fixes should be sent *
*        to the author, who may or may not act on them as he desires:        *
*                                                                            *
* Internet: raytrace@cutmcvax.cs.curtin.edu.au                               *
*                                                                            *
* Mail   : School of Computer Science         | Tel: 619 351 7680            *
*          Curtin University of Technology    | Fax: 619 351 2819            *
*          Kent Street, Bentley                                              *
*          Western Australia, 6102                                           *
*                                                                            *
\****************************************************************************/

/*
 Copyright (c) 1990 Fred Parke.
 Modifications: Andrew Marriott. 1991.
 */

#include "face.h"
#include "face_data.h"
/*	routine to generate one ring of polygons	*/
/*	forming one 'band' of the eyeballs		*/

ring(r,f,p,n)
float r,f;
register float p[16][3], n[16][3];
{
register float ang;
float x;
register int i;

	if (f>=1.0) 	x=0.0;
	else 		x=sqrt(1.0-(f*f));
	ang=0.0;
	for (i=0; i<=15; i++)
	{
		n[i][0]=x;
		n[i][1]=f*cos(ang);
		n[i][2]=f*sin(ang);
		p[i][0]=r*n[i][0];
		p[i][1]=r*n[i][1];
		p[i][2]=r*n[i][2];
		ang=ang+.3927;		/* 2*PI/16 */
	};
}

/*	routine which uses the ring procedure to	*/
/*	create the eyeball polygons			*/
/*							*/
/*	input parameters control the size of the	*/
/*	eyeball, iris, and pupil			*/

static void bands(spp,lpp,sn,ln,c,sf,gp)
float spp[16][3],lpp[16][3],sn[16][3],ln[16][3],c[2][3],sf[3],gp;
{
register int i,j;
int eye_number;
float rad,ct,sg,v[3];
float lp[16][3],sp[16][3];

	for (eye_number=0; eye_number<=1; eye_number++)
	{
		for (i=0; i<=15; i++)
		{
			if(gp ==0.0)
				for (j=0; j<3; j++)
				   sp[i][j]=(spp[i][j]+c[eye_number][j])*sf[j];
			else
			{
				for (j=0; j<3; j++)
					v[j]=(spp[i][j]+c[eye_number][j])*sf[j];
				rad=sqrt(v[0]*v[0]+v[1]*v[1]+v[2]*v[2]);
				if (rad==0.0) 	ct=0.0;
				else	 	ct=v[2]/rad;
				sg=1.0/(1.0-gp*(1.0-ct));
				for (j=0; j<3; j++)
					sp[i][j]=sg*v[j];
			}
		}
		for (i=0; i<=15; i++)
		{
			if(gp ==0.0)
				for (j=0; j<3; j++)
				   lp[i][j]=(lpp[i][j]+c[eye_number][j])*sf[j];
			else
			{
				for (j=0; j<3; j++)
					v[j]=(lpp[i][j]+c[eye_number][j])*sf[j];
				rad=sqrt(v[0]*v[0]+v[1]*v[1]+v[2]*v[2]);
				if (rad==0.0) 	ct=0.0;
				else 		ct=v[2]/rad;
				sg=1.0/(1.0-gp*(1.0-ct));
				for (j=0; j<3; j++)
					lp[i][j]=sg*v[j];
			}
		}
		for (i=0; i<=15; i++)
		{
			if (i<15) 	j=i+1;
			else 		j=0;
			if(wire)
				bgnline();
			else
				bgnpolygon();
			if(!wire) n3f(sn[i]);
			v3f(sp[i]);
			if(!wire) n3f(ln[i]);
			v3f(lp[i]);
			if(!wire) n3f(ln[j]);
			v3f(lp[j]);
			if(!wire) n3f(sn[j]);
			v3f(sp[j]);
			if(wire)
				endline();
			else
				endpolygon();
		}
	}
}

/*	routine which displays a new face image		*/

create_face_object (ng,np,ry,rz,sc,pt,Pc,pg,pgni,nn,vn,pgn,pm,coord)
int ng,np;
int ry,rz; float sc;
float pt[300][3];
int Pc[300], pg[300][4];
int pgni[401][4], nn[401];
float vn[401][3];
float pgn[300][3];
Parameter pm[MAX_PARAMETERS];
float coord[2][3];
{
int f,i, j, k, l, m, n, v;
int major_change;

static float rp1[16][3],rp2[16][3],rn1[16][3],rn2[16][3];
static float rp3[16][3],rp4[16][3],rn3[16][3],rn4[16][3];
static float rp5[16][3],rp6[16][3],rn5[16][3],rn6[16][3];
float con[3], pot[3];
float er, fi, ff, pf, s, wh,gp;
float sf[3];
float cn[4][3];

/*printf("create_face object\n");/**/
	gp=pm[46].value;
	er = pm[44].value;
	fi = pm[43].value;
	ff = pm[42].value;
	pf = pm[41].value;
	s  = pm[50].value;
	pf = pf*fi;
	ff = ff*fi;
	wh = (1.+fi)/2.;
	sf[0]=pm[7].value; sf[1]=pm[8].value; sf[2]=pm[9].value;

	makeobj(START);

	if(is_a_gt && !wire)
	{
		zbuffer(TRUE);
		cpack(bgc); clear(); zclear();
	}
	else
	{
		zbuffer(FALSE);
		color(BLACK);clear();color(WHITE);
	}

	pushmatrix();
	rotate(-900,'z');
	rotate(ry,'x');
/*	rotate(rz, 'y');/**/
	scale(sc,sc,sc);
	closeobj();
/*	display the face mask polygons		*/
	makeobj(FLESH);

	for (i=1; i<=ng; i++)
	{
		if(!object_is_visible[Pc[i]]) 
			continue;

		if(Pc[i]!=Pc[i-1])
			lmbind(MATERIAL,Pc[i]);
		if (pg[i][3]==0) 	k=2;
		else 			k=3;
		if(wire)
			bgnline();
		else
			bgnpolygon();
		for(j=0; j<=k; j++)
		{
			m=pg[i][j];
			if (!wire)
			{
				v=m;
				if(pgni[i][j]>1)
					for (l=1; l<=(pgni[i][j]-1); l++)
						v=nn[v];
				if(s==0.0)
				    for (n=0; n<3; n++)
					cn[j][n]=pgn[i][n];
				else if (s==1.0)
				    for (n=0; n<3; n++)
					cn[j][n]=vn[v][n];
				else
				    for (n=0; n<3; n++)
					cn[j][n]=s*vn[v][n]+(1.0-s)*pgn[i][n];
				n3f(cn[j]);
			}
			v3f(pt[m]);
		}
		if(wire)
		{
			endline();
			bgnline();
		}
		else
		{
			endpolygon();
			bgnpolygon();
		}
		for(j=k;j>=0;j--)
		{
			m=pg[i][j];
			if (!wire)
			{
				con[0]=cn[j][0];
				con[1]=(-cn[j][1]);
				con[2]=cn[j][2];
				n3f(con);
			}
			pot[0]=pt[m][0];
			pot[1]=(-pt[m][1]);
			pot[2]=pt[m][2];
			v3f(pot);
		}
		if(wire)
			endline();
		else
			endpolygon();
	}
	closeobj();
	/*	display the eyes	*/
	/*	output pupil		*/

	major_change=parameter[28].changed ||parameter[29].changed ||
		     parameter[30].changed ||parameter[38].changed ||
		     parameter[39].changed ||parameter[40].changed ||
		     parameter[46].changed ||parameter[ 7].changed ||
		     parameter[ 8].changed ||parameter[ 9].changed ;

	if(parameter[44].changed)
		ring(er,0.0,rp2,rn2);
	if(parameter[44].changed || parameter[43].changed || parameter[41].changed)
		ring(er,pf,rp1,rn1);
	if(object_is_visible[PUPIL])
	{
		if( major_change || parameter[44].changed || parameter[43].changed || parameter[41].changed)
		{
			makeobj(PUPIL);
			lmbind(MATERIAL,PUPIL);
			bands(rp2,rp1,rn2,rn1,coord,sf,gp);
			closeobj();
		}
	}

	/*	output iris			*/

	if(parameter[44].changed || parameter[43].changed || parameter[42].changed)
		ring(er,ff,rp3,rn3);
	if(object_is_visible[IRIS])
	{
		if( major_change || parameter[44].changed || parameter[43].changed || parameter[41].changed || parameter[42].changed)
		{
			makeobj(IRIS);
			lmbind(MATERIAL,IRIS);
			bands(rp1,rp3,rn1,rn3,coord,sf,gp);
			closeobj();
		}
	}

	/*	output fringe			*/

	if(parameter[44].changed || parameter[43].changed )
		ring(er,fi,rp4,rn4);
	if(object_is_visible[FRINGE])
	{
		if( major_change || parameter[44].changed || parameter[43].changed || parameter[42].changed)
		{
			makeobj(FRINGE);
			lmbind(MATERIAL,FRINGE);
			bands(rp3,rp4,rn3,rn4,coord,sf,gp);
			closeobj();
		}
	}

	/*	output first white		*/

	if(parameter[44].changed || parameter[43].changed )
		ring(er,wh,rp5,rn5);
	if(object_is_visible[EYEWHITE])
	{
		if( major_change || parameter[44].changed || parameter[43].changed)
		{
			makeobj(EYEWHITE);
			lmbind(MATERIAL,EYEWHITE);
			bands(rp4,rp5,rn4,rn5,coord,sf,gp);
		}
	}

	/*	output second white		*/

	if(parameter[44].changed )
		ring(er,1.0,rp6,rn6);
	if(object_is_visible[EYEWHITE])
		if( major_change || parameter[44].changed || parameter[43].changed)
		{
			bands(rp5,rp6,rn5,rn6,coord,sf,gp);
			closeobj();
		}

	makeobj(FINISH);
	popmatrix();
	closeobj();

	for(i=0;i<MAX_PARAMETERS; i++)
		parameter[i].changed=0;
/**/
}

/*	routine to compute new face mask vertex		*/
/*	positions based on conformation and		*/
/*	expression parameters				*/

points(np,coord,pm,inpts,interp,pt)
int np;
float coord[2][3];
Parameter pm[MAX_PARAMETERS];
float inpts[300][3], interp[300][3], pt[300][3];
{
register int i,j;
float sa,ca,v[3],cord[3];
float rad,ct,sg,dtr;

	dtr=.0175;

	/*  scale head			*/
	/*if(pm[7].changed)/**/
	  for(i=1; i<=np; i++)
			pt[i][0]=inpts[i][0]*pm[7].value;
	/*if(pm[8].changed)/**/
	  for(i=1; i<=np; i++)
			pt[i][1]=inpts[i][1]*pm[8].value;
	/*if(pm[9].changed)/**/
	  for(i=1; i<=np; i++)
			pt[i][2]=inpts[i][2]*pm[9].value;

	/*  eyelid section		*/

	for (i=0; i<3; i++)
		cord[i]=coord[1][i];
	
	for (i=184; i<=221; i++)
	{
		for (j=1; j<3; j++)
			pt[i][j]=(pm[1].value*inpts[i][j]+(1.-pm[1].value)*interp[i][j])*pm[j+4].value;
		pt[i][0]=pm[1].value*inpts[i][0]+(1.-pm[1].value)*interp[i][0];
		pt[i][0]=sqrt(pt[i][0]*pm[45].value*pt[i][0]*pm[45].value-
				pt[i][1]*pt[i][1]-pt[i][2]*pt[i][2]);
	}
	for (i=184; i<=189; i++)
		for (j=0; j<3; j++)
			pt[i+6][j]=pt[i][j]*.9;
	for (i=207; i<=211; i++)
		for (j=0; j<3; j++)
			pt[i+5][j]=pt[i][j]*.9;
	for (j=0; j<3; j++)
			pt[222][j]=pt[196][j]*.9;
	for (i=184; i<=222; i++)
		for (j=0; j<3; j++)
			pt[i][j]=(pt[i][j]+cord[j])*pm[j+7].value;

	/*	move chin		*/

	for (i=11; i<=40; i++)
	{
		  pt[i][0]=pt[i][0]+pm[31].value;
		  pt[i][2]=pt[i][2]+pm[32].value;
	}

	/*	mouth interpolation	*/

	for (i=49; i<=70; i++)
		for (j=0; j<3; j++)
			pt[i][j]=(pm[13].value*inpts[i][j]+
			  (1.0-pm[13].value)*interp[i][j])*pm[j+7].value;
	i=44;
	for (j=0; j<3; j++)
		pt[i][j]=(pm[13].value*inpts[i][j]+
			  (1.0-pm[13].value)*interp[i][j])*pm[j+7].value;
	i=287;
	for (j=0; j<3; j++)
		pt[i][j]=(pm[13].value*inpts[i][j]+
			  (1.0-pm[13].value)*interp[i][j])*pm[j+7].value;

	/*	x offset for mouth	*/

	pt[44][0]=pt[44][0]+.3*pm[14].value;
	pt[70][0]=pt[70][0]+.3*pm[14].value;
	pt[287][0]=pt[287][0]+.3*pm[14].value;
	for(i=49; i<=67; i+=3)
	{
		 pt[i][0]=pt[i][0]+pm[14].value;
		 pt[i+1][0]=pt[i+1][0]+.8*pm[14].value;
		 pt[i+2][0]=pt[i+2][0]+.6*pm[14].value;
	}

	/*	mouth Y scale		*/

	for (i=41; i<=44; i++)
		pt[i][1]=pt[i][1]*pm[12].value;
	for (i=49; i<=73; i++)
		pt[i][1]=pt[i][1]*pm[12].value;
	i=287;
	pt[i][1]=pt[i][1]*pm[12].value;

	for (i=36; i<=37; i++)
		pt[i][1]=pt[i][1]*(1.0+.2*(pm[12].value-1.0));
	for (i=45; i<=46; i++)
		pt[i][1]=pt[i][1]*(1.0+.4*(pm[12].value-1.0));
	for (i=95; i<=96; i++)
		pt[i][1]=pt[i][1]*(1.0+.2*(pm[12].value-1.0));

	/*	raise upper lip		*/

	for (i=61; i<=67; i+=3)
	{
		 pt[i][2]=pt[i][2]+pm[22].value;
		 pt[i+1][2]=pt[i+1][2]+.7*pm[22].value;
		 pt[i+2][2]=pt[i+2][2]+.4*pm[22].value;

	}

	/*	lower lip "f" tuck	*/


	for (i=49; i<=58; i+=3)
	{
		 pt[i][0]=pt[i][0]+pm[21].value;
		 pt[i+1][0]=pt[i+1][0]+.8*pm[21].value;
		 pt[i+2][0]=pt[i+2][0]+.6*pm[21].value;
		 pt[i][2]=pt[i][2]-pm[21].value;
		 pt[i+1][2]=pt[i+1][2]-.925*pm[21].value;
		 pt[i+2][2]=pt[i+2][2]-.8*pm[21].value;
	}

	/*	teeth offset			*/

	for (i=223; i<=286; i++)
	{
		pt[i][0]=pt[i][0]+pm[47].value;
		pt[i][2]=pt[i][2]+pm[48].value;
	};

	/*	chin to mouth Z scaling		*/

	for (i=1; i<=43; i++)
		pt[i][2]=pt[45][2]+pm[35].value*(pt[i][2]-pt[45][2]);

	/*	chin to eye Z scaling		*/

	for (i=1; i<=134; i++)
		pt[i][2]=pt[128][2]+pm[36].value*(pt[i][2]-pt[128][2]);
	for (i=223; i<=287; i++)
		pt[i][2]=pt[128][2]+pm[36].value*(pt[i][2]-pt[128][2]);

	/*	eye to forehead Z scaling	*/

	for (i=157; i<=171; i++)
		pt[i][2]=pt[156][2]+pm[37].value*(pt[i][2]-pt[156][2]);


	/*	jaw rotation		*/

	sa=sin(dtr*pm[4].value); ca=cos(dtr*pm[4].value);
	for (i=14; i<=43; i++)
		jrot(i,sa,ca,pt);
	for (i=49; i<=58; i+=3)
		jrot(i,sa,ca,pt);
	sa=sin(dtr*pm[4].value*.9); ca=cos(dtr*pm[4].value*.9);
	for (i=50; i<=59; i+=3)
		jrot(i,sa,ca,pt);
	for (i=255; i<=286; i++)
		jrot(i,sa,ca,pt);
	sa=sin(dtr*pm[4].value*.75); ca=cos(dtr*pm[4].value*.75);
	for (i=11; i<=13; i++)
		jzrot(i,sa,ca,pt);
	for (i=51; i<=60; i+=3)
		jrot(i,sa,ca,pt);
	sa=sin(dtr*pm[4].value*.5); ca=cos(dtr*pm[4].value*.5);
	for (i=6; i<=10; i++)
		jzrot(i,sa,ca,pt);
	sa=sin(dtr*pm[4].value*.35); ca=cos(dtr*pm[4].value*.35);
	for (i=44; i<=48; i++)
		jrot(i,sa,ca,pt);
	jrot(70,sa,ca,pt);
	jrot(287,sa,ca,pt);

	/*	eyebrow interpolation		*/

	for (i=138; i<=156; i++)
	    for (j=0; j<3; j++)
		pt[i][j]=(pm[2].value*inpts[i][j]+(1.0-pm[2].value)*interp[i][j])*pm[j+7].value;
	pt[144][1]=pt[144][1]+pm[3].value*.8;
	pt[149][1]=pt[149][1]+pm[3].value*.4;
	pt[145][1]=pt[145][1]+pm[3].value;
	pt[146][1]=pt[146][1]+pm[3].value;

	/*	move end of nose	*/

	for (i=74; i<=94; i++)
	{
		pt[i][0]=pt[i][0]+pm[26].value;
		pt[i][2]=pt[i][2]+pm[27].value;
	}
	for (i=94; i<=101; i++)
	{
		pt[i][0]=pt[i][0]+pm[26].value;
		pt[i][2]=pt[i][2]+pm[27].value;
	}
	for (i=71; i<=73; i++)
	{
		pt[i][0]=pt[i][0]+pm[26].value/2;
		pt[i][2]=pt[i][2]+pm[27].value/2;
	}

	/*	Y scale end of nose		*/

	for (i=74; i<=94; i++)
		pt[i][1]=pt[i][1]*pm[10].value;
	for (i=97; i<=101; i++)
		pt[i][1]=pt[i][1]*pm[10].value;

	/*	Y scale bridge of nose		*/

	for (i=109; i<=113; i++)
		pt[i][1]=pt[i][1]*pm[11].value;
	for (i=126; i<=130; i++)
		pt[i][1]=pt[i][1]*pm[11].value;

	/*	adjust corner of mouth		*/

	i=70;
	for (j=0; j<3; j++)
		pt[i][j]=pt[i][j]+pm[j+16].value;
	i=287;
	for (j=0; j<3; j++)
		pt[i][j]=pt[i][j]+pm[j+16].value;
	i=44;
	for (j=0; j<3; j++)
		pt[i][j]=pt[i][j]+pm[j+16].value;

	/*	jaw Y scale		*/

	for ( i=11; i<=40; i+=1 )
		pt[i][1]=pt[i][1]*(1.0+(pm[19].value-1.0)*(pt[i][0]/pt[23][0]));

	/*	cheek Y scale		*/

	for ( i=102; i<=107; i+=1 )
		pt[i][1]=pt[i][1]*pm[20].value;
	for ( i=113; i<=118; i+=1 )
		pt[i][1]=pt[i][1]*pm[20].value;
	for ( i=119; i<=124; i+=1 )
		pt[i][1]=pt[i][1]*pm[20].value;
	for ( i=132; i<=137; i+=1 )
		pt[i][1]=pt[i][1]*pm[20].value;

	/*	growth section			*/

	if(pm[46].value!=0.0)
	  for (i=1; i<=np; i++)
	  {
		for (j=0; j<=3; j++)
			v[j]=pt[i][j];
		rad=sqrt(v[0]*v[0]+v[1]*v[1]+v[2]*v[2]);
		if (rad==0.0)
		{
			ct=0.0;
		}
		else
		{
			ct=v[2]/rad;
		}
		sg=1.0/(1.0-pm[46].value*(1.0-ct));
		for (j=0; j<=3; j++)
			pt[i][j]=sg*v[j];
	  }

}

/*	routine to compute polygon normals	*/

static void comnor(ng,pg,pt,pgn)
int ng;
register int pg[300][4];
float pt[300][3];
float pgn[300][3];
{
register int i, j;
float x[3];
register float p0[3], p1[3], p2[3], p3[3];
float lx;

	for ( i=1; i<=ng; i++)
	{
		for ( j=0; j<3; j++)
		{
			p0[j]=pt[pg[i][0]][j];
			p1[j]=pt[pg[i][1]][j]-p0[j];
			p2[j]=pt[pg[i][2]][j]-p0[j];
			if (pg[i][3]!=0)
				p3[j]=pt[pg[i][3]][j]-p0[j];
		}
		x[0]=p2[1]*p1[2]-p2[2]*p1[1];
		x[1]=p2[2]*p1[0]-p2[0]*p1[2];
		x[2]=p2[0]*p1[1]-p2[1]*p1[0];
		if (pg[i][3]!=0)
		{
			x[0]=x[0]+p3[1]*p2[2]-p3[2]*p2[1];
			x[1]=x[1]+p3[2]*p2[0]-p3[0]*p2[2];
			x[2]=x[2]+p3[0]*p2[1]-p3[1]*p2[0];
		}
		lx=sqrt(x[0]*x[0]+x[1]*x[1]+x[2]*x[2]);
		for ( j=0; j<3; j++ )
			pgn[i][j]=x[j]/lx;
	}
}

/*	routine to compute vertex normals	*/

static void vnorm(lvn,ng,np,nv,nn,pg,pgni,pgn,vn,pt)
int lvn, ng, np, nv;
register int nn[401];
int pg[300][4], pgni[401][4];
float pgn[300][3];
register float vn[401][3];
float pt[300][3];
{
register int i;
int j, k, l, v, vertex;
float length;

	for (i=1; i<=lvn; i++)
	{
		for (j=0; j<3; j++)
			vn[i][j]=0.0;
		nn[i]=0;
	}
	nv=np;
	for (i=1; i<=ng; i++)
		for (j=0; j<4; j++)
			if (pg[i][j]>0)
			{
				vertex=pg[i][j];
				v=vertex;
				if (pgni[i][j]>1)
					for (l=1; l<=(pgni[i][j]-1); l++)
						if (nn[vertex]==0)
						{
							nv++;
							nn[vertex]=nv;
							vertex=nv;
						} 
						else
							vertex=nn[vertex];
				for ( k=0; k<3; k++)
					vn[vertex][k]=vn[vertex][k]+pgn[i][k];
				if (pt[v][1]==0.0)
					vn[vertex][1]=0.0;
			}
	for ( i=1; i<=nv; i++)
	{
		length=sqrt(vn[i][0]*vn[i][0]+
				vn[i][1]*vn[i][1]+vn[i][2]*vn[i][2]);
		if (length>=.0001)
		{
			for (j=0; j<3; j++)
				vn[i][j]=vn[i][j]/length;
		}
	}
}

#ifdef FORMS
static void main_callback(short event, short val)

{
float		old_roll 	= -1;
float		old_pitch	= -1;


/*printf("main_callback %hd, %hd\n",event,val);fflush(stdout);/**/
	if (event == REDRAW)
		display_face();
	else if (event == MOUSE3 && val == 1)
	{
		while(getbutton(MOUSE3))
		{
			parameter[52].value = (-180/640.0*(getvaluator(MOUSEX)-640)) ; 
			parameter[53].value = ( 90 + 180/512.0*(getvaluator(MOUSEY)-512)) ;      
			if((parameter[52].value !=old_roll) || (parameter[53].value != old_pitch))
				display_face();
			old_roll=parameter[52].value;old_pitch=parameter[53].value;
		}
		field_update(52);
		field_update(53);
	}
	else if (event == MOUSE2 && val == 1)
	{
		while(getbutton(MOUSE2))
		{
			old_roll = ((getvaluator(MOUSEY)/1024.0)) ;      
			parameter[51].value =
			   old_roll * parameter[51].max + (1-old_roll)*parameter[51].min;
			if((parameter[51].value !=old_pitch) )
				display_face();
			old_pitch=parameter[51].value;
		}
		field_update(51);
	}
	else if (event == MOUSE1 && val == 1)
	{
		while(getbutton(MOUSE1))
		{
			parameter[54].value = (/*-90 -*/ 180/640.0*(getvaluator(MOUSEX)-640)) ; 
			if((parameter[54].value !=old_roll) )
				display_face();
			old_roll=parameter[54].value;
		}
		field_update(54);
	}
}
#endif
make_face()
{
int i,j;

/* initialization				*/

	eye_coord[0]=190; eye_coord[1]=125; eye_coord[2]=0;
	npts=300; nnor=400;

/*	initialize parameter values	*/

	if(!read_params_file("default.prm"))
		exit (-1);

/*	read in data files				*/

	np=readpt(inpts,"fascia.st1");	/* read first vertices set	*/

	for (i=0; i<300; i++)
		for (j=0; j<3; j++)
			interp[i][j] = inpts[i][j];

	np=readpt(interp,"fascia.st2");	/* read second vertices set	*/
	ng=readt(pc,pg,pgni,"fascia.top");	/* read topology file	*/


	bgc=0xFF808080;		/* set background colour. */
}

open_window(is_open)
int is_open;
{
char vbuff[50];
/*printf("Open window %d\n",is_open);/**/

	if(!is_open)
	{
		/* See if we're on a GT. */
		gversion( vbuff );
		is_a_gt = strncmp( vbuff+4, "GT", 2 ) == 0; 

		if ( !forkflg ) foreground();	/* forking? */
	
		/* Get a window of the right size */
		prefposition(FACE_START_X,FACE_END_X,FACE_START_Y,FACE_END_Y);
		prefsize(FACE_END_X-FACE_START_X ,FACE_END_Y-FACE_START_Y );
#ifdef FORMS
		if(forms_required)	noborder();
#endif
		face_window=winopen("face view");
	}
	winset(face_window);

#ifdef FORMS
	if(forms_required)
	{
		fl_qdevice(REDRAW);
		fl_qdevice(MOUSE3);
		fl_qdevice(MOUSE2);
		fl_qdevice(MOUSE1);
		fl_set_event_call_back(main_callback);
	}
#endif

	if(is_a_gt)
	{
		doublebuffer();
		gconfig();
	}
	wintitle("Fascia");
	winconstraints();
	reshapeviewport();
	mmode(MVIEWING);
	perspective(450,1.0,0.25,100.0);
	winpop();
	if(is_a_gt  && !wire)
		RGBmode();
	else
	{
		cmode();
/*		init_for_cmode();/**/
	}
	gconfig();

	lsetdepth(0x000000,0x7fffff);
	
	/*	initialize light and materials models	*/
	lmdef(DEFLIGHT,1,5,lightone);
	lmdef(DEFLIGHT,2,5,lighttwo);
	lmdef(DEFLMODEL,1,0,NULL);
	lmdef(DEFMATERIAL,FLESH,15,flesh);
	lmdef(DEFMATERIAL,LIPS,15,lips);
	lmdef(DEFMATERIAL,EYELASH,15,eyelash);
	lmdef(DEFMATERIAL,TEETH,15,teeth);
	lmdef(DEFMATERIAL,PUPIL,15,pupil);
	lmdef(DEFMATERIAL,IRIS,15,iris);
	lmdef(DEFMATERIAL,FRINGE,15,fringe);
	lmdef(DEFMATERIAL,EYEWHITE,15,eyewhite);
	
	if(wire)
	{
		lmbind(LIGHT0,0); lmbind(LIGHT1,0); lmbind(LMODEL,0);
	}
	else
	{
		lmbind(LIGHT0,1); lmbind(LIGHT1,2); lmbind(LMODEL,1);
	}
/*printf("Leaving open_window\n");/**/
}

recompute_face()
{
register int i,j;
/*printf("recompute_face\n");/**/

	ry=(0); rz=(-900); sc=.002;
	
	/*	initialize eyeball positions	*/
	
	if(parameter[38].changed)
	  for(i=0; i<2; i++)
			crd[i][0] = eye_coord[0]+parameter[38].value;
	if(parameter[39].changed)
	  for(i=0; i<2; i++)
			crd[i][1] = eye_coord[1]+parameter[39].value;
	if(parameter[40].changed)
	  for(i=0; i<2; i++)
			crd[i][2] = eye_coord[2]+parameter[40].value;

	if(parameter[28].changed)
	  for(i=0; i<2; i++)
			eyeball[i][0] = crd[i][0]+parameter[28].value;
	if(parameter[29].changed)
	  for(i=0; i<2; i++)
			eyeball[i][1] = crd[i][1]+parameter[29].value;
	if(parameter[30].changed)
	  for(i=0; i<2; i++)
			eyeball[i][2] = crd[i][2]+parameter[30].value;
	if(parameter[39].changed)
	  crd[0][1]=(-crd[0][1]);
	if(parameter[29].changed)
	  eyeball[0][1]=(-eyeball[0][1]);

	points(np,crd,parameter,inpts,interp,pt); 	   /* initialize vertex positions	*/
	
	if(!wire)
		comnor(ng,pg,pt,pgn); 			   /* compute polygon normals		*/
	
	if(!wire)
		vnorm(nnor,ng,np,nv,nn,pg,pgni,pgn,vn,pt); /* compute vertex normals		*/

/*printf("leaving recompute_face\n");/**/
}
display_face()
{
/*printf("display_face = %ld\n",face_window);/**/

        winset(face_window);
	loadmatrix(idmat);
	polarview(parameter[51].value,(short)(parameter[52].value*10),
	       (short)(parameter[53].value*10),(short)(parameter[54].value*10));

	CALLOBJS;             /*      display face image NO UPDATE */

        swapbuffers();
}

update_face_display()
{
/*printf("update_face_display\n");/**/

        recompute_face();
	create_face_object(ng,np,ry,rz,sc,pt,pc,pg,pgni,nn,vn,pgn,parameter,eyeball);
	display_face(); 	/*      display face image WITH UPDATE */
}

void draw_face()
{
        open_window(0);
        update_face_display();
	CALLOBJS;             /* And again first time around. */
}
