/*** Function Prototypes for the Single Layer Animation System ***/


/* main.c */

void	event_loop();
void 	musc_3d(FL_OBJECT *,long);
void 	musc_1d_param(FL_OBJECT *,long);
void 	lip_param(FL_OBJECT *,long);
void 	mouth_param(FL_OBJECT *,long );
void 	redraw_face(FL_OBJECT *, long );
void 	refresh_face(FL_OBJECT *,long );
void	monitor_loop();
void	exit_session(FL_OBJECT *,long);
void	option_param(FL_OBJECT *,long);


/* face.c */
void load_face(char *);
int *load_jaw(char *);
int *load_lips(char *);

/* graphics.c */
long 	init_face_win();
void 	init_gl_env();
void	plot_face(long,float *,int *,int *,int *);
void 	cross_product(float *,int ,int,int,float *);
int	*assign_normals(int ,int *);
long 	init_msc_chart();
void	draw_msc_chart(long);
void	plot_dynamic_muscles(long ,float *);
void	plot_static_muscles(long );
void	plot_eyes(eye_info,Object);

/* muscles.c */
void 	setup_muscles(char *);
void	init_sphinctor();
void	init_muscles();
void	print_muscle(struct muscle *);



/* pick.c */

void	select_vertex(long );
int 	choose_vertex(long);


/* pull.c */
void 	pull3d(float[], int, float );
void	pull1d(float *, int,  float);
void 	sphincter(float );
void 	lip_sep(float , float );
void	rot_jaw(float *,int *,float );


/* scrn_rot.c */

void	queue_keypad();
int	keypad_event(long ,short );


/* texture.c */
void load_texture(int ,char *);
float *bind_texture_coor(float *);



/* eyes.c */
Object	make_eye_object();




/* gui.c */

void	eye_val(FL_OBJECT *, long);



