// Contains Spline control window manager object for Version #2
// wth the Actor and Scene paradigm


extern "C" {
    
#include <forms.h>
}
#include "test_forms.h"

#include <gl/gl.h>
#include <gl/device.h>
#include <stdio.h>
#include <string.h>
#include <stream.h>
#include <sys/types.h>
#include <malloc.h>

#include "winman.h"
#include "actor.h"
#include "debug.h"
#include "colors.h"

/*** Winman - initialize the window manager ***/
Winman::Winman()
{	
    
    // What initial structure do we need here??
    // Maybe an array of pointers (maximum number of boards) 
    num_boards = 0 ;
    curr_board = -1;
}



Winman::~Winman() 
{
    status("Destructor of Winman not yet implemented ");
}



/*** create_board -- make a new scene controller ***/
int Winman::create_board(char *title,long id, int no_actors)
{
    
    /* first should check to make sure ID is unique SWF*/
    status("Creating Internal Board #",num_boards);
    curr_board = num_boards;
    b[num_boards] = new Board(title,id,no_actors);
    num_boards++;
    
    fl_add_browser_line(board_browser,title);
    return (num_boards-1);
}



/*** delete_board -- delete a scene controller (doesn;t delete the scene) ***/
void Winman::delete_board(long id)
{
    // free actor,act_gid,act_id,act_title allocated memory
    // free the "board" object (which takes care of above automatically 
    // remove from board_browser
    // concatonate the data structure 
}

/*** pick_board -- let a user select a board and return ID # ***/
int	Winman::pick_board()
{
    /* Use the FORMS Chooser WIDGET */
    int		i,bnum;
    FL_OBJECT	*obj;
  
    fl_clear_choice(fl_board_list);
    for (i=0;i<num_boards;i++) {
	fl_addto_choice(fl_board_list,b[i]->scene_title);
    }
    
    fl_set_choice(fl_board_list,0);
    // Freeze all the other objects and post the Form
    fl_deactivate_all_forms();
    fl_show_form(mngr_pick,FL_PLACE_MOUSE,FALSE,NULL);
    
    // Caution, maybe this will throw away some events??
    obj = FL_EVENT;
    while(!( (obj==OK_1)|| (obj==KO_1))) {
	obj = fl_do_forms();
    }
    fl_qreset();
 
    if (obj==KO_1) {
	status("Aborting Pick_board");
	bnum = -1;
    }
    else {
	bnum=fl_get_choice(fl_board_list);
	//status("You have choosen line #",bnum);
	bnum--;
	//status("You have choosen board",b[bnum]->scene_title);
	// verify this choice?
	
    }
    fl_hide_form(mngr_pick);
    fl_activate_all_forms();
    return(bnum);
    
}


/*** show_board -- display a board (scene) on the screen ***/
void	Winman::show_board(long id)
{
    // open and display a board, maybe find a clean space on the screen
    // set the gid variable in the Board
    
#define XBORDER 10
#define YBORDER 40   
    
    //status("Winman::Showing Board",id);
    if (b[id]->open==TRUE) {
	status("Board Already Displayed",b[id]->scene_title);
	return();
    }
    
    
    
    int i;

    float	xpos,ypos,xwid,ywid;
    char	title[120];
    
    float xmax = getgdesc(GD_XPMAX);
    float ymax = getgdesc(GD_YPMAX);
    
    xwid = 300; ywid = 100;
    ypos = 10; 
    xpos = xmax-(xwid+XBORDER); 
    defbasis(CARD_BASIS,cspline_matrix);

    for (i=0;i<b[id]->num_act; i++) {
	// Make a formula for this, for good screen placement
	// maybe have a matrix to place in free areas only
	// but for now place every board in the same place
	status("Posting actor ",b[id]->act_title[i]);
	
	prefposition(xpos,xpos+xwid,ypos,ypos+ywid);
	ypos+= (ywid+YBORDER);
	if (ypos > (ymax - (ywid+YBORDER))) {
	    ypos = 10;
	    xpos -= (xwid+XBORDER);
	}

	sprintf(title,"%s:%s",b[id]->scene_title,b[id]->act_title[i]);
	b[id]->act_gid[i] = winopen(title);
	b[id]->open = TRUE;
	//status("Have opened and set to ",b[id]->act_gid[i]);
	winset(b[id]->act_gid[i]);

	// Now set up the overlay planes
	overlay(2);
	drawmode(OVERDRAW);
	gconfig();
	mapcolor(0,0,0,0);	// Color 0 = Black
	mapcolor(1,188,255,200);	// Bright green?? = Color1
	
	drawmode(NORMALDRAW);

	doublebuffer();
	RGBmode();
	curvebasis(CARD_BASIS);
	curveprecision(4);
	gconfig();

	cpack(c_grey); clear(); zclear(); swapbuffers();
	cpack(c_grey); clear(); zclear(); 
	
	
	fl_qenter(REDRAW, (short)b[id]->act_gid[i]);
	
    }
    
    
}


/*** hide_board -- *un*display a board ***/
void Winman::hide_board(long id)
{
    int i;
    
    if (id==-1)  id= curr_board;
    
    if ((id==-1) || (id>num_boards)) {
	status("No Such Board",id);
	return();
    }
    
    if (b[id]->open==FALSE) {
	status("Not Currently Displayed");
	return();
    }
    
    b[id]->open = FALSE;
    for (i=0;i<b[id]->num_act;i++) {
	winclose(b[id]->act_gid[i]);
	b[id]->act_gid[i] = -1; 
    }
    //status("Done Closing windows",b[id]->scene_title);
}


/*** push_board -- push the board to the bottom of the display ***/
void Winman::push_board(long id)
{
    
    int i;
    
    if (id==-1)  id= curr_board;
    
    if ((id==-1) || (id>num_boards)) {
	status("No Such Board",id);
	return();
    }
    
    if (b[id]->open==FALSE) {
	status("Not Currently Displayed");
	return();
    }
    
    for (i=0;i<b[id]->num_act;i++) {
	winset(b[id]->act_gid[i]);
	winpush();
    }
    
}


/*** pop_board -- bring the board to the top of the display ***/
void Winman::pop_board(long id)
{
    
    int i;
    
    if (id==-1)  id= curr_board;
    
    if ((id==-1) || (id>num_boards)) {
	status("No Such Board",id);
	return();
    }
    
    if (b[id]->open==FALSE) {
	status("Not Currently Displayed");
	return();
    }
    
    for (i=0;i<b[id]->num_act;i++) {
	winset(b[id]->act_gid[i]);
	winpop();
    }
    
    
}	

/*** precompute -- setup a boards spline coefficients for quick evaluation***/
void Winman::precompute(long bid)
{
    // should make a macro or routine to make sure board number is legal
    
    if (bid==-1)  bid= curr_board;
    
    if ((bid==-1) || (bid>num_boards)) {
	status("No Such Board",bid);
	return();
    }
    
    status("Precomputing",b[bid]->scene_title);

    b[bid]->precompute();
   
}



/*** Winman::range - return the start and ending xpos of a scene (board) ***/
void Winman::get_range(long bid,float *a1,float *a2)
{
    status("Winman getting range of ",b[bid]->scene_title);
    if (bid==-1) bid=curr_num();
    if (bid>=num_boards) {
	status("Unkown Board",bid);
	return();
    }	
    
    b[bid]->get_range(a1,a2);
    
}



/*** redraw_board -- redraw specified board, or if -1 current board ***/
void Winman::redraw_board(long bid,float cursor)
{
    int	i;
    if (bid==-1) bid = curr_board;
    
    if (b[bid]->open== TRUE) {	// if currently displayed
	for (i=0;i<b[bid]->num_act;i++) {
	    winset(b[bid]->act_gid[i]);
	    b[bid]->obj[i]->draw(cursor);

	}
    }
}


/*** reset_board -- return a board's actors to a startup spline ***/
void Winman::reset_board(long bid)
{

    if (bid==-1) bid= curr_board;
    if (bid<0) {
	status("WARNING: No Current Board");
	return;
    }

    if (bid> num_boards) {
	status("reset_board:: Illegal Board Number",bid);
	return();
    }

    b[bid]->reset();
    redraw_board(bid);
}



/*** scroll_board -- change the visible portion of actors in a board ***/
void Winman::scroll_board(long id,float st_percent,float zm_percent)
{
    int	i;
    if (id==-1)	id = curr_board;

    //status("Scrolling Board",b[id]->scene_title);
    
    if (b[id]->open==FALSE) {
	status("WARNING: Must be OPEN to scroll");
	return();
    }

    for (i=0;i<b[id]->num_act;i++) {
	winset(b[id]->act_gid[i]);
	b[id]->obj[i]->set_window(st_percent,zm_percent);
	b[id]->obj[i]->draw();
    }
}

/*** register_actor -- Add an actor info to a specified board ***/
void Winman::register_actor(long board,char *title,long id,Actor *obj)
{

    //status("Winman::registering Actor",title);
    if ((board>=num_boards) || (b[board]==0)) {
	status("Board ID not found",id);
	return();
    }


    b[board]->add_actor(title,id,obj);
    
}



/*** forward_gl_event -- pass on a GL event to the correct Actor ***/
void Winman::forward_gl_event(long dev,short val,int cur_win)
{
    // This is kinda Hokey but....since we know that I have winset
    // to the current window, unless it is a redraw or something special
    // than the current gid is the gid of the Actor who needs to be 
    // notified.
  //  status("Winman::Forwarding a GL Event",val,cur_win);
    
    // Need a quicker way to do this but...
    int	i,j;

    for (i=0;i<num_boards;i++) {
	for (j=0;j<b[i]->num_act;j++) {
	    if (b[i]->act_gid[j]==cur_win) {
		b[i]->obj[j]->gl_event(dev,val,cur_win);
		return();
	    }
	}
    }

}


/*** print_actors -- print all the scenes on a specified board ***/
void Winman::print_actors(long bid)
{
    
    if ((bid<0) ||( bid>=num_boards)) {
	status("Board ID not found",bid);
	return();
    }
    b[bid]->print_actors();
}




/*** print_boards -- print a list of all the boards being managed ***/
void Winman::print_boards()
{
    // Print out a list of the scenes and ID numbers for debugging

    int i;

    status("Number of Boards",num_boards);
    for (i=0;i<num_boards;i++) {
	cout << "Board " <<i<<": " << b[i]->scene_title ;
	cout<< "   "<<b[i]->scene_id<<endl;

    }
}



///***--------------------- Board Code --------------------***///


Board::Board(char *tit,long id,int nact)
{

    size_t len;

    scene_id = id;
  
    if (strlen(tit)==0) 
	tit = "NoName";
    
    if ((len=strlen(tit)) > 39) 
     len = 39;

    strncpy(scene_title,tit,len+1);
    
    // Allocate space for the Actors/Act_id/gid/and titles
    status("allocating space for ",nact);
    act_gid = new long [nact];	
    act_id  = new long [nact];
    act_title= new char *[nact];
    obj  =     new Actor *[nact];

    start_x = end_x = 0;
    open = FALSE;
    num_act=0;
}




void Board::add_actor(char *tit,long id,Actor *act)
{	

    size_t	len;

    //status("From Board",scene_title);
    //status("Board::Adding actor number",num_act);

    act_gid[num_act] = 0;	// No Window Id Yet
    act_id [num_act] = id;	// should make sure unique but...
    obj[num_act] = act;		// Pointer to the Actor object

 
    if (strlen(tit)==0) 
	tit = "NoName";
    
    if ((len=strlen(tit)) > 39) 
     len = 39;

    act_title[num_act] = new char [len+1];
    strncpy(act_title[num_act],tit,len);
 
    num_act++;
}

/*** Board:: append_scene() -- add a scene to end of this one ***/
void Board::append_scene(Board *newbie)
{
    int i,npnts;
    float xpos;
    status("Appending  ",newbie->scene_title);
    status("To Board   ",scene_title);

    // First find the correct xpos to append at
    xpos =0 ;
    for (i=0;i<num_act; i++) {
	npnts = obj[i]->num_pnts();
	npnts = npnts-2;
	if (xpos < obj[i]->xpos(npnts))
	  xpos = obj[i]->xpos(npnts);
    }

    for (i=0;i<num_act; i++) {
	obj[i]->append(newbie->obj[i],xpos);
    }
}


/*** Board:: append_scene() -- add a scene to end of this one ***/
void Board::prepend_scene(Board *newbie)
{
    int i,n;
    float max;
    status("Prepending  ",newbie->scene_title);
    status("To Board   ",scene_title);

    // First find the longest duration of the board
    // assuming starts at zero (0)

    max = 0 ;
    for (i=0;i<newbie->num_act; i++) {
	n = newbie->obj[i]->num_pnts()-2;
	if (max<newbie->obj[i]->xpos(n))
	  max = newbie->obj[i]->xpos(n);
    }

    status("Duration ",max);
    for (i=0;i<num_act; i++) {
	status("Prepending Scene ",i);
	obj[i]->prepend(newbie->obj[i],max);
    }
}

    

/***get_range -- get the range of this board in x-coordinates ***/
void Board::get_range(float *a,float *b)
{
    // Maybe change so start_x and end_x always automatically updated
    // in the actors?

    // make start_x == largest st_x 
    // make end_x == smallest end_x
    // note: sometimes the control points won't cover the entire range
    int i;
    start_x = -666666;
    end_x   = 666666;
    for (i=0;i<num_act;i++) {
	if (start_x < obj[i]->start())
	  start_x = obj[i]->start();

	if (end_x > obj[i]->end())
	  end_x = obj[i]->end();
    }

    *a = start_x;
    *b = end_x;
}


/*** Board:: plot_cursor -- paste a cursor on splines or erase if < 0 ***/
void Board::plot_cursor(float xpos)
{
    int i;
    for (i=0;i<num_act;i++) {
	winset(act_gid[i]);
	obj[i]->draw_cursor(xpos);
    }
}



/*** Board::precompute -- compute the spline coefficients for all my actors ***/
void Board::precompute()
{
    int i;

    
    for (i=0;i<num_act;i++) {
	obj[i]->setup_coeff();
    }
}

    


/*** reset - reset the Board to initial spline data ***/
void Board::reset()
{
    int i;
    
    for (i=0;i<num_act;i++)
      obj[i]->reset();
    /* maybe should update start X and end X */
    
}

	
/*** print_actors -- debugging routine to print all actors on a board ***/
void Board::print_actors()
{	
    int i;

    status("Board: ",scene_title);
    status("ID	   ",scene_id);
    status("Number of Actors",num_act);
    for (i=0;i<num_act;i++) {
	cout << "Actor "<< i << ": "<<act_title[i]<<"   Id:";
	cout << act_id[i] << "GID: "<<act_gid[i] << endl;
    }
}



